/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.CmdItemEvent;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceID;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTItemListenerIF;
import com.sap.sdt.engine.core.event.SDTEvent;
import com.sap.sdt.engine.core.event.SDTItemEvent;
import com.sap.sdt.gui.core.swing.controls.GuiListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GuiItemListener
extends GuiListener
implements SDTItemListenerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiItemListener.java#2 $";
    private static final Class[] ARGS = new Class[]{SDTItemEvent.class};

    GuiItemListener() {
        this.peer = new Listener(this);
    }

    public void itemStateChanged(SDTItemEvent event) {
        if (this.isLocal) {
            this.localEvent(event);
        } else {
            this.remoteEvent(event);
        }
    }

    public ItemListener peer() {
        return (ItemListener)this.peer;
    }

    protected void remoteEvent(SDTEvent event) {
        ServiceID invoker = null;
        try {
            invoker = ServiceManager.getService(this).getID();
        }
        catch (ServiceException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        CmdConsumerIF consumer = ServiceManager.getConsumer(invoker);
        CmdItemEvent cmd = new CmdItemEvent(invoker, (SDTItemEvent)event);
        consumer.consumeAndContinue(cmd);
    }

    protected final String getCls() {
        return "SDTItemListener";
    }

    protected final String getName() {
        return "itemStateChanged";
    }

    protected final Class[] getArgs() {
        return ARGS;
    }

    private class Listener
    implements ItemListener {
        private GuiItemListener listener = null;

        private Listener(GuiItemListener listener) {
            this.listener = listener;
        }

        public void itemStateChanged(ItemEvent event) {
            SDTControlIF source = GuiItemListener.this.getSource(event.getSource());
            SDTItemEvent iE = null;
            switch (event.getStateChange()) {
                case 1: {
                    iE = new SDTItemEvent(source, true);
                    break;
                }
                case 2: {
                    iE = new SDTItemEvent(source, false);
                    break;
                }
            }
            this.listener.itemStateChanged(iE);
        }
    }
}

