/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTTableIF;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiTableModel;
import com.sap.sdt.gui.core.swing.controls.GuiTextField;
import com.sap.sdt.gui.core.swing.controls.table.GuiTableColumn;
import com.sap.sdt.gui.core.swing.controls.table.Windows14Table;
import com.sap.sdt.gui.core.swing.controls.table.editors.ButtonCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.CheckBoxEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.ComboBoxCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.TextCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.renderers.ButtonCellRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.CellRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.CheckBoxCellRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.ComboBoxCellRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TableHeaderRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TextCellRenderer;
import com.sap.sdt.gui.core.swing.help.GuiHelp;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.util.GuiRunnable;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GuiInlineTable
extends GuiComponent
implements SDTTableIF,
ActionListener,
ResourceConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiInlineTable.java#2 $";
    public static final String FOCUSED_COLUMN = "FOCUSED_COLUMN";
    private final GuiTableModel model;
    private JTable table;
    private JPanel panel = (JPanel)this.peer;
    private JLabel caption;
    private JPanel buttonPanel;
    private JButton addButton;
    private JButton removeButton;
    private int maxCellHeight = 0;
    private String browseAction;
    private SDTActionListenerIF browseListener;

    GuiInlineTable() {
        super(new JPanel());
        this.panel.setLayout(new BorderLayout(0, 0));
        this.model = new GuiTableModel();
        this.table = new Windows14Table();
        this.maxCellHeight = this.table.getRowHeight();
        this.table.setModel(this.model);
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setAutoResizeMode(0);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setPreferredScrollableViewportSize(new Dimension(0, 35));
        JScrollPane scroll = new JScrollPane();
        scroll.setOpaque(false);
        scroll.setViewportView(this.table);
        scroll.getViewport().setBackground(this.table.getBackground());
        this.caption = new JLabel();
        this.caption.setFont(GuiSettings.getInstance().getFont("label"));
        this.caption.setLabelFor(this.table);
        this.caption.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.panel.add((Component)this.caption, "North");
        this.panel.add((Component)scroll, "Center");
        GuiAction add_action = new GuiAction(this, "ADD_ROW", null);
        this.addButton = new JButton(add_action);
        this.addButton.setFont(GuiSettings.getInstance().getFont("label"));
        GuiAction remove_action = new GuiAction(this, "REMOVE_ROW", null);
        this.removeButton = new JButton(remove_action);
        this.removeButton.setFont(GuiSettings.getInstance().getFont("label"));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.addButton.setAlignmentY(1.0f);
        this.removeButton.setAlignmentY(1.0f);
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        SwingToolkit.fixHeight(this.buttonPanel);
        this.panel.add((Component)this.buttonPanel, "South");
        scroll.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GuiInlineTable.this.resizeColumnToBestFit();
                if (GuiInlineTable.this.getRowCount() == 0 && ((GuiTableModel)GuiInlineTable.this.table.getModel()).isEditable()) {
                    GuiInlineTable.this.addRowAction();
                }
                e.getComponent().removeComponentListener(this);
            }
        });
        this.caption.setVisible(false);
        this.table.addKeyListener(this.keyL);
        this.table.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                int e_col;
                int rowCount = GuiInlineTable.this.getRowCount();
                if (GuiInlineTable.this.model.isEditable() && rowCount > 0 && (e_col = GuiInlineTable.this.getFirstEditableColumn()) > -1) {
                    GuiInlineTable.this.table.editCellAt(0, e_col);
                    Component aComp = GuiInlineTable.this.table.getEditorComponent();
                    GuiInlineTable.this.table.setRowSelectionInterval(0, 0);
                    GuiInlineTable.this.table.setColumnSelectionInterval(e_col, e_col);
                    aComp.requestFocus();
                    GuiInlineTable.this.table.requestFocus();
                }
                GuiInlineTable.this.table.removeFocusListener(this);
            }
        });
        this.panel.putClientProperty("resizing", Boolean.TRUE);
    }

    public void addColumn(SDTTableColumn column) {
        GuiRunnable addColumnRun = new GuiRunnable(column){

            public void run() {
                GuiInlineTable.this.addColumnImpl((SDTTableColumn)this.getParameter());
            }
        };
        addColumnRun.startAndWait();
    }

    private void addColumnImpl(SDTTableColumn column) {
        int type = column.getColumnType();
        CellRenderer renderer = null;
        TableCellEditor editor = null;
        TableCellRenderer header_renderer = null;
        switch (type) {
            case 0: {
                renderer = this.getTextCellRenderer(column);
                editor = this.getTextCellEditor(column);
                header_renderer = this.getHeaderRenderer(renderer);
                break;
            }
            case 1: {
                renderer = new CheckBoxCellRenderer();
                editor = new CheckBoxEditor();
                header_renderer = this.getHeaderRenderer(renderer);
                break;
            }
            case 2: {
                renderer = new ComboBoxCellRenderer();
                editor = new ComboBoxCellEditor();
                ((ComboBoxCellEditor)editor).setValues(column.getValues());
                header_renderer = this.getHeaderRenderer(renderer);
                break;
            }
            case 3: {
                this.addBrowseColumn(column);
                return;
            }
            case 4: {
                this.addBrowseColumn(column);
                return;
            }
            default: {
                renderer = new TextCellRenderer();
                editor = new TextCellEditor();
                header_renderer = this.getHeaderRenderer(renderer);
            }
        }
        GuiTableColumn c = this.updateColumnModel(column);
        c.setCellEditor(editor);
        c.setCellRenderer(renderer);
        c.setHeaderRenderer(header_renderer);
        this.maxCellHeight = Math.max(this.maxCellHeight, renderer.getPreferredHeight());
        this.table.setRowHeight(this.maxCellHeight + this.table.getRowMargin());
    }

    public boolean validate() {
        GuiRunnable validateRun = new GuiRunnable(){

            public void run() {
                this.addReturnValue(GuiInlineTable.this.validateImpl());
            }
        };
        validateRun.startAndWait();
        return validateRun.getBooleanReturnValue();
    }

    private boolean validateImpl() {
        if (this.table.isEditing()) {
            this.stopCellEditing();
        }
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        boolean isValid = true;
        GuiTableColumn column = null;
        while (cols.hasMoreElements()) {
            column = (GuiTableColumn)cols.nextElement();
            if (column.getDataIndex() == GuiTableColumn.NO_DATA_COLUMN_INDEX) continue;
            boolean isColumnValid = this.validateColumn(column);
            isValid = isValid && isColumnValid;
        }
        return isValid;
    }

    public void removeRow(int index) {
        GuiRunnable removeRowRun = new GuiRunnable(index){

            public void run() {
                GuiInlineTable.this.removeRowImpl(this.getIntParameter());
            }
        };
        removeRowRun.startAndWait();
    }

    private void removeRowImpl(int index) {
        this.model.removeRow(index);
    }

    public void enableAddRemove(boolean areRowsFixed) {
        GuiRunnable enableAddRemoveRun = new GuiRunnable(areRowsFixed){

            public void run() {
                GuiInlineTable.this.enableAddRemoveImpl(this.getBooleanParameter());
            }
        };
        enableAddRemoveRun.startAndWait();
    }

    private void enableAddRemoveImpl(boolean areRowsFixed) {
        this.buttonPanel.setVisible(!areRowsFixed);
    }

    public void setEnabled(boolean enabled) {
        GuiRunnable setEnabledRun = new GuiRunnable(enabled){

            public void run() {
                GuiInlineTable.this.setEnabledImpl(this.getBooleanParameter());
            }
        };
        setEnabledRun.startAndWait();
    }

    protected void setEnabledImpl(boolean enabled) {
        this.table.setEnabled(enabled);
        this.model.setEditable(enabled);
        this.removeButton.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
    }

    public void addRow(SDTTableRow row) {
        GuiRunnable addRowRun = new GuiRunnable(row){

            public void run() {
                GuiInlineTable.this.addRowImpl((SDTTableRow)this.getParameter());
            }
        };
        addRowRun.startAndWait();
    }

    private void addRowImpl(SDTTableRow row) {
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        if (row.getCells().size() == 0) {
            this.addRowAction();
            return;
        }
        while (cols.hasMoreElements()) {
            GuiTableColumn column = (GuiTableColumn)cols.nextElement();
            if (column.getDataIndex() != GuiTableColumn.NO_DATA_COLUMN_INDEX) continue;
            row.getCells().add(column.getModelIndex(), "");
        }
        this.model.addRow(row);
        this.initColumnSizes();
    }

    public SDTTableRow getRow(int index) {
        GuiRunnable getRowRun = new GuiRunnable(index){

            public void run() {
                this.addReturnValue(GuiInlineTable.this.getRowImpl(this.getIntParameter()));
            }
        };
        getRowRun.startAndWait();
        return (SDTTableRow)getRowRun.getReturnValue();
    }

    private SDTTableRow getRowImpl(int index) {
        if (this.table.isEditing()) {
            this.stopCellEditing();
        }
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        SDTTableRow modelRow = this.model.getRow(index);
        List rowCells = modelRow.getCells();
        if (rowCells.size() == 0) {
            return null;
        }
        ArrayList newL = new ArrayList();
        SDTTableRow result = new SDTTableRow(newL, modelRow.getRowID());
        while (cols.hasMoreElements()) {
            GuiTableColumn column = (GuiTableColumn)cols.nextElement();
            if (column.getDataIndex() == GuiTableColumn.NO_DATA_COLUMN_INDEX) continue;
            newL.add(rowCells.get(column.getModelIndex()));
        }
        return result;
    }

    public int getRowCount() {
        GuiRunnable getRowRun = new GuiRunnable(){

            public void run() {
                this.addReturnValue(GuiInlineTable.this.getRowCountImpl());
            }
        };
        getRowRun.startAndWait();
        return getRowRun.getIntReturnValue();
    }

    private int getRowCountImpl() {
        return this.model.getRowCount();
    }

    public void setCaption(String caption, char mnemonic) {
        Object[] parameters = new Object[]{caption, new Character(mnemonic)};
        GuiRunnable setCaptionRun = new GuiRunnable(parameters){

            public void run() {
                GuiInlineTable.this.setCaptionImpl((String)this.getParameter(0), ((Character)this.getParameter(1)).charValue());
            }
        };
        setCaptionRun.startAndWait();
    }

    private void setCaptionImpl(String caption, char mnemonic) {
        this.caption.setVisible(true);
        this.caption.setText(SwingToolkit.getPlainText(caption));
        this.caption.setDisplayedMnemonic(mnemonic);
    }

    public void addBrowseListener(String action, SDTActionListenerIF listener) {
        this.browseAction = action;
        this.browseListener = listener;
    }

    public void setEditingCellValue(Object value) {
        GuiRunnable setEditingCellValueRun = new GuiRunnable(value){

            public void run() {
                GuiInlineTable.this.setEditingCellValueImpl(this.getParameter());
            }
        };
        setEditingCellValueRun.startAndWait();
    }

    private void setEditingCellValueImpl(Object value) {
        int editingColumn = this.table.getEditingColumn();
        if (editingColumn == -1) {
            return;
        }
        GuiTableColumn column = (GuiTableColumn)this.table.getColumnModel().getColumn(editingColumn);
        if (column.getDataIndex() == GuiTableColumn.NO_DATA_COLUMN_INDEX) {
            editingColumn = this.table.getEditingColumn() - 1;
        }
        this.table.getModel().setValueAt(value, this.table.getEditingRow(), editingColumn);
    }

    public Object getEditingCellValue() {
        GuiRunnable getEditingCellValueRun = new GuiRunnable(){

            public void run() {
                this.addReturnValue(GuiInlineTable.this.getEditingCellValueImpl());
            }
        };
        getEditingCellValueRun.startAndWait();
        return getEditingCellValueRun.getReturnValue();
    }

    private Object getEditingCellValueImpl() {
        if (this.table.getEditingColumn() == -1) {
            return null;
        }
        GuiTableColumn column = (GuiTableColumn)this.table.getColumnModel().getColumn(this.table.getEditingColumn());
        int editingColumn = this.table.getEditingColumn();
        if (column.getDataIndex() == GuiTableColumn.NO_DATA_COLUMN_INDEX) {
            editingColumn = this.table.getEditingColumn() - 1;
        }
        return this.table.getModel().getValueAt(this.table.getEditingRow(), editingColumn);
    }

    public SDTTableColumn getEditingColumn() {
        GuiRunnable getEditingColumnRun = new GuiRunnable(){

            public void run() {
                this.addReturnValue(GuiInlineTable.this.getEditingColumnImpl());
            }
        };
        getEditingColumnRun.startAndWait();
        return (SDTTableColumn)getEditingColumnRun.getReturnValue();
    }

    private SDTTableColumn getEditingColumnImpl() {
        if (this.table.getEditingColumn() == -1) {
            return null;
        }
        GuiTableColumn column = (GuiTableColumn)this.table.getColumnModel().getColumn(this.table.getEditingColumn());
        return column.getData();
    }

    private void initColumnSizes() {
        int nColumns = this.table.getColumnCount();
        for (int i = 0; i < nColumns; ++i) {
            GuiTableColumn column = (GuiTableColumn)this.table.getColumnModel().getColumn(i);
            Component comp = column.getHeaderRenderer().getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            Insets insets = ((JComponent)comp).getBorder().getBorderInsets(comp);
            int headerWidth = comp.getPreferredSize().width + insets.left + insets.right + 2;
            CellRenderer cellRenderer = (CellRenderer)column.getCellRenderer();
            int cellWidth = cellRenderer.getPreferredWidth();
            int newColumnWidth = Math.max(headerWidth, cellWidth);
            column.setMinWidth(headerWidth);
            column.setPreferredWidth(newColumnWidth);
            if (!column.isRigid()) continue;
            column.setMinWidth(newColumnWidth);
            column.setMaxWidth(newColumnWidth);
        }
    }

    private void resizeColumnToBestFit() {
        int nColumns = this.table.getColumnCount();
        boolean total = false;
        int viewPortWidth = this.table.getParent().getSize().width;
        if (viewPortWidth <= 0) {
            return;
        }
        int tableWidth = this.table.getSize().width;
        if (viewPortWidth > tableWidth) {
            int excessWidth = viewPortWidth - tableWidth;
            ArrayList<GuiTableColumn> resizableColumns = new ArrayList<GuiTableColumn>(nColumns);
            for (int i = 0; i < nColumns; ++i) {
                GuiTableColumn column = (GuiTableColumn)this.table.getColumnModel().getColumn(i);
                if (column.isRigid()) continue;
                resizableColumns.add(column);
            }
            int nResizableColumns = resizableColumns.size();
            int extendWidth = excessWidth / nResizableColumns;
            int extendRestWidth = excessWidth - extendWidth * nResizableColumns;
            for (int i = 0; i < nResizableColumns; ++i) {
                GuiTableColumn column = (GuiTableColumn)resizableColumns.get(i);
                CellRenderer renderer = (CellRenderer)column.getCellRenderer();
                int cellWidth = renderer.getPreferredWidth();
                column.setPreferredWidth(column.getPreferredWidth() + extendWidth);
            }
            TableColumn column = this.table.getColumnModel().getColumn(nColumns - 1);
            column.setPreferredWidth(column.getPreferredWidth() + extendRestWidth);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_ROW")) {
            this.addRowAction();
        } else if (cmd.equals("REMOVE_ROW")) {
            this.removeRowAction();
        }
    }

    private GuiTableColumn updateColumnModel(SDTTableColumn column) {
        this.model.getColumnNames().add(column.getCaption());
        this.model.setColumnEditable(this.model.getColumnCount() - 1, column.isEnabled());
        GuiTableColumn c = new GuiTableColumn(column);
        c.setHeaderValue(this.model.getColumnName(this.model.getColumnCount() - 1) + " ");
        c.setDataIndex(this.model.getColumnCount() - 1);
        c.setModelIndex(this.model.getColumnCount() - 1);
        if (column.getType() == 1) {
            c.setRigid(true);
        }
        TableColumnModel columns = this.table.getColumnModel();
        columns.addColumn(c);
        return c;
    }

    private void addBrowseColumn(SDTTableColumn column) {
        int type = column.getColumnType();
        column.setColumnType(0);
        this.addColumn(column);
        column.setColumnType(type);
        GuiAction browse_action = null;
        browse_action = type == 3 ? new GuiAction(null, "BROWSE", null) : new GuiAction(null, "BROWSE_DIR", null);
        browse_action.setEnabled(column.isEnabled());
        ButtonCellRenderer renderer = new ButtonCellRenderer(browse_action);
        ButtonCellEditor editor = new ButtonCellEditor(browse_action);
        JButton browseButton = editor.getButton();
        browseButton.setActionCommand(this.browseAction);
        if (this.browseListener != null) {
            GuiActionListener gL = (GuiActionListener)this.browseListener;
            browseButton.addActionListener(gL.peer());
            gL.addSource(editor.getButton(), this);
        }
        GuiTableColumn c = this.updateColumnModel(column);
        c.setHeaderValue("");
        c.setDataIndex(GuiTableColumn.NO_DATA_COLUMN_INDEX);
        c.setCellEditor(editor);
        c.setCellRenderer(renderer);
        c.setRigid(true);
        c.setHeaderRenderer(this.getHeaderRenderer(renderer));
        this.maxCellHeight = Math.max(this.maxCellHeight, ((CellRenderer)renderer).getPreferredHeight());
        this.table.setRowHeight(this.maxCellHeight + this.table.getRowMargin());
    }

    private boolean validateColumn(GuiTableColumn column) {
        int minLength;
        boolean isValid = true;
        column.getData().setAdditionalHelpText("");
        if (column.getData().getConstraint(1) && !this.checkNumeric(column)) {
            isValid = false;
        }
        if ((minLength = column.getData().getConstraintValue(0)) != 0 && !this.checkMinLength(this.model.getColumnValues(column.getDataIndex()), minLength)) {
            isValid = false;
            column.getData().setAdditionalHelpText(column.getData().getAdditionalHelpText() + "Column '" + column.getData().getCaption() + "' must be at least " + minLength + " characters long." + "<p>");
        }
        if (!isValid) {
            column.getData().setAdditionalHelpText("<html><br><strong>Column Limitations</strong><p>" + column.getData().getAdditionalHelpText());
        }
        return isValid;
    }

    private boolean checkNumeric(GuiTableColumn column) {
        List data = this.model.getColumnValues(column.getDataIndex());
        for (int i = 0; i < data.size(); ++i) {
            String input = (String)data.get(i);
            try {
                int number = Integer.parseInt(input);
                int minValue = column.getData().getConstraintValue(2);
                int maxValue = column.getData().getConstraintValue(3);
                if (number < minValue) {
                    column.getData().setAdditionalHelpText(column.getData().getAdditionalHelpText() + "Column '" + column.getData().getCaption() + "' must contain a number greater or equal than " + minValue + ".<p>");
                    return false;
                }
                if (number <= maxValue) continue;
                column.getData().setAdditionalHelpText(column.getData().getAdditionalHelpText() + "Column '" + column.getData().getCaption() + "' must contain a number less or equal than " + maxValue + ".<p>");
                return false;
            }
            catch (NumberFormatException ex) {
                column.getData().setAdditionalHelpText(column.getData().getAdditionalHelpText() + "Column '" + column.getData().getCaption() + "' must contain a number.<p>");
                return false;
            }
        }
        return true;
    }

    private boolean checkMinLength(List data, int length) {
        for (int i = 0; i < data.size(); ++i) {
            String input = (String)data.get(i);
            if (input == null) {
                input = "";
            }
            if (input.length() >= length) continue;
            return false;
        }
        return true;
    }

    private void addRowAction() {
        int e_col;
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            Object defValue = ((GuiTableColumn)this.table.getColumnModel().getColumn(i)).getDefaultValue();
            l.add(defValue);
        }
        SDTTableRow row = new SDTTableRow(l);
        this.model.addRow(row);
        if (this.model.isEditable() && (e_col = this.getFirstEditableColumn()) > -1) {
            this.table.editCellAt(this.model.getRowCount() - 1, e_col);
            Component aComp = this.table.getEditorComponent();
            Rectangle cell = this.table.getCellRect(this.table.getRowCount() - 1, e_col, true);
            this.table.scrollRectToVisible(cell);
            this.table.setRowSelectionInterval(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
            this.table.setColumnSelectionInterval(e_col, e_col);
            aComp.requestFocus();
            this.table.requestFocus();
        }
    }

    private void removeRowAction() {
        this.stopCellEditing();
        int[] sel = this.table.getSelectedRows();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.model.removeRow(sel[i]);
        }
        if (sel.length > 0 && this.model.getRowCount() > 0) {
            int e_col;
            int nextSelected = sel[sel.length - 1] - sel.length + 1;
            if (nextSelected > -1 && nextSelected >= this.model.getRowCount() - 1) {
                nextSelected = this.model.getRowCount() - 1;
            }
            if ((e_col = this.getFirstEditableColumn()) > -1) {
                this.table.editCellAt(nextSelected, e_col);
                this.table.setRowSelectionInterval(nextSelected, nextSelected);
                this.table.setColumnSelectionInterval(e_col, e_col);
                this.table.getEditorComponent().requestFocus();
                this.table.requestFocus();
            }
        }
    }

    private int getFirstEditableColumn() {
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        int columns = this.model.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            if (!this.model.isCellEditable(0, i)) continue;
            return i;
        }
        return -1;
    }

    private boolean stopCellEditing() {
        int rows = this.getRowCount();
        int columns = this.model.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (this.table.getEditingColumn() != j || this.table.getEditingRow() != i) continue;
                return this.table.getCellEditor(i, j).stopCellEditing();
            }
        }
        return true;
    }

    private CellRenderer getTextCellRenderer(SDTTableColumn column) {
        TextCellRenderer renderer = new TextCellRenderer();
        if (column.getConstraint(1)) {
            renderer.setAlignment(4);
        }
        return renderer;
    }

    private TableCellRenderer getHeaderRenderer(CellRenderer renderer) {
        TableHeaderRenderer header_renderer = new TableHeaderRenderer();
        header_renderer.setAlignment(renderer.getAlignment());
        return header_renderer;
    }

    private TableCellEditor getTextCellEditor(SDTTableColumn column) {
        int constarints = column.getConstraints();
        TextCellEditor editor = new TextCellEditor();
        if (column.getConstraint(1)) {
            editor.setNumeric(true);
        }
        int minLength = column.getConstraintValue(0);
        int maxLength = column.getConstraintValue(1);
        boolean upper = column.getConstraint(2);
        editor.setMaxLength(maxLength);
        editor.setUpper(upper);
        return editor;
    }

    protected void performKeyPressed(KeyEvent e) {
        int col;
        if (e.getKeyCode() == 112 && (col = ((Integer)this.table.getClientProperty(FOCUSED_COLUMN)).intValue()) != -1) {
            GuiTableColumn table_col = (GuiTableColumn)this.table.getColumnModel().getColumn(col);
            if (table_col.getDataIndex() == GuiTableColumn.NO_DATA_COLUMN_INDEX) {
                table_col = (GuiTableColumn)this.table.getColumnModel().getColumn(col - 1);
            }
            this.setHelpItemID(table_col.getHelpItemID());
            this.setHelp(table_col.getHelp());
            this.setAdditionalHelpText(table_col.getData().getAdditionalHelpText());
        }
        super.performKeyPressed(e);
    }

    public static GuiInlineTable createTable() {
        GuiInlineTable table = new GuiInlineTable();
        SDTTableColumn bool_col = new SDTTableColumn();
        bool_col.setColumnType(1);
        bool_col.setCaption("Boolean");
        bool_col.setDefaultValue(new Boolean("true"));
        SDTTableColumn combo_col = new SDTTableColumn();
        combo_col.setColumnType(2);
        combo_col.setDefaultValue("test2");
        combo_col.setCaption("Combo");
        combo_col.addValue("test1");
        combo_col.addValue("test2");
        SDTTableColumn browse_col = new SDTTableColumn();
        browse_col.setColumnType(4);
        browse_col.setConstraintValue(0, 1);
        browse_col.setConstraintValue(1, 12);
        browse_col.setCaption("Path");
        browse_col.setDefaultValue("default path");
        SDTTableColumn text_col = new SDTTableColumn();
        text_col.setColumnType(0);
        text_col.setCaption("Text");
        text_col.setConstraintValue(0, 1);
        text_col.setConstraintValue(1, 3);
        text_col.setConstraint(2, true);
        text_col.setEnabled(false);
        SDTTableColumn column5 = new SDTTableColumn();
        column5.setColumnType(0);
        column5.setConstraint(1, true);
        column5.setConstraintValue(2, 1);
        column5.setConstraintValue(3, 34);
        column5.setCaption("Number");
        column5.setDefaultValue("0");
        table.addColumn(browse_col);
        table.addColumn(text_col);
        table.addColumn(bool_col);
        table.addColumn(combo_col);
        table.addColumn(column5);
        table.setCaption("Test", 't');
        SDTTableRow ro = new SDTTableRow();
        ArrayList<Object> c = new ArrayList<Object>();
        c.add("ok");
        c.add("ok");
        c.add(new Boolean(true));
        c.add("test2");
        c.add("ok");
        ro.setCells(c);
        table.addRow(ro);
        table.setCaption("Test", 't');
        return table;
    }

    public static void test() {
        JFrame frameMain = new JFrame("Table Test");
        frameMain.setDefaultCloseOperation(3);
        JPanel pnContent = new JPanel();
        pnContent.setLayout(new BoxLayout(pnContent, 1));
        frameMain.setContentPane(pnContent);
        frameMain.setSize(700, 700);
        frameMain.setLocation(200, 100);
        frameMain.show();
        final GuiInlineTable table = GuiInlineTable.createTable();
        GuiHelp.getInstance().setDisplay(frameMain);
        JComponent comp = table.getPeer();
        GuiTextField tf2 = new GuiTextField();
        tf2.setCaption("Textfield Validation :", 'F');
        tf2.setMaxLength(5);
        tf2.setNumeric(true);
        tf2.setMinValue(1);
        pnContent.add(tf2.getPeer());
        pnContent.add(comp);
        JButton b = new JButton("Next");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                table.setEditingCellValue("Test");
                for (int i = 0; i < table.getRowCount(); ++i) {
                    System.out.println("row =  " + i + " = " + table.getRow(i).getCells());
                }
                JPanel pn = (JPanel)table.getPeer();
                JScrollPane sc = (JScrollPane)pn.getComponent(1);
                ((JTable)sc.getViewport().getView()).clearSelection();
            }
        });
        pnContent.add(Box.createVerticalStrut(5));
        pnContent.add(b);
        pnContent.validate();
    }
}

