/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.SDTFileChooserIF;
import com.sap.sdt.engine.core.controls.SDTInternalListenerIF;
import com.sap.sdt.engine.core.controls.file.FileNode;
import com.sap.sdt.engine.core.event.SDTInternalEvent;
import com.sap.sdt.gui.core.images.ImageHolder;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.file.FileProviderIF;
import com.sap.sdt.gui.core.swing.util.SelectAllFocusListener;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class GuiFileChooser
extends GuiComponent
implements SDTFileChooserIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiFileChooser.java#2 $";
    private static final String separatorWindows = "\\";
    private static final String separatorUnix = "/";
    private static final String rootWindows = "My Computer";
    private static final String rootUnix = "/";
    private static final FileNode rootFileNodeWindows = new FileNode("My Computer", true);
    private static final FileNode rootFileNodeUnix = new FileNode("/", true);
    private static final FileNode waitFileNode = new FileNode("- wait -", false);
    private boolean windows = true;
    private String separator = "\\";
    private final JPanel pn;
    private JLabel lbDescription;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode;
    private JScrollPane sp;
    private JTree tree;
    private JLabel lbFileCaption;
    private JTextField tfFile;
    private JButton bnOK;
    private JButton bnCancel;
    private String currentDir = null;
    private boolean dirsOnly;
    private GuiActionListener actionListener;
    private RemoteFileProvider provider;
    private boolean takeFromTree = true;
    private HashMap directoryMap = new HashMap(200);
    private static JFrame m_fMain;

    public GuiFileChooser() {
        super(new JPanel());
        this.pn = (JPanel)this.peer;
        this.createDefaultLayout();
        this.createListener();
    }

    private void createDefaultLayout() {
        GuiSettings settings = GuiSettings.getInstance();
        this.pn.setLayout(new BoxLayout(this.pn, 1));
        this.pn.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JLabel lbTemp = new JLabel();
        lbTemp.setAlignmentX(0.0f);
        lbTemp.setFont(settings.getFont("label"));
        lbTemp.setText("<html><font size='+1' color='#FF0000'>Don't create usability CSN because the file <br>chooser is still under development!</font><br></html>");
        this.lbDescription = new JLabel();
        this.lbDescription.setAlignmentX(0.0f);
        this.lbDescription.setFont(settings.getFont("label"));
        this.pn.add(this.lbDescription);
        this.pn.add(Box.createVerticalStrut(20));
        this.rootNode = new DefaultMutableTreeNode(waitFileNode);
        this.treeModel = new DefaultTreeModel(this.rootNode, true);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.putClientProperty("DoNotFrog", Boolean.TRUE);
        this.tree.setAutoscrolls(true);
        this.tree.setCellRenderer(new FileNodeRenderer());
        this.sp = new JScrollPane(this.tree);
        this.sp.setAlignmentX(0.0f);
        this.sp.setHorizontalScrollBarPolicy(31);
        this.sp.setVerticalScrollBarPolicy(20);
        this.pn.add(this.sp);
        this.pn.add(Box.createVerticalStrut(10));
        JPanel pnFolder = new JPanel();
        pnFolder.setLayout(new BoxLayout(pnFolder, 0));
        pnFolder.setAlignmentX(0.0f);
        this.lbFileCaption = new JLabel();
        pnFolder.add(this.lbFileCaption);
        pnFolder.add(Box.createHorizontalStrut(5));
        this.tfFile = new JTextField();
        pnFolder.add(this.tfFile);
        SwingToolkit.fixHeight(pnFolder);
        this.pn.add(pnFolder);
        this.pn.add(Box.createVerticalStrut(10));
        int buttonSpace = settings.getInt("netweaver.button.space.side") * 2;
        JPanel pnButton = new JPanel();
        pnButton.setLayout(new BoxLayout(pnButton, 0));
        pnButton.setAlignmentX(0.0f);
        pnButton.add(Box.createHorizontalGlue());
        this.bnOK = new JButton("OK");
        this.bnOK.setActionCommand("ACTION_FILECHOOSER_OK");
        pnButton.add(this.bnOK);
        pnButton.add(Box.createHorizontalStrut(settings.getInt("netweaver.button.gap")));
        this.bnCancel = new JButton("Cancel");
        this.bnCancel.setActionCommand("ACTION_FILECHOOSER_CANCEL");
        pnButton.add(this.bnCancel);
        Dimension dim = this.bnCancel.getPreferredSize();
        int width = dim.width + buttonSpace;
        int height = dim.height;
        this.bnOK.setPreferredSize(new Dimension(width, height));
        this.bnCancel.setPreferredSize(new Dimension(width, height));
        SwingToolkit.fixHeight(pnButton);
        this.pn.add(pnButton);
        this.setDirectoriesOnlyImpl(true);
        SelectAllFocusListener.register(this.tfFile);
    }

    private void createListener() {
        this.tfFile.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.contentChange();
            }

            public void removeUpdate(DocumentEvent e) {
                this.contentChange();
            }

            public void changedUpdate(DocumentEvent e) {
            }

            private void contentChange() {
                GuiFileChooser.this.takeFromTree = false;
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GuiFileChooser.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                GuiFileChooser.this.tree.scrollPathToVisible(GuiFileChooser.this.tree.getSelectionPath());
                if (node.isRoot() && GuiFileChooser.this.windows) {
                    GuiFileChooser.this.tfFile.setText("");
                    GuiFileChooser.this.takeFromTree = false;
                } else {
                    FileNode fileNode = (FileNode)node.getUserObject();
                    GuiFileChooser.this.tfFile.setText(fileNode.getName());
                    GuiFileChooser.this.takeFromTree = true;
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                TreePath path = e.getPath();
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                GuiFileChooser.this.resetDirectory(treeNode);
                GuiFileChooser.this.insertFile(waitFileNode, treeNode);
                if (treeNode.getUserObject() == rootFileNodeWindows) {
                    GuiFileChooser.this.requestRoots();
                } else {
                    if (treeNode.getUserObject() == waitFileNode) {
                        throw new ExpandVetoException(e);
                    }
                    String dir = GuiFileChooser.this.createPath((DefaultMutableTreeNode)path.getLastPathComponent());
                    GuiFileChooser.this.requestFiles(dir, GuiFileChooser.this.dirsOnly);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            }
        });
    }

    public void setDirectoriesOnly(boolean dirsOnly) {
        if (this.dirsOnly != dirsOnly) {
            this.setDirectoriesOnlyImpl(dirsOnly);
        }
    }

    private void setDirectoriesOnlyImpl(boolean dirsOnly) {
        this.dirsOnly = dirsOnly;
        if (dirsOnly) {
            this.lbDescription.setText("Select the folder.");
            this.lbFileCaption.setText("Folder");
        } else {
            this.lbDescription.setText("Select the file.");
            this.lbFileCaption.setText("File");
        }
    }

    public void setInternalListener(SDTInternalListenerIF internalListener) {
        this.provider = new RemoteFileProvider(internalListener);
    }

    public void setCurrentDirectory(String dir) {
        this.currentDir = dir;
    }

    public synchronized void setFileNodes(String dir, FileNode[] children) {
        if (dir == null) {
            return;
        }
        Update update = new Update(dir, children);
        SwingUtilities.invokeLater(update);
    }

    private void resetDirectory(DefaultMutableTreeNode parentNode) {
        int nChilds = parentNode.getChildCount();
        for (int i = 0; i < nChilds; ++i) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)parentNode.getFirstChild());
        }
    }

    private void insertDirectory(FileNode newDirNode, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(newDirNode, true);
        this.treeModel.insertNodeInto(newChild, parent, parent.getChildCount());
        String filePath = this.createPath(newChild);
        this.directoryMap.put(filePath, newChild);
    }

    private void insertFile(FileNode newFileNode, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(newFileNode, false);
        this.treeModel.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public String getSelectedFile() {
        String path = "";
        if (this.takeFromTree) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            path = this.createPath(node);
        } else {
            path = this.tfFile.getText();
        }
        if (this.windows && path.length() == 2) {
            path = path + this.separator;
        }
        return path;
    }

    public void addActionListener(SDTActionListenerIF listener) {
        this.actionListener = (GuiActionListener)listener;
        ActionListener aL = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((ActionListener)GuiFileChooser.this.actionListener.getPeer()).actionPerformed(evt);
            }
        };
        this.bnOK.addActionListener(aL);
        this.bnCancel.addActionListener(aL);
        this.actionListener.addSource(this.bnOK, this);
        this.actionListener.addSource(this.bnCancel, this);
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public void refresh() {
        this.setDefaultButton(this.bnOK);
        this.tree.requestFocusInWindow();
        this.requestRoots();
        if (this.currentDir != null) {
            this.tfFile.setText(this.currentDir);
        }
    }

    private String createPath(DefaultMutableTreeNode node) {
        Object[] fileNodes = node.getUserObjectPath();
        StringBuffer path = new StringBuffer(fileNodes.length * 8);
        int startIndex = this.windows ? 1 : 0;
        path.append(((FileNode)fileNodes[startIndex]).getName());
        for (int i = ++startIndex; i < fileNodes.length; ++i) {
            if (i > 1 || this.windows) {
                path.append(this.separator);
            }
            path.append(((FileNode)fileNodes[i]).getName());
        }
        return path.toString();
    }

    private void requestRoots() {
        this.setEnabledUserInput(false);
        this.provider.requestRoots();
    }

    private void requestFiles(String dir, boolean dirsOnly) {
        this.setEnabledUserInput(false);
        this.provider.requestFiles(dir, dirsOnly);
    }

    private void setEnabledUserInput(boolean enabled) {
        this.tree.setEnabled(enabled);
        this.tfFile.setEnabled(enabled);
        this.bnOK.setEnabled(enabled);
        this.bnCancel.setEnabled(enabled);
        if (enabled) {
            this.sp.setCursor(Cursor.getDefaultCursor());
            this.tree.requestFocusInWindow();
        } else {
            this.sp.setCursor(Cursor.getPredefinedCursor(3));
            this.sp.requestFocusInWindow();
        }
    }

    public static void test() {
        JFrame f = new JFrame("Remote FileChooser Test");
        JPanel pn = (JPanel)f.getContentPane();
        pn.setLayout(new BorderLayout(0, 0));
        GuiFileChooser fileChooser = new GuiFileChooser();
        fileChooser.setDirectoriesOnly(true);
        pn.add((Component)fileChooser.getPeer(), "Center");
        f.setLocation(400, 200);
        f.setSize(350, 300);
        f.show();
        fileChooser.refresh();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiFileChooser.test();
        m_fMain.setDefaultCloseOperation(3);
    }

    private class Update
    implements Runnable {
        private String dir;
        private FileNode[] children;

        public Update(String dir, FileNode[] children) {
            this.dir = dir;
            this.children = children;
        }

        public void run() {
            if (this.dir.length() == 0) {
                if (this.children != null && this.children.length > 0) {
                    if (this.children.length == 1 && this.children[0].getName().equals("/")) {
                        GuiFileChooser.this.windows = false;
                        GuiFileChooser.this.separator = "/";
                        GuiFileChooser.this.rootNode.setUserObject(rootFileNodeUnix);
                        GuiFileChooser.this.directoryMap.put("/", GuiFileChooser.this.rootNode);
                        GuiFileChooser.this.tree.setSelectionRow(0);
                        GuiFileChooser.this.tree.collapseRow(0);
                        GuiFileChooser.this.tree.expandRow(0);
                    } else {
                        GuiFileChooser.this.windows = true;
                        GuiFileChooser.this.separator = GuiFileChooser.separatorWindows;
                        GuiFileChooser.this.rootNode.setUserObject(rootFileNodeWindows);
                        GuiFileChooser.this.resetDirectory(GuiFileChooser.this.rootNode);
                        for (int i = 0; i < this.children.length; ++i) {
                            FileNode driveNode = this.children[i];
                            if (driveNode.getName().equalsIgnoreCase("a:") || driveNode.getName().equalsIgnoreCase("b:")) continue;
                            GuiFileChooser.this.insertDirectory(driveNode, GuiFileChooser.this.rootNode);
                        }
                        GuiFileChooser.this.tree.setSelectionRow(1);
                    }
                }
            } else {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)GuiFileChooser.this.directoryMap.get(this.dir);
                if (parentNode != null) {
                    GuiFileChooser.this.resetDirectory(parentNode);
                    if (this.children != null && this.children.length > 0) {
                        int nChilds = this.children.length;
                        ArrayList<FileNode> dirList = new ArrayList<FileNode>(nChilds);
                        ArrayList<FileNode> fileList = new ArrayList<FileNode>(nChilds);
                        for (int i = 0; i < nChilds; ++i) {
                            FileNode fileNode = this.children[i];
                            if (fileNode.isDirectory()) {
                                dirList.add(fileNode);
                                continue;
                            }
                            fileList.add(fileNode);
                        }
                        Collections.sort(dirList);
                        Collections.sort(fileList);
                        int nDirs = dirList.size();
                        for (int j = 0; j < nDirs; ++j) {
                            GuiFileChooser.this.insertDirectory((FileNode)dirList.get(j), parentNode);
                        }
                        int nFiles = fileList.size();
                        for (int k = 0; k < nFiles; ++k) {
                            GuiFileChooser.this.insertFile((FileNode)fileList.get(k), parentNode);
                        }
                    }
                } else {
                    System.err.println("Error: GuiFileChooser.setFileNodes(): received data for unknown directory (" + this.dir + ")");
                }
            }
            GuiFileChooser.this.setEnabledUserInput(true);
        }
    }

    private class RemoteFileProvider
    implements FileProviderIF,
    SDTConstants {
        private final SDTInternalListenerIF internalListener;

        public RemoteFileProvider(SDTInternalListenerIF internalListener) {
            this.internalListener = internalListener;
        }

        public void requestRoots() {
            SDTInternalEvent evt = new SDTInternalEvent(GuiFileChooser.this, "ACTION_REQUEST_ROOTS", null);
            this.internalListener.eventPerformed(evt);
        }

        public void requestFiles(String dir, boolean dirsOnly) {
            String action = dirsOnly ? "ACTION_REQUEST_DIRECTORIES" : "ACTION_REQUEST_FILES";
            SDTInternalEvent evt = new SDTInternalEvent(GuiFileChooser.this, action, dir);
            this.internalListener.eventPerformed(evt);
        }
    }

    private class FileNodeRenderer
    extends DefaultTreeCellRenderer {
        private FileNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setEnabled(true);
            FileNode fileNode = (FileNode)((DefaultMutableTreeNode)value).getUserObject();
            if (fileNode != null) {
                String fileName = fileNode.getName();
                this.setText(fileName);
                Icon icon = null;
                if (fileNode == rootFileNodeWindows) {
                    icon = UIManager.getIcon("FileView.computerIcon");
                } else if (fileNode == rootFileNodeUnix) {
                    icon = UIManager.getIcon("FileView.hardDriveIcon");
                } else if (fileName.length() == 2 && fileName.endsWith(":")) {
                    icon = UIManager.getIcon("FileView.hardDriveIcon");
                } else if (fileNode == waitFileNode) {
                    icon = ImageHolder.TIME_ICON;
                }
                if (icon != null) {
                    this.setIcon(icon);
                    this.setDisabledIcon(icon);
                }
            }
            return this;
        }
    }
}

