/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTFileBrowserIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiCaptionComponent;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.util.SelectAllFocusListener;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GuiFileBrowser
extends GuiCaptionComponent
implements SDTFileBrowserIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiFileBrowser.java#3 $";
    private JPanel pn;
    private JPanel pathArea;
    private JTextField textField;
    private JButton browseButton;

    public GuiFileBrowser() {
        super(new JPanel());
        this.pn = (JPanel)this.peer;
        this.createDefaultLayout();
    }

    public void setText(String text) {
        this.textField.setText(SwingToolkit.getPlainText(text));
    }

    public String getText() {
        return this.textField.getText();
    }

    public void addBrowseListener(String action, SDTActionListenerIF listener) {
        this.browseButton.setActionCommand(action);
        GuiActionListener gL = (GuiActionListener)listener;
        this.browseButton.addActionListener(gL.peer());
        gL.addSource(this.browseButton, this);
    }

    public void setEnabled(boolean isEnabled) {
        this.caption.setEnabled(isEnabled);
        this.textField.setEnabled(isEnabled);
        this.textField.setEditable(isEnabled);
        this.browseButton.setEnabled(isEnabled);
    }

    public boolean validate() {
        return true;
    }

    private void createDefaultLayout() {
        this.pathArea = new JPanel();
        this.textField = new JTextField();
        GuiAction browseAction = new GuiAction(null, "BROWSE", null);
        this.browseButton = new JButton();
        this.browseButton.setAction(browseAction);
        this.browseButton.setRequestFocusEnabled(false);
        this.browseButton.setFont(GuiSettings.getInstance().getFont("label"));
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.textField.setFont(GuiSettings.getInstance().getFont("input"));
        this.pathArea.setLayout(new BoxLayout(this.pathArea, 0));
        this.pathArea.add(this.textField);
        this.pathArea.add(Box.createHorizontalStrut(5));
        this.pathArea.add(this.browseButton);
        this.pn.setLayout(new BoxLayout(this.pn, 0));
        this.pn.add(this.caption);
        this.pn.add(Box.createHorizontalStrut(5));
        this.pn.add(this.pathArea);
        this.pn.putClientProperty("alignable_container", Boolean.TRUE);
        this.pn.putClientProperty("left_component", this.caption);
        this.pn.putClientProperty("right_component", this.pathArea);
        this.caption.setLabelFor(this.textField);
        this.textField.addKeyListener(this.keyL);
        this.browseButton.addKeyListener(this.keyL);
        SelectAllFocusListener.register(this.textField);
    }
}

