/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTDynamicControlIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.controls.GuiPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class GuiDynamicControl
extends GuiControl
implements SDTDynamicControlIF {
    private JSplitPane pane;
    private int orientation;
    private SDTControlIF dynamic;
    private JPanel dPart;
    private JComponent dContent;
    private int divider_location;
    private BasicSplitPaneDivider divider;

    public GuiDynamicControl() {
        super(new JSplitPane(0));
        this.pane = (JSplitPane)this.peer;
        for (int i = 0; i < this.pane.getComponentCount(); ++i) {
            Component c = this.pane.getComponent(i);
            if (!(c instanceof BasicSplitPaneDivider)) continue;
            this.divider = (BasicSplitPaneDivider)c;
        }
    }

    public SDTControlIF getDynamicPart() {
        return this.dynamic;
    }

    public void setDynamicPart(SDTControlIF dynamic) {
        this.dynamic = dynamic;
        this.setDynamicPartContent(((GuiControl)dynamic).getPeer());
        if (this.orientation == 1) {
            this.pane.setRightComponent(this.dPart);
        } else {
            this.pane.setBottomComponent(this.dPart);
        }
    }

    private JPanel initDynamicPart() {
        JPanel dPanel = new JPanel();
        dPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setLayout(new BorderLayout());
        JButton b = new JButton("hide");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                GuiDynamicControl.this.hideAction();
            }
        });
        b.putClientProperty("buttontype", "AppToolbar");
        toolBar.putClientProperty("toolbarType", new Integer(4));
        toolBar.add((Component)b, "East");
        dPanel.add((Component)toolBar, "First");
        this.dContent = new JPanel();
        dPanel.add((Component)this.dContent, "South");
        return dPanel;
    }

    private void showAction() {
        if (this.dPart.isVisible()) {
            return;
        }
        this.dPart.setVisible(true);
        if (this.divider_location == 0) {
            this.divider_location = 150;
        }
        this.pane.setDividerLocation(this.divider_location);
        this.divider.setVisible(true);
    }

    private void hideAction() {
        this.divider_location = this.pane.getDividerLocation();
        this.dPart.setVisible(false);
        this.divider.setVisible(false);
    }

    private void setDynamicPartContent(JComponent component) {
        if (this.dPart == null) {
            this.dPart = this.initDynamicPart();
        }
        this.dPart.remove(this.dContent);
        this.dContent = component;
        this.dPart.add((Component)this.dContent, "Center");
    }

    public void setEnabled(boolean enabled) {
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.pane.setOrientation(orientation);
    }

    public void setStaticPart(SDTControlIF staticPart) {
        if (this.orientation == 1) {
            this.pane.setLeftComponent(((GuiControl)staticPart).getPeer());
        } else {
            this.pane.setTopComponent(((GuiControl)staticPart).getPeer());
        }
    }

    public void showDynamicPart() {
        this.showAction();
    }

    public void hideDynamicPart() {
        this.hideAction();
    }

    public static void test() {
        GuiSettings.getInstance();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        final GuiDynamicControl c = new GuiDynamicControl();
        GuiPanel p = new GuiPanel();
        JButton b = new JButton("show");
        final GuiPanel testD = new GuiPanel();
        c.setDynamicPart(new GuiPanel());
        c.showDynamicPart();
        testD.getPeer().add(new JButton("set"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                c.setDynamicPart(testD);
                c.showDynamicPart();
            }
        });
        p.getPeer().add(b);
        c.setStaticPart(p);
        f.getContentPane().add(c.getPeer());
        f.setSize(400, 500);
        f.setVisible(true);
    }
}

