/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTInternalListenerIF;
import com.sap.sdt.gui.core.help.HelpEvent;
import com.sap.sdt.gui.core.help.HelpListener;
import com.sap.sdt.gui.core.swing.controls.GuiBase;
import com.sap.sdt.gui.core.swing.help.GuiHelp;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public abstract class GuiControl
extends GuiBase
implements SDTControlIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiControl.java#2 $";
    protected JComponent peer = null;
    protected ArrayList helpListeners = null;
    protected KeyL keyL = new KeyL();
    protected MouseL mouseL = new MouseL();
    protected SDTInternalListenerIF resolver = null;
    protected Object sync = new Object();
    protected String help = null;
    protected String helpItemID = null;
    protected String resolvedHelp = null;
    protected String additionalHelpText = "";

    protected GuiControl(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        this.peer = comp;
        this.peer.setAlignmentX(0.0f);
        GuiHelp.setHelp(this);
        comp.addKeyListener(this.keyL);
        comp.addMouseListener(this.mouseL);
    }

    public void refresh() {
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setHelpItemID(String id) {
        this.helpItemID = id;
    }

    public String getHelpItemID() {
        return this.helpItemID;
    }

    public void setResolver(SDTInternalListenerIF resolver) {
        this.resolver = resolver;
    }

    public SDTInternalListenerIF getResolver() {
        return this.resolver;
    }

    public String getAdditionalHelpText() {
        return this.additionalHelpText;
    }

    public void setAdditionalHelpText(String text) {
        this.additionalHelpText = text;
    }

    public JComponent getPeer() {
        return this.peer;
    }

    public void addHelpListener(HelpListener listener) {
        if (this.helpListeners == null) {
            this.helpListeners = new ArrayList();
        }
        this.helpListeners.add(listener);
    }

    public void setDefaultButton(JButton bn) {
        for (Container o = this.peer; o != null; o = o.getParent()) {
            if (!(o instanceof JRootPane)) continue;
            ((JRootPane)o).setDefaultButton(bn);
            break;
        }
    }

    protected void helpRequested() {
        for (int i = 0; i < this.helpListeners.size(); ++i) {
            ((HelpListener)this.helpListeners.get(i)).helpRequested(new HelpEvent(this));
        }
    }

    protected void performMouseClicked(MouseEvent e) {
    }

    protected void performMouseReleased(MouseEvent e) {
    }

    protected void performKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 112) {
            this.helpRequested();
        }
    }

    private class KeyL
    extends KeyAdapter {
        private KeyL() {
        }

        public void keyPressed(KeyEvent e) {
            GuiControl.this.performKeyPressed(e);
        }
    }

    private class MouseL
    implements MouseListener {
        private MouseL() {
        }

        public void mouseClicked(MouseEvent e) {
            GuiControl.this.performMouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            GuiControl.this.performMouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

