/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTContainerIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JPanel;

abstract class GuiContainer
extends GuiControl
implements SDTContainerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiContainer.java#2 $";
    private final JPanel panel;
    protected ContainerL containerL = new ContainerL();

    public GuiContainer() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.peer().addContainerListener(this.containerL);
    }

    protected JPanel peer() {
        return this.panel;
    }

    public void add(SDTControlIF child) {
        this.peer.add(((GuiControl)child).getPeer());
    }

    public void remove(SDTControlIF child) {
        this.peer.remove(((GuiControl)child).getPeer());
    }

    public void removeAll() {
        this.peer.removeAll();
    }

    private void addListenersRecursively(Component c) {
        c.addMouseListener(this.mouseL);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this.containerL);
            cont.addContainerListener(this.containerL);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addListenersRecursively(children[i]);
            }
        }
    }

    private void removeListenersRecursively(Component c) {
        c.removeMouseListener(this.mouseL);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this.containerL);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeListenersRecursively(children[i]);
            }
        }
    }

    private class ContainerL
    extends ContainerAdapter {
        private ContainerL() {
        }

        public void componentAdded(ContainerEvent e) {
            GuiContainer.this.addListenersRecursively(e.getChild());
        }

        public void componentRemoved(ContainerEvent e) {
            GuiContainer.this.removeListenersRecursively(e.getChild());
        }
    }
}

