/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTComboBoxIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiCaptionComponent;
import com.sap.sdt.gui.core.swing.util.SelectAllFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

class GuiComboBox
extends GuiCaptionComponent
implements SDTComboBoxIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiComboBox.java#2 $";
    private static JComboBox coHelp = new JComboBox();
    private final JPanel panel = (JPanel)this.peer;
    private JComboBox comboBox = new JComboBox();
    boolean isWidthFix = false;
    int width = 0;

    GuiComboBox() {
        super(new JPanel());
        this.createDefaultLayout();
    }

    public void createDefaultLayout() {
        this.caption.setLabelFor(this.comboBox);
        this.comboBox.setEditable(false);
        this.comboBox.setFont(GuiSettings.getInstance().getFont("input"));
        this.comboBox.addKeyListener(this.keyL);
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.caption);
        int hgap = GuiSettings.getInstance().getInt("layout.horizontal.gap");
        this.panel.add(Box.createHorizontalStrut(hgap));
        this.panel.add(this.comboBox);
        this.panel.putClientProperty("alignable_container", Boolean.TRUE);
        this.panel.putClientProperty("left_component", this.caption);
        this.panel.putClientProperty("right_component", this.comboBox);
        Component comp = this.comboBox.getEditor().getEditorComponent();
        if (comp instanceof JTextComponent) {
            SelectAllFocusListener.register((JTextComponent)comp);
        }
    }

    public boolean validate() {
        if (this.comboBox.isEditable()) {
            Object newItem = this.comboBox.getEditor().getItem();
            this.comboBox.setPopupVisible(false);
            this.comboBox.getModel().setSelectedItem(newItem);
        }
        return true;
    }

    public List getItems() {
        Vector items = new Vector();
        int count = this.comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            items.add(this.comboBox.getItemAt(i));
        }
        return items;
    }

    public void setEditable(boolean isEditable) {
        boolean change;
        boolean bl = change = isEditable != this.comboBox.isEditable();
        if (change) {
            this.comboBox.setEditable(isEditable);
            this.visualUpdateWidth();
        }
    }

    public void setSelectedItem(Object selectedItem) {
        this.comboBox.setSelectedItem(selectedItem);
    }

    public Object getSelectedItem() {
        return this.comboBox.getSelectedItem();
    }

    public void addItem(Object item) {
        int length;
        this.comboBox.addItem(item);
        if (!this.isWidthFix && item instanceof String && (length = ((String)item).length()) > this.width) {
            this.width = length;
            this.visualUpdateWidth();
        }
    }

    public void setEnabled(boolean b) {
        this.comboBox.setEnabled(b);
        this.caption.setEnabled(b);
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.isWidthFix = true;
            this.width = width;
            this.visualUpdateWidth();
        }
    }

    private void visualUpdateWidth() {
        if (this.isWidthFix) {
            this.syncWidth();
        } else if (this.comboBox.isEditable()) {
            this.setWidthToMax();
        } else if (this.width > 0) {
            this.syncWidth();
        } else {
            this.setWidthToMax();
        }
    }

    private void syncWidth() {
        char[] fillArr = new char[this.width + 1];
        String fillStr = new String(fillArr);
        this.comboBox.setPrototypeDisplayValue(fillStr);
        coHelp.setPrototypeDisplayValue(fillStr);
        this.comboBox.setMaximumSize(coHelp.getPreferredSize());
    }

    private void setWidthToMax() {
        this.comboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    static {
        coHelp.setEditable(false);
        coHelp.setFont(GuiSettings.getInstance().getFont("input"));
    }
}

