/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTButtonIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class GuiButton
extends GuiComponent
implements SDTButtonIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiButton.java#2 $";
    private final JButton button = (JButton)this.peer;
    private boolean isDefault = false;

    public GuiButton() {
        super(new JButton());
        this.button.setFont(GuiSettings.getInstance().getFont("label"));
    }

    public void setEnabled(boolean isEnabled) {
        this.button.setEnabled(isEnabled);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public boolean validate() {
        return true;
    }

    public void setActionCommand(String action) {
        this.button.setActionCommand(action);
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setToolTip(String toolTip) {
        this.button.setToolTipText(toolTip);
    }

    public void addActionListener(SDTActionListenerIF listener) {
        GuiActionListener gL = (GuiActionListener)listener;
        this.button.addActionListener(gL.peer());
        gL.addSource(this.button, this);
    }

    public void removeActionListener(SDTActionListenerIF listener) {
        GuiActionListener gL = (GuiActionListener)listener;
        this.button.removeActionListener(gL.peer());
        gL.removeSource(this.button);
    }

    public void setCaption(String caption, char mnemonic) {
        this.button.setText(caption);
        this.button.setMnemonic(mnemonic);
    }

    public void setMnemonicIndex(int index) {
        this.button.setDisplayedMnemonicIndex(index);
    }

    public String getCaption() {
        return this.button.getText();
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        JFrame f = new JFrame("GuiButton Test");
        GuiButton bn = new GuiButton();
        bn.setToolTip("Test");
        bn.setCaption("Log Off", 'o');
        bn.setMnemonicIndex(4);
        f.getContentPane().add(bn.getPeer());
        f.pack();
        f.setLocation(200, 100);
        f.show();
        f.setDefaultCloseOperation(3);
    }
}

