/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.communication.CmdActionEvent;
import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceID;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.engine.core.event.SDTEvent;
import com.sap.sdt.gui.core.swing.controls.GuiListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GuiActionListener
extends GuiListener
implements SDTActionListenerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiActionListener.java#2 $";
    private static final Class[] ARGS = new Class[]{SDTActionEvent.class};

    public GuiActionListener() {
        this.peer = new Listener(this);
    }

    public void actionPerformed(SDTActionEvent event) {
        if (this.isLocal) {
            this.localEvent(event);
        } else {
            this.remoteEvent(event);
        }
    }

    protected void remoteEvent(SDTEvent event) {
        ServiceID invoker = null;
        try {
            invoker = ServiceManager.getService(this).getID();
        }
        catch (ServiceException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        CmdConsumerIF consumer = ServiceManager.getConsumer(invoker);
        CmdActionEvent cmd = new CmdActionEvent(invoker, (SDTActionEvent)event);
        consumer.consumeAndContinue(cmd);
    }

    protected final String getCls() {
        return "SDTActionListener";
    }

    protected final String getName() {
        return "actionPerformed";
    }

    protected final Class[] getArgs() {
        return ARGS;
    }

    public final ActionListener peer() {
        return (ActionListener)this.peer;
    }

    private class Listener
    implements ActionListener {
        private GuiActionListener listener = null;

        private Listener(GuiActionListener listener) {
            this.listener = listener;
        }

        public void actionPerformed(ActionEvent e) {
            SDTControlIF source = GuiActionListener.this.getSource(e.getSource());
            String action = e.getActionCommand();
            SDTActionEvent aE = new SDTActionEvent(source, action);
            this.listener.actionPerformed(aE);
        }
    }
}

