/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiCheckBox;
import com.sap.sdt.gui.core.swing.controls.GuiLabel;
import com.sap.sdt.gui.core.swing.controls.GuiPasswordField;
import com.sap.sdt.gui.core.swing.controls.GuiRadioBox;
import com.sap.sdt.gui.core.swing.controls.GuiRadioButton;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import com.sap.sdt.gui.core.swing.controls.GuiTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AlignableLayout
implements LayoutManager {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/AlignableLayout.java#2 $";
    public static final String ALIGNABLE_CONTAINER_KEY = "alignable_container";
    public static final String LEFT_COMPONENT_KEY = "left_component";
    public static final String RIGHT_COMPONENT_KEY = "right_component";
    public static final String ALIGNMENT_KEY = "alignment";
    public static final String STRETCH_Y_KEY = "resizing";
    public static final String TOP = "top";
    protected int m_divider = -1;
    protected int m_hGap = 5;
    protected int m_vGap = 8;
    private Dimension prefSize = new Dimension(0, 0);
    private int nResizables = 0;
    private static final String ALIGNABLE_PAIR_KEY = "alignable_pair";
    private static JFrame frame1;
    private static JFrame frame2;

    public AlignableLayout() {
    }

    public AlignableLayout(int hGap, int vGap) {
        this.m_hGap = hGap;
        this.m_vGap = vGap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension size;
        this.resolveAlignableContainer(target);
        int divider = this.getDivider(target);
        ArrayList htmlViews = new ArrayList();
        int w = 0;
        int h = 0;
        for (int k = 0; k < target.getComponentCount(); ++k) {
            JComponent leftComp = (JComponent)target.getComponent(k);
            if (leftComp.getClientProperty(ALIGNABLE_PAIR_KEY) == Boolean.TRUE) {
                Component rightComp = target.getComponent(++k);
                Dimension dimLeftComp = leftComp.getPreferredSize();
                Dimension dimRightComp = rightComp.getPreferredSize();
                w = Math.max(w, dimRightComp.width);
                h += Math.max(dimLeftComp.height, dimRightComp.height) + this.m_vGap;
                continue;
            }
            Dimension dim = leftComp.getPreferredSize();
            h += dim.height + this.m_vGap;
        }
        Insets insets = target.getInsets();
        this.prefSize = size = new Dimension(divider + w + insets.left + insets.right, (h -= this.m_vGap) + insets.top + insets.bottom);
        return size;
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public void layoutContainer(Container target) {
        this.resolveAlignableContainer(target);
        int divider = this.getDivider(target);
        Insets insets = target.getInsets();
        int width = target.getWidth() - insets.left - insets.right;
        int height = target.getHeight();
        int remainingHeight = Math.max(0, height - this.prefSize.height);
        int x = insets.left;
        int y = insets.top;
        for (int k = 0; k < target.getComponentCount(); ++k) {
            JComponent leftComp = (JComponent)target.getComponent(k);
            if (leftComp.getClientProperty(ALIGNABLE_PAIR_KEY) == Boolean.TRUE) {
                Component rightComp = target.getComponent(++k);
                Dimension dimLeftComp = leftComp.getPreferredSize();
                Dimension dimRightComp = rightComp.getPreferredSize();
                int h = Math.max(dimLeftComp.height, dimRightComp.height);
                if (leftComp.getClientProperty(ALIGNMENT_KEY) == TOP) {
                    leftComp.setBounds(x, y, divider - this.m_hGap, dimLeftComp.height);
                } else {
                    leftComp.setBounds(x, y + (h - dimLeftComp.height) / 2, divider - this.m_hGap, dimLeftComp.height);
                }
                rightComp.setBounds(x + divider, y + (h - dimRightComp.height) / 2, Math.min(rightComp.getMaximumSize().width, width - divider), dimRightComp.height);
                y += h + this.m_vGap;
                continue;
            }
            Dimension dimLeftComp = leftComp.getPreferredSize();
            int heightLeftComp = dimLeftComp.height;
            if (leftComp.getClientProperty(STRETCH_Y_KEY) == Boolean.TRUE) {
                heightLeftComp += remainingHeight / this.nResizables;
            }
            leftComp.setBounds(x, y, width, heightLeftComp);
            y += heightLeftComp + this.m_vGap;
        }
    }

    public void setHorizontalGap(int hGap) {
        this.m_hGap = hGap;
    }

    public void setVerticalGap(int vGap) {
        this.m_vGap = vGap;
    }

    public int getHorizontalGap() {
        return this.m_hGap;
    }

    public int getVerticalGap() {
        return this.m_vGap;
    }

    public void setDivider(int divider) {
        if (divider > 0) {
            this.m_divider = divider;
        }
    }

    public int getDivider() {
        return this.m_divider;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.m_hGap + ",vgap=" + this.m_vGap + ",divider=" + this.m_divider + "]";
    }

    protected int getDivider(Container target) {
        if (this.m_divider > 0) {
            return this.m_divider;
        }
        int divider = 0;
        for (int k = 0; k < target.getComponentCount(); ++k) {
            JComponent comp = (JComponent)target.getComponent(k);
            if (comp.getClientProperty(ALIGNABLE_PAIR_KEY) != Boolean.TRUE) continue;
            Dimension dim = comp.getPreferredSize();
            divider = Math.max(divider, dim.width);
        }
        return divider += this.m_hGap;
    }

    protected void resolveAlignableContainer(Container target) {
        this.nResizables = 0;
        for (int k = 0; k < target.getComponentCount(); ++k) {
            JComponent comp = (JComponent)target.getComponent(k);
            if (comp.getClientProperty(ALIGNABLE_CONTAINER_KEY) == Boolean.TRUE) {
                target.remove(k);
                JComponent leftComp = (JComponent)comp.getClientProperty(LEFT_COMPONENT_KEY);
                JComponent rightComp = (JComponent)comp.getClientProperty(RIGHT_COMPONENT_KEY);
                if (leftComp == null || rightComp == null) continue;
                leftComp.putClientProperty(ALIGNABLE_PAIR_KEY, Boolean.TRUE);
                target.add((Component)rightComp, k);
                target.add((Component)leftComp, k);
                ++k;
                continue;
            }
            if (comp.getClientProperty(STRETCH_Y_KEY) != Boolean.TRUE) continue;
            ++this.nResizables;
        }
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        AlignableLayout.test();
        frame1.setDefaultCloseOperation(3);
        frame2.setDefaultCloseOperation(3);
    }

    public static void test() {
        JFrame fBox;
        JFrame fAligned;
        frame1 = fAligned = new JFrame("AlignableLayout Test");
        JPanel pnAligned = AlignableLayout.createTestPanel();
        pnAligned.setLayout(new AlignableLayout());
        fAligned.setContentPane(pnAligned);
        fAligned.pack();
        fAligned.setLocation(100, 100);
        fAligned.show();
        fAligned.setSize(fAligned.getPreferredSize());
        fAligned.validate();
        fAligned.repaint();
        frame2 = fBox = new JFrame("BoxLayout Y-Axis Test");
        JPanel pnBox = AlignableLayout.createTestPanel();
        pnBox.setLayout(new BoxLayout(pnBox, 1));
        pnBox.add(Box.createVerticalStrut(Short.MAX_VALUE));
        fBox.setContentPane(pnBox);
        fBox.pack();
        Point p = fAligned.getLocation();
        fBox.setLocation(p.x, p.y + fAligned.getHeight() + 10);
        fBox.show();
        fBox.setSize(fAligned.getPreferredSize());
        fBox.validate();
        fBox.repaint();
    }

    private static JPanel createTestPanel() {
        JPanel pn = new JPanel();
        pn.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GuiTextField tf1 = new GuiTextField();
        tf1.setCaption("Textfield", 'd');
        tf1.setMaxLength(10);
        GuiTextField tf2 = new GuiTextField();
        tf2.setCaption("Textfield", 'F');
        tf2.setMaxLength(3);
        tf2.setText("default value");
        tf2.getPeer().setBorder(BorderFactory.createLineBorder(Color.red, 5));
        GuiTextField tf3 = new GuiTextField();
        tf3.setCaption("Henrik's Textfield", 't');
        GuiTextField tf4 = new GuiTextField();
        tf4.setEnabled(false);
        tf4.setCaption("Textfield disabled", 'e');
        tf4.setText("Test");
        GuiLabel lb1 = new GuiLabel();
        lb1.setText("This is just a test label with as much text as is required to fill more than just a single line.");
        lb1.setBold(false);
        GuiStyledText st1 = new GuiStyledText();
        st1.setText("<html>Das ist ein <font size='+2'><i>HTML</i></font> label in <font color='#FF0000'>red</font>.</html>");
        GuiRadioButton rb1 = new GuiRadioButton();
        rb1.setCaption("NT", 'n');
        rb1.setSelected(true);
        GuiRadioButton rb2 = new GuiRadioButton();
        rb2.setCaption("Unix", 'u');
        GuiRadioBox radioBox = new GuiRadioBox();
        radioBox.setCaption("Choose OS type", 'O');
        radioBox.add(rb1);
        radioBox.add(rb2);
        GuiCheckBox cb1 = new GuiCheckBox();
        cb1.setCaption("CheckBox", 'x');
        GuiPasswordField psw = new GuiPasswordField();
        psw.setCaption("Input Password", 'p');
        pn.add(radioBox.getPeer());
        pn.add(tf1.getPeer());
        pn.add(tf2.getPeer());
        pn.add(st1.getPeer());
        int index = pn.getComponentCount();
        pn.add(tf3.getPeer());
        pn.add(lb1.getPeer());
        pn.add(cb1.getPeer());
        pn.add(tf4.getPeer());
        pn.add(psw.getPeer());
        return pn;
    }
}

