/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.settings;

import com.sap.sdt.util.misc.JavaRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class GuiSettings {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/settings/GuiSettings.java#2 $";
    private static final GuiSettings instance;
    private static final boolean onWindows;
    private static final boolean onWebstart;
    private final Properties settings;
    private final HashMap alternates;
    private final HashMap resourceCache;
    private HashMap sapFonts;
    private final String DEFAULT_SETTING_FILE_NAME = "settings.properties";
    private final String FONT_POSTFIX = ".font";
    private final String NAME_POSTFIX = ".name";
    private final String STYLE_POSTFIX = ".style";
    private final String SIZE_POSTFIX = ".size";
    private final String FOREGROUND_POSTFIX = ".foreground";
    private final String BACKGROUND_POSTFIX = ".background";
    private static String lookAndFeelID;
    private final String ALTERNATE_KEY = "alternate";
    private final String HEIGHTLIMIT_POSTFIX = ".heightlimit";

    private GuiSettings() {
        JDialog.setDefaultLookAndFeelDecorated(false);
        this.settings = new Properties();
        this.resourceCache = new HashMap(512);
        this.alternates = new HashMap();
        this.sapFonts = this.createSAPFonts();
        this.load("settings.properties");
        this.setLookAndFeel(this.getString("laf.current.class"), this.getString("laf.current.theme"));
        this.createAlternates();
        this.createDefaults();
    }

    public static GuiSettings getInstance() {
        return instance;
    }

    public static boolean isWindows() {
        return onWindows;
    }

    public static boolean isWebStart() {
        return onWebstart;
    }

    public void load(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("settings file name must not be null");
        }
        InputStream in = GuiSettings.class.getResourceAsStream(fileName);
        if (in == null) {
            throw new IllegalArgumentException("settings file must exist");
        }
        try {
            this.settings.load(in);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.resourceCache.clear();
    }

    private String getString(String key) {
        while (key.length() > 0) {
            String value = this.settings.getProperty(key, "");
            if (value.length() > 0) {
                return value;
            }
            key = this.getParent(key);
        }
        return "";
    }

    private boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value.length() == 0) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public int getInt(String key) {
        String value = this.getString(key);
        if (value.length() == 0) {
            return -1;
        }
        try {
            int intValue = Integer.parseInt(value);
            return intValue;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Locale getLocale() {
        Locale locale = Locale.getDefault();
        String localeName = this.getString("locale");
        if (localeName.equalsIgnoreCase("english")) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public Font getFont(String key) {
        Font font;
        Object o = this.resourceCache.get(key = key + ".font");
        if (o instanceof Font) {
            return (Font)o;
        }
        String fontName = this.getString(key + ".name");
        int fontStyle = this.getInt(key + ".style");
        int fontSize = this.getInt(key + ".size");
        String SAP_PREFIX = "sap_";
        if (fontName.startsWith("sap_")) {
            String sapFontName = fontName.substring("sap_".length());
            font = (Font)this.sapFonts.get(sapFontName);
            if (font != null) {
                font = font.deriveFont(fontStyle, fontSize);
            }
        } else {
            String alternateFontName = (String)this.alternates.get(fontName);
            if (alternateFontName != null) {
                fontName = alternateFontName;
            }
            font = new Font(fontName, fontStyle, fontSize);
        }
        this.resourceCache.put(key, font);
        return font;
    }

    public Color getForeground(String key) {
        return this.getColor(key + ".foreground");
    }

    public void setForeground(Component comp, String key) {
        Color color = this.getForeground(key);
        if (color != null) {
            comp.setForeground(color);
        }
    }

    public Color getBackground(String key) {
        return this.getColor(key + ".background");
    }

    public void setBackground(Component comp, String key) {
        Color color = this.getBackground(key);
        if (color != null) {
            comp.setBackground(color);
        }
    }

    public Border getBorder(String key) {
        Object o = this.resourceCache.get(key);
        if (o instanceof Border) {
            return (Border)o;
        }
        return BorderFactory.createEmptyBorder();
    }

    public void setLookAndFeel(String className, String theme) {
        Locale.setDefault(this.getLocale());
        try {
            Class<?> lookAndFeelClass = Class.forName(className);
            LookAndFeel lookAndFeel = (LookAndFeel)lookAndFeelClass.newInstance();
            if (theme.length() > 0) {
                UIManager.put("currentTheme", theme);
            }
            UIManager.setLookAndFeel(lookAndFeel);
            this.initLookAndFeelDependend();
        }
        catch (Exception exception) {
            // empty catch block
        }
        lookAndFeelID = UIManager.getLookAndFeel().getID();
    }

    public static boolean isBuggyWindowsLookAndFeel() {
        return lookAndFeelID.equals("Windows") && JavaRuntime.isExactVersion(new int[]{1, 4});
    }

    public static boolean isFrogLookAndFeel() {
        return lookAndFeelID.equals("Frog");
    }

    private HashMap createSAPFonts() {
        HashMap<String, Font> fonts = new HashMap<String, Font>();
        InputStream in = GuiSettings.class.getResourceAsStream("arimon__.ttf");
        if (in != null) {
            try {
                Font font = Font.createFont(0, in);
                in.close();
                fonts.put("monospaced", font);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fonts;
    }

    private void createDefaults() {
        this.setOptional("laf.current.class", "com.sap.plaf.frog.FrogLookAndFeel");
        this.setOptional("font.name", GuiSettings.isWindows() ? "sansserif" : "lucida sans");
        this.setOptional("font.style", "0");
        this.setOptional("font.size", "12");
        this.setOptional("form.background", Integer.toString(UIManager.getColor("Panel.background").getRGB()));
        this.setOptional("summary.background", Integer.toString(UIManager.getColor("Panel.background").getRGB()));
    }

    private void createAlternates() {
        JLabel lb = new JLabel();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> fontList = Arrays.asList(ge.getAvailableFontFamilyNames());
        Enumeration<Object> enumeration = this.settings.keys();
        while (enumeration.hasMoreElements()) {
            FontMetrics fm;
            int fontHeight;
            String name;
            String type;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("alternate") || !(type = key.substring("alternate".length())).startsWith(".font.") || (name = type.substring(".font".length() + 1)).length() <= 0 || name.indexOf(46) != -1) continue;
            String fontName = name;
            String alternateFontName = this.settings.getProperty(key);
            String currentFontKey = "alternate.font." + fontName;
            int fontSize = this.getInt(currentFontKey + ".size");
            int fontHeightLimit = this.getInt(currentFontKey + ".heightlimit");
            if (alternateFontName == null || fontSize <= 0 || fontHeightLimit < fontSize || (fontHeight = (fm = lb.getFontMetrics(new Font(fontName, 0, fontSize))).getHeight()) <= fontHeightLimit || !fontList.contains(alternateFontName)) continue;
            this.alternates.put(fontName, alternateFontName);
        }
    }

    private void initLookAndFeelDependend() {
        this.resourceCache.put("cell.nofocus.border", BorderFactory.createEmptyBorder(0, 2, 0, 1));
        this.resourceCache.put("cell.focus.border", UIManager.getBorder("Component.cellFocusBorder"));
    }

    private void setOptional(String key, String value) {
        if (this.getString(key).length() == 0) {
            this.settings.put(key, value);
        }
    }

    private String getParent(String key) {
        int pos = key.indexOf(46);
        if (pos != -1) {
            return key.substring(++pos);
        }
        return "";
    }

    private Color getColor(String key) {
        String colorRGB;
        Color color = null;
        Object o = this.resourceCache.get(key);
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o == null && (colorRGB = this.getString(key)).length() > 0) {
            try {
                color = Color.decode(colorRGB);
            }
            catch (NumberFormatException enf) {
                // empty catch block
            }
        }
        this.resourceCache.put(key, color);
        return color;
    }

    public static void main(String[] args) {
        GuiSettings settings = GuiSettings.getInstance();
        System.out.println(settings.getBackground("header.description.text"));
        System.out.println(settings.getFont("test"));
        System.exit(0);
    }

    static {
        onWindows = System.getProperty("os.name").startsWith("Windows");
        boolean webstartClassExists = false;
        try {
            ClassLoader.getSystemClassLoader().loadClass("javax.jnlp.ClipboardService");
            webstartClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        onWebstart = webstartClassExists;
        instance = new GuiSettings();
    }
}

