/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.services.tool.views;

import com.sap.sdt.engine.core.controls.SDTButtonIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTFileChooserIF;
import com.sap.sdt.engine.core.services.tool.views.SDTNetWeaverViewIF;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstLogBrowserIF;
import com.sap.sdt.gui.core.images.ImageHolder;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiButton;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.controls.GuiFileChooser;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import com.sap.sdt.gui.core.swing.controls.GuiView;
import com.sap.sdt.gui.core.swing.help.GuiHelp;
import com.sap.sdt.gui.core.swing.ui.Gui;
import com.sap.sdt.gui.core.swing.ui.GuiDialog;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import com.sap.sdt.gui.ext.sapinst.swing.controls.SAPinstLogBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class GuiNetWeaverView
extends GuiView
implements SDTNetWeaverViewIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/services/tool/views/GuiNetWeaverView.java#2 $";
    public static final String SCROLLABLE_KEY = "scrollable_form";
    public static final String NEXT_BUTTON_KEY = "next_button_key";
    private static final GuiSettings settings = GuiSettings.getInstance();
    private static final int buttonSpace = settings.getInt("netweaver.button.space.side");
    private JPanel pnHelp = this.peer();
    private JScrollPane sc;
    private JScrollablePanel pn;
    private JComponent form;
    private JLabel lbTitle;
    private GuiStyledText stDescription;
    private JPanel pnForm;
    private JPanel pnNavigation;
    private JPanel pnStatus;
    private JLabel lbStatus;
    private int maxWidth = 0;
    private Component lastFocusComp;
    private boolean isWaiting = false;
    private JDialog dialog = null;
    private JDialog logDialog = null;
    private JDialog fileDialog = null;
    private static JFrame m_fMain;

    public GuiNetWeaverView() {
        this.createDefaultLayout();
    }

    private void createDefaultLayout() {
        this.pn = new JScrollablePanel();
        this.pn.setLayout(new BorderLayout());
        this.pn.setBackground(settings.getBackground("netweaver"));
        this.addImage();
        this.addLine();
        this.addContent();
        this.addNavigation();
        this.sc = new JScrollPane(this.pn);
        this.sc.setBorder(null);
        this.pnHelp.setLayout(new BorderLayout());
        this.pnHelp.add(this.sc);
    }

    private void addImage() {
        JLabel lb = new JLabel(ImageHolder.NETWEAVER_IMAGE);
        lb.setHorizontalAlignment(2);
        lb.setAlignmentX(0.0f);
        SwingToolkit.setWidth(lb, Short.MAX_VALUE);
        this.pn.add((Component)lb, "North");
    }

    private void addLine() {
    }

    private void addContent() {
        JPanel pnContent = new JPanel();
        pnContent.putClientProperty("Preview", Boolean.TRUE);
        pnContent.setLayout(new BoxLayout(pnContent, 1));
        pnContent.setBackground(settings.getBackground("netweaver"));
        pnContent.setBorder(BorderFactory.createEmptyBorder(settings.getInt("netweaver.content.space.top"), settings.getInt("netweaver.content.space.side"), 0, settings.getInt("netweaver.content.space.side")));
        this.lbTitle = new JLabel();
        this.lbTitle.setAlignmentX(0.0f);
        this.lbTitle.setFont(settings.getFont("header.title.text"));
        this.lbTitle.setForeground(settings.getForeground("header.title.netweaver.text"));
        this.lbTitle.setForeground(settings.getForeground("header.title.netweaver.text"));
        pnContent.add(this.lbTitle);
        pnContent.add(Box.createVerticalStrut(settings.getInt("netweaver.title.description.gap")));
        this.stDescription = new GuiStyledText();
        this.stDescription.getPeer().setAlignmentX(0.0f);
        SwingToolkit.setHeight(this.stDescription.getPeer(), 40);
        pnContent.add(this.stDescription.getPeer());
        pnContent.add(Box.createVerticalStrut(settings.getInt("netweaver.description.form.gap")));
        this.pnForm = new JPanel();
        this.pnForm.setLayout(new BorderLayout());
        this.pnForm.setAlignmentX(0.0f);
        this.pnForm.setOpaque(false);
        this.pnForm.setBackground(settings.getBackground("form.netweaver"));
        this.pnForm.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createMatteBorder(settings.getInt("netweaver.form.space.top"), settings.getInt("netweaver.form.space.side"), settings.getInt("netweaver.form.space.bottom"), settings.getInt("netweaver.form.space.side"), settings.getBackground("form"))));
        pnContent.add(this.pnForm);
        this.pn.add((Component)pnContent, "Center");
    }

    private void addNavigation() {
        this.pnNavigation = new JPanel();
        this.pnNavigation.setLayout(new BoxLayout(this.pnNavigation, 0));
        this.pnNavigation.setBackground(settings.getBackground("netweaver"));
        this.pnNavigation.setBorder(BorderFactory.createEmptyBorder(settings.getInt("netweaver.form.navigation.gap"), settings.getInt("netweaver.content.space.side"), settings.getInt("netweaver.content.space.bottom"), settings.getInt("netweaver.content.space.side")));
        this.pnNavigation.add(Box.createHorizontalGlue());
        JButton bn = new JButton("OK");
        this.pnNavigation.add(bn);
        SwingToolkit.fixHeight(this.pnNavigation);
        this.pnNavigation.remove(bn);
        this.pn.add((Component)this.pnNavigation, "South");
    }

    public void setTitle(String text) {
        this.lbTitle.setText(SwingToolkit.getPlainText(text));
    }

    public void setDescription(String text) {
        this.stDescription.setText(text);
    }

    public void addButton(SDTButtonIF button) {
        int width;
        JButton bn = (JButton)((GuiButton)button).getPeer();
        bn.setRequestFocusEnabled(false);
        if (button.getCaption().equalsIgnoreCase("next")) {
            this.pnForm.putClientProperty(NEXT_BUTTON_KEY, bn);
        }
        if ((width = bn.getPreferredSize().width + buttonSpace * 2) > this.maxWidth) {
            this.maxWidth = width;
            int n = this.pnNavigation.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JComponent comp = (JComponent)this.pnNavigation.getComponent(i);
                if (!(comp instanceof JButton)) continue;
                comp.setPreferredSize(new Dimension(this.maxWidth, comp.getPreferredSize().height));
            }
        }
        bn.setPreferredSize(new Dimension(this.maxWidth, bn.getPreferredSize().height));
        this.pnNavigation.add(Box.createHorizontalStrut(settings.getInt("netweaver.button.gap")));
        this.pnNavigation.add(bn);
        if (button.isDefault()) {
            this.setDefaultButton(bn);
        }
        this.pnNavigation.validate();
    }

    public void removeButtons() {
        this.pnNavigation.removeAll();
        this.pnNavigation.add(Box.createHorizontalGlue());
        this.pnNavigation.validate();
        this.pnForm.putClientProperty(NEXT_BUTTON_KEY, null);
    }

    public void add(SDTControlIF content) {
        this.setStatus(null);
        GuiHelp.getInstance().hideHelp();
        this.form = ((GuiControl)content).getPeer();
        SwingToolkit.setMaxHeight(this.form, Short.MAX_VALUE);
        boolean scrolling = this.form.getClientProperty(SCROLLABLE_KEY) != Boolean.FALSE;
        this.pn.setScrollingEnabled(scrolling);
        this.pnForm.removeAll();
        this.pnForm.add((Component)this.form, "Center");
        this.pnForm.validate();
    }

    public void refresh() {
        this.lastFocusComp = null;
        this.setFocus();
        this.pnHelp.invalidate();
        this.pnHelp.validate();
        this.pnHelp.repaint();
    }

    private void setFocus() {
        if (this.form == null) {
            return;
        }
        KeyboardFocusManager kbdFocusMngr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        FocusTraversalPolicy focusTraversalPolicy = kbdFocusMngr.getDefaultFocusTraversalPolicy();
        Component compFocus = focusTraversalPolicy.getDefaultComponent(this.form);
        if (compFocus != null) {
            compFocus.requestFocusInWindow();
        }
    }

    public void showLogBrowser(SAPinstLogBrowserIF logBrowser) {
        SAPinstLogBrowser lB = (SAPinstLogBrowser)logBrowser;
        if (this.logDialog == null) {
            JFrame frame = ((Gui)this.parent.getParent()).getPeer();
            this.logDialog = new GuiDialog((Frame)frame, "Log Browser", lB.getCloseAction());
            this.logDialog.setSize(506, 578);
        }
        JComponent peer = lB.getPeer();
        this.logDialog.setContentPane(peer);
        this.logDialog.setJMenuBar(lB.getMenuBar());
        this.logDialog.setVisible(true);
    }

    public void hideLogBrowser() {
        this.logDialog.setVisible(false);
    }

    public void showFileChooser(SDTFileChooserIF fileChooser) {
        if (this.fileDialog == null) {
            JFrame frame = ((Gui)this.parent.getParent()).getPeer();
            this.fileDialog = new JDialog((Frame)frame, "File Chooser");
            this.fileDialog.setDefaultCloseOperation(0);
            this.fileDialog.setSize(400, 500);
            SwingToolkit.setLocationRelativeTo(this.fileDialog, frame);
        }
        JComponent peer = ((GuiFileChooser)fileChooser).getPeer();
        this.fileDialog.setContentPane(peer);
        this.fileDialog.setVisible(true);
        fileChooser.refresh();
    }

    public void hideFileChooser() {
        if (this.fileDialog != null) {
            this.fileDialog.setVisible(false);
        }
    }

    public void setWaitCursor(boolean isWaitCursor) {
        if (this.isWaiting == isWaitCursor) {
            return;
        }
        this.isWaiting = isWaitCursor;
        JFrame frame = ((Gui)this.getParent().getParent()).getPeer();
        if (isWaitCursor) {
            this.lastFocusComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            frame.getGlassPane().setVisible(true);
            frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            frame.getGlassPane().setVisible(false);
            if (this.lastFocusComp != null) {
                JButton bn;
                if (this.lastFocusComp instanceof JButton && (bn = (JButton)this.lastFocusComp).getText().equalsIgnoreCase("Browse...")) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.lastFocusComp);
                    return;
                }
                this.lastFocusComp.requestFocusInWindow();
                this.lastFocusComp = null;
            } else {
                this.setFocus();
            }
        }
    }

    public static void test() {
        JFrame f = new JFrame("Netweaver View");
        GuiNetWeaverView view = new GuiNetWeaverView();
        view.setTitle("Define the SAP System Parameters");
        view.setDescription("Please enter the SAP system's ID and database name.");
        view.setStatus("Connected");
        f.setContentPane(view.getPeer());
        f.setLocation(300, 100);
        f.setSize(510, 460);
        f.show();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiNetWeaverView.test();
        m_fMain.setDefaultCloseOperation(3);
    }

    private static class JScrollablePanel
    extends JPanel
    implements Scrollable {
        private boolean scrolling = true;

        private JScrollablePanel() {
        }

        public void setScrollingEnabled(boolean enabled) {
            this.scrolling = enabled;
        }

        public boolean getScrollableTracksViewportHeight() {
            boolean tracking = false;
            if (this.getParent() instanceof JViewport) {
                tracking = this.scrolling ? ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height : true;
            }
            return tracking;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height / 10;
                }
                case 0: {
                    return visibleRect.width / 10;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height;
                }
                case 0: {
                    return visibleRect.width;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dim = super.getPreferredSize();
            return dim;
        }
    }
}

