/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core;

import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.controls.SDTGuiIF;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.engine.core.services.GuiServiceException;
import com.sap.sdt.engine.core.services.GuiServiceIF;
import com.sap.sdt.gui.core.GuiArguments;
import com.sap.sdt.gui.core.GuiTraceIF;
import com.sap.sdt.gui.core.admin.SDTGuiAdmin;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiControlFactory;
import com.sap.sdt.gui.core.swing.controls.GuiPerspective;
import com.sap.sdt.gui.core.swing.ui.Gui;
import com.sap.sdt.gui.core.swing.ui.GuiMenuBar;
import com.sap.sdt.gui.core.swing.views.SingleToolLogonView;
import com.sap.sdt.trace.SapLoggingAdmin;
import com.sap.sdt.util.arg.OptionIF;
import com.sap.sdt.util.arg.ParameterIF;
import com.sap.sdt.util.info.IP;
import com.sap.sdt.util.info.InfoProviderFactoryProperties;
import com.sap.sdt.util.info.InfoProviderIF;
import com.sap.sdt.util.prop.FactoryPropertiesCapableIF;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;

public final class SDTGui {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/SDTGui.java#2 $";
    private static final String GUI_NAME = "SDTGui";
    private GuiArguments guiArgs = null;
    private SDTGuiIF gui = null;
    private SDTGuiAdminIF gA = null;
    private String logDir = null;
    private String host = null;
    private int port = -1;

    private SDTGui() {
    }

    public static void main(String[] args) {
        Thread.currentThread().setName(GUI_NAME);
        Configuration.setType(0);
        Configuration.setTracer(GuiTraceIF.trc);
        new SDTGui().start(args);
    }

    private void start(String[] args) {
        this.initInfoProvider();
        this.guiArgs = new GuiArguments();
        this.guiArgs.parseArgs(args);
        this.initArgs(this.guiArgs);
        this.initLogDir();
        this.initStdOutErr();
        this.initLogging();
        this.initGui();
    }

    private void initArgs(GuiArguments args) {
        List options = this.guiArgs.getOptions();
        Iterator it = options.iterator();
        while (it.hasNext()) {
            OptionIF option = (OptionIF)it.next();
            int optionType = GuiArguments.getOptType(option.getName());
            switch (optionType) {
                case 0: {
                    System.out.println("Here a help text should be printed");
                    System.exit(0);
                    break;
                }
                case 1: {
                    this.logDir = option.getValue();
                    break;
                }
            }
        }
        this.initConnectData();
    }

    private void initLogDir() {
        File log = null;
        if (this.logDir != null) {
            if (this.logDir.startsWith("file:")) {
                this.logDir = this.logDir.substring("file:".length());
                log = new File(this.logDir);
            } else {
                this.exit("Unknown logging destination " + this.logDir);
            }
        } else {
            String tmpDirPathName = System.getProperty("user.home");
            log = new File(tmpDirPathName + File.separator + ".sdtgui");
        }
        log.mkdir();
        this.logDir = log.getAbsolutePath() + File.separator;
    }

    private void initStdOutErr() {
        String redirect = System.getProperty("redirect_output");
        if (redirect != null && redirect.equalsIgnoreCase("false")) {
            return;
        }
        try {
            File outFile = new File(this.logDir + "sdtgui.out");
            FileOutputStream fOut = new FileOutputStream(outFile);
            PrintStream stdOut = new PrintStream(fOut);
            File errFile = new File(this.logDir + "sdtgui.err");
            FileOutputStream fErr = new FileOutputStream(errFile);
            PrintStream stdErr = new PrintStream(fErr);
            System.setOut(stdOut);
            System.setErr(stdErr);
        }
        catch (FileNotFoundException fnfE) {
            this.exit("Unable to redirect stdout/stderr: " + fnfE.getMessage());
        }
    }

    private void initLogging() {
        InputStream propStream = SDTGui.class.getResourceAsStream("logging.properties");
        Properties prop = new Properties();
        try {
            prop.load(propStream);
            File log = new File(this.logDir);
            SapLoggingAdmin.setLogDir(log);
            SapLoggingAdmin.setTraceFile(new File(log, "sdtgui.trc"));
            SapLoggingAdmin.configure(prop);
        }
        catch (Exception e) {
            this.exit("Unable to configure SAP logging: " + e.getMessage());
        }
    }

    private void initInfoProvider() {
        InfoProviderFactoryProperties prop = new InfoProviderFactoryProperties(GUI_NAME);
        String xmlDir = "xmlDirectory";
        prop.setProperty(xmlDir, "com/sap/sdt/gui/core");
        InfoProviderIF info = IP.getIP();
        if (info instanceof FactoryPropertiesCapableIF) {
            ((FactoryPropertiesCapableIF)((Object)info)).setFactoryProperties(prop);
        }
    }

    private void initGui() {
        Configuration.setControlFactory(GuiControlFactory.getInstance());
        this.gui = Configuration.getControlFactory().createGui();
        this.gA = new SDTGuiAdmin(this.gui);
        Configuration.setClientAdmin(this.gA);
        int cmdType = GuiArguments.getCmdType(this.guiArgs.getCommand().getName());
        switch (cmdType) {
            case 1: {
                this.initSAPinstGui();
                break;
            }
            case 2: {
                this.initR3upGui();
                break;
            }
            case 3: {
                this.initJUpgradeGui();
                break;
            }
            case 4: {
                this.initJSPMGui();
                break;
            }
            case 0: {
                this.initServerGui();
                break;
            }
        }
        this.gui.show();
    }

    private void initSAPinstGui() {
        if (this.host == null || this.port == -1) {
            String storedHost = this.host;
            int storedPort = this.port;
            this.host = this.host == null ? "localhost" : this.host;
            this.port = this.port == -1 ? 21212 : this.port;
            try {
                this.logon("com.sap.sdt.server.ext.sapinst.SAPinstService");
            }
            catch (GuiServiceException gsE) {
                this.gui.setStatus("");
                this.host = storedHost;
                this.port = storedPort;
                this.initLocalGui(1);
            }
        } else {
            this.initLocalGui(1);
        }
    }

    private void initR3upGui() {
        this.initLocalGui(2);
    }

    private void initJUpgradeGui() {
        if (this.host == null || this.port == -1) {
            String storedHost = this.host;
            int storedPort = this.port;
            this.host = this.host == null ? "localhost" : this.host;
            this.port = this.port == -1 ? 6666 : this.port;
            try {
                this.logon("com.sap.sdt.server.ext.jump.JUpgradeService");
            }
            catch (GuiServiceException gsE) {
                this.gui.setStatus("");
                this.host = storedHost;
                this.port = storedPort;
                this.initLocalGui(3);
            }
        } else {
            this.initLocalGui(3);
        }
    }

    private void initJSPMGui() {
        this.initLocalGui(4);
    }

    private void initLocalGui(int type) {
        if (this.host == null || this.port == -1) {
            this.showLogonScreen(type);
        } else {
            String service = null;
            switch (type) {
                case 1: {
                    service = "com.sap.sdt.server.ext.sapinst.SAPinstService";
                    break;
                }
                case 2: {
                    service = "com.sap.sdt.server.ext.r3up.R3upService";
                    break;
                }
                case 3: {
                    service = "com.sap.sdt.server.ext.jump.JUpgradeService";
                    break;
                }
                case 4: {
                    service = "com.sap.sdt.server.ext.jump.JSPMService";
                    break;
                }
            }
            try {
                this.logon(service);
            }
            catch (GuiServiceException gsE) {
                this.showLogonScreen(type, gsE.getMessage());
            }
        }
    }

    private void initServerGui() {
        ((Gui)this.gui).setMenuBar(new GuiMenuBar((ActionListener)((Object)this.gui)));
        String serviceClass = null;
        List params = this.guiArgs.getCommand().getParameters();
        Iterator it = params.iterator();
        while (it.hasNext()) {
            ParameterIF param = (ParameterIF)it.next();
            int paramType = GuiArguments.getParamType(param.getName());
            switch (paramType) {
                case 2: {
                    serviceClass = param.getValue();
                    break;
                }
            }
        }
        if (this.host == null || this.port == -1) {
            this.showLogonScreen(0);
        } else {
            ServerID serverID = null;
            try {
                serverID = this.gA.connect(this.host, this.port);
                this.gui.setConnected();
            }
            catch (ServiceException sE) {
                this.showLogonScreen(0, sE.getMessage());
            }
            if (serviceClass != null) {
                this.initService(serverID, serviceClass);
            }
        }
    }

    private void initService(ServerID serverID, String serviceClass) {
        Service service = null;
        try {
            service = this.gA.requestService(Class.forName(serviceClass), serverID);
        }
        catch (ServiceException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException cnfE) {
            cnfE.printStackTrace();
            System.exit(1);
        }
        GuiServiceIF sS = (GuiServiceIF)service.getProvider();
        try {
            sS.addGui(this.gA.getID());
        }
        catch (GuiServiceException e) {
            e.printStackTrace();
        }
        this.gui.addService(sS.getKey());
    }

    private void initConnectData() {
        List params = this.guiArgs.getCommand().getParameters();
        Iterator it = params.iterator();
        while (it.hasNext()) {
            ParameterIF param = (ParameterIF)it.next();
            int paramType = GuiArguments.getParamType(param.getName());
            switch (paramType) {
                case 1: {
                    this.host = param.getValue();
                    break;
                }
                case 0: {
                    this.port = Integer.parseInt(param.getValue());
                    break;
                }
            }
        }
    }

    private void showLogonScreen(int type) {
        this.showLogonScreen(type, "<html>Enter the host name and TCP/IP port you want to log on to.</html>");
    }

    private void showLogonScreen(int type, String desc) {
        String title = null;
        int defaultPort = 0;
        switch (type) {
            case 1: {
                title = "SAPinst Installation GUI";
                defaultPort = 21212;
                break;
            }
            case 2: {
                title = "Upgrade Assistant";
                defaultPort = 4240;
                break;
            }
            case 3: {
                title = "Java Upgrade Management Program";
                defaultPort = 6666;
                break;
            }
            case 4: {
                title = "Java Support Package Manager";
                defaultPort = 6666;
                break;
            }
            case 0: {
                title = "SDTServer";
                defaultPort = 4711;
                break;
            }
        }
        GuiPerspective perspective = new GuiPerspective();
        SingleToolLogonView view = new SingleToolLogonView();
        view.setTitle("SAP NetWeaver");
        view.setSubTitle(title);
        view.setDescription(desc);
        perspective.addView(view);
        String defaultHost = "localhost";
        view.setHost(this.host != null ? this.host : defaultHost);
        view.setPort(this.port != -1 ? this.port : defaultPort);
        LogOnActionListener l = new LogOnActionListener(view, type);
        view.setListener(l);
        this.gui.setPerspective(perspective);
        this.gui.show();
        view.refresh();
    }

    private void logon(String service) throws GuiServiceException {
        GuiServiceIF gS = null;
        try {
            Class<?> serviceClass = Class.forName(service);
            Class[] argTypes = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{this.host, new Integer(this.port)};
            Constructor<?> ctor = serviceClass.getConstructor(argTypes);
            gS = (GuiServiceIF)ctor.newInstance(args);
        }
        catch (ClassNotFoundException cnfE) {
            cnfE.printStackTrace();
        }
        catch (SecurityException sE) {
            sE.printStackTrace();
        }
        catch (NoSuchMethodException nsmE) {
            nsmE.printStackTrace();
        }
        catch (IllegalArgumentException iaE) {
            iaE.printStackTrace();
        }
        catch (InstantiationException iE) {
            iE.printStackTrace();
        }
        catch (IllegalAccessException iaE) {
            iaE.printStackTrace();
        }
        catch (InvocationTargetException itE) {
            itE.printStackTrace();
        }
        SDTGuiAdmin gA = (SDTGuiAdmin)Configuration.getClientAdmin();
        gS.addGui(gA.getID());
        gA.registerService(gS.getKey(), gS);
    }

    private void exit(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private class LogOnActionListener
    extends GuiActionListener {
        private final SingleToolLogonView view;
        private final int type;

        public LogOnActionListener(SingleToolLogonView view, int type) {
            this.view = view;
            this.type = type;
        }

        public void actionPerformed(SDTActionEvent e) {
            this.view.setWaitCursor(true);
            SDTGui.this.host = this.view.getHost();
            SDTGui.this.port = this.view.getPort();
            if (SDTGui.this.host.length() == 0) {
                JOptionPane.showMessageDialog(((Gui)SDTGui.this.gui).getPeer(), ResourceManager.getString("Message.Input.Host"), ResourceManager.getString("Input.Dialog.Title"), 0);
                return;
            }
            if (SDTGui.this.port < 0) {
                JOptionPane.showMessageDialog(((Gui)SDTGui.this.gui).getPeer(), ResourceManager.getString("Message.Input.Port"), ResourceManager.getString("Input.Dialog.Title"), 0);
                return;
            }
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    SDTGui.this.initLocalGui(this.type);
                    break;
                }
                case 0: {
                    SDTGui.this.initServerGui();
                    break;
                }
            }
            this.view.setWaitCursor(false);
        }
    }
}

