/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core;

import com.sap.sdt.util.arg.AbstractArguments;
import com.sap.sdt.util.arg.Command;
import com.sap.sdt.util.arg.CommandIF;
import com.sap.sdt.util.arg.Option;
import com.sap.sdt.util.arg.OptionIF;
import com.sap.sdt.util.arg.Parameter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class GuiArguments
extends AbstractArguments {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/GuiArguments.java#2 $";
    public static final String CMD_SERVER = "server";
    public static final String CMD_SAPINST = "sapinst";
    public static final String CMD_R3UP = "r3up";
    public static final String CMD_JUPGRADE = "jump";
    public static final String CMD_JSPM = "jspm";
    public static final String CMD_HELP = "help";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_SERVICE = "service";
    public static final String OPT_HELP = "h";
    public static final String OPT_LOGDIR = "logdest";
    public static final int CMD_TYPE_UNKNOWN = -1;
    public static final int CMD_TYPE_SERVER = 0;
    public static final int CMD_TYPE_SAPINST = 1;
    public static final int CMD_TYPE_R3UP = 2;
    public static final int CMD_TYPE_JUPGRADE = 3;
    public static final int CMD_TYPE_JSPM = 4;
    public static final int CMD_TYPE_HELP = 5;
    public static final int CMD_TYPE_LAST = 6;
    public static final int PARAM_TYPE_UNKNOWN = -1;
    public static final int PARAM_TYPE_PORT = 0;
    public static final int PARAM_TYPE_HOST = 1;
    public static final int PARAM_TYPE_SERVICE = 2;
    public static final int PARAM_TYPE_LAST = 3;
    public static final int OPT_TYPE_UNKNOWN = -1;
    public static final int OPT_TYPE_HELP = 0;
    public static final int OPT_TYPE_LOGDIR = 1;
    public static final int OPT_TYPE_LAST = 2;
    private static final int EXIT_FAILURE = 1;
    private static final int EXIT_OK = 0;
    private CommandIF[] knownCommands = null;
    private OptionIF[] knownOptions = null;
    private static String[] cmdNames = new String[6];
    private static String[] prmNames = new String[3];
    private static String[] optNames = new String[2];

    public GuiArguments() {
        this.init();
    }

    public GuiArguments(int nrCommands) {
        super(nrCommands);
        this.init();
    }

    public static int getCmdType(String cmd) {
        int type = -1;
        for (int i = 0; i < 6; ++i) {
            if (!cmd.equals(cmdNames[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    public static int getParamType(String param) {
        int type = -1;
        for (int i = 0; i < 3; ++i) {
            if (!param.equals(prmNames[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    public static int getOptType(String opt) {
        int type = -1;
        for (int i = 0; i < 2; ++i) {
            if (!opt.equals(optNames[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    public CommandIF[] getAllKnownCommands() {
        return this.knownCommands;
    }

    public OptionIF[] getAllKnownOptions() {
        return this.knownOptions;
    }

    private void init() {
        Command serverCmd = new Command(CMD_SERVER);
        serverCmd.setDescription(new String[]{"Run SDTGui in server mode"});
        Parameter portParam = new Parameter(PARAM_PORT, true, "server port");
        Parameter hostParam = new Parameter(PARAM_HOST, true, "server host");
        Parameter srvcParam = new Parameter(PARAM_SERVICE, true, "the service to be run");
        serverCmd.addParameter(portParam);
        serverCmd.addParameter(hostParam);
        serverCmd.addParameter(srvcParam);
        serverCmd.setNumberOfParameters(0);
        Command sapinstCmd = new Command(CMD_SAPINST);
        sapinstCmd.setDescription(new String[]{"Run SDTGui in SAPinst mode"});
        Parameter sapinstPortParam = new Parameter(PARAM_PORT, true, "SAPinst port");
        Parameter sapinstHostParam = new Parameter(PARAM_HOST, true, "SAPinst host");
        sapinstCmd.addParameter(sapinstPortParam);
        sapinstCmd.addParameter(sapinstHostParam);
        sapinstCmd.setNumberOfParameters(0);
        Command r3upCmd = new Command(CMD_R3UP);
        r3upCmd.setDescription(new String[]{"Run SDTGui in R3up mode"});
        Parameter r3upPortParam = new Parameter(PARAM_PORT, true, "");
        Parameter r3upHostParam = new Parameter(PARAM_HOST, true, "");
        r3upCmd.addParameter(r3upPortParam);
        r3upCmd.addParameter(r3upHostParam);
        r3upCmd.setNumberOfParameters(0);
        Command jumpCmd = new Command(CMD_JUPGRADE);
        jumpCmd.setDescription(new String[]{"Run SDTGui in JUMP mode"});
        Parameter jumpPortParam = new Parameter(PARAM_PORT, true, "");
        Parameter jumpHostParam = new Parameter(PARAM_HOST, true, "");
        jumpCmd.addParameter(jumpPortParam);
        jumpCmd.addParameter(jumpHostParam);
        jumpCmd.setNumberOfParameters(0);
        Command jspmCmd = new Command(CMD_JSPM);
        jspmCmd.setDescription(new String[]{"Run SDTGui in JSPM mode"});
        Parameter jspmPortParam = new Parameter(PARAM_PORT, true, "");
        Parameter jspmHostParam = new Parameter(PARAM_HOST, true, "");
        jspmCmd.addParameter(jumpPortParam);
        jspmCmd.addParameter(jumpHostParam);
        jspmCmd.setNumberOfParameters(0);
        Command helpCmd = new Command(CMD_HELP);
        helpCmd.setDescription(new String[]{"Provides Help information for SDT GUI commands."});
        this.knownCommands = new CommandIF[]{serverCmd, sapinstCmd, r3upCmd, jumpCmd, jspmCmd, helpCmd};
        this.defaultCmd = serverCmd;
        Option helpOpt = new Option(OPT_HELP, false, "Print help");
        Option logdirOpt = new Option(OPT_LOGDIR, false, "Specify custom log directory");
        this.knownOptions = new OptionIF[]{helpOpt, logdirOpt};
    }

    public void parseArgs(String[] args) {
        this.parse(args);
        CommandIF command = this.getCommand();
        if (!this.argsHaveNoError()) {
            if (!this.areEnoughParameters() && this.isCmdKnown()) {
                this.printUsage(command);
            }
            this.exit(1, "Parse Error - Exiting");
        }
        List optList = this.getOptions();
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            OptionIF opt = (OptionIF)it.next();
            int optType = GuiArguments.getOptType(opt.getName());
            switch (optType) {
                case 0: {
                    this.print(this.printHelp(command.getName()));
                    break;
                }
            }
        }
        int cmdType = GuiArguments.getCmdType(command.getName());
        if (cmdType == 5) {
            this.print(this.printHelp(new String()));
        }
    }

    private void print(List help) {
        Iterator it = help.iterator();
        while (it.hasNext()) {
            System.out.println((String)it.next());
            System.out.flush();
        }
        this.exit(0, null);
    }

    private void exit(int code, String msg) {
        if (msg != null) {
            PrintStream stream = null;
            stream = code > 0 ? System.err : System.out;
            stream.println(msg);
            stream.flush();
        }
        System.exit(code);
    }

    private void printUsage(CommandIF command) {
        System.out.println("Usage :");
        this.print(this.printHelp(command.getName()));
        this.exit(1, "Parse Error - Exiting");
    }

    static {
        GuiArguments.cmdNames[0] = CMD_SERVER;
        GuiArguments.cmdNames[1] = CMD_SAPINST;
        GuiArguments.cmdNames[2] = CMD_R3UP;
        GuiArguments.cmdNames[3] = CMD_JUPGRADE;
        GuiArguments.cmdNames[4] = CMD_JSPM;
        GuiArguments.cmdNames[5] = CMD_HELP;
        GuiArguments.prmNames[1] = PARAM_HOST;
        GuiArguments.prmNames[0] = PARAM_PORT;
        GuiArguments.prmNames[2] = PARAM_SERVICE;
        GuiArguments.optNames[0] = OPT_HELP;
        GuiArguments.optNames[1] = OPT_LOGDIR;
    }
}

