/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.controls.mgmt;

import com.sap.sdt.engine.core.controls.SDTComponentIF;
import com.sap.sdt.engine.core.controls.SDTMenuIF;
import com.sap.sdt.engine.core.controls.SDTMessageBoxIF;
import com.sap.sdt.engine.core.controls.SDTPerspectiveIF;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SDTPerspectiveManager {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/controls/mgmt/SDTPerspectiveManager.java#2 $";
    private List entries;
    private SDTViewIF activeView;
    private SDTPerspectiveIF perspective;
    private boolean isPerspectiveActive = false;
    private List perspectiveMenus;

    public SDTPerspectiveManager(SDTPerspectiveIF perspective) {
        this.perspective = perspective;
    }

    public void registerView(SDTViewIF view) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(new ViewEntry(view));
        if (this.activeView == null) {
            this.activate(view);
        }
    }

    public void registerView(SDTViewIF view, int pos) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(pos, new ViewEntry(view));
    }

    public void activateNextView() {
        int next = 0;
        if (this.activeView != null && (next = this.entries.indexOf(this.getEntry(this.activeView)) + 1) > this.entries.size() - 1) {
            next = 0;
        }
        SDTViewIF view = ((ViewEntry)this.entries.get(next)).getView();
        this.activate(view);
    }

    public void activatePreviousView() {
        int prev = 0;
        if (this.activeView != null && (prev = this.entries.indexOf(this.getEntry(this.activeView)) - 1) < 0) {
            prev = this.entries.size() - 1;
        }
        SDTViewIF view = ((ViewEntry)this.entries.get(prev)).getView();
        this.activate(view);
    }

    public void activate(SDTViewIF view) {
        String title;
        if (this.activeView != null && this.isActive(view)) {
            this.deactivate(this.activeView);
        }
        ViewEntry entry = this.getEntry(view);
        this.activeView = view;
        if (entry.getPopup() != null) {
            view.showPopup(entry.getPopup());
        }
        view.activate();
        String status = entry.getViewStatus();
        if (status != null) {
            this.perspective.setStatus(status);
        }
        if ((title = entry.getGuiTitle()) != null && this.perspective.getParent() != null) {
            this.perspective.getParent().setTitle(title);
        }
        entry.enableMenus(true);
    }

    public void deactivate(SDTViewIF view) {
        if (view != null) {
            ViewEntry entry = this.getEntry(view);
            if (entry.getPopup() != null) {
                SDTMessageBoxIF popup = entry.getPopup();
                view.hidePopup();
                this.pushPopup(view, popup);
            }
            view.deactivate();
            entry.enableMenus(false);
        }
    }

    public boolean isActive(SDTViewIF viewIF) {
        if (this.activeView != null) {
            return this.isPerspectiveActive && this.activeView.equals(viewIF);
        }
        return true;
    }

    public void pushPopup(SDTViewIF viewIF, SDTMessageBoxIF popup) {
        ViewEntry entry = this.getEntry(viewIF);
        if (entry != null) {
            entry.pushPopup(popup);
        }
    }

    public void popPopup(SDTViewIF viewIF) {
        ViewEntry entry = this.getEntry(viewIF);
        if (entry != null) {
            entry.popPopup();
        }
    }

    public void setGuiTitle(SDTViewIF viewIF, String title) {
        ViewEntry entry = this.getEntry(viewIF);
        if (entry != null) {
            entry.setGuiTitle(title);
        }
        if (this.isActive(viewIF) && this.isPerspectiveActive && this.perspective.getParent() != null) {
            this.perspective.getParent().setTitle(title);
        }
    }

    public void setViewStatus(SDTViewIF viewIF, String status) {
        ViewEntry entry = this.getEntry(viewIF);
        if (entry != null) {
            entry.setViewStatus(status);
        }
        if (this.isActive(viewIF) && this.isPerspectiveActive) {
            this.perspective.getParent().setStatus(status);
        }
    }

    public void addViewMenu(SDTViewIF viewIF, SDTComponentIF menu) {
        ViewEntry entry = this.getEntry(viewIF);
        if (entry != null) {
            entry.addViewMenu(menu);
            entry.enableMenus(this.isActive(viewIF) && this.isPerspectiveActive);
        }
    }

    public void activate(SDTPerspectiveIF perspective) {
        if (this.activeView == null) {
            if (this.entries != null && this.entries.size() > 0) {
                this.activeView = ((ViewEntry)this.entries.get(0)).getView();
                this.activate(this.activeView);
            }
        } else {
            this.activate(this.activeView);
        }
        if (this.perspectiveMenus != null) {
            Iterator iter = this.perspectiveMenus.iterator();
            while (iter.hasNext()) {
                ((SDTMenuIF)iter.next()).setEnabled(true);
            }
        }
        this.isPerspectiveActive = true;
    }

    public void deactivate(SDTPerspectiveIF perspective) {
        if (this.activeView != null) {
            this.deactivate(this.activeView);
        }
        if (this.perspectiveMenus != null) {
            Iterator iter = this.perspectiveMenus.iterator();
            while (iter.hasNext()) {
                ((SDTMenuIF)iter.next()).setEnabled(false);
            }
        }
        this.isPerspectiveActive = false;
    }

    public void addMenu(SDTMenuIF menu) {
        if (this.perspectiveMenus == null) {
            this.perspectiveMenus = new ArrayList();
        }
        this.perspectiveMenus.add(menu);
    }

    public List getMenus() {
        return this.perspectiveMenus;
    }

    private ViewEntry getEntry(SDTViewIF view) {
        ViewEntry entry = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            entry = (ViewEntry)this.entries.get(i);
            if (!entry.getView().equals(view)) continue;
            return entry;
        }
        return entry;
    }

    private static class ViewEntry {
        private SDTViewIF view = null;
        private SDTMessageBoxIF popup = null;
        private String guiTitle = null;
        private String viewStatus = null;
        private List menus = null;

        ViewEntry(SDTViewIF _view) {
            this.view = _view;
            this.guiTitle = _view.getGuiTitle();
            this.viewStatus = this.view.getStatus();
        }

        private void pushPopup(SDTMessageBoxIF popup) {
            this.popup = popup;
        }

        private SDTMessageBoxIF getPopup() {
            return this.popup;
        }

        private void popPopup() {
            this.popup = null;
        }

        private SDTViewIF getView() {
            return this.view;
        }

        public String getGuiTitle() {
            return this.guiTitle;
        }

        public void setGuiTitle(String string) {
            this.guiTitle = string;
        }

        public void addViewMenu(SDTComponentIF menu) {
            this.menus.add(menu);
        }

        public List getMenus() {
            return this.menus;
        }

        public String getViewStatus() {
            return this.viewStatus;
        }

        public void setViewStatus(String string) {
            this.viewStatus = string;
        }

        public void enableMenus(boolean enable) {
            List menus = this.getMenus();
            if (menus != null) {
                Iterator it = menus.iterator();
                while (it.hasNext()) {
                    ((SDTComponentIF)it.next()).setEnabled(enable);
                }
            }
        }
    }
}

