/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceID;
import com.sap.sdt.util.misc.Semaphore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ServiceManager {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/ServiceManager.java#2 $";
    private static Semaphore mutex = new Semaphore();
    private static Map idToServiceMap = new HashMap();

    private ServiceManager() {
    }

    public static Service register(Class iface, Object provider, CmdConsumerIF consumer) {
        return ServiceManager.register(new Entry(new Service(iface, provider), consumer));
    }

    public static Service register(Class iface, CmdConsumerIF consumer) {
        return ServiceManager.register(new Entry(new Service(iface), consumer));
    }

    public static Service register(Service service, Object provider, CmdConsumerIF consumer) {
        return ServiceManager.register(new Entry(new Service(service, provider), consumer));
    }

    public static Service register(String name, Class iface, Object provider) {
        return ServiceManager.register(new Entry(new Service(name, iface, provider)));
    }

    public static Service register(Service service, CmdConsumerIF consumer) {
        return ServiceManager.register(new Entry(new Service(service), consumer));
    }

    public static void remove(Service service) {
        mutex.down();
        ServiceManager.trace("De-Registering Service: {0} {1} {2}", service);
        idToServiceMap.remove(service.getID());
        mutex.up();
    }

    public static void removeAll(CmdConsumerIF consumer) {
        mutex.down();
        Iterator it = idToServiceMap.values().iterator();
        while (it.hasNext()) {
            Entry current = (Entry)it.next();
            if (!consumer.equals(current.getConsumer())) continue;
            ServiceManager.trace("De-Registering Service: {0} {1} {2}", current.getService());
            it.remove();
        }
        mutex.up();
    }

    public static Service getService(ServiceID id) throws ServiceException {
        Entry entry = ServiceManager.getEntry(id);
        if (entry == null) {
            throw new ServiceException();
        }
        return entry.getService();
    }

    public static Service getService(Object provider) throws ServiceException {
        Entry entry = ServiceManager.getEntry(provider);
        if (entry == null) {
            throw new ServiceException();
        }
        return entry.getService();
    }

    public static void replaceProviders(Object[] args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            args[i] = ServiceManager.replaceProvider(args[i]);
        }
    }

    public static Object replaceProvider(Object arg) {
        Object result = arg;
        Entry entry = ServiceManager.getEntry(arg);
        if (entry != null) {
            result = entry.getService().getID();
        }
        return result;
    }

    public static void replaceIDs(Object[] args) throws ServiceException {
        for (int i = 0; args != null && i < args.length; ++i) {
            args[i] = ServiceManager.replaceID(args[i]);
        }
    }

    public static Object replaceID(Object arg) throws ServiceException {
        Object result = arg;
        if (arg instanceof ServiceID) {
            result = ServiceManager.getService((ServiceID)arg).getProvider();
        }
        return result;
    }

    public static CmdConsumerIF getConsumer(ServiceID id) {
        return ServiceManager.getEntry(id).getConsumer();
    }

    public static Service[] getServices() {
        Object[] entries = idToServiceMap.values().toArray();
        Service[] services = new Service[entries.length];
        for (int i = 0; i < services.length; ++i) {
            services[i] = ((Entry)entries[i]).getService();
        }
        return services;
    }

    private static Service register(Entry entry) {
        mutex.down();
        ServiceManager.trace("Registering Service: {0} {1} {2}", entry.getService());
        idToServiceMap.put(entry.getService().getID(), entry);
        mutex.up();
        return entry.getService();
    }

    private static Entry getEntry(ServiceID id) {
        mutex.down();
        Entry entry = (Entry)idToServiceMap.get(id);
        mutex.up();
        return entry;
    }

    private static Entry getEntry(Object provider) {
        Entry entry = null;
        mutex.down();
        Iterator it = idToServiceMap.values().iterator();
        while (it.hasNext()) {
            Entry current = (Entry)it.next();
            if (provider != current.getService().getProvider()) continue;
            entry = current;
            break;
        }
        mutex.up();
        return entry;
    }

    private static void trace(String msg, Service service) {
        String name = service.getName();
        Class cls = service.getInterface();
        ServiceID id = service.getID();
        Object[] args = new Object[]{name, cls, id};
        Configuration.getTracer().info(ServiceManager.class, msg, args);
    }

    private static class Entry {
        private Service service = null;
        private CmdConsumerIF consumer = null;

        Entry(Service service) {
            this(service, null);
        }

        Entry(Service service, CmdConsumerIF consumer) {
            this.service = service;
            this.consumer = consumer;
        }

        public Service getService() {
            return this.service;
        }

        public CmdConsumerIF getConsumer() {
            return this.consumer;
        }
    }
}

