/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.CmdInvoke;
import com.sap.sdt.engine.core.communication.ServiceID;
import com.sap.sdt.engine.core.communication.ServiceManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class Service
implements InvocationHandler {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/Service.java#2 $";
    private ServiceID id = null;
    private String name = null;
    private Class iface = null;
    private transient Object provider = null;

    Service(Service service) {
        Class iface = service.getInterface();
        this.init(service.getID(), service.getName(), iface, this.create(iface));
    }

    Service(Service service, Object provider) {
        this.init(service.getID(), service.getName(), service.getInterface(), provider);
    }

    Service(Class iface) {
        this.init(new ServiceID(), "SDTControl", iface, this.create(iface));
    }

    Service(Class iface, Object provider) {
        this.init(new ServiceID(), "SDTControl", iface, provider);
    }

    Service(String name, Class iface, Object provider) {
        this.init(new ServiceID(), name, iface, provider);
    }

    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        ServiceID invoker = ServiceManager.getService(target).getID();
        if (this.isHashCode(method)) {
            return new Integer(invoker.hashCode());
        }
        ServiceManager.replaceProviders(args);
        CmdConsumerIF consumer = ServiceManager.getConsumer(invoker);
        CmdInvoke cmd = new CmdInvoke(invoker, method, args);
        return consumer.consumeAndWait(cmd);
    }

    public ServiceID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class getInterface() {
        return this.iface;
    }

    public Object getProvider() {
        return this.provider;
    }

    private void init(ServiceID id, String name, Class iface, Object provider) {
        this.id = id;
        this.name = name;
        this.iface = iface;
        this.provider = provider;
    }

    private Object create(Class iface) {
        Object provider = null;
        ClassLoader cl = iface.getClassLoader();
        Class[] classes = new Class[]{iface};
        provider = Proxy.newProxyInstance(cl, classes, (InvocationHandler)this);
        return provider;
    }

    private boolean isHashCode(Method method) {
        boolean isHashCode = false;
        if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
            isHashCode = true;
        }
        return isHashCode;
    }
}

