/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.AbstractCmd;
import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.CmdResponse;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceID;
import com.sap.sdt.engine.core.communication.ServiceManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class CmdInvoke
extends AbstractCmd {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/CmdInvoke.java#2 $";
    private Method method = null;
    private Object[] args = null;

    CmdInvoke(ServiceID invoker, Method method, Object[] args) {
        super(invoker);
        this.method = method;
        this.args = args;
        ServiceManager.replaceProviders(this.args);
    }

    public int getType() {
        return 3;
    }

    public void execute(CmdConsumerIF consumer) throws ServiceException {
        CmdResponse cmd = null;
        try {
            Object target = ServiceManager.getService(this.invoker).getProvider();
            Object response = null;
            ServiceManager.replaceIDs(this.args);
            response = this.method.invoke(target, this.args);
            cmd = new CmdResponse(this.cmdID, response);
        }
        catch (InvocationTargetException itE) {
            cmd = new CmdResponse(this.cmdID, itE.getTargetException());
        }
        catch (Throwable t) {
            cmd = new CmdResponse(this.cmdID, t);
            Configuration.getTracer().error(this.getClass(), t.getMessage());
        }
        consumer.consumeAndContinue(cmd);
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }
}

