/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.admin.ClientAdminIF;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.AbstractCmd;
import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.ServerConnection;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.util.vers.VersionIF;

class CmdConnectReply
extends AbstractCmd {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/CmdConnectReply.java#2 $";
    private ServerID serverID = null;
    private Service service = null;
    private VersionIF version = null;
    private boolean failed = false;
    private ServiceException reason = null;

    CmdConnectReply(VersionIF version) throws ServiceException {
        this.version = version;
        ServerAdminIF admin = Configuration.getServerAdmin();
        this.service = ServiceManager.getService(admin);
        this.serverID = admin.getID();
    }

    CmdConnectReply(ServiceException reason) {
        this.reason = reason;
        this.failed = false;
    }

    public int getType() {
        return 1;
    }

    public void execute(CmdConsumerIF consumer) throws ServiceException {
        if (this.failed) {
            throw this.reason;
        }
        this.service = ServiceManager.register(this.service, consumer);
        ServerAdminIF sA = (ServerAdminIF)this.service.getProvider();
        ClientAdminIF cA = Configuration.getClientAdmin();
        ServerConnection connection = (ServerConnection)consumer;
        cA.addServer(this.serverID);
        cA.setServerConnection(this.serverID, connection);
        cA.setServerAdmin(this.serverID, sA);
        cA.setServerVersion(this.serverID, this.version);
        connection.setID(this.serverID);
    }
}

