/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.communication.AbstractCmd;
import com.sap.sdt.engine.core.communication.ClientConnection;
import com.sap.sdt.engine.core.communication.ClientVersionTooLowException;
import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.MalformedVersionException;
import com.sap.sdt.engine.core.communication.ServerVersionTooLowException;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.util.vers.VersionException;
import com.sap.sdt.util.vers.VersionIF;

class CmdConnectInit
extends AbstractCmd {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/CmdConnectInit.java#2 $";
    private ClientID clientID = Configuration.getClientAdmin().getID();
    private VersionIF clntCurVers = Configuration.getCurVers();
    private VersionIF clntLowVers = Configuration.getLowVers();

    CmdConnectInit() {
    }

    public int getType() {
        return 0;
    }

    public void execute(CmdConsumerIF consumer) throws ServiceException {
        VersionIF svrCurVers = Configuration.getCurVers();
        VersionIF svrLowVers = Configuration.getLowVers();
        VersionIF vers = null;
        try {
            if (svrCurVers.isLower(this.clntLowVers)) {
                throw new ServerVersionTooLowException();
            }
            if (this.clntCurVers.isLower(svrLowVers)) {
                throw new ClientVersionTooLowException();
            }
            vers = svrCurVers.isLower(this.clntCurVers) ? svrCurVers : this.clntCurVers;
        }
        catch (VersionException vE) {
            throw new MalformedVersionException(vE);
        }
        ServerAdminIF sA = Configuration.getServerAdmin();
        ClientConnection connection = (ClientConnection)consumer;
        sA.addClient(this.clientID);
        sA.setClientVersion(this.clientID, vers);
        sA.setClientConnection(this.clientID, connection);
        connection.setID(this.clientID);
    }
}

