/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.communication.AbstractConnection;
import com.sap.sdt.engine.core.communication.CmdConnectReply;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.vers.VersionIF;

public class ClientConnection
extends AbstractConnection {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/ClientConnection.java#2 $";
    private ClientID clientID = null;

    public void networkError(NetworkException nwE) {
        nwE.printStackTrace();
        this.close();
    }

    public void commLinkClosed() {
        this.close();
    }

    public void accept(CommLinkIF commLink) throws ServiceException {
        this.commLink = commLink;
        this.open();
    }

    public void setID(ClientID clientID) {
        this.clientID = clientID;
    }

    protected void handshake() throws ServiceException {
        try {
            this.receive().execute(this);
        }
        catch (ServiceException sE) {
            this.send(new CmdConnectReply(sE));
            throw sE;
        }
        ServerAdminIF admin = Configuration.getServerAdmin();
        VersionIF version = admin.getClientVersion(this.clientID);
        this.send(new CmdConnectReply(version));
        this.receive().execute(this);
    }
}

