/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.WorkerIF;
import com.sap.sdt.util.misc.SyncBuffer;

abstract class AbstractWorker
extends Thread
implements WorkerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/AbstractWorker.java#2 $";
    protected boolean isRunning = false;
    protected SyncBuffer buffer = null;

    public AbstractWorker(String name) {
        this.setName(name);
        this.buffer = new SyncBuffer();
    }

    public void start() {
        this.isRunning = true;
        super.start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void terminate() {
        this.isRunning = false;
    }

    public void put(Object obj) {
        this.buffer.put(obj);
    }

    public void run() {
        try {
            while (this.isRunning) {
                Object cmd = this.buffer.get();
                this.handleCmd(cmd);
                Thread.yield();
            }
        }
        catch (ServiceException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    protected abstract void handleCmd(Object var1) throws ServiceException;
}

