/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.AbstractCmdConsumer;
import com.sap.sdt.engine.core.communication.CmdIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.EngineConstants;
import com.sap.sdt.engine.core.communication.ExecWorker;
import com.sap.sdt.engine.core.communication.SendWorker;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.CommLinkObserverIF;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.serial.SerialAdmin;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.StringReader;

abstract class AbstractConnection
extends AbstractCmdConsumer
implements CommLinkObserverIF,
EngineConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/AbstractConnection.java#2 $";
    protected boolean isRunning = false;
    protected CommLinkIF commLink = null;
    protected SendWorker sendWorker = new SendWorker("SendWorker");
    protected ExecWorker execWorker = new ExecWorker("ExecuteWorker");
    protected ExecWorker cntlWorker = new ExecWorker("EventWorker");

    protected AbstractConnection() {
        this.execWorker.setConsumer(this);
        this.cntlWorker.setConsumer(this);
        this.isRunning = true;
    }

    public void msgReceived(String msg) {
        if (this.isRunning) {
            CmdIF cmd = this.deserialize(msg);
            switch (cmd.getType()) {
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    this.execWorker.put(cmd);
                    break;
                }
                case 4: {
                    this.cntlWorker.put(cmd);
                    break;
                }
                default: {
                    System.out.println("Unknown command");
                }
            }
        }
    }

    void close() {
        if (this.isRunning) {
            this.isRunning = false;
            this.commLink.stop();
            this.sendWorker.terminate();
            this.execWorker.terminate();
            this.cntlWorker.terminate();
            this.emptyStorage();
            this.sendWorker = null;
            this.execWorker = null;
            this.cntlWorker = null;
            this.commLink = null;
        }
    }

    protected void handleCmd(CmdIF cmd) {
        if (this.isRunning) {
            this.sendWorker.put(this.serialize(cmd));
        }
    }

    protected void open() throws ServiceException {
        this.handshake();
        this.sendWorker.setCommLink(this.commLink);
        this.sendWorker.start();
        this.execWorker.start();
        this.cntlWorker.start();
        this.commLink.addObserver(this);
        this.commLink.start();
    }

    protected abstract void handshake() throws ServiceException;

    protected void send(CmdIF cmd) throws ServiceException {
        try {
            this.commLink.send(this.serialize(cmd));
        }
        catch (NetworkException nwE) {
            nwE.printStackTrace();
            System.exit(1);
        }
    }

    protected CmdIF receive() throws ServiceException {
        try {
            return this.deserialize(this.commLink.receive());
        }
        catch (NetworkException nwE) {
            nwE.printStackTrace();
            throw new ServiceException();
        }
    }

    protected String serialize(CmdIF cmd) {
        String msg = null;
        try {
            XMLElementIF xml = SerialAdmin.serialize(cmd);
            msg = xml.toString();
        }
        catch (SerialException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        Configuration.getTracer().info(this.getClass(), "Sent: {0}", msg);
        return msg;
    }

    protected CmdIF deserialize(String msg) {
        Configuration.getTracer().info(this.getClass(), "Received: {0}", msg);
        Object obj = null;
        try {
            Object xmlStr = null;
            StringReader reader = new StringReader(msg);
            XMLElementIF xml = XMLAdmin.createXMLElement(reader);
            obj = SerialAdmin.deserialize(xml);
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
            System.exit(1);
        }
        catch (SerialException sE) {
            sE.printStackTrace();
            System.exit(1);
        }
        return (CmdIF)obj;
    }
}

