/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.communication;

import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.CmdID;
import com.sap.sdt.engine.core.communication.CmdIF;
import com.sap.sdt.engine.core.communication.CmdInvoke;
import com.sap.sdt.engine.core.communication.ConnectionClosedException;
import com.sap.sdt.util.misc.Semaphore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractCmdConsumer
implements CmdConsumerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/communication/AbstractCmdConsumer.java#2 $";
    private Map cmdStorage = new HashMap();
    private Semaphore mutex = new Semaphore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object consumeAndWait(CmdInvoke cmd) throws Throwable {
        this.storeCmd(cmd);
        CmdInvoke cmdInvoke = cmd;
        synchronized (cmdInvoke) {
            this.handleCmd(cmd);
            try {
                cmd.wait();
            }
            catch (InterruptedException iE) {
                iE.printStackTrace();
                System.exit(1);
            }
        }
        if (cmd.hasException()) {
            throw cmd.getException();
        }
        return cmd.getResult();
    }

    public void consumeAndContinue(CmdIF cmd) {
        this.handleCmd(cmd);
    }

    public CmdInvoke getStoredCmd(CmdID cmdID) {
        this.mutex.down();
        CmdInvoke cmd = (CmdInvoke)this.cmdStorage.remove(cmdID);
        this.mutex.up();
        return cmd;
    }

    protected abstract void handleCmd(CmdIF var1);

    protected void storeCmd(CmdIF cmd) {
        this.mutex.down();
        this.cmdStorage.put(cmd.getID(), cmd);
        this.mutex.up();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emptyStorage() {
        System.out.println("Emptying storage ...");
        this.mutex.down();
        Iterator it = this.cmdStorage.values().iterator();
        while (it.hasNext()) {
            CmdInvoke cmd = (CmdInvoke)it.next();
            System.out.println("Removing command " + cmd.getID());
            cmd.setException(new ConnectionClosedException());
            CmdInvoke cmdInvoke = cmd;
            synchronized (cmdInvoke) {
                cmd.notify();
            }
        }
        this.cmdStorage.clear();
        this.mutex.up();
        System.out.println("done.");
    }
}

