/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.admin;

import com.sap.sdt.engine.core.admin.ClientAdminIF;
import com.sap.sdt.engine.core.admin.ClientEntry;
import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.ClientConnection;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.net.ServerCommLink;
import com.sap.sdt.util.vers.VersionIF;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractServerAdmin
implements ServerAdminIF,
Runnable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/admin/AbstractServerAdmin.java#2 $";
    protected ServerID serverID = new ServerID();
    protected int port = -1;
    protected Thread engine = new Thread(this);
    protected boolean isRunning = false;
    protected ServerCommLink serverLink = null;
    protected Map clients = null;

    protected AbstractServerAdmin(String name) {
        this.engine.setName(name);
        this.clients = new HashMap();
        ServiceManager.register(name, this.getInterface(), this);
    }

    public ServerID getID() {
        return this.serverID;
    }

    public void start(int port) {
        this.port = port;
        this.isRunning = true;
        this.engine.start();
    }

    public void stop() {
        this.isRunning = false;
        this.serverLink.close();
    }

    public void addClient(ClientID clientID) {
        this.clients.put(clientID, new ClientEntry(clientID));
    }

    public void removeClient(ClientID clientID) {
        this.clients.remove(clientID);
    }

    public void setClientConnection(ClientID clientID, ClientConnection conn) {
        this.getClientEntry(clientID).setConnection(conn);
    }

    public void setClientAdmin(ClientID clientID, ClientAdminIF admin) {
        this.getClientEntry(clientID).setClientAdmin(admin);
    }

    public void setClientVersion(ClientID clientID, VersionIF version) {
        this.getClientEntry(clientID).setVersion(version);
    }

    public ClientConnection getClientConnection(ClientID clientID) {
        return this.getClientEntry(clientID).getConnection();
    }

    public ClientAdminIF getClientAdmin(ClientID clientID) {
        return this.getClientEntry(clientID).getClientAdmin();
    }

    public VersionIF getClientVersion(ClientID clientID) {
        return this.getClientEntry(clientID).getVersion();
    }

    public ClientAdminIF[] getClientAdmins() {
        Object[] entries = this.clients.values().toArray();
        ClientAdminIF[] admins = new ClientAdminIF[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            admins[i] = ((ClientEntry)entries[i]).getClientAdmin();
        }
        return admins;
    }

    public Service[] getServices() {
        return ServiceManager.getServices();
    }

    public Service requestService(Class iface) throws ServiceException {
        Service service = null;
        Service[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            if (!iface.equals(services[i].getInterface())) continue;
            service = services[i];
            break;
        }
        return service;
    }

    public void run() {
        try {
            this.serverLink = new ServerCommLink(this.port);
        }
        catch (NetworkException nwE) {
            this.exit(1, nwE.getMessage());
        }
        while (this.isRunning) {
            try {
                ClientConnection connection = new ClientConnection();
                connection.accept(this.serverLink.accept());
                Thread.yield();
            }
            catch (NetworkException nwE) {
                if (this.serverLink.isClosed()) {
                    this.isRunning = false;
                    continue;
                }
                nwE.printStackTrace();
                System.exit(1);
            }
            catch (ServiceException sE) {
                sE.printStackTrace();
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
        this.cleanUp();
    }

    protected abstract Class getInterface();

    protected ClientEntry getClientEntry(ClientID clientID) {
        return (ClientEntry)this.clients.get(clientID);
    }

    protected void cleanUp() {
    }

    protected void exit() {
        this.exit(0, null);
    }

    protected void exit(int code, String msg) {
        if (msg != null) {
            PrintStream stream = null;
            stream = code > 0 ? System.err : System.out;
            stream.println(msg);
            stream.flush();
        }
        System.exit(code);
    }
}

