/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.engine.core.admin;

import com.sap.sdt.engine.core.admin.ClientAdminIF;
import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.admin.ServerEntry;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.ServerConnection;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.util.vers.VersionIF;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractClientAdmin
implements ClientAdminIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_engine/java/com/sap/sdt/engine/core/admin/AbstractClientAdmin.java#2 $";
    protected ClientID clientID = new ClientID();
    protected Map servers = new HashMap();

    protected AbstractClientAdmin() {
        ServiceManager.register("Client", this.getInterface(), this);
    }

    public ClientID getID() {
        return this.clientID;
    }

    public ServerID connect(String host, int port) throws ServiceException {
        ServerConnection connection = new ServerConnection();
        return connection.connect(host, port);
    }

    public void addServer(ServerID serverID) {
        this.servers.put(serverID, new ServerEntry(serverID));
    }

    public void removeServer(ServerID serverID) {
        this.servers.remove(serverID);
        ServiceManager.removeAll(this.getServerConnection(serverID));
    }

    public void setServerConnection(ServerID serverID, ServerConnection conn) {
        this.getServerEntry(serverID).setConnection(conn);
    }

    public void setServerAdmin(ServerID serverID, ServerAdminIF admin) {
        this.getServerEntry(serverID).setServerAdmin(admin);
    }

    public void setServerVersion(ServerID serverID, VersionIF version) {
        this.getServerEntry(serverID).setVersion(version);
    }

    public ServerConnection getServerConnection(ServerID serverID) {
        return this.getServerEntry(serverID).getConnection();
    }

    public ServerAdminIF getServerAdmin(ServerID serverID) {
        return this.getServerEntry(serverID).getServerAdmin();
    }

    public VersionIF getServerVersion(ServerID serverID) {
        return this.getServerEntry(serverID).getVersion();
    }

    public void disconnect(ServerID serverID) throws ServiceException {
        ServerConnection connection = this.getServerConnection(serverID);
        connection.disconnect();
        this.removeServer(serverID);
    }

    public void disconnect() throws ServiceException {
        Iterator it = this.servers.keySet().iterator();
        while (it.hasNext()) {
            ServerID serverID = (ServerID)it.next();
            this.disconnect(serverID);
        }
    }

    public Service requestService(Class iface, ServerID serverID) throws ServiceException {
        Service service = this.getServerAdmin(serverID).requestService(iface);
        ServerConnection consumer = this.getServerConnection(serverID);
        return ServiceManager.register(service, (CmdConsumerIF)consumer);
    }

    protected abstract Class getInterface();

    protected ServerEntry getServerEntry(ServerID serverID) {
        return (ServerEntry)this.servers.get(serverID);
    }
}

