/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.util;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class UITextUtilities
implements SwingConstants {
    protected static boolean mIsTextCut = false;
    protected static int mMinPointsWidth = 0;
    protected static int mMinOnePointWidth = 2;
    protected static int mViewWidth;
    protected static int mMaxChars;
    protected static int mTaboffset;

    static {
        mTaboffset = 15;
    }

    private static void setTextCut(boolean b) {
        mIsTextCut = b;
    }

    private static void setMaxChars(int maxChars) {
        mMaxChars = maxChars;
    }

    private static int getMaxChars() {
        return mMaxChars;
    }

    private static boolean isTextCut() {
        return mIsTextCut;
    }

    public static void paintText(Graphics g, String s, int accChar, int textX, int textY) {
        int textWidth = 0;
        String cuttedText = "";
        if (s.equals("B")) {
            boolean bl = false;
        }
        if (s != null && s.length() >= UITextUtilities.getMaxChars()) {
            cuttedText = s.substring(0, UITextUtilities.getMaxChars());
            BasicGraphicsUtils.drawString(g, cuttedText, accChar, textX, textY);
            if (UITextUtilities.isTextCut()) {
                textWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), cuttedText);
                if (mViewWidth >= textWidth + 1) {
                    g.drawLine(textX + textWidth + 1, textY, textX + textWidth + 1, textY);
                }
                if (mViewWidth >= textWidth + 3) {
                    g.drawLine(textX + textWidth + 3, textY, textX + textWidth + 3, textY);
                }
                if (mViewWidth >= textWidth + 5) {
                    g.drawLine(textX + textWidth + 5, textY, textX + textWidth + 5, textY);
                }
            }
        }
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                textR.height = fm.getHeight();
            }
        }
        int gap = textIsEmpty || icon == null ? 0 : textIconGap;
        UITextUtilities.setTextCut(false);
        if (!textIsEmpty) {
            UITextUtilities.setMaxChars(text.length());
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            if (textR.width > availTextWidth - mTaboffset) {
                int totalWidth = mMinPointsWidth;
                int nChars = 0;
                while (nChars < text.length()) {
                    if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth - mTaboffset) {
                        UITextUtilities.setTextCut(true);
                        UITextUtilities.setMaxChars(nChars);
                        break;
                    }
                    ++nChars;
                }
                text = text.substring(0, nChars == 0 ? 1 : nChars);
                int newTextWidth = SwingUtilities.computeStringWidth(fm, text) + mMinPointsWidth;
                textR.width = nChars == 0 && viewR.width < newTextWidth ? viewR.width : (viewR.width - newTextWidth >= mMinOnePointWidth ? newTextWidth + mMinOnePointWidth : newTextWidth);
                mViewWidth = viewR.width;
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return text;
    }
}

