/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.util;

import com.sap.plaf.common.LookAndFeelUtil;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.hueshift.FrogHueShift;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.xml.XMLNode;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;

public class ThemeData
extends JComponent {
    private static String osname = System.getProperty("os.name").toUpperCase();
    private static Hashtable mInfoHashtable = new Hashtable();
    static FrogImageData imageData = null;
    static String objectName;

    public static void createXMLInfo() throws Exception {
        String xmlFrogInputFile = "com/sap/plaf/frog/resources/default/theme.xml";
        String xmlND2002inputFile = "com/sap/plaf/frog/resources/2002/theme.xml";
        XMLNode xmlNode = ThemeData.getXMLNode(xmlFrogInputFile);
        if (xmlNode != null) {
            ThemeData.fillhash(xmlNode, "Default");
            ThemeData.setupNotFoundInXML("Default");
        }
        if ((xmlNode = ThemeData.getXMLNode(xmlND2002inputFile)) != null) {
            ThemeData.fillhash(xmlNode, "Streamline");
            ThemeData.setupNotFoundInXML("Streamline");
        }
    }

    public static FrogImageData getImageDataFromThemeName(String systemThemeName, String imageDataString) {
        Exception e;
        if (systemThemeName.equals("Streamline")) {
            imageData = (FrogImageData)mInfoHashtable.get("Streamline." + imageDataString);
            if (imageData == null) {
                if (mInfoHashtable.get("Streamline." + imageDataString + ".Left") == null || mInfoHashtable.get("Streamline." + imageDataString + ".Top") == null || mInfoHashtable.get("Streamline." + imageDataString + ".Right") == null || mInfoHashtable.get("Streamline." + imageDataString + ".Bottom") == null) {
                    System.err.println("ThemeData.getImageData: Can not find in hashtable: 2002: " + imageDataString);
                    e = new Exception();
                    e.printStackTrace();
                }
                imageData = new FrogImageData(new Integer((String)mInfoHashtable.get("Streamline." + imageDataString + ".Left")), new Integer((String)mInfoHashtable.get("Streamline." + imageDataString + ".Top")), new Integer((String)mInfoHashtable.get("Streamline." + imageDataString + ".Right")), new Integer((String)mInfoHashtable.get("Streamline." + imageDataString + ".Bottom")), (String)mInfoHashtable.get("Streamline." + imageDataString + ".Url"), imageDataString);
                mInfoHashtable.put("Streamline." + imageDataString, imageData);
            }
        } else {
            imageData = (FrogImageData)mInfoHashtable.get("Default." + imageDataString);
            if (imageData == null) {
                if (mInfoHashtable.get("Default." + imageDataString + ".Left") == null || mInfoHashtable.get("Default." + imageDataString + ".Top") == null || mInfoHashtable.get("Default." + imageDataString + ".Right") == null || mInfoHashtable.get("Default." + imageDataString + ".Bottom") == null) {
                    System.err.println("ThemeData.getImageData: Can not find in hashtable: Default: " + imageDataString);
                    e = new Exception();
                    e.printStackTrace();
                }
                imageData = new FrogImageData(new Integer((String)mInfoHashtable.get("Default." + imageDataString + ".Left")), new Integer((String)mInfoHashtable.get("Default." + imageDataString + ".Top")), new Integer((String)mInfoHashtable.get("Default." + imageDataString + ".Right")), new Integer((String)mInfoHashtable.get("Default." + imageDataString + ".Bottom")), (String)mInfoHashtable.get("Default." + imageDataString + ".Url"), imageDataString);
                mInfoHashtable.put("Default." + imageDataString, imageData);
            }
        }
        if (imageData == null) {
            System.err.println("ThemInfo.getImageData: Can not find imageData of:" + imageDataString);
            e = new Exception();
            e.printStackTrace();
        }
        return imageData;
    }

    public static FrogImageData getImageData(JComponent c, String imageDataString) {
        String systemThemeName = SystemHueShift.getDisplayedTheme(c).getRootThemeName().equals("Streamline") || SystemHueShift.getDisplayedTheme(c) == null && FrogHueShift.getCurrentTheme().getRootThemeName().equals("Streamline") || SystemHueShift.getDisplayedTheme(c).getRootThemeName().equals("Tradeshow") || SystemHueShift.getDisplayedTheme(c) == null && FrogHueShift.getCurrentTheme().getRootThemeName().equals("Tradeshow") || imageDataString.equals("Notch.NotchTop") || imageDataString.equals("Notch.NotchBottom") ? "Streamline" : SystemHueShift.getDisplayedThemeName(c);
        return ThemeData.getImageDataFromThemeName(systemThemeName, imageDataString);
    }

    public static XMLNode getXMLNode(String filename) {
        return LookAndFeelUtil.getXMLNode(filename);
    }

    private static void fillhash(XMLNode xmlNode, String way) {
        if (xmlNode.getChildren().hasMoreElements()) {
            Enumeration e2 = xmlNode.getChildren();
            while (e2.hasMoreElements()) {
                xmlNode = (XMLNode)e2.nextElement();
                ThemeData.fillhash(xmlNode, String.valueOf(way) + "." + xmlNode.getName());
            }
        } else if (xmlNode.getValue() != null) {
            mInfoHashtable.put(way, xmlNode.getValue());
        }
    }

    private static void setupNotFoundInXML(String prefix) {
        String mImagePath = (String)mInfoHashtable.get(String.valueOf(prefix) + "." + "PopupMenu.Bord.LB.A.Url");
        FrogImageData mBox_LUC = new FrogImageData(193, 62, 195, 64, mImagePath, "GroupBox.LUC");
        FrogImageData mBox_LBC = new FrogImageData(193, 67, 195, 69, mImagePath, "GroupBox.LBC");
        FrogImageData mBox_RBC = new FrogImageData(198, 67, 200, 69, mImagePath, "GroupBox.RBC");
        FrogImageData mBox_RUC = new FrogImageData(198, 62, 200, 64, mImagePath, "GroupBox.RUC");
        FrogImageData mBox_RLE_HEADER = new FrogImageData(193, 73, 194, 74, mImagePath, "GroupBox.RLE_HEADER");
        FrogImageData mBox_TOP = new FrogImageData(196, 62, 197, 63, mImagePath, "GroupBox.TOP");
        FrogImageData mBox_RIGHT = new FrogImageData(199, 65, 200, 66, mImagePath, "GroupBox.RIGHT");
        FrogImageData mBox_BOTTOM = new FrogImageData(196, 68, 197, 69, mImagePath, "GroupBox.BOTTOM");
        FrogImageData mBox_LEFT = new FrogImageData(193, 65, 194, 66, mImagePath, "GroupBox.LEFT");
        FrogImageData mBox_BOTLINE = new FrogImageData(199, 71, 194, 72, mImagePath, "GroupBox.BOTLINE");
        mBox_RLE_HEADER = new FrogImageData(193, 73, 194, 74, mImagePath, "GroupBox.RLE_HEADER");
        FrogImageData mBox_PROG_HEADER = new FrogImageData(199, 71, 202, 74, mImagePath, "GroupBox.PROG_HEADER");
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.LUC", mBox_LUC);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.LBC", mBox_LBC);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.RBC", mBox_RBC);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.RUC", mBox_RUC);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.RLE_HEADER", mBox_RLE_HEADER);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.TOP", mBox_TOP);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.RIGHT", mBox_RIGHT);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.BOTTOM", mBox_BOTTOM);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.LEFT", mBox_LEFT);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.BOTLINE", mBox_BOTLINE);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.RLE_HEADER", mBox_RLE_HEADER);
        mInfoHashtable.put(String.valueOf(prefix) + ".GroupBox.PROG_HEADER", mBox_PROG_HEADER);
    }
}

