/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.hueshift;

import com.sap.plaf.frog.FrogGIFImageFilter;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.FrogHueShift;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.util.FrogTrace;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public class SystemHueShift {
    public static final String DEFAULTTHEME = "DefaultTheme";
    protected static Hashtable mSystemThemeEntries = new Hashtable();
    protected static Hashtable mInitializedThemes = new Hashtable();
    protected static Hashtable mTriedThemes = new Hashtable();
    protected static SystemHueShift mSystemHueShift;
    protected static String prefix;

    static {
        prefix = "";
    }

    public SystemHueShift() {
        mSystemHueShift = this.createSystemHueShift();
        mSystemThemeEntries = new Hashtable();
        mInitializedThemes = new Hashtable();
    }

    protected SystemHueShift createSystemHueShift() {
        if (mSystemHueShift == null) {
            return this;
        }
        return mSystemHueShift;
    }

    public static SystemHueShift getInstance() {
        return mSystemHueShift;
    }

    public static Image getCropImage(JComponent c, FrogImageData imgdata) {
        Image image = null;
        String uiResource = imgdata.getID();
        String systemThemeName = SystemHueShift.getDisplayedThemeName(c);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME)) {
            String currentThemeName = FrogHueShift.getCurrentTheme().getName();
            if (UIManager.get(String.valueOf(prefix) + uiResource) == null) {
                UIManager.put(String.valueOf(prefix) + uiResource, FrogLookAndFeel.getCropImage(c, imgdata));
            }
            if (UIManager.get(String.valueOf(prefix) + uiResource) == null) {
                System.err.println("SystemHueShift.getCropImage 1: can't get uiResource: Default." + uiResource);
            }
            image = (Image)UIManager.get(String.valueOf(prefix) + uiResource);
            if (FrogTrace.trace("UAI") && uiResource.equals("Statusbar.RightArrow")) {
                UIManager.put(String.valueOf(prefix) + uiResource, null);
            }
            return image;
        }
        if (UIManager.get(String.valueOf(systemThemeName) + "." + uiResource) == null) {
            UIManager.put(String.valueOf(systemThemeName) + "." + uiResource, FrogLookAndFeel.getCropImage(c, imgdata));
        }
        if (UIManager.get(String.valueOf(systemThemeName) + "." + uiResource) == null) {
            System.err.println("SystemHueShift.getCropImage 2: can't get uiResource: " + systemThemeName + "." + uiResource);
        }
        image = (Image)UIManager.get(String.valueOf(systemThemeName) + "." + uiResource);
        if (FrogTrace.trace("UAI") && uiResource.equals("Statusbar.RightArrow")) {
            UIManager.put(String.valueOf(systemThemeName) + "." + uiResource, null);
        }
        return image;
    }

    public static Icon getIcon(String name) {
        return UIManager.getIcon(name);
    }

    public static Icon getIcon(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcIcon(c, uiResource);
    }

    protected Icon getCalcIcon(JComponent c, String uiResource) {
        Icon icon = null;
        String systemThemeName = SystemHueShift.getDisplayedThemeName(c);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        if (mSystemHueShift == null) {
            icon = UIManager.getIcon(uiResource);
        } else if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME)) {
            if (UIManager.getIcon(String.valueOf(prefix) + uiResource) == null) {
                SystemHueShift.createTheme(DEFAULTTHEME);
            } else {
                icon = UIManager.getIcon(String.valueOf(prefix) + uiResource);
            }
        } else {
            if (UIManager.getBorder(String.valueOf(systemThemeName) + "." + uiResource) == null && mTriedThemes.get(systemThemeName) == null) {
                SystemHueShift.createTheme(systemThemeName);
                mTriedThemes.put(systemThemeName, Boolean.TRUE);
                if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
                    systemThemeName = DEFAULTTHEME;
                }
            }
            icon = UIManager.getIcon(String.valueOf(systemThemeName) + "." + uiResource);
        }
        return icon;
    }

    public static ColorUIResource getColor(JComponent c, int index) {
        String systemThemeName = SystemHueShift.getDisplayedThemeName(c);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        HueShiftTheme theme = systemThemeName != null && systemThemeName.equals(DEFAULTTHEME) ? FrogHueShift.getCurrentTheme() : FrogHueShift.getTheme(systemThemeName);
        if (FrogTrace.trace("UIS")) {
            FrogTrace.trace("UIS", "SystemHueShift.getColor(c,index), theme: " + theme.getName() + ", system: " + systemThemeName + ", index: " + index);
        }
        return theme.getColor(index - 73);
    }

    public static Color getColor(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcColor(c, uiResource);
    }

    public static Color getColor(String systemName, String themeType, String uiResource) {
        return SystemHueShift.getInstance().getCalcColorWithType(systemName, themeType, uiResource);
    }

    protected Color getCalcColor(JComponent c, String uiResource) {
        String themeType = null;
        if (c != null && c.getClientProperty("theme") != null) {
            themeType = (String)c.getClientProperty("theme");
        }
        return SystemHueShift.getInstance().getCalcColorWithType(SystemHueShift.getSystemName(c), themeType, uiResource);
    }

    private Color getCalcColorWithType(String systemName, String themeType, String uiResource) {
        Color color = null;
        String systemThemeName = SystemHueShift.getInstance().getDisplayedThemeName(systemName, themeType, uiResource);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        if (mSystemHueShift == null) {
            color = UIManager.getColor(uiResource);
        } else if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME)) {
            if (UIManager.getColor(String.valueOf(prefix) + uiResource) == null) {
                SystemHueShift.createTheme(systemThemeName);
            }
            color = UIManager.getColor(String.valueOf(prefix) + uiResource);
        } else {
            if (UIManager.getColor(String.valueOf(systemThemeName) + "." + uiResource) == null && mTriedThemes.get(systemThemeName) == null) {
                SystemHueShift.createTheme(systemThemeName);
                mTriedThemes.put(systemThemeName, Boolean.TRUE);
                if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
                    systemThemeName = DEFAULTTHEME;
                }
            }
            color = UIManager.getColor(String.valueOf(systemThemeName) + "." + uiResource);
        }
        if (color == null) {
            if (FrogTrace.trace("EBC") || FrogTrace.trace("EBC2")) {
                FrogTrace.trace("EBC", "No Color in SystemHueShift.getColor systemName: " + systemName + ", themeType: " + themeType + ", uiResource: " + uiResource);
            }
            color = new ColorUIResource(Color.blue);
        }
        return color;
    }

    public static Font getFont(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcFont(c, uiResource);
    }

    protected Font getCalcFont(JComponent c, String uiResource) {
        Font font = null;
        String systemThemeName = SystemHueShift.getDisplayedThemeName(c);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        if (mSystemHueShift == null) {
            font = UIManager.getFont(uiResource);
        } else if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME)) {
            if (UIManager.getFont(String.valueOf(prefix) + uiResource) == null) {
                SystemHueShift.createTheme(DEFAULTTHEME);
            } else {
                font = UIManager.getFont(String.valueOf(prefix) + uiResource);
            }
        } else {
            if (UIManager.getBorder(String.valueOf(systemThemeName) + "." + uiResource) == null && mTriedThemes.get(systemThemeName) == null) {
                SystemHueShift.createTheme(systemThemeName);
                mTriedThemes.put(systemThemeName, Boolean.TRUE);
                if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
                    systemThemeName = DEFAULTTHEME;
                }
            }
            font = UIManager.getFont(String.valueOf(systemThemeName) + "." + uiResource);
        }
        return font;
    }

    public static Border getBorder(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcBorder(c, uiResource);
    }

    protected Border getCalcBorder(JComponent c, String uiResource) {
        Border border = null;
        String systemThemeName = SystemHueShift.getDisplayedThemeName(c);
        if (mTriedThemes.get(systemThemeName) != null && mInitializedThemes.get(systemThemeName) == null) {
            systemThemeName = DEFAULTTHEME;
        }
        if (mSystemHueShift == null) {
            border = UIManager.getBorder(uiResource);
        } else if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME)) {
            if (UIManager.getBorder(String.valueOf(prefix) + uiResource) == null) {
                SystemHueShift.createTheme(DEFAULTTHEME);
            } else {
                border = UIManager.getBorder(String.valueOf(prefix) + uiResource);
            }
        } else {
            if (UIManager.getBorder(String.valueOf(systemThemeName) + "." + uiResource) == null && mTriedThemes.get(systemThemeName) == null) {
                SystemHueShift.createTheme(systemThemeName);
                mTriedThemes.put(systemThemeName, Boolean.TRUE);
            }
            border = UIManager.getBorder(String.valueOf(systemThemeName) + "." + uiResource);
        }
        return border;
    }

    public static String getResource(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcResource(c, uiResource);
    }

    protected String getCalcResource(JComponent c, String uiResource) {
        return null;
    }

    public static Insets getInsets(JComponent c, String uiResource) {
        return SystemHueShift.getInstance().getCalcInsets(c, uiResource);
    }

    protected Insets getCalcInsets(JComponent c, String uiResource) {
        return null;
    }

    public static String getSystemName(JComponent c) {
        String systemName = null;
        Object rootPane = null;
        JRootPane currentRootPane = null;
        Container cont = null;
        cont = c;
        Object system = null;
        if (c != null && (system = c.getClientProperty("system")) == null) {
            if (c instanceof RootPaneContainer) {
                currentRootPane = ((RootPaneContainer)((Object)c)).getRootPane();
            }
            while (cont != null) {
                if (cont instanceof JRootPane && (system = (currentRootPane = (JRootPane)cont).getClientProperty("system")) != null) {
                    return (String)system;
                }
                cont = cont.getParent();
            }
        }
        if (system != null) {
            systemName = (String)system;
        }
        return systemName;
    }

    public static Object getSchemeOfSystem(String system) {
        return mSystemThemeEntries.get(system);
    }

    public static String getProposedThemeName(JComponent c) {
        String themeName = null;
        Object themeString = null;
        if (c != null && (themeString = c.getClientProperty("system")) == null && c.getRootPane() != null) {
            themeString = c.getRootPane().getClientProperty("system");
        }
        if (themeString != null) {
            themeName = (String)themeString;
        }
        return themeName;
    }

    public static boolean isStreamline(JComponent c) {
        String designName = "";
        Object designString = null;
        if (c != null && (designString = c.getClientProperty("theme")) == null && c.getRootPane() != null) {
            designString = c.getRootPane().getClientProperty("theme");
        }
        if (designString != null) {
            designName = (String)designString;
        }
        return designName.equals("Streamline");
    }

    protected String readSystemThemeName(String systemName) {
        String systemThemeName = DEFAULTTHEME;
        String prefix = "SystemTheme_" + systemName;
        return systemThemeName;
    }

    protected static void createTheme(String themeName) {
        mSystemHueShift.realizeTheme(themeName);
    }

    protected void realizeTheme(String themeName) {
        HueShiftTheme theme;
        if (themeName.equals(DEFAULTTHEME)) {
            theme = FrogHueShift.getCurrentTheme();
            theme.setMaskedAsDefaultTheme(true);
        } else {
            theme = FrogHueShift.getTheme(themeName);
            theme.setMaskedAsDefaultTheme(false);
        }
        FrogGIFImageFilter.setTheme(theme);
        mInitializedThemes.put(theme.getName(), Boolean.TRUE);
        FrogLookAndFeel.getInstance().initThemeSpecificDefaults(theme, null);
    }

    public static String getDisplayedThemeName(JComponent c) {
        return SystemHueShift.getInstance().getCalcDisplayedThemeName(c);
    }

    protected String getCalcDisplayedThemeName(JComponent c) {
        String systemName = null;
        String themeType = null;
        if (c != null) {
            if (SystemHueShift.getSystemName(c) != null) {
                systemName = (String)c.getClientProperty("system");
            }
            if (c.getClientProperty("theme") != null) {
                themeType = (String)c.getClientProperty("theme");
            }
        }
        return this.getDisplayedThemeName2(systemName, themeType);
    }

    public static String getDisplayedThemeName(String systemName, String themeType) {
        return SystemHueShift.getInstance().getDisplayedThemeName2(systemName, themeType);
    }

    public String getDisplayedThemeName2(String systemName, String themeType) {
        return this.getDisplayedThemeName(systemName, themeType, null);
    }

    public String getDisplayedThemeName(String systemName, String themeType, String uiResource) {
        String systemThemeName = null;
        String displayedSystemThemeName = null;
        String generalSetting = "OldClassic";
        if (UIManager.getString("lookAndFeel") == "OldClassic" || UIManager.getString("lookAndFeel") == null) {
            return DEFAULTTHEME;
        }
        generalSetting = UIManager.getString("lookAndFeel");
        systemThemeName = systemName == null ? DEFAULTTHEME : (String)mSystemThemeEntries.get(systemName);
        if (systemThemeName == null) {
            systemThemeName = mSystemHueShift == null ? DEFAULTTHEME : mSystemHueShift.readSystemThemeName(systemName);
            mSystemThemeEntries.put(systemName, systemThemeName);
        }
        displayedSystemThemeName = systemThemeName;
        if (systemThemeName != null && systemThemeName.equals(DEFAULTTHEME) && generalSetting.equals("Systemdependent")) {
            if (themeType == null) {
                displayedSystemThemeName = DEFAULTTHEME;
            } else if (themeType.equals("Streamline")) {
                displayedSystemThemeName = UIManager.getString("StreamlineDefault");
            } else if (themeType.equals("Enjoy")) {
                displayedSystemThemeName = UIManager.getString("EnjoyDefault");
            } else if (themeType.equals("Tradeshow")) {
                displayedSystemThemeName = UIManager.getString("TradeshowDefault");
            }
        }
        return displayedSystemThemeName;
    }

    public static HueShiftTheme getDisplayedTheme(JComponent c) {
        return FrogHueShift.getTheme(SystemHueShift.getDisplayedThemeName(c));
    }

    public static void clearAllEntries() {
        mSystemThemeEntries = new Hashtable();
        mInitializedThemes = new Hashtable();
        mTriedThemes = new Hashtable();
    }
}

