/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.hueshift;

import com.sap.plaf.frog.FrogCheckBoxIcon;
import com.sap.plaf.frog.FrogGIFImageFilter;
import com.sap.plaf.frog.FrogGIFReader;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.FrogScrollButton;
import com.sap.plaf.frog.FrogToolBarUI;
import com.sap.plaf.frog.customizing.CustomizeFrame;
import com.sap.plaf.frog.customizing.HueShiftDialogI;
import com.sap.plaf.frog.customizing.SystemColorDialogI;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class FrogHueShift
extends Component
implements ActionListener {
    public static final String __PerforceId = "$Id$";
    protected static String[] mFrogClassNames;
    protected static String[] mAllDesignNames;
    protected static String mCurrentThemeName;
    protected static String mCurrentDesignName;
    protected static HueShiftTheme mCurrentTheme;
    protected static HueShiftTheme mSelectedTheme;
    protected static HueShiftTheme mNewCalculatedTheme;
    protected static Hashtable mStreamlineThemes;
    protected static Hashtable mEnjoyThemes;
    protected static Hashtable mTradeshowThemes;
    protected static boolean mThemesInitialized;
    protected static HueShiftDialogI mHueShiftPanel;
    protected static SystemColorDialogI mSystemColorsPanel;
    protected static String mIdentifier;
    protected static FrogHueShift mFrogHueShift;
    protected static Image mPreviewImage;
    public static final String LOOKANDFEEL = "lookAndFeel";
    public static final String LOOKANDFEELDEFAULT = "lookAndFeelDefault";

    static {
        mAllDesignNames = new String[]{"Enjoy", "Streamline", "Tradeshow"};
        mCurrentThemeName = null;
        mCurrentDesignName = null;
        mCurrentTheme = null;
        mStreamlineThemes = new Hashtable();
        mEnjoyThemes = new Hashtable();
        mTradeshowThemes = new Hashtable();
        mIdentifier = "CustomTheme_";
        mFrogHueShift = null;
    }

    public FrogHueShift() {
        this.initialize();
    }

    public void initialize() {
        if (!mThemesInitialized) {
            mFrogHueShift = this;
            this.initializeThemes();
            FrogHueShift.initializeCurrentTheme();
            mSelectedTheme = mCurrentTheme;
            FrogHueShift.setCurrentDesignName(mCurrentTheme.getRootThemeName());
        }
    }

    protected void initializeThemes() {
        BufferedReader inputFileBuffer = null;
        String fname = "com/sap/plaf/frog/resources/themecolors.properties";
        String line = "";
        URL url = null;
        ClassLoader loader = this.getClass().getClassLoader();
        url = loader == null ? ClassLoader.getSystemResource(fname) : loader.getResource(fname);
        try {
            inputFileBuffer = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = inputFileBuffer.readLine()) != null) {
                if (!line.startsWith("ThemeName")) continue;
                String themeName = line.substring(line.indexOf(":") + 1, line.length());
                String stringThemeColors = inputFileBuffer.readLine();
                if (stringThemeColors == null) continue;
                stringThemeColors = stringThemeColors.substring(stringThemeColors.indexOf("ThemeColors:"), stringThemeColors.length() - 1);
                ColorUIResource[] themeColors = FrogHueShift.stringColorsToColors(stringThemeColors);
                HueShiftTheme hueShiftTheme = new HueShiftTheme(themeName, themeColors);
                if (themeName.equals("Streamline")) {
                    hueShiftTheme.setRootThemeName("Streamline");
                    mStreamlineThemes.put(themeName, hueShiftTheme);
                    continue;
                }
                if (themeName.equals("Tradeshow")) {
                    hueShiftTheme.setRootThemeName("Tradeshow");
                    mTradeshowThemes.put(themeName, hueShiftTheme);
                    continue;
                }
                if (themeName.equals("Highcontrast")) {
                    hueShiftTheme.setRootThemeName("Highcontrast");
                    continue;
                }
                hueShiftTheme.setRootThemeName("Enjoy");
                mEnjoyThemes.put(themeName, hueShiftTheme);
            }
        }
        catch (Exception e) {
            System.err.println("############################# ERROR #############################");
            System.err.println("FrogHueShift.initializeThemes: Can't initialize themes with file: " + fname);
            System.err.println("############################# ERROR #############################");
            FrogHueShift.initializeFallBackThemes();
        }
        mThemesInitialized = true;
    }

    private static void initializeFallBackThemes() {
        ColorUIResource[] mBrightComplementaryColors = new ColorUIResource[]{new ColorUIResource(-4869208), new ColorUIResource(-1), new ColorUIResource(-65545), new ColorUIResource(-197395), new ColorUIResource(-724250), new ColorUIResource(-1185060), new ColorUIResource(-1710633), new ColorUIResource(-1908011), new ColorUIResource(-2566197), new ColorUIResource(-3224128), new ColorUIResource(-3750470), new ColorUIResource(-4408399), new ColorUIResource(-5592416), new ColorUIResource(-6711410), new ColorUIResource(-7566206), new ColorUIResource(-8224649), new ColorUIResource(-9606044), new ColorUIResource(-10461094), new ColorUIResource(-11776956), new ColorUIResource(-8742488), new ColorUIResource(-6441276), new ColorUIResource(-5651759), new ColorUIResource(-538781)};
        HueShiftTheme mBrightComplementaryTheme = new HueShiftTheme("BrightComplementary", mBrightComplementaryColors);
        mEnjoyThemes.put("BrightComplementary", mBrightComplementaryTheme);
        ColorUIResource[] mBrightHarmonicColors = new ColorUIResource[]{new ColorUIResource(-8018251), new ColorUIResource(-1), new ColorUIResource(-1179649), new ColorUIResource(-2362113), new ColorUIResource(-2953737), new ColorUIResource(-3742481), new ColorUIResource(-4138264), new ColorUIResource(-4729630), new ColorUIResource(-5256232), new ColorUIResource(-5651503), new ColorUIResource(-6572092), new ColorUIResource(-7361092), new ColorUIResource(-8676694), new ColorUIResource(-9992298), new ColorUIResource(-10584434), new ColorUIResource(-11571070), new ColorUIResource(-12228745), new ColorUIResource(-13017744), new ColorUIResource(-14726048), new ColorUIResource(-8742488), new ColorUIResource(-6572092), new ColorUIResource(-5651759), new ColorUIResource(-538781)};
        HueShiftTheme mBrightHarmonicTheme = new HueShiftTheme("BrightHarmonic", mBrightHarmonicColors);
        mEnjoyThemes.put("BrightHarmonic", mBrightHarmonicTheme);
        ColorUIResource[] mComplementaryColors = new ColorUIResource[]{new ColorUIResource(-6579569), new ColorUIResource(-197395), new ColorUIResource(-723997), new ColorUIResource(-1381929), new ColorUIResource(-2039856), new ColorUIResource(-2566457), new ColorUIResource(-3224128), new ColorUIResource(-3355715), new ColorUIResource(-4079438), new ColorUIResource(-4737368), new ColorUIResource(-5395297), new ColorUIResource(-6250603), new ColorUIResource(-7434620), new ColorUIResource(-8421771), new ColorUIResource(-9276822), new ColorUIResource(-9935008), new ColorUIResource(-10790316), new ColorUIResource(-11579575), new ColorUIResource(-12632261), new ColorUIResource(-10125170), new ColorUIResource(-8151638), new ColorUIResource(-7493449), new ColorUIResource(-6966847)};
        HueShiftTheme mComplementaryTheme = new HueShiftTheme("Complementary", mComplementaryColors);
        mEnjoyThemes.put("Complementary", mComplementaryTheme);
        ColorUIResource[] mHarmonicColors = new ColorUIResource[]{new ColorUIResource(-9466725), new ColorUIResource(-1050113), new ColorUIResource(-2626572), new ColorUIResource(-4137494), new ColorUIResource(-4729118), new ColorUIResource(-5255461), new ColorUIResource(-5782061), new ColorUIResource(-6439732), new ColorUIResource(-6966591), new ColorUIResource(-7362121), new ColorUIResource(-8282710), new ColorUIResource(-8940637), new ColorUIResource(-10256498), new ColorUIResource(-11309444), new ColorUIResource(-11704459), new ColorUIResource(-12559768), new ColorUIResource(-12955040), new ColorUIResource(-13415077), new ColorUIResource(-14336177), new ColorUIResource(-10125170), new ColorUIResource(-8151638), new ColorUIResource(-7493449), new ColorUIResource(-6966847)};
        HueShiftTheme mHarmonicTheme = new HueShiftTheme("Harmonic", mHarmonicColors);
        mEnjoyThemes.put("Harmonic", mHarmonicTheme);
        ColorUIResource[] mHighContrastBlueColors = new ColorUIResource[]{new ColorUIResource(-10383446), new ColorUIResource(-1), new ColorUIResource(-1), new ColorUIResource(-854537), new ColorUIResource(-1182988), new ColorUIResource(-1511694), new ColorUIResource(-2168851), new ColorUIResource(-3088923), new ColorUIResource(-3088923), new ColorUIResource(-3680288), new ColorUIResource(-7491903), new ColorUIResource(-7491903), new ColorUIResource(-4403237), new ColorUIResource(-9726289), new ColorUIResource(-13809578), new ColorUIResource(-12821136), new ColorUIResource(-13216666), new ColorUIResource(-13546661), new ColorUIResource(-16777216), new ColorUIResource(-8477510), new ColorUIResource(-3943459), new ColorUIResource(-3351838), new ColorUIResource(-3088923)};
        HueShiftTheme mHighContrastBlueTheme = new HueShiftTheme("HighContrastBlue", mHighContrastBlueColors);
        mEnjoyThemes.put("HighContrastBlue", mHighContrastBlueTheme);
        ColorUIResource[] mHighContrastColors = new ColorUIResource[]{new ColorUIResource(-8092540), new ColorUIResource(-1), new ColorUIResource(-1), new ColorUIResource(-1184275), new ColorUIResource(-1184275), new ColorUIResource(-1184275), new ColorUIResource(-1710619), new ColorUIResource(-2368549), new ColorUIResource(-2368549), new ColorUIResource(-3421237), new ColorUIResource(-5723992), new ColorUIResource(-5723992), new ColorUIResource(-3421237), new ColorUIResource(-7566196), new ColorUIResource(-12632257), new ColorUIResource(-11250604), new ColorUIResource(-11776948), new ColorUIResource(-12105913), new ColorUIResource(-16777216), new ColorUIResource(-6579301), new ColorUIResource(-3223858), new ColorUIResource(-2697514), new ColorUIResource(-2368549)};
        HueShiftTheme mHighContrastTheme = new HueShiftTheme("HighContrast", mHighContrastColors);
        mEnjoyThemes.put("HighContrast", mHighContrastTheme);
    }

    public static String[] getThemeNames(String themetype) {
        String[] themeNames = null;
        if (themetype == "Enjoy") {
            themeNames = new String[mEnjoyThemes.size()];
            Enumeration enumeration = mEnjoyThemes.keys();
            int i = 0;
            while (i < mEnjoyThemes.size()) {
                themeNames[i] = (String)enumeration.nextElement();
                ++i;
            }
        } else if (themetype == "Tradeshow") {
            themeNames = new String[mTradeshowThemes.size()];
            Enumeration enumeration = mTradeshowThemes.keys();
            int j = 0;
            while (j < mTradeshowThemes.size()) {
                themeNames[j] = (String)enumeration.nextElement();
                ++j;
            }
        } else {
            themeNames = new String[mStreamlineThemes.size()];
            Enumeration enumeration = mStreamlineThemes.keys();
            int j = 0;
            while (j < mStreamlineThemes.size()) {
                themeNames[j] = (String)enumeration.nextElement();
                ++j;
            }
        }
        return themeNames;
    }

    public static void setCurrentDesignName(String name) {
        mCurrentDesignName = name;
    }

    public static String getCurrentDesignName() {
        return mCurrentDesignName;
    }

    public static String[] getDesignNames() {
        String[] mAvailableDesignNames = new String[]{"Enjoy", "Streamline", "Tradeshow"};
        return mAvailableDesignNames;
    }

    public static void initializeCurrentTheme() {
        String currentThemeName = null;
        HueShiftTheme theme = null;
        if (UIManager.getString("currentTheme") != null) {
            currentThemeName = UIManager.getString("currentTheme");
        } else if (UIManager.getString(LOOKANDFEEL) != null && UIManager.getString(LOOKANDFEEL).equals("Enjoy")) {
            currentThemeName = (String)UIManager.get("EnjoyDefault");
        } else if (UIManager.getString(LOOKANDFEEL) != null && UIManager.getString(LOOKANDFEEL).equals("Streamline")) {
            if (UIManager.getString("StreamlineDefault") != null) {
                currentThemeName = UIManager.getString("StreamlineDefault");
            }
        } else if (UIManager.getString(LOOKANDFEEL) != null && UIManager.getString(LOOKANDFEEL).equals("Tradeshow")) {
            if (UIManager.getString("TradeshowDefault") != null) {
                currentThemeName = UIManager.getString("TradeshowDefault");
            }
        } else if (UIManager.getString(LOOKANDFEEL) != null && UIManager.getString(LOOKANDFEEL).equals("Systemdependent")) {
            currentThemeName = UIManager.getString(LOOKANDFEELDEFAULT) != null ? UIManager.getString(LOOKANDFEELDEFAULT) : UIManager.getString("EnjoyDefault");
        }
        if (currentThemeName == null || mEnjoyThemes.get(currentThemeName) == null && mStreamlineThemes.get(currentThemeName) == null) {
            currentThemeName = "Tradeshow";
        }
        UIManager.put("currentTheme", currentThemeName);
        theme = FrogHueShift.getTheme(currentThemeName);
        FrogHueShift.setCurrentDesignName(theme.getRootThemeName());
        FrogHueShift.setCurrentTheme(theme);
        mCurrentTheme.setMaskedAsDefaultTheme(true);
        FrogGIFImageFilter.setTheme(mCurrentTheme);
    }

    public static void realizeThemeChange() {
        FrogHueShift.setCurrentTheme(mNewCalculatedTheme);
        mCurrentTheme.setMaskedAsDefaultTheme(true);
        FrogGIFImageFilter.setTheme(mCurrentTheme);
        FrogGIFReader.calculateNewColorModel(true);
        FrogHueShift.reloadHueShiftDefaults(mCurrentTheme);
        FrogHueShift.saveThemeAsDefault(mCurrentTheme.getName());
        CustomizeFrame.updateRegisteredWindows();
    }

    public static void saveThemeAsDefault(String theme) {
        System.err.print("FrogHueShift.saveThemeAsDefault");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand.equals("VisualSetting.DesignSelected")) {
            FrogHueShift.setCurrentDesignName(mHueShiftPanel.getSelectedDesignName());
        } else if (actionCommand.equals("VisualSetting.FrogThemeChanged")) {
            FrogHueShift.realizeThemeChange();
        } else if (actionCommand.equals("VisualSetting.FrogThemeSelected")) {
            mSelectedTheme = FrogHueShift.getTheme(mHueShiftPanel.getSelectedThemeName());
            ColorUIResource c = mSelectedTheme.getColor(9);
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            mHueShiftPanel.setForegroundValue((int)(hsb[0] * 100.0f));
            c = mSelectedTheme.getColor(21);
            hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            mHueShiftPanel.setBackgroundValue((int)(hsb[0] * 100.0f));
            FrogHueShift.displayCurrentPreviewImage(mSelectedTheme, mHueShiftPanel);
            mNewCalculatedTheme = mSelectedTheme;
        } else if (actionCommand.equals("VisualSetting.ForegroundChanged")) {
            this.calculateCustomizeTheme(mHueShiftPanel.getForegroundValue(), mHueShiftPanel.getBackgroundValue());
            FrogHueShift.displayCurrentPreviewImage(mNewCalculatedTheme, mHueShiftPanel);
            mHueShiftPanel.setCurrentThemeName(mNewCalculatedTheme.getName());
        } else if (actionCommand.equals("VisualSetting.BackgroundChanged")) {
            this.calculateCustomizeTheme(mHueShiftPanel.getForegroundValue(), mHueShiftPanel.getBackgroundValue());
            FrogHueShift.displayCurrentPreviewImage(mNewCalculatedTheme, mHueShiftPanel);
            mHueShiftPanel.setCurrentThemeName(mNewCalculatedTheme.getName());
        } else if (actionCommand.equals("VisualSetting.SaveTheme")) {
            String customThemeNames = "";
            HueShiftTheme mNewCustomTheme = new HueShiftTheme(mHueShiftPanel.getCreatedThemeName(), mCurrentTheme.getColors());
            this.update();
            mHueShiftPanel.setThemeListSelectedValue(mNewCustomTheme.getName());
        } else if (actionCommand.equals("VisualSetting.RestoreThemes")) {
            FrogHueShift.setCurrentTheme(FrogHueShift.getTheme(mHueShiftPanel.getSelectedThemeName()));
            if (mCurrentTheme == null) {
                FrogHueShift.updateDefaultThemes();
            }
            this.update();
        } else if (actionCommand.equals("VisualSetting.DeleteTheme")) {
            FrogHueShift.setCurrentTheme(FrogHueShift.getTheme(mHueShiftPanel.getSelectedThemeName()));
            if (mCurrentTheme == null) {
                FrogHueShift.updateDefaultThemes();
            }
            mHueShiftPanel.setThemeListSelectedValue(mCurrentTheme.getName());
            this.update();
        } else {
            mThemesInitialized = false;
            this.initialize();
            mHueShiftPanel.setImages();
            FrogHueShift.displayCurrentPreviewImage(FrogHueShift.getCurrentTheme(), mHueShiftPanel);
            ColorUIResource c = mCurrentTheme.getColor(9);
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            mHueShiftPanel.setForegroundValue((int)(hsb[0] * 100.0f));
            c = mCurrentTheme.getColor(21);
            hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            mHueShiftPanel.setBackgroundValue((int)(hsb[0] * 100.0f));
        }
    }

    protected static void updateDefaultThemes() {
    }

    public static void setHueShiftDialogMask(HueShiftDialogI visualSettings) {
        mHueShiftPanel = visualSettings;
        if (mFrogHueShift != null) {
            mHueShiftPanel.addActionListener(mFrogHueShift);
        }
    }

    public static HueShiftTheme getTheme(String themeName) {
        HueShiftTheme searchedTheme = null;
        if (themeName == null) {
            return searchedTheme;
        }
        if (themeName.equals("DefaultTheme")) {
            searchedTheme = FrogHueShift.getCurrentTheme();
        } else {
            searchedTheme = (HueShiftTheme)mEnjoyThemes.get(themeName);
            if (searchedTheme == null) {
                searchedTheme = (HueShiftTheme)mStreamlineThemes.get(themeName);
            }
            if (searchedTheme == null) {
                searchedTheme = (HueShiftTheme)mTradeshowThemes.get(themeName);
            }
            if (searchedTheme == null) {
                searchedTheme = FrogHueShift.getCurrentTheme();
            }
        }
        return searchedTheme;
    }

    public static boolean isSchemeDataSaved(HueShiftTheme theme) {
        if (theme != null) {
            return mEnjoyThemes.get(theme.getName()) != null || mStreamlineThemes.get(theme.getName()) != null || mTradeshowThemes.get(theme.getName()) != null;
        }
        return false;
    }

    public ColorUIResource[] getCurrentThemeColors() {
        return mCurrentTheme.getColors();
    }

    public static String getCurrentThemeName() {
        return mCurrentTheme.getName();
    }

    public static HueShiftTheme getCurrentTheme() {
        return mCurrentTheme;
    }

    public static HueShiftTheme getSelectedTheme() {
        if (mSelectedTheme == null) {
            return FrogHueShift.getCurrentTheme();
        }
        return mSelectedTheme;
    }

    protected void initializeSelectedTheme() {
        mSelectedTheme = FrogHueShift.getCurrentTheme().getRootThemeName().equals(FrogHueShift.getCurrentDesignName()) ? FrogHueShift.getCurrentTheme() : (FrogHueShift.getCurrentDesignName().equals("Enjoy") ? FrogHueShift.getTheme("Complementary") : (FrogHueShift.getCurrentDesignName().equals("Streamline") ? FrogHueShift.getTheme("Streamline") : FrogHueShift.getTheme("Tradeshow")));
    }

    public static void reloadHueShiftDefaults(HueShiftTheme currentTheme) {
        FrogLookAndFeel.getInstance().initThemeSpecificDefaults(currentTheme, null);
        FrogToolBarUI.reloadHueShiftDefaults();
        FrogScrollButton.reloadHueShiftDefaults();
        FrogCheckBoxIcon checkBoxIcon = (FrogCheckBoxIcon)UIManager.getIcon("CheckBox.icon");
        checkBoxIcon.reloadHueShiftDefaults();
    }

    public static String getDefaultEnjoyThemeName() {
        if (UIManager.get("EnjoyDefault") != null) {
            return (String)UIManager.get("EnjoyDefault");
        }
        return "Complementary";
    }

    private static ColorUIResource[] stringColorsToColors(String stringcolors) {
        ColorUIResource[] themeColors = new ColorUIResource[23];
        int ch = 44;
        String integerString = "0";
        int currentPosition = 0;
        int i = 0;
        while (i < 23) {
            if (i == 0) {
                integerString = stringcolors.substring(stringcolors.indexOf(":") + 1, stringcolors.indexOf(ch, currentPosition));
            } else if (i == 22) {
                integerString = stringcolors.substring(currentPosition + 1, stringcolors.length());
            } else {
                currentPosition = stringcolors.indexOf(ch, currentPosition);
                int nextPosition = stringcolors.indexOf(ch, currentPosition + 1);
                integerString = stringcolors.substring(currentPosition + 1, nextPosition);
                currentPosition = nextPosition;
            }
            int colorRGB = Integer.valueOf(integerString);
            themeColors[i] = new ColorUIResource(colorRGB);
            ++i;
        }
        return themeColors;
    }

    public static String[] sortStringArray(String[] array) {
        int i = array.length - 1;
        while (i > 0) {
            boolean swapped = false;
            int j = 0;
            while (j < i) {
                if (array[j + 1].compareTo(array[j]) < 0) {
                    String temp = array[j];
                    array[j] = array[j + 1];
                    array[j + 1] = temp;
                    swapped = true;
                }
                ++j;
            }
            if (!swapped) break;
            --i;
        }
        return array;
    }

    protected void update() {
        mThemesInitialized = false;
        mStreamlineThemes = new Hashtable();
        mEnjoyThemes = new Hashtable();
        mTradeshowThemes = new Hashtable();
        this.initializeThemes();
        FrogHueShift.updateDefaultThemes();
        FrogHueShift.updateHueShiftPanel();
        FrogHueShift.updateSystemColorsPanel();
    }

    public static void updateHueShiftPanel() {
        if (mHueShiftPanel != null) {
            mHueShiftPanel.update(FrogHueShift.getThemeNames(FrogHueShift.getSelectedTheme().getRootThemeName()), FrogHueShift.getDesignNames(), FrogHueShift.getSelectedTheme(), mPreviewImage);
        }
    }

    public static void updateSystemColorsPanel() {
        if (mSystemColorsPanel != null) {
            String currentSystemColorsThemeName = mSystemColorsPanel.getSelectedThemeName();
            mPreviewImage = currentSystemColorsThemeName == null ? FrogHueShift.calculateCurrentPreviewImage(FrogHueShift.getCurrentTheme()) : FrogHueShift.calculateCurrentPreviewImage(FrogHueShift.getTheme(currentSystemColorsThemeName));
            mSystemColorsPanel.setPreviewImage(mPreviewImage);
        }
    }

    public static void updatePreviewPanel() {
    }

    protected void calculateCustomizeTheme(float foreH, float backH) {
        ColorUIResource[] themeColors = mSelectedTheme.getColors();
        ColorUIResource selectedThemeReferenceForeColor = mSelectedTheme.getColor(9);
        float[] hsbHolder = Color.RGBtoHSB(selectedThemeReferenceForeColor.getRed(), selectedThemeReferenceForeColor.getGreen(), selectedThemeReferenceForeColor.getBlue(), null);
        float deltaForegroundHue = (foreH - 100.0f * hsbHolder[0]) / 100.0f;
        ColorUIResource selectedThemeReferenceBackColor = mSelectedTheme.getColor(21);
        hsbHolder = Color.RGBtoHSB(selectedThemeReferenceBackColor.getRed(), selectedThemeReferenceBackColor.getGreen(), selectedThemeReferenceBackColor.getBlue(), null);
        float deltaBackgroundHue = (backH - 100.0f * hsbHolder[0]) / 100.0f;
        int i = 0;
        while (i < 19) {
            hsbHolder = Color.RGBtoHSB(themeColors[i].getRed(), themeColors[i].getGreen(), themeColors[i].getBlue(), null);
            hsbHolder[0] = hsbHolder[0] + deltaForegroundHue;
            themeColors[i] = new ColorUIResource(Color.HSBtoRGB(hsbHolder[0], hsbHolder[1], hsbHolder[2]));
            ++i;
        }
        i = 19;
        while (i < 23) {
            hsbHolder = Color.RGBtoHSB(themeColors[i].getRed(), themeColors[i].getGreen(), themeColors[i].getBlue(), null);
            hsbHolder[0] = hsbHolder[0] + deltaBackgroundHue;
            themeColors[i] = new ColorUIResource(Color.HSBtoRGB(hsbHolder[0], hsbHolder[1], hsbHolder[2]));
            ++i;
        }
        mNewCalculatedTheme = new HueShiftTheme("Custom, Derived From " + mHueShiftPanel.getSelectedThemeName(), themeColors);
        mNewCalculatedTheme.setRootThemeName(FrogHueShift.getSelectedTheme().getRootThemeName());
    }

    protected static void displayCurrentPreviewImage(HueShiftTheme currentTheme, SystemColorDialogI dialog) {
        mPreviewImage = FrogHueShift.calculateCurrentPreviewImage(currentTheme);
        dialog.setPreviewImage(mPreviewImage);
    }

    protected static Image calculateCurrentPreviewImage(HueShiftTheme theme) {
        FrogGIFImageFilter.calculatePreview(true);
        FrogGIFImageFilter.setPreviewTheme(theme);
        if (theme.getRootThemeName().equals("Enjoy")) {
            return FrogGIFReader.loadImage("com/sap/platin/base/settings/resources/enjoyHueShift.gif");
        }
        if (theme.getRootThemeName().equals("Streamline")) {
            return FrogGIFReader.loadImage("com/sap/platin/base/settings/resources/streamlineHueShift.gif");
        }
        return FrogGIFReader.loadImage("com/sap/platin/base/settings/resources/tradeshowHueShift.gif");
    }

    protected static void setCurrentTheme(HueShiftTheme currentTheme) {
        mCurrentTheme = currentTheme;
    }

    public static void setSystemDialogMask(SystemColorDialogI systemDialog) {
        mSystemColorsPanel = systemDialog;
        if (mSystemColorsPanel != null) {
            mSystemColorsPanel.addActionListener(mFrogHueShift);
            FrogHueShift.updateSystemColorsPanel();
        }
    }
}

