/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.customizing;

import com.sap.plaf.frog.SystemCheckBox;
import com.sap.plaf.frog.customizing.PicPanel;
import com.sap.plaf.frog.customizing.SystemColorDialogI;
import com.sap.plaf.frog.customizing.SystemListData;
import com.sap.plaf.frog.hueshift.FrogHueShift;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.util.FrogTrace;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SystemColorsPanel
extends JPanel
implements SystemColorDialogI {
    private JLabel mThemeNameLabel;
    private JScrollPane mScrollPaneThemes;
    private JScrollPane mScrollPaneSystems;
    private JList mThemeList;
    private PicPanel mPreviewPicPanel;
    private Vector mSystemListData;
    private Hashtable mColoredSystems;
    private JList mSystemList;
    private SystemListOrganizer mSystemListOrganizer;
    private Vector mListenerList;

    public SystemColorsPanel() {
        this.setLayout(null);
        this.setBounds(2, 27, 567, 318);
        this.setVisible(false);
        if (!UIManager.getLookAndFeel().getName().equals("Classic")) {
            this.mThemeNameLabel = new JLabel();
            this.add(this.mThemeNameLabel);
            this.mThemeNameLabel.setBounds(2, 2, 230, 23);
            this.mThemeNameLabel.setFont(UIManager.getFont("controlFontConstSize"));
            this.mScrollPaneThemes = new JScrollPane();
            this.mScrollPaneThemes.setOpaque(true);
            this.add(this.mScrollPaneThemes);
            this.mScrollPaneThemes.setBounds(2, 33, 146, 278);
            this.mThemeList = new JList();
            this.mThemeList.setBounds(0, 0, 148, 143);
            this.mScrollPaneThemes.getViewport().add(this.mThemeList);
            this.mScrollPaneSystems = new JScrollPane();
            this.mScrollPaneSystems.setOpaque(true);
            this.add(this.mScrollPaneSystems);
            this.mScrollPaneSystems.setBounds(366, 33, 145, 278);
            this.mSystemList = new JList();
            this.mSystemListOrganizer = new SystemListOrganizer();
            this.mSystemList.setCellRenderer(this.mSystemListOrganizer);
            this.mSystemList.setBounds(0, 0, 150, 276);
            this.mScrollPaneSystems.getViewport().add(this.mSystemList);
            this.mPreviewPicPanel = new PicPanel();
            this.mPreviewPicPanel.setLayout(null);
            this.add(this.mPreviewPicPanel);
            this.mPreviewPicPanel.setBounds(153, 80, 208, 143);
            this.mPreviewPicPanel.setOpaque(true);
            ThemeSelectionListener lThemeSelectionListener = new ThemeSelectionListener();
            this.mThemeList.addListSelectionListener(lThemeSelectionListener);
            this.mSystemListOrganizer = new SystemListOrganizer();
            this.mSystemList.addMouseListener(this.mSystemListOrganizer);
            this.mListenerList = new Vector();
        }
    }

    public void setSystemListData(Vector systemListData) {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.setSystemListData(systemListData), systemListData: " + systemListData);
        }
        this.mSystemList.setListData(systemListData);
    }

    public void mThemeList_valueChanged() {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.mThemeList_valueChanged()");
        }
        try {
            String currentThemeName = (String)this.mThemeList.getSelectedValue();
            this.mThemeList.setEnabled(true);
            this.fireActionPerformed(new ActionEvent(this, 1001, "SystemColorDialog.FrogThemeSelected"));
            this.setCurrentThemeName(currentThemeName);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSelectedThemeName() {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.setCurrentThemeName(), themeName" + (String)this.mThemeList.getSelectedValue());
        }
        return (String)this.mThemeList.getSelectedValue();
    }

    public void setCurrentThemeName(String themeName) {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.setCurrentThemeName(String themeName), themeName: " + themeName);
        }
        this.mThemeNameLabel.setText(themeName);
    }

    public void setThemeListSelectedValue(String themeName) {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.setThemeListSelectedValue(String themeName)");
        }
        this.mThemeList.setSelectedValue(themeName, true);
    }

    public void update(String[] themeNames, String[] designNames, HueShiftTheme currentTheme, Image previewImage) {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.update(..)");
        }
        this.mThemeList.setListData(SystemColorsPanel.sortStringArray(themeNames));
        this.mThemeNameLabel.setText(currentTheme.getName());
        this.setThemeListSelectedValue(currentTheme.getName());
        this.setPreviewImage(previewImage);
    }

    public void setPreviewImage(Image prev) {
        this.mPreviewPicPanel.setImage(prev);
        this.mPreviewPicPanel.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.mListenerList.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mListenerList.removeElement(l);
    }

    public void actionPerformed(ActionEvent event) {
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (FrogTrace.trace("SCP")) {
            FrogTrace.trace("SCP", "SystemColorsPanel.fireActionPerformed(ActionEvent e)");
        }
        Enumeration enumeration = this.mListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener listener = (ActionListener)enumeration.nextElement();
            listener.actionPerformed(e);
        }
    }

    public static String[] sortStringArray(String[] array) {
        int i = array.length - 1;
        while (i > 0) {
            boolean swapped = false;
            int j = 0;
            while (j < i) {
                if (array[j + 1].compareTo(array[j]) < 0) {
                    String temp = array[j];
                    array[j] = array[j + 1];
                    array[j + 1] = temp;
                    swapped = true;
                }
                ++j;
            }
            if (!swapped) break;
            --i;
        }
        return array;
    }

    public JList getSystemList() {
        return this.mSystemList;
    }

    public class SystemListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
            if (object == SystemColorsPanel.this.mThemeList && !((JList)object).getValueIsAdjusting()) {
                SystemColorsPanel.this.mThemeList_valueChanged();
                SystemColorsPanel.this.mThemeNameLabel.setText(((SystemListData)SystemColorsPanel.this.mThemeList.getSelectedValue()).getTheme().getName());
            }
        }
    }

    public class SystemListOrganizer
    extends SystemCheckBox
    implements ListCellRenderer,
    MouseListener {
        SystemListOrganizer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SystemListData SystemListData2 = (SystemListData)value;
            this.setText(SystemListData2.getSystemName());
            if (SystemListData2.getTheme().getName().equals(SystemColorsPanel.this.getSelectedThemeName()) && SystemListData2.isChecked()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setTextAreaBackground(SystemListData2.getTheme().getColor(5));
            this.setBackground(SystemListData2.getTheme().getColor(22));
            return this;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (FrogTrace.trace("SCP")) {
                FrogTrace.trace("SCP", "SystemColorsPanel.mousePressed(MouseEvent e)");
            }
            int index = SystemColorsPanel.this.mSystemList.locationToIndex(e.getPoint());
            SystemListData SystemListData2 = (SystemListData)SystemColorsPanel.this.mSystemList.getModel().getElementAt(index);
            if (SystemListData2.getTheme().getName().equals(SystemColorsPanel.this.getSelectedThemeName())) {
                SystemListData2.restoreTheme();
            } else {
                SystemListData2.setRestoreTheme(SystemListData2.getTheme());
                SystemListData2.setTheme(FrogHueShift.getTheme(SystemColorsPanel.this.getSelectedThemeName()));
            }
            if (SystemListData2.getTheme().getName().equals(SystemColorsPanel.this.getSelectedThemeName()) && SystemListData2.getTheme().getName().equals(UIManager.get("currentTheme"))) {
                SystemListData2.setChecked(false);
            } else {
                SystemListData2.setChecked(true);
            }
            SystemColorsPanel.this.mSystemList.repaint();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    public class ThemeSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
            if (object == SystemColorsPanel.this.mThemeList && !((JList)object).getValueIsAdjusting()) {
                SystemColorsPanel.this.mThemeList_valueChanged();
            }
        }
    }
}

