/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.customizing;

import com.sap.plaf.frog.customizing.HueShiftDialogI;
import com.sap.plaf.frog.customizing.PicPanel;
import com.sap.plaf.frog.customizing.SaveAsDialog;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HueShiftPanel
extends JPanel
implements HueShiftDialogI {
    private static Image mRainbowImage;
    private JLabel mThemeNameText;
    private JLabel mThemeNameLabel;
    private JLabel mDesignNameLabel;
    private JComboBox mDesignNameComboBox;
    private JScrollPane mScrollPane;
    private JList mThemeList;
    private PicPanel mPreviewPicPanel;
    private JCheckBox JCheckBox1;
    private JLabel JLabel3;
    private JLabel JLabel1;
    private JScrollBar mForegroundScrollBar;
    private JLabel JLabel2;
    private JScrollBar mBackgroundScrollBar;
    private JButton mSaveAsButton;
    private JButton mDeleteButton;
    private JButton mRestoreButton;
    private String mCreatedThemeName;
    private static int mOldForegroundScrollValue;
    private static int mOldBackgroundScrollValue;
    private Vector mListenerList;
    private SaveAsDialog mSaveAsDialog;
    private JFrame mPrefWindow;
    int y = 29;
    int x = 4;

    public HueShiftPanel() {
        Font theControlFont = UIManager.getFont("controlFontConstSize");
        int designNameLabelWidth = 45;
        this.setLayout(null);
        this.setBounds(2, 27, 567, 318);
        this.mDesignNameComboBox = new JComboBox();
        this.mDesignNameComboBox.setBounds(57, 9, 153, 20);
        this.mDesignNameComboBox.setFont(theControlFont);
        this.add(this.mDesignNameComboBox);
        this.mDesignNameComboBox.addActionListener(this);
        this.mDesignNameLabel = new JLabel();
        this.mDesignNameLabel.setBounds(this.x, 9, designNameLabelWidth, 23);
        this.mDesignNameLabel.setText("Theme:");
        this.mDesignNameLabel.setFont(theControlFont);
        this.add(this.mDesignNameLabel);
        this.mThemeNameLabel = new JLabel();
        this.mThemeNameLabel.setText("Scheme:");
        this.mThemeNameLabel.setBounds(this.x, this.y + 7, 49, 23);
        this.mThemeNameLabel.setFont(theControlFont);
        this.add(this.mThemeNameLabel);
        this.mThemeNameText = new JLabel();
        this.add(this.mThemeNameText);
        this.mThemeNameText.setBounds(57, this.y + 7, 230, 23);
        this.mThemeNameText.setFont(theControlFont);
        this.mScrollPane = new JScrollPane();
        this.mScrollPane.setOpaque(true);
        this.add(this.mScrollPane);
        this.mScrollPane.setBounds(this.x, this.y + 33, 208, 143);
        this.mScrollPane.getViewport().add(this.mThemeList);
        this.mThemeList = new JList();
        this.mThemeList.setBounds(0, this.y + 0, 207, 140);
        this.mScrollPane.getViewport().add(this.mThemeList);
        this.mPreviewPicPanel = new PicPanel();
        this.mPreviewPicPanel.setLayout(null);
        this.add(this.mPreviewPicPanel);
        this.mPreviewPicPanel.setBackground(Color.red);
        this.mPreviewPicPanel.setBounds(302, this.y + 33, 208, 143);
        this.mPreviewPicPanel.setOpaque(true);
        this.JCheckBox1 = new JCheckBox();
        this.add(this.JCheckBox1);
        this.JCheckBox1.setBounds(249, this.y + 193, 17, 18);
        this.JLabel3 = new JLabel();
        this.JLabel3.setText("< Link >");
        this.JLabel3.setFont(theControlFont);
        this.add(this.JLabel3);
        this.JLabel3.setForeground(Color.black);
        this.JLabel3.setBounds(235, this.y + 172, 60, 24);
        this.mSaveAsButton = new JButton();
        this.mSaveAsButton.setText("Save As");
        this.mSaveAsButton.setActionCommand("jbutton");
        this.add(this.mSaveAsButton);
        this.mSaveAsButton.setBounds(215, this.y + 33, 82, 23);
        this.mSaveAsButton.setEnabled(true);
        this.mSaveAsButton.setFont(theControlFont);
        this.mDeleteButton = new JButton();
        this.mDeleteButton.setText("Delete");
        this.mDeleteButton.setActionCommand("jbutton");
        this.mDeleteButton.setEnabled(false);
        this.mDeleteButton.setFont(theControlFont);
        this.add(this.mDeleteButton);
        this.mDeleteButton.setBounds(215, this.y + 61, 82, 23);
        this.mRestoreButton = new JButton();
        this.mRestoreButton.setText("Restore");
        this.mRestoreButton.setActionCommand("jbutton");
        this.mRestoreButton.setEnabled(true);
        this.mRestoreButton.setFont(theControlFont);
        this.add(this.mRestoreButton);
        this.mRestoreButton.setBounds(215, this.y + 89, 82, 23);
        this.mForegroundScrollBar = new JScrollBar();
        this.mForegroundScrollBar.setOrientation(0);
        this.add(this.mForegroundScrollBar);
        this.mForegroundScrollBar.setBounds(2, this.y + 225, 208, 17);
        this.mBackgroundScrollBar = new JScrollBar();
        this.mBackgroundScrollBar.setOrientation(0);
        this.add(this.mBackgroundScrollBar);
        this.mForegroundScrollBar.setMaximum(110);
        this.mBackgroundScrollBar.setMaximum(110);
        this.mBackgroundScrollBar.setBounds(302, this.y + 225, 208, 17);
        this.JLabel1 = new JLabel();
        this.JLabel1.setText("Foreground Color:");
        this.JLabel1.setFont(theControlFont);
        this.add(this.JLabel1);
        this.JLabel1.setForeground(Color.black);
        this.JLabel1.setBounds(2, this.y + 201, 144, 24);
        this.JLabel2 = new JLabel();
        this.JLabel2.setText("BackgroundColor:");
        this.JLabel2.setFont(theControlFont);
        this.add(this.JLabel2);
        this.JLabel2.setForeground(Color.black);
        this.JLabel2.setBounds(302, this.y + 201, 132, 24);
        SymListSelection lSymListSelection = new SymListSelection();
        this.mThemeList.addListSelectionListener(lSymListSelection);
        SymMouse aSymMouse = new SymMouse();
        this.mThemeList.addMouseListener(aSymMouse);
        this.mRestoreButton.addActionListener(this);
        this.mSaveAsButton.addActionListener(this);
        this.mDeleteButton.addActionListener(this);
        SymAdjustment lSymAdjustment = new SymAdjustment();
        this.mForegroundScrollBar.addAdjustmentListener(lSymAdjustment);
        this.mBackgroundScrollBar.addAdjustmentListener(lSymAdjustment);
        this.mListenerList = new Vector();
    }

    public void setSaveAsDialog(JDialog dialog) {
        if (dialog instanceof SaveAsDialog) {
            this.mSaveAsDialog = (SaveAsDialog)dialog;
            this.mSaveAsDialog.addActionListener(this);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (mRainbowImage != null) {
            g.drawImage(mRainbowImage, 49, this.y + 250, 49 + mRainbowImage.getWidth(null), this.y + 250 + mRainbowImage.getHeight(null), 0, 0, mRainbowImage.getWidth(null), mRainbowImage.getHeight(null), null);
            g.drawImage(mRainbowImage, 349, this.y + 250, 349 + mRainbowImage.getWidth(null), this.y + 250 + mRainbowImage.getHeight(null), 0, 0, mRainbowImage.getWidth(null), mRainbowImage.getHeight(null), null);
        }
    }

    public String getSelectedThemeName() {
        return (String)this.mThemeList.getSelectedValue();
    }

    public String getCreatedThemeName() {
        return this.mCreatedThemeName;
    }

    public void setForegroundValue(int value) {
        mOldForegroundScrollValue = value;
        this.mForegroundScrollBar.setValue(value);
    }

    public int getForegroundValue() {
        return this.mForegroundScrollBar.getValue();
    }

    public void setBackgroundValue(int value) {
        mOldBackgroundScrollValue = value;
        this.mBackgroundScrollBar.setValue(value);
    }

    public int getBackgroundValue() {
        return this.mBackgroundScrollBar.getValue();
    }

    public void setCurrentThemeName(String name) {
        this.mThemeNameText.setText(name);
    }

    public void setThemeListSelectedValue(String themeName) {
        this.mThemeList.setSelectedValue(themeName, true);
    }

    public void update(String[] themeNames, String[] designNames, HueShiftTheme selectedTheme, Image previewImage) {
        this.fillThemeList(themeNames);
        this.setCurrentThemeName(selectedTheme.getName());
        this.setThemeListSelectedValue(selectedTheme.getName());
        this.mDesignNameComboBox.removeAllItems();
        int i = 0;
        while (i < designNames.length) {
            this.mDesignNameComboBox.addItem(designNames[i]);
            ++i;
        }
        this.mDesignNameComboBox.setSelectedItem(selectedTheme.getRootThemeName());
    }

    public void setPreviewImage(Image img) {
        this.mPreviewPicPanel.setImage(img);
        this.mPreviewPicPanel.repaint();
    }

    public void setImages() {
    }

    public void addActionListener(ActionListener l) {
        this.mListenerList.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mListenerList.removeElement(l);
    }

    public void setDeleteButtonEnabled(boolean b) {
        this.mDeleteButton.setEnabled(b);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        Object object = event.getSource();
        if (object == this.mRestoreButton) {
            this.mRestoreButton_actionPerformed(event);
        } else if (object == this.mSaveAsButton) {
            this.mSaveAsButton_actionPerformed(event);
        } else if (object == this.mDeleteButton) {
            this.mDeleteButton_actionPerformed(event);
        } else if (actionCommand.equals("CancelSaveAsDialog")) {
            this.mSaveAsDialog.dispose();
        } else if (actionCommand.equals("OKSaveAsDialog")) {
            this.saveTheme();
        } else if (object == this.mDesignNameComboBox) {
            this.mDesignNameComboBox_actionPerformed(event);
        }
    }

    protected void mDesignNameComboBox_actionPerformed(ActionEvent event) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.DesignSelected"));
    }

    protected void mRestoreButton_actionPerformed(ActionEvent event) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.RestoreThemes"));
    }

    protected void mSaveAsButton_actionPerformed(ActionEvent event) {
        Rectangle r = null;
        Container comp = null;
        int x = 0;
        int y = 0;
        if (this.mSaveAsDialog != null) {
            this.mSaveAsDialog.setText(this.mThemeNameText.getText());
            comp = this.getParent();
            while (comp != null) {
                if (comp instanceof JFrame) {
                    r = ((JFrame)comp).getBounds();
                    comp = null;
                    continue;
                }
                comp = comp.getParent();
            }
            if (r != null) {
                x = r.x + r.width / 2 - this.mSaveAsDialog.getSize().width / 2;
                y = r.y + r.height / 2 - this.mSaveAsDialog.getSize().height / 2;
            }
            this.mSaveAsDialog.setLocation(x, y);
            this.mSaveAsDialog.show();
        }
    }

    protected void mDeleteButton_actionPerformed(ActionEvent event) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.DeleteTheme"));
    }

    protected void fireActionPerformed(ActionEvent e) {
        Enumeration enumeration = this.mListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener listener = (ActionListener)enumeration.nextElement();
            listener.actionPerformed(e);
        }
    }

    protected void saveTheme() {
        this.mCreatedThemeName = this.mSaveAsDialog.getText();
        if (this.mCreatedThemeName.equals("")) {
            this.mSaveAsDialog.dispose();
            JOptionPane.showMessageDialog(this.mPrefWindow, "This was not a valid name", "Save Error Dialog", 2);
        } else {
            this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.SaveTheme"));
            this.mSaveAsDialog.dispose();
        }
    }

    public void fillThemeList(String[] themelist) {
        String[] sortedThemeList = null;
        if (this.mThemeList == null) {
            this.mThemeList = new JList<String>(themelist);
        } else {
            sortedThemeList = HueShiftPanel.sortStringArray(themelist);
            this.mThemeList.setListData(sortedThemeList);
        }
    }

    public void mThemeList_valueChanged() {
        try {
            String currentThemeName = (String)this.mThemeList.getSelectedValue();
            this.mThemeList.setEnabled(true);
            this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.FrogThemeSelected"));
            this.setCurrentThemeName(currentThemeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isForegroundScrollbarManualDragged() {
        return this.mForegroundScrollBar.getValue() - mOldForegroundScrollValue != 0;
    }

    private boolean isBackgroundScrollbarManualDragged() {
        return this.mBackgroundScrollBar.getValue() - mOldBackgroundScrollValue != 0;
    }

    protected void mBackgroundScrollBar_adjustmentValueChanged(AdjustmentEvent event) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.BackgroundChanged"));
    }

    protected void mForegroundScrollBar_adjustmentValueChanged(AdjustmentEvent event) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "VisualSetting.ForegroundChanged"));
    }

    public void setRainbowImage(Image rainbowImage) {
        mRainbowImage = rainbowImage;
    }

    public static String[] sortStringArray(String[] array) {
        int i = array.length - 1;
        while (i > 0) {
            boolean swapped = false;
            int j = 0;
            while (j < i) {
                if (array[j + 1].compareTo(array[j]) < 0) {
                    String temp = array[j];
                    array[j] = array[j + 1];
                    array[j + 1] = temp;
                    swapped = true;
                }
                ++j;
            }
            if (!swapped) break;
            --i;
        }
        return array;
    }

    public JList getSystemList() {
        return null;
    }

    public String getSelectedDesignName() {
        return (String)this.mDesignNameComboBox.getSelectedItem();
    }

    public class SymListSelection
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
            if (object == HueShiftPanel.this.mThemeList && !((JList)object).getValueIsAdjusting()) {
                HueShiftPanel.this.mThemeList_valueChanged();
            }
        }
    }

    public class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == HueShiftPanel.this.mThemeList) {
                HueShiftPanel.this.mThemeList_valueChanged();
            }
        }
    }

    public class SymAdjustment
    implements AdjustmentListener {
        int rangeValue;

        public void adjustmentValueChanged(AdjustmentEvent event) {
            Object object = event.getSource();
            if (object == HueShiftPanel.this.mForegroundScrollBar && HueShiftPanel.this.isForegroundScrollbarManualDragged()) {
                if (HueShiftPanel.this.JCheckBox1.isSelected()) {
                    this.rangeValue = HueShiftPanel.this.getBackgroundValue() + (HueShiftPanel.this.getForegroundValue() - mOldForegroundScrollValue);
                    if (this.rangeValue >= 100) {
                        this.rangeValue = 0;
                    } else if (this.rangeValue <= 0) {
                        this.rangeValue = 100;
                    }
                    HueShiftPanel.this.setBackgroundValue(this.rangeValue);
                    HueShiftPanel.this.mBackgroundScrollBar_adjustmentValueChanged(event);
                    mOldBackgroundScrollValue = HueShiftPanel.this.mBackgroundScrollBar.getValue();
                }
                HueShiftPanel.this.mForegroundScrollBar_adjustmentValueChanged(event);
                mOldForegroundScrollValue = HueShiftPanel.this.mForegroundScrollBar.getValue();
            }
            if (object == HueShiftPanel.this.mBackgroundScrollBar && HueShiftPanel.this.isBackgroundScrollbarManualDragged()) {
                if (HueShiftPanel.this.JCheckBox1.isSelected()) {
                    this.rangeValue = HueShiftPanel.this.getForegroundValue() + (HueShiftPanel.this.getBackgroundValue() - mOldBackgroundScrollValue);
                    if (this.rangeValue >= 100) {
                        this.rangeValue = 0;
                    } else if (this.rangeValue <= 0) {
                        this.rangeValue = 100;
                    }
                    HueShiftPanel.this.setForegroundValue(this.rangeValue);
                    HueShiftPanel.this.mBackgroundScrollBar_adjustmentValueChanged(event);
                    mOldForegroundScrollValue = HueShiftPanel.this.mForegroundScrollBar.getValue();
                }
                HueShiftPanel.this.mBackgroundScrollBar_adjustmentValueChanged(event);
                mOldBackgroundScrollValue = HueShiftPanel.this.mBackgroundScrollBar.getValue();
            }
        }
    }
}

