/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog.customizing;

import com.sap.plaf.frog.customizing.SaveAsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CustomizeFrame
extends JFrame
implements ActionListener {
    int mWidth = 530;
    int mHeight = 400;
    int mScrollPaneWidth = 80;
    int mSpacer = 4;
    JPanel mMainPanel = new JPanel();
    protected static Vector mHueShiftWindows = new Vector();
    public static final int CLASSIC = 0;
    public static final int FROG = 1;
    static /* synthetic */ Class class$0;

    public CustomizeFrame() {
        this.initialize();
    }

    protected void initialize() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((d.width - this.mWidth) / 2, (d.height - this.mHeight) / 2, this.mWidth, this.mHeight);
        this.setResizable(false);
        this.setTitle("Visual Customizing");
        this.getContentPane().setLayout(null);
        this.mMainPanel.setLayout(null);
        this.mMainPanel.setBounds(0, 0, this.mWidth, 422);
        this.mMainPanel.setBackground(Color.red);
        this.getContentPane().add(this.mMainPanel);
        this.mMainPanel.setLayout(null);
        this.setVisible(false);
        CustomizeFrame.addHueShiftWindow(this);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("VisualSetting.ChangeToFrog")) {
            this.realizeFrogLookAndFeel();
        } else if (action.equals("VisualSetting.ChangeToClassic")) {
            this.realizeClassicLookAndFeel();
        }
    }

    protected Image loadimage(String path) {
        URL url = null;
        Image image = null;
        MediaTracker mMediaTracker = new MediaTracker(this);
        try {
            ClassLoader loader;
            url = this.getClass().getResource(path);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sap.plaf.frog.customizing.CustomizeFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((loader = clazz.getClassLoader()) != null) {
                url = loader.getResource(path);
                if (url == null) {
                    url = ClassLoader.getSystemResource(path);
                }
            } else {
                url = ClassLoader.getSystemResource(path);
            }
            ImageProducer ip = (ImageProducer)url.getContent();
            image = this.createImage(ip);
            mMediaTracker.addImage(image, 0);
            mMediaTracker.waitForID(0);
        }
        catch (Exception e) {
            System.err.println("FrogCustomizeWindow.loadImages: " + path + " Can't read image from file");
            e.printStackTrace();
        }
        return image;
    }

    public Image[] loadImages() {
        Image[] images = new Image[]{this.loadimage("com/sap/plaf/frog/resources/Frog.gif"), this.loadimage("com/sap/plaf/frog/resources/Classic.gif"), this.loadimage("com/sap/plaf/frog/resources/Rainbow.gif")};
        return images;
    }

    public void addNotify() {
        boolean frameSizeAdjusted = false;
        Dimension size = this.getSize();
        super.addNotify();
        if (frameSizeAdjusted) {
            return;
        }
        frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        boolean tweakFrameSize = false;
        try {
            String property = System.getProperty("TweakFrameSize");
            if (property != null && property.equals("true")) {
                tweakFrameSize = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tweakFrameSize) {
            this.setSize(2 * insets.left + 2 * insets.right + size.width, 2 * insets.top + 2 * insets.bottom + size.height);
        } else {
            this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
        }
    }

    public SaveAsDialog getSaveAsDialog() {
        SaveAsDialog mSaveAsDialog = new SaveAsDialog(this);
        return mSaveAsDialog;
    }

    public JPanel getVisualSettings() {
        return null;
    }

    public static void addHueShiftWindow(Component c) {
        mHueShiftWindows.addElement(c);
    }

    public static void removeHueShiftWindow(Component c) {
        mHueShiftWindows.removeElement(c);
    }

    protected void realizeFrogLookAndFeel() {
        try {
            Class<?> frogLookAndFeelClass = Class.forName("com.sap.platin.plaf.frog.PlatinFrogLookAndFeel");
            LookAndFeel mFrogLookAndFeel = (LookAndFeel)frogLookAndFeelClass.newInstance();
            UIManager.setLookAndFeel(mFrogLookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomizeFrame.updateRegisteredWindows();
        this.saveLookAndFeel(1);
    }

    protected void realizeClassicLookAndFeel() {
        try {
            Class<?> metalLookAndFeelClass = Class.forName("javax.swing.plaf.metal.MetalLookAndFeel");
            LookAndFeel mMetalLookAndFeel = (LookAndFeel)metalLookAndFeelClass.newInstance();
            UIManager.setLookAndFeel(mMetalLookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomizeFrame.updateRegisteredWindows();
        this.saveLookAndFeel(0);
    }

    private void saveLookAndFeel(int lookAndFeel) {
    }

    public static void updateRegisteredWindows() {
        Enumeration enumeration = mHueShiftWindows.elements();
        while (enumeration.hasMoreElements()) {
            JFrame frame = (JFrame)enumeration.nextElement();
            SwingUtilities.updateComponentTreeUI(frame);
            frame.repaint();
        }
    }
}

