/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class FrogUtils {
    public static void drawFlush3DBorder(Graphics g, Rectangle r) {
        FrogUtils.drawFlush3DBorder(g, r.x, r.y, r.width, r.height);
    }

    public static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(FrogLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(FrogLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(FrogLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    public static void drawPressed3DBorder(Graphics g, Rectangle r) {
        FrogUtils.drawPressed3DBorder(g, r.x, r.y, r.width, r.height);
    }

    public static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(FrogLookAndFeel.getControlShadow());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    public static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        FrogUtils.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(FrogLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    public static void drawDark3DBorder(Graphics g, Rectangle r) {
        FrogUtils.drawDark3DBorder(g, r.x, r.y, r.width, r.height);
    }

    public static void drawDark3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        FrogUtils.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(FrogLookAndFeel.getControl());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.setColor(FrogLookAndFeel.getControlShadow());
        g.drawLine(1, h - 2, 1, h - 2);
        g.drawLine(w - 2, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    public static void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        if (active) {
            FrogUtils.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            FrogUtils.drawFlush3DBorder(g, x, y, w, h);
        }
    }

    public static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        FrogUtils.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(FrogLookAndFeel.getPrimaryControl());
        g.drawLine(x + 1, y + 1, x + 1, h - 3);
        g.drawLine(x + 1, y + 1, w - 3, x + 1);
        g.setColor(FrogLookAndFeel.getPrimaryControlDarkShadow());
        g.drawLine(x + 2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 2, w - 2, h - 2);
    }

    public static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        FrogUtils.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active);
        g.setColor(FrogLookAndFeel.getControlDarkShadow());
        g.drawRect(x, y, w - 3, h - 3);
        g.drawLine(w - 2, 0, w - 2, 0);
        g.drawLine(0, h - 2, 0, h - 2);
    }

    static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(2, 2, 2, 0);

        TableHeaderBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getControlDarkShadow());
            g.drawLine(w - 1, 0, w - 1, h - 2);
            g.drawLine(1, h - 2, w - 1, h - 2);
            g.setColor(FrogLookAndFeel.getControlHighlight());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 3);
            g.setColor(FrogLookAndFeel.getControlShadow());
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = this.editorBorderInsets.left;
            insets.right = this.editorBorderInsets.right;
            insets.top = this.editorBorderInsets.top;
            insets.bottom = this.editorBorderInsets.bottom;
            return insets;
        }
    }
}

