/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogTreeI;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.FrogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FrogTreeUI
extends MetalTreeUI {
    public static final String __PerforceId = "$Id: $";
    private static Color lineColor;
    private static Color defCellRendererNonSelectColor;
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private PropertyChangeListener lineStyleListener = new LineListener();
    private boolean sapTree;
    private boolean opaque;
    private boolean rootVisible;

    public static ComponentUI createUI(JComponent x) {
        return new FrogTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return 4;
    }

    public void installUI(JComponent c) {
        Object lineStyleFlag;
        super.installUI(c);
        this.sapTree = c instanceof FrogTreeI;
        lineColor = UIManager.getColor("Tree.line");
        this.opaque = this.tree.isOpaque();
        this.rootVisible = ((JTree)c).isRootVisible();
        if (this.sapTree) {
            this.opaque = ((FrogTreeI)((Object)c)).hasBackgroundImage();
        }
        if ((lineStyleFlag = c.getClientProperty(LINE_STYLE)) == null || !FrogUtil.isStandAlone(UIManager.getLookAndFeel())) {
            lineStyleFlag = new Integer(1);
        }
        this.decodeLineStyle(HORIZ_STYLE_STRING);
        c.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(c);
    }

    private static boolean isFirstChild(TreeNode v) {
        if (v == null) {
            throw new IllegalArgumentException("isFirstChild: Node is <null>");
        }
        return v.getParent() == null || v.getParent().getIndex(v) == 0;
    }

    public Icon getExpandedIcon() {
        if (this.expandedIcon != (Icon)UIManager.get("Tree.defaultExpandedIcon")) {
            return this.expandedIcon;
        }
        if (this.expandedIcon == (Icon)UIManager.get("Tree.defaultExpandedIcon") && (Icon)UIManager.getDefaults().get("Tree.expandedIcon") != (Icon)UIManager.get("Tree.defaultExpandedIcon")) {
            return (Icon)UIManager.getDefaults().get("Tree.expandedIcon");
        }
        return SystemHueShift.getIcon(this.tree, "Tree.SAPexpandedIcon");
    }

    public Icon getCollapsedIcon() {
        if (this.collapsedIcon != (Icon)UIManager.get("Tree.defaultCollapsedIcon")) {
            return this.collapsedIcon;
        }
        if (this.collapsedIcon == (Icon)UIManager.get("Tree.defaultCollapsedIcon") && (Icon)UIManager.getDefaults().get("Tree.collapsedIcon") != (Icon)UIManager.get("Tree.defaultCollapsedIcon")) {
            return (Icon)UIManager.getDefaults().get("Tree.collapsedIcon");
        }
        return SystemHueShift.getIcon(this.tree, "Tree.SAPcollapsedIcon");
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
        super.decodeLineStyle(lineStyleFlag);
        if (!FrogUtil.isStandAlone(UIManager.getLookAndFeel())) {
            this.lineStyle = 1;
        } else if (lineStyleFlag == null || lineStyleFlag.equals(NO_STYLE_STRING)) {
            this.lineStyle = 0;
        } else if (lineStyleFlag.equals(LEG_LINE_STYLE_STRING)) {
            this.lineStyle = 2;
        } else if (lineStyleFlag.equals(HORIZ_STYLE_STRING)) {
            this.lineStyle = 1;
        }
    }

    protected boolean isLocationInExpandControl(int row, int rowLevel, int mouseX, int mouseY) {
        if (this.tree != null && !this.isLeaf(row)) {
            int boxWidth = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() + 6 : 8;
            Insets i = this.tree.getInsets();
            int boxLeftX = i != null ? i.left : 0;
            int boxRightX = (boxLeftX += (rowLevel + this.depthOffset - 1) * this.totalChildIndent + this.getLeftChildIndent() - boxWidth / 2) + boxWidth;
            return mouseX >= boxLeftX && mouseX <= boxRightX;
        }
        return false;
    }

    public void paint(Graphics g, JComponent c) {
        boolean paintSelectionBackground;
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        boolean bl = paintSelectionBackground = this.tree.getClientProperty("Tree.paintSelectionBackground") != null;
        if (this.tree.getClientProperty("DoNotFrog") == null && this.lineStyle == 1 && (c.getBackground() instanceof ColorUIResource || c.getBackground() == null)) {
            Insets insets;
            if (this.treeState == null) {
                return;
            }
            Rectangle paintBounds = g.getClipBounds();
            if (this.tree.getModel() == null) {
                g.setColor(SystemHueShift.getColor(c, "Tree.background"));
                g.fillRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                return;
            }
            Enumeration<TreePath> exPaths = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
            int depth = 0;
            if (exPaths != null) {
                while (exPaths.hasMoreElements()) {
                    depth = Math.max(depth, exPaths.nextElement().getPathCount());
                }
            }
            if ((insets = this.tree.getInsets()) == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
            Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            int row = this.treeState.getRowForPath(initialPath);
            int endY = paintBounds.y + paintBounds.height;
            this.drawingCache.clear();
            if (initialPath != null && paintingEnumerator != null) {
                boolean done = false;
                Rectangle boundsBuffer = new Rectangle();
                TreePath path = null;
                boolean higherLevel = false;
                boolean lowerLevel = false;
                boolean first = true;
                while (!done && paintingEnumerator.hasMoreElements()) {
                    boolean isExpanded;
                    boolean hasBeenExpanded;
                    path = paintingEnumerator.nextElement();
                    if (path == null) {
                        return;
                    }
                    int pathLength = path.getPathCount();
                    --pathLength;
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    Rectangle clipRect = null;
                    Rectangle newClip = null;
                    int drawWidth = 0;
                    if (c.isOpaque() && c.getBackground() instanceof ColorUIResource) {
                        if (this.sapTree) {
                            clipRect = g.getClipBounds();
                            newClip = ((FrogTreeI)((Object)c)).getDrawingRect();
                            newClip.x = clipRect.x;
                            newClip.y = clipRect.y;
                            newClip.height = clipRect.height;
                            drawWidth = newClip.width;
                            g.setClip(newClip);
                        } else {
                            newClip = g.getClipBounds();
                            drawWidth = c.getSize().width;
                        }
                        Object node = path.getLastPathComponent();
                        if (node != null && node instanceof TreeNode) {
                            lowerLevel = FrogTreeUI.isFirstChild((TreeNode)node);
                            higherLevel = this.tree.getPathForRow(row - 1) != null ? this.tree.getPathForRow(row - 1).getPathCount() - 1 > pathLength : false;
                        } else {
                            lowerLevel = false;
                            higherLevel = false;
                        }
                        if (higherLevel || lowerLevel || first && (!paintSelectionBackground || !this.tree.isRowSelected(row))) {
                            switch (depth - pathLength) {
                                case 0: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background4"));
                                    defCellRendererNonSelectColor = SystemHueShift.getColor(c, "Tree.background4");
                                    break;
                                }
                                case 1: {
                                    defCellRendererNonSelectColor = SystemHueShift.getColor(c, "Tree.background3");
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background3"));
                                    break;
                                }
                                case 2: {
                                    defCellRendererNonSelectColor = SystemHueShift.getColor(c, "Tree.background2");
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background2"));
                                    break;
                                }
                                default: {
                                    defCellRendererNonSelectColor = SystemHueShift.getColor(c, "Tree.background1");
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background1"));
                                }
                            }
                            g.fillRect(0, bounds.y, drawWidth, c.getSize().height - bounds.y);
                        }
                        first = false;
                        if (!paintingEnumerator.hasMoreElements() && pathLength > 1) {
                            Rectangle r = this.tree.getRowBounds(row);
                            int height = r != null ? r.height : 0;
                            switch (depth) {
                                case 2: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background3"));
                                    break;
                                }
                                case 3: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background2"));
                                    break;
                                }
                                default: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.background1"));
                                }
                            }
                            g.fillRect(0, bounds.y + height, drawWidth, c.getSize().height - bounds.y - height);
                            g.setColor(SystemHueShift.getColor(c, "Tree.highlightLine0"));
                            g.drawLine(0, bounds.y + height, drawWidth, bounds.y + height);
                        }
                        if (this.sapTree) {
                            g.setClip(clipRect);
                        }
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    this.paintFrogRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (this.opaque) {
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                        if (this.sapTree) {
                            g.setClip(newClip);
                        }
                        if (lowerLevel) {
                            switch (depth - pathLength) {
                                case 0: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.shadowLine0"));
                                    break;
                                }
                                case 1: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.shadowLine1"));
                                    break;
                                }
                                default: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.shadowLineDefault"));
                                }
                            }
                            g.drawLine(0, bounds.y, drawWidth, bounds.y);
                        } else if (higherLevel) {
                            switch (depth - pathLength) {
                                case 0: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.highlightLine0"));
                                    break;
                                }
                                case 1: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.highlightLine0"));
                                    break;
                                }
                                case 2: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.highlightLine1"));
                                    break;
                                }
                                default: {
                                    g.setColor(SystemHueShift.getColor(c, "Tree.highlightLineDefault"));
                                }
                            }
                            g.drawLine(0, bounds.y, drawWidth, bounds.y);
                        }
                        if (this.sapTree) {
                            g.setClip(clipRect);
                        }
                    }
                    ++row;
                }
            }
        } else {
            super.paint(g, c);
        }
    }

    protected void paintFrogRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, true);
        if (component instanceof DefaultTreeCellRenderer) {
            ((DefaultTreeCellRenderer)component).setBackgroundNonSelectionColor(defCellRendererNonSelectColor);
        }
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(FrogTreeUI.LINE_STYLE) && FrogUtil.isStandAlone(UIManager.getLookAndFeel())) {
                FrogTreeUI.this.decodeLineStyle(e.getNewValue());
            }
        }
    }
}

