/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogButtonUI;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FrogToolBarUI
extends BasicToolBarUI {
    public static final String __PerforceId = "$Id$";
    protected boolean mDefaultsInitialized = false;
    private static boolean mNonHueShiftDefaultsInit = false;
    private boolean isToolbarTypeSet = false;
    private Integer mToolbarType = null;
    private static Border rolloverBorder = new FrogBorders.RolloverButtonBorder();
    private static Border nonRolloverBorder = new FrogBorders.ButtonBorder();
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    protected PropertyChangeListener mPropertyChangeHandler;
    private Hashtable borderTable = new Hashtable();
    private boolean rolloverBorders = false;
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static int IS_TOOLBAR = 0;
    private static int IS_APPLICATIONTOOLBAR = 1;
    private static Color mBackgroundColorType0 = null;
    private static Color mBackgroundColorType1 = null;
    private static Color mBackgroundColorType2 = null;
    private static Color mBackgroundColorType3 = null;
    private static Color mBackgroundColorType4 = null;

    public static ComponentUI createUI(JComponent c) {
        return new FrogToolBarUI();
    }

    public void update(Graphics g, JComponent c) {
        this.mToolbarType = (Integer)this.toolBar.getClientProperty("toolbarType");
        if (!this.mDefaultsInitialized) {
            if (this.mToolbarType != null) {
                this.setToolbarDefaults();
            }
            this.mDefaultsInitialized = true;
        }
        super.update(g, c);
        if (c.isOpaque()) {
            Color temp;
            Dimension size = c.getSize();
            if (this.mToolbarType != null) {
                if (this.mToolbarType == 2) {
                    g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Title.Bgnd")), 0, 0, size.width, size.height, ThemeData.getImageData(c, "Title.Bgnd").getLeft(), ThemeData.getImageData(c, "Title.Bgnd").getTop(), ThemeData.getImageData(c, "Title.Bgnd").getRight(), ThemeData.getImageData(c, "Title.Bgnd").getBottom(), null);
                } else if (this.mToolbarType == 3) {
                    temp = g.getColor();
                    g.setColor(SystemHueShift.getColor(c, "ToolBar.controlbackground"));
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(temp);
                } else if (this.mToolbarType == 0) {
                    temp = g.getColor();
                    g.setColor(mBackgroundColorType0);
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(temp);
                } else if (this.mToolbarType == 1) {
                    temp = g.getColor();
                    g.setColor(mBackgroundColorType1);
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(temp);
                } else if (this.mToolbarType == 4) {
                    temp = g.getColor();
                    g.setColor(mBackgroundColorType4);
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(temp);
                } else {
                    temp = g.getColor();
                    g.setColor(c.getBackground());
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(temp);
                }
            }
            if (this.mToolbarType == null) {
                temp = g.getColor();
                g.setColor(c.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(temp);
            }
        }
    }

    private void setToolbarDefaults() {
        if (this.mToolbarType == null) {
            LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
            LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        } else if (this.mToolbarType == 0) {
            LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
            LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        } else if (this.mToolbarType == 1) {
            this.toolBar.setBorder((Border)UIManager.get("ToolBar.applicationborder"));
            this.toolBar.setBackground((Color)UIManager.get("ToolBar.applicationbackground"));
            this.toolBar.setForeground((Color)UIManager.get("ToolBar.foreground"));
        } else if (this.mToolbarType == 2) {
            LookAndFeel.installBorder(this.toolBar, "TitleBar.titleborder");
            LookAndFeel.installColorsAndFont(this.toolBar, "TitleBar.background", "TitleBar.foreground", "TitleBar.font");
        } else if (this.mToolbarType == 3) {
            LookAndFeel.installBorder(this.toolBar, "ToolBar.controlborder");
            LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.controlbackground", "ToolBar.foreground", "ToolBar.font");
        } else if (this.mToolbarType == 4) {
            LookAndFeel.installBorder(this.toolBar, "ToolBar.controlborder");
            LookAndFeel.installColorsAndFont(this.toolBar, "userAreaBackground", "ToolBar.foreground", "ToolBar.font");
        }
        this.isToolbarTypeSet = true;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.toolBar = (JToolBar)c;
        this.mToolbarType = (Integer)this.toolBar.getClientProperty("toolbarType");
        if (this.mToolbarType != null && this.mToolbarType == 0 && this.toolBar.getComponentCount() > 4 && this.toolBar.getComponent(1) instanceof JToolBar.Separator && this.toolBar.getComponent(3) instanceof JToolBar.Separator) {
            this.toolBar.remove(1);
            this.toolBar.remove(2);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.installNormalBorders(c);
    }

    protected void installDefaults() {
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        this.setRolloverBorders(true);
        if (!mNonHueShiftDefaultsInit) {
            mBackgroundColorType0 = UIManager.getColor("ToolBar.background");
            mBackgroundColorType1 = UIManager.getColor("ToolBar.applicationbackground");
            mBackgroundColorType2 = UIManager.getColor("TitleBar.background");
            mBackgroundColorType3 = UIManager.getColor("ToolBar.controlbackground");
            mBackgroundColorType4 = UIManager.getColor("userAreaBackground");
            mNonHueShiftDefaultsInit = true;
        }
        this.setToolbarDefaults();
    }

    protected PropertyChangeListener createPropertyChangeHandler() {
        return new PropertyChangeHandler();
    }

    protected void navigateFocusedComp(int direction) {
        if (this.mToolbarType != null && this.mToolbarType != 3) {
            super.navigateFocusedComp(direction);
            return;
        }
        int nComp = this.toolBar.getComponentCount();
        block0 : switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex + 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j >= nComp) {
                        j = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j++)) != null && comp.isFocusTraversable()) {
                        comp.requestFocus();
                        break block0;
                    }
                    if (comp == null || !(comp instanceof JPanel) || comp.isFocusTraversable() || !comp.isVisible() || ((JComponent)comp).isManagingFocus() || ((Container)comp).getComponentCount() <= 0 || !((JPanel)comp).getComponent(0).isFocusTraversable()) continue;
                    ((JPanel)comp).getComponent(0).requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex - 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j < 0) {
                        j = nComp - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j--)) != null && comp.isFocusTraversable()) {
                        comp.requestFocus();
                        break block0;
                    }
                    if (comp == null || !(comp instanceof JPanel) || comp.isFocusTraversable() || !comp.isVisible() || ((JComponent)comp).isManagingFocus() || ((Container)comp).getComponentCount() <= 0 || !((JPanel)comp).getComponent(0).isFocusTraversable()) continue;
                    ((JPanel)comp).getComponent(0).requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    public static void reloadHueShiftDefaults() {
        mBackgroundColorType1 = UIManager.getColor("ToolBar.applicationbackground");
        mBackgroundColorType3 = UIManager.getColor("ToolBar.controlbackground");
        mBackgroundColorType4 = UIManager.getColor("userAreaBackground");
    }

    protected void installListeners() {
        super.installListeners();
        this.contListener = this.createContainerListener();
        if (this.contListener != null) {
            this.toolBar.addContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.addPropertyChangeListener(this.rolloverListener);
        }
        this.mPropertyChangeHandler = this.createPropertyChangeHandler();
        if (this.mPropertyChangeHandler != null) {
            this.toolBar.addPropertyChangeListener(this.mPropertyChangeHandler);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.contListener != null) {
            this.toolBar.removeContainerListener(this.contListener);
        }
        this.contListener = null;
        if (this.rolloverListener != null) {
            this.toolBar.removePropertyChangeListener(this.rolloverListener);
        }
        this.rolloverListener = null;
        if (this.mPropertyChangeHandler != null) {
            this.toolBar.removePropertyChangeListener(this.mPropertyChangeHandler);
        }
    }

    protected ContainerListener createContainerListener() {
        return new FrogContainerListener();
    }

    protected PropertyChangeListener createRolloverListener() {
        return new FrogRolloverListener();
    }

    protected MouseInputListener createDockingListener() {
        return new FrogDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point p) {
        if (this.dragWindow == null) {
            this.dragWindow = this.createDragWindow(this.toolBar);
        }
        this.dragWindow.setOffset(p);
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean rollover) {
        this.rolloverBorders = rollover;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JComponent) {
                ((JComponent)components[i]).updateUI();
                this.setBorderToRollover(components[i]);
            }
            ++i;
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JComponent) {
                ((JComponent)components[i]).updateUI();
                this.setBorderToNonRollover(components[i]);
            }
            ++i;
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToNormal(components[i]);
            ++i;
        }
    }

    protected void setBorderToRollover(Component c) {
        JButton b;
        if (c instanceof JButton && (b = (JButton)c).getUI() instanceof FrogButtonUI) {
            if (b.getBorder() instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource || b.getBorder() == nonRolloverBorder) {
                b.setBorder(rolloverBorder);
            }
            b.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        JButton b;
        if (c instanceof JButton && (b = (JButton)c).getUI() instanceof FrogButtonUI) {
            if (b.getBorder() instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource || b.getBorder() == rolloverBorder) {
                b.setBorder(nonRolloverBorder);
            }
            b.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component c) {
        JButton b;
        if (c instanceof JButton && (b = (JButton)c).getUI() instanceof FrogButtonUI) {
            if (b.getBorder() == rolloverBorder || b.getBorder() == nonRolloverBorder) {
                b.setBorder((Border)this.borderTable.remove(b));
            }
            b.setRolloverEnabled(false);
        }
    }

    protected class FrogContainerListener
    implements ContainerListener {
        protected FrogContainerListener() {
        }

        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (FrogToolBarUI.this.rolloverBorders) {
                FrogToolBarUI.this.setBorderToRollover(c);
            } else {
                FrogToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            FrogToolBarUI.this.setBorderToNormal(c);
        }
    }

    protected class FrogRolloverListener
    implements PropertyChangeListener {
        protected FrogRolloverListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(IS_ROLLOVER)) {
                if (e.getNewValue() != null) {
                    FrogToolBarUI.this.setRolloverBorders((Boolean)e.getNewValue());
                } else {
                    FrogToolBarUI.this.setRolloverBorders(false);
                }
            }
        }
    }

    protected class FrogDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps = false;

        public FrogDockingListener(JToolBar t) {
            super(FrogToolBarUI.this, t);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            FrogToolBarUI.this.setDragOffset(e.getPoint());
            this.pressedInBumps = false;
            Rectangle bumpRect = new Rectangle();
            if (this.toolBar.getSize().height <= this.toolBar.getSize().width) {
                bumpRect.setBounds(0, 0, 14, this.toolBar.getSize().height);
            } else {
                bumpRect.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (bumpRect.contains(e.getPoint())) {
                this.pressedInBumps = true;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressedInBumps) {
                super.mouseDragged(e);
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        Integer toolbartype = null;

        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("toolbarType") && e.getSource() instanceof JToolBar) {
                this.toolbartype = (Integer)e.getNewValue();
                FrogToolBarUI.this.mToolbarType = this.toolbartype;
                FrogToolBarUI.this.setToolbarDefaults();
            }
        }
    }
}

