/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class FrogTextFieldUI
extends MetalTextFieldUI
implements FocusListener {
    ColorUIResource enabledBackgroundColor = null;
    protected JComponent mTextfield = null;
    private PropertyChangeListener mStyleListener = new StyleListener();
    private static final String STYLE1 = "JTextComponent.style";
    private static final String STYLE2 = "label";
    private static final String LABEL_STYLE_STRING = "Label";
    private static final Boolean LABEL_STYLE_BOOLEAN = Boolean.TRUE;

    public static ComponentUI createUI(JComponent c) {
        return new FrogTextFieldUI();
    }

    public void installUI(JComponent c) {
        this.mTextfield = c;
        super.installUI(c);
        if (c.getClientProperty(STYLE2) != null && c instanceof JTextField) {
            c.setOpaque(false);
            ((JTextField)c).setEditable(false);
            c.setBorder(UIManager.getBorder("TextComponent.LabelBorder"));
        } else {
            this.enabledBackgroundColor = (ColorUIResource)UIManager.get("TextField.background");
            c.setBorder(UIManager.getBorder("TextField.border"));
        }
        c.addFocusListener(this);
        c.addPropertyChangeListener(this.mStyleListener);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        this.mTextfield.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.mTextfield.repaint();
    }

    protected void paintBackground(Graphics g) {
        if (this.getComponent().getBackground() instanceof ColorUIResource) {
            if (!(this.getComponent().hasFocus() || this.getComponent().isEnabled() && this.getComponent().isEditable())) {
                g.setColor(SystemHueShift.getColor((JComponent)this.getComponent(), "TextField.inactiveBackground"));
            } else if (!(!this.getComponent().hasFocus() || this.getComponent().isEnabled() && this.getComponent().isEditable())) {
                g.setColor(SystemHueShift.getColor((JComponent)this.getComponent(), "TextField.inactiveFocusBackground"));
            } else if (this.getComponent().hasFocus() && this.getComponent().isEditable()) {
                g.setColor((ColorUIResource)UIManager.get("focusEnabledText"));
            } else {
                g.setColor(SystemHueShift.getColor((JComponent)this.getComponent(), "TextField.background"));
            }
            Dimension d = this.getComponent().getSize();
            g.fillRect(0, 0, d.width, d.height);
        } else {
            super.paintBackground(g);
        }
    }

    private void setStyle(Object styleName) {
        if ((styleName.equals(LABEL_STYLE_STRING) || styleName.equals(LABEL_STYLE_BOOLEAN)) && this.mTextfield instanceof JTextField) {
            this.mTextfield.setOpaque(false);
            ((JTextField)this.mTextfield).setEditable(false);
            this.mTextfield.setBorder(UIManager.getBorder("TextComponent.LabelBorder"));
        }
    }

    class StyleListener
    implements PropertyChangeListener {
        StyleListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(FrogTextFieldUI.STYLE1) || name.equals(FrogTextFieldUI.STYLE2)) {
                FrogTextFieldUI.this.setStyle(e.getNewValue());
            }
        }
    }
}

