/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.FrogTabStripComboBoxUI;
import com.sap.plaf.frog.TabbedPaneSelectionModel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import com.sap.plaf.frog.util.UITextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class FrogTabbedPaneUI
extends MetalTabbedPaneUI
implements LayoutManager,
ChangeListener,
Serializable,
SwingConstants {
    public static final String __PerforceId = "$Id$";
    private static boolean mMacVendor = false;
    protected JButton mRghtScrlButton;
    protected JButton mLeftScrlButton;
    protected JComboBox mTabListButton;
    protected static int mTabOffset = 0;
    protected static final String PRIMARY = "Primary";
    protected static final String SECONDARY = "Secondary";
    int completeWidth;
    int limitedWidth;
    int calculatedWidth = 0;
    int mMaxTabWidth = 99999;
    protected static int m_spacingHeight = 2;
    protected static int m_iconSpacingWidth = 4;
    protected static Insets m_contentBorderInsets = new Insets(1, 1, 1, 1);
    protected int m_visibleTabsStart = 0;
    protected int m_visibleTabsEnd = -1;
    protected boolean mNextTabPressed = false;
    protected boolean mPrevTabPressed = false;
    protected boolean mOnlyTabEndDecreased = false;
    int mOldVisibleTabsStart = 0;
    protected JTabbedPane mTabbedPane;
    protected boolean mTabSelected = false;
    protected boolean mTabSelectedDuringInit = false;
    protected Color m_tabAreaBackground;
    protected static Color m_primaryTabBackground;
    protected static Color m_secondaryTabBackground;
    protected int m_maxTabHeight;
    protected int m_upperOffsetX = 9;
    protected static int m_lowerOffsetX;
    protected static int m_borderOverlay;
    protected boolean mSelectTabTrigger = false;
    protected static int m_tabLeftOffset;
    protected static int m_tabRightOffset;
    protected static int m_buttonWidth;
    protected static int m_buttonGap;
    protected int[] m_tabWidth = null;
    protected int[] m_tabPosX = null;
    protected int m_tabPosY = 0;
    protected int m_buttonPosY = 0;
    protected int[] m_buttonPosX = null;
    protected boolean m_tabListButtonPressed = false;
    protected boolean m_rightButtonPressed = false;
    protected boolean m_leftButtonPressed = false;
    protected static Color m_primaryStripBackground;
    protected static Color m_primaryStripTextBackground;
    protected static FrogImageData[] mImageDataResources;
    private static final String TABSELECTION = "visibleTabStrip";
    protected int mScrollDirection = 0;
    public static int SCROLL_LEFT;
    public static int SCROLL_RIGHT;
    public static int NoScrollDirection;
    protected MouseListener m_mouseGetter;
    protected FocusListener m_focusGetter;
    protected ChangeListener m_tabChangeListener;
    protected ContainerHandler mContainerListener;
    protected PropertyChangeHandler mPropertyChangeListener;
    protected ActionListener m_actionListener;
    protected static boolean m_default_initialized;
    private static Image mA_Bord_UB;
    private static Image mA_Bord_RB;
    private static Image mA_Bord_BB;
    private static Image mA_Bord_LB;
    private static Image mA_Bord_FL;
    private static Image mA_SecTabBeh_LB;
    private static Image mA_SecTabBeh_UB;
    private static Image mA_SecTabBeh_RB;
    private static Image mA_SecTabBeh_BB;
    private static Image mA_SecTabFst_LB;
    private static Image mA_SecTabFst_UB;
    private static Image mA_SecTabFst_RB;
    private static Image mA_PrimTab_LB;
    private static Image mA_PrimTab_UB;
    private static Image mA_PrimTab_RB;
    private static Image mA_StackTab_RBC;
    private static Image mA_StackTab_RB;
    private static Image mA_LeadStackTab_LB;
    private static final int HEIGHTKLUDGE;
    private ContainerListener containerListener;

    static {
        m_tabLeftOffset = 3;
        m_tabRightOffset = 35;
        m_buttonWidth = 18;
        m_buttonGap = 2;
        SCROLL_LEFT = 1;
        SCROLL_RIGHT = 2;
        NoScrollDirection = 0;
        m_default_initialized = false;
        mA_Bord_UB = null;
        mA_Bord_RB = null;
        mA_Bord_BB = null;
        mA_Bord_LB = null;
        mA_Bord_FL = null;
        mA_SecTabBeh_LB = null;
        mA_SecTabBeh_UB = null;
        mA_SecTabBeh_RB = null;
        mA_SecTabBeh_BB = null;
        mA_SecTabFst_LB = null;
        mA_SecTabFst_UB = null;
        mA_SecTabFst_RB = null;
        mA_PrimTab_LB = null;
        mA_PrimTab_UB = null;
        mA_PrimTab_RB = null;
        mA_StackTab_RBC = null;
        mA_StackTab_RB = null;
        mA_LeadStackTab_LB = null;
        HEIGHTKLUDGE = FrogLookAndFeel.isVMVersion1dot2() ? 2 : 0;
    }

    public FrogTabbedPaneUI() {
        if (!m_default_initialized) {
            FrogTabbedPaneUI.initializeImageData();
            m_default_initialized = true;
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new FrogTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        this.mTabbedPane = (JTabbedPane)c;
        c.setLayout(this);
        this.mTabbedPane.setOpaque(false);
        this.mLeftScrlButton = new JButton(){

            public void paint(Graphics g) {
                g.fillRect(0, 0, 50, 100);
            }
        };
        this.mRghtScrlButton = new JButton();
        this.mTabListButton = new JComboBox();
        this.mLeftScrlButton.setVisible(true);
        this.mRghtScrlButton.setVisible(true);
        this.mLeftScrlButton.setBorder(null);
        this.mLeftScrlButton.setOpaque(false);
        this.mRghtScrlButton.setBorder(null);
        this.mRghtScrlButton.setOpaque(false);
        this.installDefaults(c);
        this.installListeners(c);
        super.installKeyboardActions();
        this.tabPane.setModel(new TabbedPaneSelectionModel());
        this.configureTabListButton();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallKeyboardActions();
        this.uninstallListeners(c);
        this.uninstallDefaults(c);
        c.remove(this.mLeftScrlButton);
        c.remove(this.mRghtScrlButton);
        c.remove(this.mTabListButton);
        c.setLayout(null);
    }

    protected void installDefaults(JComponent c) {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(c, "TabbedPane.tabBackground", "TabbedPane.tabForeground", "TabbedPane.font");
        this.m_tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        m_secondaryTabBackground = UIManager.getColor("TabbedPane.secondaryTabBackground");
        if (UIManager.get("maxTabWidth") != null) {
            this.mMaxTabWidth = (Integer)UIManager.get("maxTabWidth");
        }
    }

    public static void reloadHueShiftDefaults() {
        m_secondaryTabBackground = UIManager.getColor("TabbedPane.secondaryTabBackground");
        m_primaryStripBackground = UIManager.getColor("TabbedPane.primaryStripBackground");
        m_primaryStripTextBackground = UIManager.getColor("TabbedPane.primaryStripTextBackground");
    }

    protected void uninstallDefaults(JComponent c) {
    }

    protected void configureTabListButton() {
        if (this.mTabListButton != null) {
            this.mTabListButton.setVisible(true);
            this.mTabListButton.putClientProperty("ComboBox.calculateMaxStringLength", Boolean.TRUE);
            this.mTabListButton.setUI(new FrogTabStripComboBoxUI());
            this.mTabListButton.setOpaque(false);
            this.mTabListButton.setBorder(null);
            this.mTabListButton.setModel(new TabComboBoxModel());
            ((TabComboBoxModel)this.mTabListButton.getModel()).setDataModel(this.mTabbedPane);
            ((FrogTabStripComboBoxUI)this.mTabListButton.getUI()).addActionListener((TabComboBoxModel)this.mTabListButton.getModel());
            if (this.mTabbedPane.getClientProperty("TabbedPane.maxRowsForTabList") != null) {
                this.mTabListButton.setMaximumRowCount((Integer)this.mTabbedPane.getClientProperty("TabbedPane.maxRowsForTabList"));
            } else {
                this.mTabListButton.setMaximumRowCount(UIManager.getInt("TabbedPane.maxRowsForTabList"));
            }
        }
    }

    protected void installListeners(JComponent c) {
        this.m_mouseGetter = this.createMouseListener(c);
        if (this.m_mouseGetter != null) {
            c.addMouseListener(this.m_mouseGetter);
        }
        if ((this.m_focusGetter = this.createFocusListener(c)) != null) {
            c.addFocusListener(this.m_focusGetter);
        }
        if ((this.m_tabChangeListener = this.createChangeListener(c)) != null) {
            ((JTabbedPane)c).addChangeListener(this.m_tabChangeListener);
        }
        if ((this.mContainerListener = this.createContainerListener(c)) != null) {
            this.tabPane.addContainerListener(this.mContainerListener);
        }
        if ((this.m_actionListener = this.createActionListener()) != null) {
            this.mRghtScrlButton.addActionListener(this.m_actionListener);
            this.mLeftScrlButton.addActionListener(this.m_actionListener);
            this.mTabListButton.addActionListener(this.m_actionListener);
        }
    }

    protected void uninstallListeners(JComponent c) {
        if (this.m_mouseGetter != null) {
            c.removeMouseListener(this.m_mouseGetter);
            this.m_mouseGetter = null;
        }
        if (this.m_focusGetter != null) {
            c.removeFocusListener(this.m_focusGetter);
            this.m_focusGetter = null;
        }
        if (this.m_tabChangeListener != null) {
            ((JTabbedPane)c).removeChangeListener(this.m_tabChangeListener);
        }
        if (this.mContainerListener != null) {
            this.tabPane.removeContainerListener(this.mContainerListener);
        }
    }

    protected MouseListener createMouseListener(JComponent c) {
        return new MouseGetter();
    }

    protected FocusListener createFocusListener(JComponent c) {
        return new FocusGetter();
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return this;
    }

    protected ActionListener createActionListener() {
        return new ActionGetter();
    }

    protected ContainerHandler createContainerListener(JComponent c) {
        return new ContainerHandler();
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.controlButtonEnabling();
        this.m_tabAreaBackground = Color.yellow;
        m_primaryTabBackground = SystemHueShift.getColor(c, "TabbedPane.primaryTabBackground");
        m_secondaryTabBackground = SystemHueShift.getColor(c, "TabbedPane.secondaryTabBackground");
        JTabbedPane pane = (JTabbedPane)c;
        int selectedIndex = pane.getSelectedIndex();
        int tabPlacement = pane.getTabPlacement();
        int tabCount = pane.getTabCount() - mTabOffset;
        this.calculateLayoutInfo(pane);
        this.paintContentBorder(g, pane);
        if (tabCount > 0) {
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            if (this.mTabbedPane.getClientProperty("tabAreaVisible") != null && !((Boolean)this.mTabbedPane.getClientProperty("tabAreaVisible")).booleanValue()) {
                Rectangle clipRect = new Rectangle(0, 0);
            } else {
                Rectangle clipRect = g.getClipBounds();
                if (this.m_visibleTabsStart == selectedIndex) {
                    this.paintPrimaryTab(tabPlacement, g, pane, this.m_visibleTabsStart, iconRect, textRect);
                } else {
                    this.paintFirstSecondaryTab(tabPlacement, g, pane, this.m_visibleTabsStart, iconRect, textRect);
                }
                int j = this.m_visibleTabsStart + 1;
                while (j <= this.m_visibleTabsEnd) {
                    if (j == selectedIndex) {
                        this.paintPrimaryTab(tabPlacement, g, pane, j, iconRect, textRect);
                    } else {
                        this.paintSecondaryTab(g, pane, j, iconRect, textRect);
                    }
                    ++j;
                }
                if (this.hasLeftStack(pane)) {
                    this.paintLeftStack(g, pane, this.m_visibleTabsStart);
                }
                if (this.hasRightStack(pane)) {
                    this.paintRightStack(g, pane, this.m_visibleTabsEnd);
                }
                if (this.hasRightStack(pane) || this.hasLeftStack(pane)) {
                    this.paintTabListButton(g, pane, this.m_buttonPosX[0], this.m_buttonPosY);
                    this.paintRightButton(g, pane, this.m_buttonPosX[1], this.m_buttonPosY);
                    this.paintLeftButton(g, pane, this.m_buttonPosX[2], this.m_buttonPosY);
                }
            }
        }
    }

    protected void paintPrimaryTab(int tabPlacement, Graphics g, JTabbedPane pane, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = this.getTabBounds(pane, tabIndex);
        tabRect.height += ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight() - 1;
        int steps = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getHeight() - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight() + 1;
        int overlay = steps + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth();
        int offset = this.m_upperOffsetX;
        int selectedIndex = pane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        g.translate(tabRect.x - overlay + offset, tabRect.y);
        switch (tabPlacement) {
            case 3: {
                g.setColor(SystemHueShift.getColor((JComponent)pane, "TabbedPane.primaryStripBackground"));
                int a = ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth();
                int h1 = ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight();
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth() - 1;
                int h2 = h1 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getWidth();
                g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth() - 1, 0, steps + a, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC")), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getTop(), null);
                int i = steps;
                while (i > 0) {
                    g.fillRect(x2, h2 - 1, steps + a - (steps - i) - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getWidth(), 1);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB")), x1, h2, x2, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getHeight(), Color.green, null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB")), x1, h2, x2, h1, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getTop(), Color.green, null);
                    }
                    ++h1;
                    ++x1;
                    ++h2;
                    ++x2;
                    --i;
                }
                g.fillRect(x2, h2, a, 1);
                g.translate(-tabRect.x + overlay - offset, -tabRect.y);
                g.translate(tabRect.x, tabRect.y);
                int stackOffset4 = 2;
                int stackOffset7 = 0;
                int stackOffset8 = 0;
                int stackOffsetbottop9 = -4;
                g.fillRect(offset - 1 - stackOffset4 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight() - stackOffset7, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth() - offset - 1 + stackOffset4, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight() + stackOffset8);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC")), offset - 2, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getHeight(), offset - 3 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getTop(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth(), 0, tabRect.width, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getBottom(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth() + 2, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getHeight(), null);
                } else {
                    g.setColor(SystemHueShift.getColor((JComponent)pane, "TabbedPane.primaryStripBackground"));
                    g.fillRect(offset - 1 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth() + 1 - (offset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth()), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight());
                    if (SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Streamline") || SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Tradeshow")) {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), offset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth() + stackOffsetbottop9, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight() + 1, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getTop() + 1, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getBottom(), null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), offset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth() + stackOffsetbottop9, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getBottom(), null);
                    }
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getBottom(), null);
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getHeight() + 1, tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getTop() + 1, ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getBottom(), null);
                }
                g.translate(-tabRect.x, -tabRect.y);
                if (tabIndex < 0 && tabIndex >= pane.getTabCount()) break;
                String title = pane.getTitleAt(tabIndex);
                Font font = pane.getFont();
                FontMetrics metrics = g.getFontMetrics(font);
                int maxLetterWidth = metrics.charWidth('m') / 4;
                Icon icon = this.getIconForTab(pane, tabIndex);
                this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
                iconRect.x += maxLetterWidth;
                textRect.x += maxLetterWidth;
                break;
            }
            default: {
                g.setColor(SystemHueShift.getColor((JComponent)pane, "TabbedPane.primaryStripBackground"));
                int a = ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth();
                int h1 = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight() + 1;
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth() - 2;
                int h2 = h1 - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getWidth();
                g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth() - 1, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight(), steps + a, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC")), 0, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LBC").getBottom(), null);
                int i = 0;
                while (i < steps) {
                    g.fillRect(x2, h2, steps - i + a, 1);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB")), x1, h2, x2, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getHeight(), Color.green, null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB")), x1, h2, x2, h1, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LB").getBottom(), Color.green, null);
                    }
                    --h1;
                    ++x1;
                    --h2;
                    ++x2;
                    ++i;
                }
                g.fillRect(x2, h2, a, 1);
                g.translate(-tabRect.x + overlay - offset, -tabRect.y);
                g.translate(tabRect.x, tabRect.y);
                int stackOffset = 0;
                g.fillRect(offset - 1 - stackOffset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth() - offset - 1 + stackOffset, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC")), offset - 2, 0, offset - 2 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth(), 0, tabRect.width, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getBottom(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth() + 2, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getHeight(), null);
                } else {
                    int stackoffset2 = 0;
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB")), offset - 2 + ThemeData.getImageData(pane, "TabStripCtl.PrimTab.LUC").getWidth() - stackoffset2, 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getWidth() + 2, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.UB").getBottom(), null);
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.PrimTab.RB").getBottom(), null);
                }
                g.translate(-tabRect.x, -tabRect.y);
            }
        }
        if (tabIndex >= 0 || tabIndex < pane.getTabCount()) {
            String title = pane.getTitleAt(tabIndex);
            Font font = pane.getFont();
            FontMetrics metrics = g.getFontMetrics(font);
            int maxLetterWidth = metrics.charWidth('m') / 4;
            Icon icon = this.getIconForTab(pane, tabIndex);
            this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            iconRect.x += maxLetterWidth;
            textRect.x += maxLetterWidth;
            this.paintText(g, pane, font, metrics, tabIndex, title, textRect, PRIMARY);
            this.paintIcon(g, pane, icon, iconRect);
            this.paintFocusIndicator(g, pane, tabIndex, textRect);
        }
    }

    protected void paintFirstSecondaryTab(int tabPlacement, Graphics g, JTabbedPane pane, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = this.getTabBounds(pane, tabIndex);
        int steps = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getHeight() - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight();
        int overlay = steps + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth();
        int offset = this.m_upperOffsetX;
        int selectedIndex = pane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        g.translate(tabRect.x - overlay + offset, tabRect.y);
        g.setColor(m_secondaryTabBackground);
        int a = ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth();
        switch (tabPlacement) {
            case 3: {
                int h1 = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight();
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + this.m_upperOffsetX + pane.getInsets().left;
                int h2 = h1 - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getWidth();
                int x = steps + 2 * ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getWidth() - 1;
                g.fillRect(x - 1, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight(), tabRect.width + overlay - offset - x, 1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC")), -1, 1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() - 1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight() + 1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getTop(), null);
                int i = 0;
                while (i < steps + 3) {
                    g.fillRect(x2 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + 2, h2 + 1, i + a + 2, 2);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB")), x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() - 1, h2, x2 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() - 1, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getHeight(), null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB")), x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + 3, h2 + 3, x2 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + 3, h1 + 3, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getTop(), null);
                    }
                    --h1;
                    --x1;
                    --h2;
                    --x2;
                    ++i;
                }
                g.fillRect(-1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth(), 1, steps + a, 2);
                g.translate(-tabRect.x + overlay - offset, -tabRect.y);
                g.translate(tabRect.x, tabRect.y);
                int stackOffset5 = 0;
                int stackOffsety10 = 0;
                int stackOffsetx11 = 0;
                g.fillRect(offset - stackOffset5, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight() - 1, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - a, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight() + stackOffsety10);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB")), offset + ThemeData.getImageData(pane, "SecTabFst_LUCFst_LB").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight(), tabRect.width, tabRect.height, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getHeight(), null);
                } else {
                    if (SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Streamline") || SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Tradeshow")) {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB")), offset - stackOffsetx11 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - 3, tabRect.height + 2 - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth() + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), tabRect.height + 1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getBottom() - 1, Color.green, null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), offset - stackOffsetx11 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - 4, tabRect.height + 2 - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth() + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), tabRect.height + 1, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getTop() + 1, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getBottom(), null);
                    }
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight() - 1, tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight() + 2, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getBottom(), null);
                }
                g.translate(-tabRect.x, -tabRect.y);
                break;
            }
            default: {
                g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() - 1, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight(), steps + a + 1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC")), -1, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth() + 1 - 2, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getBottom(), null);
                int h1 = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getHeight();
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LBC").getWidth();
                int h2 = h1 - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getWidth();
                int i = 0;
                while (i < steps + 1) {
                    g.fillRect(x2 - 2, h2, steps - i + a, 1);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB")), x1, h2, x2, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getHeight(), null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB")), x1 - 2, h2, x2 - 2, h1, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LB").getBottom(), null);
                    }
                    --h1;
                    ++x1;
                    --h2;
                    ++x2;
                    ++i;
                }
                g.fillRect(x2, h2, a, 1);
                g.translate(-tabRect.x + overlay - offset, -tabRect.y);
                g.translate(tabRect.x, tabRect.y);
                int stackOffset = 0;
                g.fillRect(offset - stackOffset + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight() - 1, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - offset + stackOffset, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight() + 1);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC")), offset - 2, 0, offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - 2, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth(), 0, tabRect.width, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getBottom(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight(), tabRect.width, tabRect.height, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getHeight(), null);
                } else {
                    int stackoffset3 = 0;
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.LUC").getWidth() - 2 - stackoffset3, 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getBottom(), null);
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RUC").getHeight(), tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.RB").getBottom(), null);
                }
                g.translate(-tabRect.x, -tabRect.y);
            }
        }
        if (tabIndex >= 0 || tabIndex < pane.getTabCount()) {
            String title = pane.getTitleAt(tabIndex);
            Font font = pane.getFont();
            FontMetrics metrics = g.getFontMetrics(font);
            int maxLetterWidth = metrics.charWidth('m') / 4;
            Icon icon = this.getIconForTab(pane, tabIndex);
            this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            iconRect.x += maxLetterWidth;
            textRect.x += maxLetterWidth;
            this.paintText(g, pane, font, metrics, tabIndex, title, textRect, SECONDARY);
            this.paintIcon(g, pane, icon, iconRect);
        }
    }

    protected void paintSecondaryTab(Graphics g, JTabbedPane pane, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        int tabPlacement = pane.getTabPlacement();
        Rectangle tabRect = this.getTabBounds(pane, tabIndex);
        int steps = this.m_upperOffsetX - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() + 1;
        int offset = this.m_upperOffsetX;
        int selectedIndex = pane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        int a = 0;
        g.setColor(m_secondaryTabBackground);
        switch (tabPlacement) {
            case 3: {
                ++tabRect.y;
                g.translate(tabRect.x, tabRect.y);
                a = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth();
                g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getWidth(), steps + a, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getWidth() + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC")), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getTop(), null);
                int h1 = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight();
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth() - 1;
                int h2 = h1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getWidth();
                int i = 0;
                while (i < steps) {
                    g.fillRect(x2, h2, steps - i + a, 1);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB")), x1, h2, x2, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getHeight(), null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB")), x1, h2, x2, h1, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getTop(), null);
                    }
                    ++h1;
                    ++x1;
                    ++h2;
                    ++x2;
                    ++i;
                }
                g.fillRect(x2, h2, a, 1);
                g.fillRect(offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() - offset, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight() - 1);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC")), offset - 1, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getHeight(), offset - 1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() - 2, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getRight() - 2, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getTop(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getTop(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), 0, tabRect.width, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getTop(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB")), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), tabRect.height, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), null);
                    break;
                }
                if (SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Streamline") || SystemHueShift.getDisplayedTheme(pane).getRootThemeName().equals("Tradeshow")) {
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB")), offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() - 3, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight() + 1, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth() + 2, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabFst.UB").getBottom() - 1, null);
                } else {
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() - 2, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight() + 1, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth() + 2, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getBottom(), null);
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB")), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getTop(), null);
                break;
            }
            default: {
                g.translate(tabRect.x, tabRect.y);
                a = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth();
                ++tabRect.x;
                g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight(), steps + a, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC")), 0, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getBottom(), null);
                --tabRect.x;
                int h1 = tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight();
                int x1 = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth() - 1;
                int h2 = h1 - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getHeight();
                int x2 = x1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getWidth();
                int i = 0;
                while (i < steps) {
                    g.fillRect(x2, h2, steps - i + a, 1);
                    if (mMacVendor) {
                        g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB")), x1, h2, x2, h1, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getHeight(), null);
                    } else {
                        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB")), x1, h2, x2, h1, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LB").getBottom(), null);
                    }
                    --h1;
                    ++x1;
                    --h2;
                    ++x2;
                    ++i;
                }
                g.fillRect(x2, h2, a, 1);
                g.fillRect(offset + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth() - offset, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight());
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC")), offset - 1, 0, offset - 1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth(), 0, tabRect.width, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), tabRect.width, tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getBottom(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB")), offset - 1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getHeight(), null);
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB")), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), tabRect.height, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), null);
                    break;
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB")), offset - 1 + ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getWidth(), 0, tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.UB").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB")), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RUC").getHeight(), tabRect.width, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RB").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB")), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getHeight(), tabRect.width - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.RBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.BB").getBottom(), null);
            }
        }
        g.translate(-tabRect.x, -tabRect.y);
        if (tabIndex >= 0 || tabIndex < pane.getTabCount()) {
            String title = pane.getTitleAt(tabIndex);
            Font font = pane.getFont();
            FontMetrics metrics = g.getFontMetrics(font);
            int maxLetterWidth = metrics.charWidth('m') / 4;
            Icon icon = this.getIconForTab(pane, tabIndex);
            this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            iconRect.x += maxLetterWidth;
            textRect.x += maxLetterWidth;
            this.paintText(g, pane, font, metrics, tabIndex, title, textRect, SECONDARY);
            this.paintIcon(g, pane, icon, iconRect);
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.x = 0;
        textRect.x = 0;
        iconRect.y = 0;
        textRect.y = 0;
        UITextUtilities.layoutCompoundLabel(null, metrics, title, icon, 0, 0, 0, 4, tabRect, iconRect, textRect, m_iconSpacingWidth);
        int xNudge = 0;
        int yNudge = 0;
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintIcon(Graphics g, JTabbedPane pane, Icon icon, Rectangle iconRect) {
        if (icon != null) {
            icon.paintIcon(pane, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, JTabbedPane pane, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, String prop) {
        g.setFont(font);
        if (pane.isEnabledAt(tabIndex)) {
            if (tabIndex == pane.getSelectedIndex() && pane.getForegroundAt(tabIndex) instanceof UIResource) {
                g.setColor(SystemHueShift.getColor((JComponent)pane, "TabbedPane.primaryTabforeground"));
            } else {
                g.setColor(pane.getForegroundAt(tabIndex));
            }
            UITextUtilities.paintText(g, title, 0, textRect.x, textRect.y + metrics.getAscent());
        } else {
            if (PRIMARY.equals(prop)) {
                g.setColor(UIManager.getColor("TabbedPane.disabledForegroundPrim"));
            } else {
                g.setColor(UIManager.getColor("TabbedPane.disabledForegroundSec"));
            }
            UITextUtilities.paintText(g, title, 0, textRect.x, textRect.y + metrics.getAscent());
        }
    }

    protected void paintRightStack(Graphics g, JTabbedPane pane, int end) {
        Rectangle tabRect = this.getTabBounds(pane, end);
        tabRect.height -= 3;
        int tabPlacement = pane.getTabPlacement();
        switch (tabPlacement) {
            case 3: {
                ++tabRect.y;
                g.translate(tabRect.x + tabRect.width, tabRect.y);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC")), 0, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() - 8, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getHeight() + (tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() - 8), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getTop(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB")), 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() + 2, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getHeight(), null);
                    break;
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB")), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() - 8, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getTop(), null);
                break;
            }
            default: {
                tabRect.y += 3;
                g.translate(tabRect.x + tabRect.width, tabRect.y);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC")), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC")), 0, tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() + 2, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getWidth(), tabRect.height, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getBottom(), null);
                if (mMacVendor) {
                    g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB")), 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() + 2, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getHeight(), null);
                    break;
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB")), 0, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getWidth(), tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.StackTab.RBC").getHeight() + 2, ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.StackTab.RB").getBottom(), null);
            }
        }
        g.translate(-tabRect.x - tabRect.width, -tabRect.y);
    }

    protected void paintLeftStack(Graphics g, JTabbedPane pane, int start) {
        Rectangle tabRect = this.getTabBounds(pane, start);
        int xStackOffset = tabRect.x + this.m_upperOffsetX - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getWidth() - 3;
        int yStackOffset = 4;
        int tabPlacement = pane.getTabPlacement();
        switch (tabPlacement) {
            case 1: {
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC")), xStackOffset, yStackOffset, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getWidth() + xStackOffset, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getHeight() + yStackOffset, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getBottom(), null);
                int xLBstack = xStackOffset - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getHeight() + 1;
                int startHeight = yStackOffset + ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getHeight();
                int i = startHeight + 1;
                while (i < tabRect.height + 1) {
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB")), --xLBstack, i, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getWidth() + xLBstack, i - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getBottom(), null);
                    ++i;
                }
                break;
            }
            case 3: {
                int startHeight;
                int yBottomOffset = tabRect.y + 1;
                int yPaintOffset = -yStackOffset + yBottomOffset + tabRect.height;
                g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC")), xStackOffset - 1, yPaintOffset - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getWidth() + xStackOffset - 1, yPaintOffset, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getTop(), null);
                int xLBstack = xStackOffset - 1;
                int i = startHeight = yBottomOffset + tabRect.height - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LUC").getHeight() - yStackOffset;
                while (i > yBottomOffset) {
                    g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB")), --xLBstack, i, ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getWidth() + xLBstack, i - ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getBottom(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.LeadStackTab.LB").getTop(), null);
                    --i;
                }
                break;
            }
        }
    }

    protected void paintRightButton(Graphics g, JTabbedPane pane, int x, int y) {
        g.translate(x, y);
        boolean isEnabled = pane.isEnabled() && this.hasRightStack(pane);
        boolean isPressed = this.mRghtScrlButton.getModel().isPressed();
        if (isEnabled && isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl.PS"), pane);
        } else if (isEnabled) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl"), pane);
        } else if (isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl.PS"), pane);
        } else {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl.DS"), pane);
        }
        g.translate(-x, -y);
    }

    protected void paintLeftButton(Graphics g, JTabbedPane pane, int x, int y) {
        g.translate(x, y);
        boolean isEnabled = pane.isEnabled() && this.hasLeftStack(pane);
        boolean isPressed = this.mLeftScrlButton.getModel().isPressed();
        if (isEnabled && isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.LeftScrl.PS"), pane);
        } else if (isEnabled) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.LeftScrl"), pane);
        } else if (isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.LeftScrl.PS"), pane);
        } else {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.LeftScrl.DS"), pane);
        }
        g.translate(-x, -y);
    }

    protected void paintTabListButton(Graphics g, JTabbedPane pane, int x, int y) {
        g.translate(x, y);
        boolean isEnabled = pane.isEnabled();
        boolean isPressed = false;
        if (isEnabled && isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl.PS"), pane);
        } else if (isEnabled) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.TabList"), pane);
        } else if (isPressed) {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.RightScrl.PS"), pane);
        } else {
            this.paintFroggyStyle(g, ThemeData.getImageData(pane, "TabStripCtl.TabList"), pane);
        }
        g.translate(-x, -y);
    }

    private void paintFroggyStyle(Graphics g, FrogImageData image, JComponent c) {
        int width = m_buttonWidth;
        int height = m_buttonWidth;
        g.drawImage(FrogLookAndFeel.getImageFromData(c, image), 0, 0, width, height, image.getLeft(), image.getTop(), image.getRight(), image.getBottom(), null);
    }

    protected void paintFocusIndicator(Graphics g, JTabbedPane pane, int tabIndex, Rectangle textRect) {
        if (pane.hasFocus()) {
            FrogBorders.FocusBorder.drawFocusRect(g, textRect.x - 2, textRect.y, textRect.width + 5, textRect.height);
        }
    }

    protected void paintContentBorder(Graphics g, JTabbedPane pane) {
        Rectangle bounds = pane.getBounds();
        Insets insets = pane.getInsets();
        int tabPlacement = pane.getTabPlacement();
        int h = bounds.height - (insets.top + insets.bottom) - this.m_maxTabHeight;
        int w = bounds.width - (insets.left + insets.right);
        int x = insets.left;
        int y = 0;
        switch (tabPlacement) {
            default: {
                y = insets.top + this.m_maxTabHeight;
                break;
            }
            case 3: {
                y = insets.top;
            }
        }
        g.translate(x, y);
        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC")), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getBottom(), null);
        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC")), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getWidth(), 0, w, ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getBottom(), null);
        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC")), 0, h - ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getWidth(), h, ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getBottom(), null);
        g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC")), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), h - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getHeight(), w, h, ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getBottom(), null);
        if (mMacVendor) {
            g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.UB")), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getWidth(), 0, w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getWidth() + 2, ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getWidth(), h - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight(), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), h, 0, 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.LB")), 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), h - ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.RB")), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getHeight(), w, h - ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getHeight(), 0, 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getHeight(), null);
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.UB")), ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getWidth(), 0, w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB")), ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getWidth(), h - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight(), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RBC").getWidth(), h, ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.LB")), 0, ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), h - ThemeData.getImageData(pane, "TabStripCtl.Bord.LBC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(pane, ThemeData.getImageData(pane, "TabStripCtl.Bord.RB")), w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RUC").getHeight(), w, h - ThemeData.getImageData(pane, "TabStripCtl.Bord.LUC").getHeight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getLeft(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getTop(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getRight(), ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getBottom(), null);
        }
        g.setColor(SystemHueShift.getColor((JComponent)pane, "TabbedPane.primaryStripBackground"));
        Insets contentInsets = this.getContentBorderInsets(pane);
        int height = 0;
        int width = 0;
        height = contentInsets.top - ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight();
        width = w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth() - ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth();
        if (height > 0) {
            g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), width, height);
        }
        height = contentInsets.bottom - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight();
        width = w - ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth() - ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth();
        if (height > 0) {
            g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), h - contentInsets.bottom, width, height);
        }
        height = h - ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight() - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight();
        width = contentInsets.left - ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth();
        if (width > 0) {
            g.fillRect(ThemeData.getImageData(pane, "TabStripCtl.Bord.LB").getWidth(), ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), width, height);
        }
        height = h - ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight() - ThemeData.getImageData(pane, "TabStripCtl.Bord.BB").getHeight();
        width = contentInsets.right - ThemeData.getImageData(pane, "TabStripCtl.Bord.RB").getWidth();
        if (width > 0) {
            g.fillRect(w - contentInsets.right, ThemeData.getImageData(pane, "TabStripCtl.Bord.UB").getHeight(), width, height);
        }
        g.translate(-x, -y);
    }

    public Dimension getPreferredSize(JComponent c) {
        JTabbedPane pane = (JTabbedPane)c;
        Dimension size = this.calculateSize(pane, false);
        int widthOfAllTabs = this.getPrefWidthOfAllTabs(pane);
        return new Dimension(Math.max(size.width, widthOfAllTabs), size.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        JTabbedPane pane = (JTabbedPane)c;
        return this.calculateSize(pane, true);
    }

    public int getPrefWidthOfAllTabs(JTabbedPane pane) {
        int retValue = 0;
        Font font = pane.getFont();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int tabCount = pane.getTabCount() - mTabOffset;
        int[] m_tabWidth = new int[tabCount];
        int maxTabWidth = -10;
        int tabWidth = -1;
        int i = 0;
        while (i < tabCount) {
            m_tabWidth[i] = this.tabWidth(pane, i, metrics);
            retValue += m_tabWidth[i];
            ++i;
        }
        return retValue;
    }

    protected Dimension calculateSize(JTabbedPane pane, boolean minimum) {
        Insets insets = pane.getInsets();
        Insets borderInsets = this.getContentBorderInsets(pane);
        Dimension zeroSize = new Dimension(0, 0);
        int height = borderInsets.top + borderInsets.bottom;
        int width = borderInsets.left + borderInsets.right;
        int cWidth = 0;
        int cHeight = 0;
        int i = 0;
        while (i < pane.getTabCount() - mTabOffset) {
            Component component = pane.getComponentAt(i);
            Dimension size = zeroSize;
            if (component instanceof JComponent) {
                if (component.getFont() == null) {
                    component.setFont(pane.getFont());
                }
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size != null) {
                    cHeight = Math.max(size.height, cHeight);
                    cWidth = Math.max(size.width, cWidth);
                }
            }
            ++i;
        }
        height += cHeight;
        int tabExtent = 0;
        tabExtent = this.preferredTotalTabHeight(pane, pane.getFont(), width += cWidth);
        return new Dimension(width + insets.left + insets.right, (height += tabExtent) + insets.bottom + insets.top);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(parent.getBounds().width, parent.getBounds().height);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container parent) {
        if (this.mTabbedPane.getClientProperty("Trace") != null) {
            System.err.println("FrogTabbedPaneUI.layoutContainer m_visibleTabsStart:" + this.m_visibleTabsStart + " m_visibleTabsEnd:" + this.m_visibleTabsEnd);
        }
        this.mTabbedPane = (JTabbedPane)parent;
        JTabbedPane pane = (JTabbedPane)parent;
        if (this.mTabbedPane.getClientProperty("Trace") != null) {
            System.err.println("FrogTabbedPaneUI.layoutContainer setVisibleTabsEnd(-1)");
        }
        this.setVisibleTabsEnd(-1);
        this.layoutTabbedPane(pane);
        if (this.hasLeftStack(pane) && !this.hasRightStack(pane)) {
            this.setVisibleTabsStart(-1);
            this.layoutTabbedPane(pane);
        }
        this.mTabSelected = false;
    }

    protected int getMinimumTabSize(JTabbedPane pane) {
        if (pane.getClientProperty("minimumTabWidth") != null) {
            return (Integer)pane.getClientProperty("minimumTabWidth");
        }
        if (UIManager.get("TabbedPane.minimumTabWidth") != null) {
            return (Integer)UIManager.get("TabbedPane.minimumTabWidth");
        }
        return -1;
    }

    protected void layoutTabbedPane(JTabbedPane pane) {
        this.mTabbedPane = pane;
        int totalTabHeight = 0;
        Insets insets = pane.getInsets();
        Insets borderInsets = this.getContentBorderInsets(pane);
        int selectedIndex = pane.getSelectedIndex();
        int tabPlacement = pane.getTabPlacement();
        if (selectedIndex >= 0) {
            Component selectedComponent = pane.getComponentAt(selectedIndex);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                int ch;
                int cy;
                if (selectedComponent.getParent() == null && this.getVisibleComponent() != null && SwingUtilities.findFocusOwner(this.getVisibleComponent()) != null) {
                    shouldChangeFocus = true;
                }
                this.calculateLayoutInfo(pane);
                Rectangle bounds = pane.getBounds();
                totalTabHeight = this.m_maxTabHeight;
                int cx = insets.left + borderInsets.left;
                switch (tabPlacement) {
                    case 3: {
                        cy = insets.top + borderInsets.top;
                        ch = bounds.height - totalTabHeight - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom;
                        break;
                    }
                    default: {
                        cy = insets.top + totalTabHeight + borderInsets.top;
                        ch = bounds.height - totalTabHeight - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom;
                    }
                }
                int cw = bounds.width - insets.left - insets.right - borderInsets.left - borderInsets.right;
                selectedComponent.setBounds(cx, cy, cw, ch);
                selectedComponent.validate();
                if (shouldChangeFocus) {
                    if (selectedComponent.isFocusTraversable()) {
                        selectedComponent.requestFocus();
                        shouldChangeFocus = false;
                    } else if (selectedComponent instanceof JComponent && ((JComponent)selectedComponent).requestDefaultFocus()) {
                        shouldChangeFocus = false;
                    }
                    if (shouldChangeFocus) {
                        pane.requestFocus();
                    }
                }
            }
        }
        if (this.AreTabsValid() && this.mTabSelectedDuringInit && pane.getSelectedIndex() != -1) {
            if (this.mTabbedPane.getClientProperty("Trace") != null) {
                System.err.println("FrogTabbedPaneUI.layoutTabbedPane: Tab was selected during init");
            }
            this.mTabSelectedDuringInit = false;
            this.selectTab(pane, pane.getSelectedIndex());
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        if (this.mTabbedPane.getClientProperty("Trace") != null) {
            System.err.println("FrogTabbedPaneUI.stateChanged:selectedIndex:" + pane.getSelectedIndex());
        }
        if (pane.getSelectedIndex() < 0) {
            if (this.getVisibleComponent() != null) {
                this.setVisibleComponent(null);
            }
        } else {
            Component selectedComponent = pane.getComponentAt(pane.getSelectedIndex());
            if (selectedComponent != null) {
                this.setVisibleComponent(selectedComponent);
            }
        }
        if (pane.getSelectedIndex() >= 0 && (pane.getSelectedIndex() != 0 || pane.getTabCount() - mTabOffset != 1)) {
            this.selectTab(pane, pane.getSelectedIndex());
        }
    }

    protected Component getVisibleComponent(JTabbedPane pane) {
        int count = pane.getTabCount() - mTabOffset;
        while (count-- > 0) {
            Component component = pane.getComponentAt(count);
            if (component == null || component.getParent() != pane) continue;
            return component;
        }
        return null;
    }

    protected void calculateLayoutInfo(JTabbedPane pane) {
        Font font = pane.getFont();
        int selectedIndex = pane.getSelectedIndex();
        int tabCount = pane.getTabCount() - mTabOffset;
        if (tabCount > 0) {
            this.determineTabWidths(pane, tabCount, false, font);
            this.determineTabHeight(pane, font);
            this.arrangeTabs(pane, tabCount, font);
            this.arrangeButtons(pane);
        } else {
            this.m_maxTabHeight = 0;
        }
    }

    protected void determineTabWidths(JTabbedPane pane, int tabCount, boolean useMinimumTabSize, Font font) {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.m_tabWidth = new int[tabCount];
        int maxTabWidth = -10;
        int tabWidth = -1;
        if (useMinimumTabSize && this.getMinimumTabSize(pane) > 0) {
            maxTabWidth = (pane.getSize().width - pane.getInsets().left - this.getLeftTabOffSet() - this.m_upperOffsetX) / tabCount;
            tabWidth = this.getMinimumTabSize(pane) > maxTabWidth ? this.getMinimumTabSize(pane) : maxTabWidth;
            int i = 0;
            while (i < tabCount) {
                this.m_tabWidth[i] = Math.min(tabWidth, this.tabWidth(pane, i, metrics));
                ++i;
            }
        } else {
            int i = 0;
            while (i < tabCount) {
                this.m_tabWidth[i] = this.tabWidth(pane, i, metrics);
                ++i;
            }
        }
    }

    protected void determineTabHeight(JTabbedPane pane, Font font) {
        this.m_maxTabHeight = this.mTabbedPane.getClientProperty("tabAreaVisible") != null && (Boolean)this.mTabbedPane.getClientProperty("tabAreaVisible") == false ? 0 : this.maxTabHeight(pane, font);
    }

    protected int getXPosOfFirstTab() {
        return this.mTabbedPane.getInsets().left + this.getLeftTabOffSet() + 1 + this.m_upperOffsetX;
    }

    protected void arrangeButtons(JTabbedPane pane) {
        int tabPlacement = pane.getTabPlacement();
        if (this.hasRightStack(pane) || this.hasLeftStack(pane)) {
            this.mLeftScrlButton.setVisible(true);
            this.mRghtScrlButton.setVisible(true);
            this.mTabListButton.setVisible(true);
            Rectangle bounds = pane.getBounds();
            Insets borderInsets = this.getContentBorderInsets(pane);
            Insets insets = pane.getInsets();
            int totalTabHeight = this.m_maxTabHeight;
            int cw = bounds.width - insets.left - insets.right;
            int ch = bounds.height - totalTabHeight - insets.top - insets.bottom;
            int chBottom = bounds.height - totalTabHeight + m_buttonGap;
            int cx = insets.left;
            int cy = insets.top + totalTabHeight;
            switch (tabPlacement) {
                default: {
                    this.m_buttonPosY = insets.top + this.m_maxTabHeight - m_buttonWidth - m_buttonGap;
                    break;
                }
                case 3: {
                    this.m_buttonPosY = chBottom;
                }
            }
            if (this.m_buttonPosX == null) {
                this.m_buttonPosX = new int[3];
            }
            this.m_buttonPosX[0] = cx + cw - m_buttonWidth;
            this.m_buttonPosX[1] = cx + cw - 2 * m_buttonWidth - m_buttonGap;
            this.m_buttonPosX[2] = cx + cw - 3 * m_buttonWidth - 2 * m_buttonGap;
            this.mLeftScrlButton.setBounds(this.mTabbedPane.bounds().x + this.m_buttonPosX[2], this.mTabbedPane.bounds().y + this.m_buttonPosY, m_buttonWidth, m_buttonWidth);
            this.mRghtScrlButton.setBounds(this.m_buttonPosX[1], this.m_buttonPosY, m_buttonWidth, m_buttonWidth);
            this.mTabListButton.setBounds(this.m_buttonPosX[0], this.m_buttonPosY, m_buttonWidth, m_buttonWidth);
        } else {
            this.mLeftScrlButton.setVisible(false);
            this.mRghtScrlButton.setVisible(false);
            this.mTabListButton.setVisible(false);
        }
    }

    protected void arrangeTabs(JTabbedPane pane, int tabCount, Font font) {
        block25: {
            int i;
            int x;
            int allTabsWidth;
            block24: {
                Dimension size = pane.getSize();
                Insets insets = pane.getInsets();
                int selectedIndex = pane.getSelectedIndex();
                int tabPlacement = pane.getTabPlacement();
                allTabsWidth = 0;
                int steps = this.m_maxTabHeight - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LUC").getHeight() - ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getHeight();
                this.m_upperOffsetX = ThemeData.getImageData(pane, "TabStripCtl.SecTabBeh.LBC").getWidth() + steps;
                this.m_tabPosX = new int[tabCount];
                x = this.getXPosOfFirstTab();
                this.completeWidth = size.width;
                this.limitedWidth = size.width - insets.right - 3 * (m_buttonWidth + m_buttonGap) - 14;
                if (this.mTabbedPane.getClientProperty("Trace") != null) {
                    System.err.println("completeWidth: " + this.completeWidth + " limitedWidth:" + this.limitedWidth);
                }
                allTabsWidth = x;
                i = 0;
                while (i < pane.getTabCount() - mTabOffset) {
                    allTabsWidth += this.m_tabWidth[i];
                    ++i;
                }
                if (allTabsWidth > this.completeWidth) {
                    this.determineTabWidths(pane, pane.getTabCount() - mTabOffset, true, pane.getFont());
                    allTabsWidth = x;
                    i = 0;
                    while (i < pane.getTabCount() - mTabOffset) {
                        allTabsWidth += this.m_tabWidth[i];
                        ++i;
                    }
                }
                switch (tabPlacement) {
                    case 3: {
                        this.m_tabPosY = pane.getBounds().height - this.m_maxTabHeight - 1;
                        break;
                    }
                    default: {
                        this.m_tabPosY = insets.top;
                    }
                }
                if (this.m_visibleTabsStart < 0 || this.completeWidth == 0 || !this.AreTabsValid()) break block24;
                int tabsWidth = x;
                this.calculatedWidth = allTabsWidth > this.completeWidth ? this.limitedWidth : this.completeWidth;
                if (this.m_visibleTabsEnd == -1) {
                    if (this.mTabbedPane.getClientProperty("Trace") != null) {
                        System.err.println("FrogTabbedPaneUI.arrangeTabs: calculate steps up");
                    }
                    this.setVisibleTabsEnd(this.m_visibleTabsStart);
                    i = this.m_visibleTabsStart;
                    while (i < pane.getTabCount() - mTabOffset) {
                        if ((tabsWidth += this.m_tabWidth[i]) > this.calculatedWidth) break;
                        this.setVisibleTabsEnd(i);
                        ++i;
                    }
                    if (!this.mPrevTabPressed && !this.mNextTabPressed && this.m_visibleTabsEnd == pane.getTabCount() - 1 - mTabOffset) {
                        int tWidth = 0;
                        i = this.m_visibleTabsEnd;
                        while (i >= 0) {
                            if ((tWidth += this.m_tabWidth[i]) > this.calculatedWidth) break;
                            this.setVisibleTabsStart(i);
                            --i;
                        }
                    }
                }
                if (this.m_visibleTabsStart >= tabCount) {
                    this.setVisibleTabsStart(tabCount - 1);
                }
                if (this.m_visibleTabsEnd >= tabCount) {
                    this.setVisibleTabsEnd(tabCount - 1);
                }
                if (this.m_visibleTabsStart < 0) break block25;
                this.setTabPosX(this.m_visibleTabsStart, x);
                i = this.m_visibleTabsStart + 1;
                while (i <= this.m_visibleTabsEnd) {
                    this.setTabPosX(i, this.m_tabPosX[i - 1] + this.m_tabWidth[i - 1]);
                    ++i;
                }
                break block25;
            }
            if (this.m_visibleTabsEnd >= 0 && this.completeWidth != 0 && this.AreTabsValid()) {
                this.calculatedWidth = allTabsWidth > this.completeWidth ? this.limitedWidth : this.completeWidth;
                if (this.mTabbedPane.getClientProperty("Trace") != null) {
                    System.err.println("FrogTabbedPaneUI.arrangeTabs: calculate steps down");
                }
                int tabPos6 = x;
                this.setVisibleTabsStart(this.m_visibleTabsEnd);
                i = this.m_visibleTabsEnd;
                while (i >= 0) {
                    if ((tabPos6 += this.m_tabWidth[i]) > this.calculatedWidth) break;
                    this.setVisibleTabsStart(i);
                    --i;
                }
                if (!this.mNextTabPressed && !this.mPrevTabPressed) {
                    int tabsWidth3 = x;
                    i = this.m_visibleTabsStart;
                    while (i < pane.getTabCount() - mTabOffset) {
                        if ((tabsWidth3 += this.m_tabWidth[i]) > this.calculatedWidth) break;
                        this.setVisibleTabsEnd(i);
                        ++i;
                    }
                }
                this.mOnlyTabEndDecreased = this.mOldVisibleTabsStart == this.m_visibleTabsStart && this.mPrevTabPressed;
                if (this.m_visibleTabsStart >= tabCount) {
                    this.setVisibleTabsStart(tabCount - 1);
                }
                if (this.m_visibleTabsEnd >= tabCount) {
                    this.setVisibleTabsEnd(tabCount - 1);
                }
                if (this.m_visibleTabsEnd >= 0) {
                    this.setTabPosX(this.m_visibleTabsStart, x);
                    i = this.m_visibleTabsStart + 1;
                    while (i <= this.m_visibleTabsEnd) {
                        this.setTabPosX(i, this.m_tabPosX[i - 1] + this.m_tabWidth[i - 1]);
                        ++i;
                    }
                }
            }
        }
    }

    protected int tabHeight(JTabbedPane pane, int tabIndex, int fontHeight) {
        int height = fontHeight;
        Icon icon = this.getIconForTab(pane, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        return height += 2 * m_spacingHeight + 2;
    }

    protected int maxTabHeight(JTabbedPane pane) {
        return this.maxTabHeight(pane, pane.getFont());
    }

    protected int maxTabHeight(JTabbedPane pane, Font font) {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int tabCount = pane.getTabCount() - mTabOffset;
        int result = 0;
        int fontHeight = metrics.getHeight() - HEIGHTKLUDGE;
        int i = 0;
        while (i < tabCount) {
            result = Math.max(this.tabHeight(pane, i, fontHeight), result);
            ++i;
        }
        return result;
    }

    protected int tabWidth(JTabbedPane pane, int tabIndex, FontMetrics metrics) {
        String title = "";
        if (tabIndex >= 0 || tabIndex < pane.getTabCount()) {
            title = pane.getTitleAt(tabIndex);
        }
        Icon icon = this.getIconForTab(pane, tabIndex);
        int maxLetterWidth = metrics.charWidth('m');
        int width = (int)(1.25 * (double)maxLetterWidth) + this.m_upperOffsetX;
        if (icon != null) {
            width += icon.getIconWidth() + m_iconSpacingWidth;
        }
        width += metrics.stringWidth(title);
        width = Math.min(width, this.mMaxTabWidth);
        return width;
    }

    protected boolean hasRightStack(JTabbedPane pane) {
        int tabCount = pane.getTabCount() - mTabOffset;
        return this.m_visibleTabsEnd < tabCount - 1;
    }

    protected boolean hasLeftStack(JComponent pane) {
        return this.m_visibleTabsStart > 0;
    }

    protected Icon getIconForTab(JTabbedPane pane, int tabIndex) {
        return !pane.isEnabledAt(tabIndex) && pane.getDisabledIconAt(tabIndex) != null ? pane.getDisabledIconAt(tabIndex) : pane.getIconAt(tabIndex);
    }

    protected Insets getContentBorderInsets(JTabbedPane pane) {
        return m_contentBorderInsets;
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.calculateLayoutInfo(pane);
        int tabCount = pane.getTabCount() - mTabOffset;
        if (i < tabCount && i >= 0) {
            return new Rectangle(this.m_tabPosX[i], this.m_tabPosY, Math.min(this.m_tabWidth[i], this.mMaxTabWidth), this.m_maxTabHeight);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public Rectangle getTabAreaBounds(JTabbedPane pane) {
        this.calculateLayoutInfo(pane);
        int width = this.m_buttonPosX[2] - this.m_tabPosX[this.m_visibleTabsStart] + m_lowerOffsetX;
        width = Math.min(width, this.mMaxTabWidth);
        return new Rectangle(this.m_tabPosX[this.m_visibleTabsStart] - m_lowerOffsetX, this.m_tabPosY, width, this.m_maxTabHeight);
    }

    public Rectangle getButtonAreaBounds(JTabbedPane pane) {
        this.calculateLayoutInfo(pane);
        int width = this.m_buttonPosX[0] + m_buttonWidth - this.m_buttonPosX[2];
        return new Rectangle(this.m_buttonPosX[0], this.m_buttonPosY, width, m_buttonWidth);
    }

    protected Rectangle getButtonBounds(JTabbedPane pane, int i) {
        this.calculateLayoutInfo(pane);
        return new Rectangle(this.m_buttonPosX[i], this.m_buttonPosY, m_buttonWidth, m_buttonWidth);
    }

    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    protected int preferredTotalTabHeight(JTabbedPane pane, Font font, int width) {
        int tabCount = pane.getTabCount() - mTabOffset;
        boolean total = false;
        if (tabCount > 0) {
            this.m_maxTabHeight = this.mTabbedPane.getClientProperty("tabAreaVisible") != null && (Boolean)this.mTabbedPane.getClientProperty("tabAreaVisible") == false ? 0 : this.maxTabHeight(pane, font);
        }
        return this.m_maxTabHeight;
    }

    protected int getPrevTabIndex(JTabbedPane pane, int base) {
        int tabIndex = base - 1;
        if (tabIndex < 0) {
            tabIndex = pane.getTabCount() - 1 - mTabOffset;
        }
        return tabIndex;
    }

    protected int getNextTabIndex(JTabbedPane pane, int base) {
        return (base + 1) % pane.getTabCount() - mTabOffset;
    }

    protected void selectTab(JTabbedPane pane, int index) {
        this.mTabSelected = true;
        Font font = pane.getFont();
        int tabCount = pane.getTabCount() - mTabOffset;
        if (index > this.m_visibleTabsEnd && this.m_visibleTabsEnd != -1) {
            this.setVisibleTabsEnd(index);
            this.setVisibleTabsStart(-1);
            this.layoutTabbedPane(pane);
            this.mTabSelectedDuringInit = false;
        } else if (index < this.m_visibleTabsStart && this.m_visibleTabsStart != -1) {
            this.setVisibleTabsStart(index);
            this.setVisibleTabsEnd(-1);
            this.layoutTabbedPane(pane);
            this.mTabSelectedDuringInit = false;
        } else if (index > this.m_visibleTabsEnd && this.m_visibleTabsEnd == -1 || index < this.m_visibleTabsStart && this.m_visibleTabsStart == -1) {
            this.mTabSelectedDuringInit = true;
        } else {
            this.mTabSelectedDuringInit = false;
            this.layoutTabbedPane(pane);
        }
        this.mSelectTabTrigger = true;
        this.controlButtonEnabling();
        pane.repaint();
    }

    protected void nextTab(JTabbedPane pane) {
        int tabIndex = this.m_visibleTabsStart;
        int tabCount = pane.getTabCount() - mTabOffset;
        if (!this.mOnlyTabEndDecreased) {
            tabIndex = this.m_visibleTabsStart + 1;
        }
        this.mTabSelected = false;
        this.mOnlyTabEndDecreased = false;
        this.mSelectTabTrigger = false;
        this.mNextTabPressed = true;
        this.mPrevTabPressed = false;
        if (tabIndex < tabCount) {
            while (!pane.isEnabledAt(tabIndex) && tabIndex < tabCount) {
                ++tabIndex;
            }
            if (tabIndex >= tabCount) {
                tabIndex = tabCount - 1;
            }
            this.setVisibleTabsStart(tabIndex);
            this.setVisibleTabsEnd(-1);
        }
    }

    protected void prevTab(JTabbedPane pane) {
        int tabIndex = this.m_visibleTabsEnd - 1;
        this.mTabSelected = false;
        this.mSelectTabTrigger = false;
        this.mOldVisibleTabsStart = this.m_visibleTabsStart;
        this.mNextTabPressed = false;
        this.mPrevTabPressed = true;
        if (tabIndex >= 0) {
            while (!pane.isEnabledAt(tabIndex) && tabIndex >= 0) {
                --tabIndex;
            }
            if (tabIndex < 0) {
                tabIndex = 0;
            }
            this.setVisibleTabsEnd(tabIndex);
            this.setVisibleTabsStart(-1);
        }
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        int maxTabIndex = this.tabPane.getTabCount() - mTabOffset - 1;
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        if (tabIndex > maxTabIndex) {
            tabIndex = maxTabIndex;
        }
        this.tabPane.setSelectedIndex(tabIndex);
        this.controlButtonEnabling();
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        int maxTabIndex = this.tabPane.getTabCount() - mTabOffset - 1;
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        if (tabIndex > maxTabIndex) {
            tabIndex = 0;
        }
        this.tabPane.setSelectedIndex(tabIndex);
        this.controlButtonEnabling();
    }

    protected void selectPreviousTabInRun(int current) {
        this.selectPreviousTab(current);
    }

    protected void selectNextTabInRun(int current) {
        this.selectNextTab(current);
    }

    protected int buttonForCoordinate(JTabbedPane pane, int x, int y) {
        this.calculateLayoutInfo(pane);
        if (this.hasLeftStack(pane) || this.hasRightStack(pane)) {
            if (x >= this.m_buttonPosX[2] && x <= this.m_buttonPosX[2] + m_buttonWidth) {
                return 2;
            }
            if (x >= this.m_buttonPosX[1] && x <= this.m_buttonPosX[1] + m_buttonWidth) {
                return 1;
            }
            if (x >= this.m_buttonPosX[0] && x <= this.m_buttonPosX[0] + m_buttonWidth) {
                return 0;
            }
        }
        return -1;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        int tabCount = pane.getTabCount() - mTabOffset;
        Rectangle bounds = pane.getBounds();
        Insets insets = pane.getInsets();
        if (tabCount <= 0) {
            return -1;
        }
        int tabPlacement = pane.getTabPlacement();
        int y1 = 0;
        switch (tabPlacement) {
            case 3: {
                y1 = -bounds.height + this.m_maxTabHeight + y + 2;
                break;
            }
            default: {
                y1 = this.m_maxTabHeight - y + insets.top;
            }
        }
        this.calculateLayoutInfo(pane);
        if (y < this.m_tabPosY || y > this.m_maxTabHeight + this.m_tabPosY) {
            return -1;
        }
        if (this.m_visibleTabsEnd == -1 || x > this.m_tabPosX[this.m_visibleTabsEnd] + this.m_tabWidth[this.m_visibleTabsEnd]) {
            return -1;
        }
        int i = this.m_visibleTabsEnd;
        while (i >= this.m_visibleTabsStart) {
            if (x >= this.m_tabPosX[i]) {
                int current = pane.getSelectedIndex();
                if (i == current - 1 && current <= this.m_visibleTabsEnd) {
                    pane.getInsets();
                    int x1 = this.m_tabPosX[current] - x + 1;
                    if (x1 + y1 <= m_lowerOffsetX) {
                        return current;
                    }
                }
                return i;
            }
            --i;
        }
        return -1;
    }

    private static void initializeImageData() {
        if (FrogLookAndFeel.isMACOS9()) {
            mMacVendor = true;
        }
        m_lowerOffsetX = ThemeData.getImageData(null, "TabStripCtl.SecTabBeh.LBC").getHeight();
        m_borderOverlay = ThemeData.getImageData(null, "TabStripCtl.Bord.UB").getHeight();
    }

    public static FrogImageData[] getImageDataResources() {
        if (mImageDataResources == null) {
            FrogTabbedPaneUI.initializeImageData();
            FrogImageData[] datas = new FrogImageData[]{ThemeData.getImageData(null, "TabStripCtl.Bord.UB"), ThemeData.getImageData(null, "TabStripCtl.Bord.RB"), ThemeData.getImageData(null, "TabStripCtl.Bord.BB"), ThemeData.getImageData(null, "TabStripCtl.Bord.LB"), ThemeData.getImageData(null, "TabStripCtl.Bord.FL"), ThemeData.getImageData(null, "TabStripCtl.SecTabBeh.UB"), ThemeData.getImageData(null, "TabStripCtl.SecTabBeh.RB"), ThemeData.getImageData(null, "TabStripCtl.SecTabBeh.BB"), ThemeData.getImageData(null, "TabStripCtl.SecTabBeh.LB"), ThemeData.getImageData(null, "TabStripCtl.SecTabFst.UB"), ThemeData.getImageData(null, "TabStripCtl.SecTabFst.RB"), ThemeData.getImageData(null, "TabStripCtl.SecTabFst.LB"), ThemeData.getImageData(null, "TabStripCtl.PrimTab.UB"), ThemeData.getImageData(null, "TabStripCtl.PrimTab.RB"), ThemeData.getImageData(null, "TabStripCtl.PrimTab.LB"), ThemeData.getImageData(null, "TabStripCtl.StackTab.RB")};
            mImageDataResources = datas;
        }
        return mImageDataResources;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.getTabBounds(this.mTabbedPane, tabIndex);
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = tabRect.width % 2;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.getTabBounds(this.mTabbedPane, tabIndex);
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    private void setVisibleTabsEnd(int end) {
        if (this.mTabbedPane.getClientProperty("Trace") != null) {
            System.err.println("FrogTabbedPaneUI.setVisibleTabsEnd: " + end);
        }
        if (this.mTabbedPane.getClientProperty("StackTrace") != null) {
            Exception e = new Exception();
            e.printStackTrace();
        }
        this.m_visibleTabsEnd = end;
    }

    private void setVisibleTabsStart(int start) {
        if (this.mTabbedPane.getClientProperty("Trace") != null) {
            System.err.println("FrogTabbedPaneUI.setVisibleTabsStart: " + start);
        }
        if (this.mTabbedPane.getClientProperty("StackTrace") != null) {
            Exception e = new Exception();
            e.printStackTrace();
        }
        this.m_visibleTabsStart = start;
    }

    private boolean AreTabsValid() {
        return this.m_tabWidth != null && this.m_tabWidth[0] != 22;
    }

    private void setTabPosX(int i, int value) {
        this.m_tabPosX[i] = value;
    }

    protected void showTabList(int x, int y) {
        TabbedPanePopup popup = new TabbedPanePopup(this.mTabbedPane);
        popup.show(this.mTabbedPane.getSize(), this.mTabbedPane, x, y);
    }

    protected void scrollLeft() {
        if (this.hasLeftStack(this.mTabbedPane)) {
            this.mScrollDirection = SCROLL_LEFT;
            this.prevTab(this.mTabbedPane);
            this.mTabbedPane.repaint();
        }
        this.controlButtonEnabling();
    }

    protected void scrollRight() {
        if (this.hasRightStack(this.mTabbedPane)) {
            this.mScrollDirection = SCROLL_RIGHT;
            int m_oldVisibleTabsEnd = this.m_visibleTabsEnd;
            this.nextTab(this.mTabbedPane);
            while (m_oldVisibleTabsEnd == this.m_visibleTabsEnd && this.m_visibleTabsStart <= this.m_visibleTabsEnd) {
                m_oldVisibleTabsEnd = this.m_visibleTabsEnd;
                this.nextTab(this.mTabbedPane);
            }
            this.mTabbedPane.repaint();
        }
        this.controlButtonEnabling();
    }

    protected void controlButtonEnabling() {
        boolean isRightScrlButtonEnabled;
        boolean isLeftScrlButtonEnabled = this.mTabbedPane.isEnabled() && this.hasLeftStack(this.mTabbedPane);
        boolean bl = isRightScrlButtonEnabled = this.mTabbedPane.isEnabled() && this.hasRightStack(this.mTabbedPane);
        if (isLeftScrlButtonEnabled) {
            this.mLeftScrlButton.getModel().setEnabled(true);
        } else {
            this.mLeftScrlButton.getModel().setEnabled(false);
        }
        if (isRightScrlButtonEnabled) {
            this.mRghtScrlButton.getModel().setEnabled(true);
        } else {
            this.mRghtScrlButton.getModel().setEnabled(false);
        }
    }

    public void toggleXIPopup(int x, int y) {
        ((FrogTabStripComboBoxUI)this.mTabListButton.getUI()).showXIPopup(x, y, this.mTabbedPane);
    }

    protected int getLeftTabOffSet() {
        if (this.hasLeftStack(this.mTabbedPane)) {
            return ThemeData.getImageData(this.mTabbedPane, "TabStripCtl.LeadStackTab.LB").getWidth();
        }
        return m_tabLeftOffset;
    }

    class MouseGetter
    extends MouseAdapter
    implements Serializable {
        MouseGetter() {
        }

        public void mousePressed(MouseEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int buttonIndex = FrogTabbedPaneUI.this.buttonForCoordinate(pane, e.getX(), e.getY());
            if (buttonIndex >= 0) {
                if (buttonIndex == 0) {
                    FrogTabbedPaneUI.this.m_tabListButtonPressed = true;
                    pane.repaint(FrogTabbedPaneUI.this.getButtonBounds(pane, 0));
                } else if (buttonIndex == 1 && FrogTabbedPaneUI.this.hasRightStack(pane)) {
                    FrogTabbedPaneUI.this.m_rightButtonPressed = true;
                    pane.repaint(FrogTabbedPaneUI.this.getButtonBounds(pane, 1));
                } else if (buttonIndex == 2 && FrogTabbedPaneUI.this.hasLeftStack(pane)) {
                    FrogTabbedPaneUI.this.m_leftButtonPressed = true;
                    pane.repaint(FrogTabbedPaneUI.this.getButtonBounds(pane, 2));
                }
                pane.requestFocus();
                return;
            }
        }

        public void mouseReleased(MouseEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int buttonIndex = FrogTabbedPaneUI.this.buttonForCoordinate(pane, e.getX(), e.getY());
            if (buttonIndex >= 0) {
                if (buttonIndex == 0) {
                    FrogTabbedPaneUI.this.m_tabListButtonPressed = false;
                    pane.repaint(FrogTabbedPaneUI.this.getButtonBounds(pane, 0));
                    FrogTabbedPaneUI.this.toggleXIPopup(e.getX(), e.getY());
                } else if (buttonIndex == 1 && FrogTabbedPaneUI.this.hasRightStack(pane)) {
                    FrogTabbedPaneUI.this.nextTab(pane);
                    FrogTabbedPaneUI.this.m_rightButtonPressed = false;
                    Rectangle tabRect = FrogTabbedPaneUI.this.getTabAreaBounds(pane);
                    tabRect.x -= m_lowerOffsetX;
                    tabRect.width += m_lowerOffsetX;
                    tabRect.height += m_borderOverlay;
                    pane.repaint();
                    pane.repaint(FrogTabbedPaneUI.this.getButtonAreaBounds(pane));
                } else if (buttonIndex == 2 && FrogTabbedPaneUI.this.hasLeftStack(pane)) {
                    FrogTabbedPaneUI.this.prevTab(pane);
                    FrogTabbedPaneUI.this.m_leftButtonPressed = false;
                    Rectangle tabRect = FrogTabbedPaneUI.this.getTabAreaBounds(pane);
                    tabRect.x -= m_lowerOffsetX;
                    tabRect.width += m_lowerOffsetX;
                    tabRect.height += m_borderOverlay;
                    pane.repaint();
                    pane.repaint(FrogTabbedPaneUI.this.getButtonAreaBounds(pane));
                }
                return;
            }
            int tabIndex = FrogTabbedPaneUI.this.tabForCoordinate(pane, e.getX(), e.getY());
            if (tabIndex >= 0 && pane.isEnabledAt(tabIndex)) {
                if (tabIndex == pane.getSelectedIndex()) {
                    pane.requestFocus();
                    pane.repaint();
                } else if (FrogTabbedPaneUI.this.mTabbedPane.getClientProperty("tabAreaVisible") == null || ((Boolean)FrogTabbedPaneUI.this.mTabbedPane.getClientProperty("tabAreaVisible")).booleanValue()) {
                    FrogTabbedPaneUI.this.mTabbedPane.setSelectedIndex(tabIndex);
                    FrogTabbedPaneUI.this.mTabbedPane.requestFocus();
                    FrogTabbedPaneUI.this.mTabbedPane.repaint();
                }
            }
        }
    }

    class FocusGetter
    extends FocusAdapter
    implements Serializable {
        FocusGetter() {
        }

        public void focusGained(FocusEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Rectangle tabRect = FrogTabbedPaneUI.this.getTabBounds(pane, pane.getSelectedIndex());
            tabRect.x -= m_lowerOffsetX;
            tabRect.width += m_lowerOffsetX;
            tabRect.height += m_borderOverlay;
            pane.repaint();
        }

        public void focusLost(FocusEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Rectangle tabRect = FrogTabbedPaneUI.this.getTabBounds(pane, pane.getSelectedIndex());
            tabRect.x -= m_lowerOffsetX;
            tabRect.width += m_lowerOffsetX;
            tabRect.height += m_borderOverlay;
            pane.repaint();
        }
    }

    class TabbedPanePopup
    extends JPopupMenu
    implements ActionListener {
        protected JTabbedPane mTabbedPane = null;

        public TabbedPanePopup(JTabbedPane pane) {
            this.mTabbedPane = pane;
            int tabCount = pane.getTabCount() - mTabOffset;
            int i = 0;
            while (i < tabCount) {
                String s = pane.getTitleAt(i);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(s);
                if (pane.getSelectedIndex() == i) {
                    item.setState(true);
                }
                item.setIcon(pane.getIconAt(i));
                item.addActionListener(this);
                item.setActionCommand("" + i);
                this.add(item);
                ++i;
            }
        }

        public void show(Dimension bound, Component invoker, int x, int y) {
            int mFittingSpace = 3;
            Dimension popupSize = this.getPreferredSize();
            if (popupSize.width + x > bound.width && (x = x - popupSize.width + mFittingSpace) < 0) {
                x = 0;
            }
            if (popupSize.height + y > bound.height && (y -= popupSize.height) < 0) {
                y = 0;
            }
            super.show(invoker, x, y);
        }

        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            int selectedIndex = Integer.parseInt(s);
            FrogTabbedPaneUI.this.mOnlyTabEndDecreased = false;
            FrogTabbedPaneUI.this.mPrevTabPressed = false;
            FrogTabbedPaneUI.this.mNextTabPressed = false;
            if (selectedIndex >= 0) {
                this.mTabbedPane.setSelectedIndex(selectedIndex);
                this.mTabbedPane.repaint();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ancestor") && evt.getOldValue() != null) {
                FrogTabbedPaneUI.this.mTabbedPane.getParent().remove(FrogTabbedPaneUI.this.mLeftScrlButton);
                FrogTabbedPaneUI.this.mTabbedPane.getParent().remove(FrogTabbedPaneUI.this.mRghtScrlButton);
                FrogTabbedPaneUI.this.mTabbedPane.getParent().remove(FrogTabbedPaneUI.this.mTabListButton);
            }
            if (evt.getPropertyName().equals("TabbedPane.maxRowsForTabList")) {
                FrogTabbedPaneUI.this.mTabListButton.setMaximumRowCount((Integer)FrogTabbedPaneUI.this.mTabbedPane.getClientProperty("TabbedPane.maxRowsForTabList"));
            }
        }
    }

    public class ContainerHandler
    implements ContainerListener {
        public void componentRemoved(ContainerEvent e) {
            if (FrogTabbedPaneUI.this.mTabbedPane.getClientProperty("Trace") != null) {
                System.err.println("FrogTabbedPaneUI.componentRemoved");
            }
            FrogTabbedPaneUI.this.setVisibleTabsEnd(-1);
        }

        public void componentAdded(ContainerEvent e) {
            if (FrogTabbedPaneUI.this.mTabbedPane.getClientProperty("Trace") != null) {
                System.err.println("FrogTabbedPaneUI.componentAdded");
            }
            JTabbedPane pane = (JTabbedPane)e.getContainer();
            if (FrogTabbedPaneUI.this.mTabbedPane.getComponentCount() - mTabOffset == 1) {
                FrogTabbedPaneUI.this.setVisibleComponent(pane.getComponentAt(0));
            }
            FrogTabbedPaneUI.this.setVisibleTabsEnd(-1);
            FrogTabbedPaneUI.this.layoutContainer(FrogTabbedPaneUI.this.mTabbedPane);
        }
    }

    public class ComponentHandler
    implements ComponentListener {
        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }

    class ActionGetter
    implements ActionListener {
        ActionGetter() {
        }

        public void actionPerformed(ActionEvent e) {
            Object object = e.getSource();
            String selectedValue = (String)FrogTabbedPaneUI.this.mTabListButton.getSelectedItem();
            if (object == FrogTabbedPaneUI.this.mLeftScrlButton) {
                FrogTabbedPaneUI.this.scrollLeft();
            } else if (object == FrogTabbedPaneUI.this.mRghtScrlButton) {
                FrogTabbedPaneUI.this.scrollRight();
            }
            FrogTabbedPaneUI.this.calculateLayoutInfo(FrogTabbedPaneUI.this.mTabbedPane);
            FrogTabbedPaneUI.this.controlButtonEnabling();
        }
    }

    public class TabButton
    extends JButton {
        TabButton() {
        }

        public void setIcon(Icon ic) {
            super.setIcon(ic);
        }

        public void requestFocus() {
            super.requestFocus();
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public boolean isFocusable() {
            return true;
        }
    }

    public class TabComboBoxModel
    extends DefaultComboBoxModel
    implements ActionListener {
        Object selectedObject;
        JTabbedPane mTabbedPane;

        TabComboBoxModel() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("showPopup") && this.mTabbedPane != null) {
                this.setSelectedItem(this.mTabbedPane.getTitleAt(this.mTabbedPane.getSelectedIndex()));
            } else if (e.getActionCommand().equals("hidePopup") && this.mTabbedPane != null && this.selectedObject != null && !this.mTabbedPane.getTitleAt(this.mTabbedPane.getSelectedIndex()).equals(this.selectedObject)) {
                int i = 0;
                while (i < this.mTabbedPane.getTabCount() - mTabOffset) {
                    if (this.mTabbedPane.getTitleAt(i).equals(this.selectedObject)) {
                        this.mTabbedPane.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        public void setDataModel(JTabbedPane tabbedPane) {
            this.mTabbedPane = tabbedPane;
        }

        public Object getElementAt(int index) {
            if (index >= 0 && index < this.mTabbedPane.getTabCount() - mTabOffset) {
                return this.mTabbedPane.getTitleAt(index);
            }
            return null;
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            if (this.mTabbedPane != null) {
                return this.mTabbedPane.getTabCount() - mTabOffset;
            }
            return 0;
        }

        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }
}

