/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogComboBoxUI;
import com.sap.plaf.frog.FrogComboPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;

public class FrogTabStripComboBoxUI
extends FrogComboBoxUI {
    private Vector mListenerList = new Vector();
    private TabStripComboPopup mTabStripComboPopup;

    public static ComponentUI createUI(JComponent c) {
        return new FrogTabStripComboBoxUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (c.hasFocus() || this.arrowButton.hasFocus()) {
            FrogBorders.FocusBorder.drawFocus(g, c);
        }
    }

    protected JButton createArrowButton() {
        JButton button = new JButton(){

            public boolean isFocusable() {
                return false;
            }

            public void paint(Graphics g) {
                super.paint(g);
                if (FrogTabStripComboBoxUI.this.comboBox.hasFocus() || FrogTabStripComboBoxUI.this.arrowButton.hasFocus()) {
                    FrogBorders.FocusBorder.drawFocus(g, this);
                }
            }
        };
        return button;
    }

    protected ComboPopup createPopup() {
        this.mTabStripComboPopup = new TabStripComboPopup(this.comboBox);
        return this.mTabStripComboPopup;
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        if (this.arrowButton != null) {
            this.arrowButton.setOpaque(false);
            this.arrowButton.setBorder(null);
            this.arrowButton.setPressedIcon(UIManager.getIcon("TabbedPane.listIconButtonPS"));
            this.arrowButton.setIcon(UIManager.getIcon("TabbedPane.listIconButton"));
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener downAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FrogTabStripComboBoxUI.this.comboBox.isEnabled()) {
                    if (FrogTabStripComboBoxUI.this.isPopupVisible(FrogTabStripComboBoxUI.this.comboBox)) {
                        FrogTabStripComboBoxUI.this.selectNextPossibleValue();
                    } else if (FrogTabStripComboBoxUI.this.comboBox.getClientProperty("SortedList") != null) {
                        FrogTabStripComboBoxUI.this.selectNextPossibleValue();
                    } else {
                        FrogTabStripComboBoxUI.this.setPopupVisible(FrogTabStripComboBoxUI.this.comboBox, true);
                    }
                }
            }
        };
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 1);
        ActionListener altAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String typedText = (String)FrogTabStripComboBoxUI.this.comboBox.getEditor().getItem();
                JList<Object> list = FrogTabStripComboBoxUI.this.popup.getList();
                int currentScrolledIndex = -1;
                FrogTabStripComboBoxUI.this.togglePopup();
            }
        };
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(40, 8), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(38, 8), 1);
        ActionListener upAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FrogTabStripComboBoxUI.this.comboBox.getClientProperty("SortedList") != null && FrogTabStripComboBoxUI.this.comboBox.isEnabled()) {
                    FrogTabStripComboBoxUI.this.selectPreviousPossibleValue();
                } else if (FrogTabStripComboBoxUI.this.comboBox.isEnabled() && FrogTabStripComboBoxUI.this.isPopupVisible(FrogTabStripComboBoxUI.this.comboBox)) {
                    FrogTabStripComboBoxUI.this.selectPreviousPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 1);
    }

    public void addActionListener(ActionListener l) {
        this.mListenerList.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mListenerList.removeElement(l);
    }

    protected void fireActionPerformed(ActionEvent e) {
        Enumeration enumeration = this.mListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener listener = (ActionListener)enumeration.nextElement();
            listener.actionPerformed(e);
        }
    }

    public void showXIPopup(int x, int y, Component invoker) {
        this.mTabStripComboPopup.setupPopup(x, y, invoker);
        this.mTabStripComboPopup.show();
    }

    public class TabStripComboPopup
    extends FrogComboPopup {
        int mPopupY = -1;
        int mPopupX = -1;
        Component mInvoker = null;

        TabStripComboPopup(JComboBox combo) {
            super(combo);
            this.setRequestFocusEnabled(true);
        }

        public void show() {
            super.show();
            FrogTabStripComboBoxUI.this.fireActionPerformed(new ActionEvent(this, 1001, "showPopup"));
        }

        public void show(Component invoker, int x, int y) {
            super.show(this.mInvoker, x, y);
        }

        public void hide() {
            if (this.mPopup.isVisible()) {
                FrogTabStripComboBoxUI.this.fireActionPerformed(new ActionEvent(this, 1001, "hidePopup"));
            }
            super.hide();
        }

        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            if (this.mPopupX != -1 && this.mPopupY != -1) {
                py = this.mPopupY;
                px = this.mPopupX;
            }
            Rectangle absBounds = new Rectangle();
            Rectangle r = new Rectangle(this.mPopupX, this.mPopupY, pw, ph);
            Point p = new Point(0, 0);
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            SwingUtilities.convertPointFromScreen(p, this.comboBox);
            absBounds.x = p.x;
            absBounds.y = p.y;
            absBounds.width = scrSize.width;
            absBounds.height = scrSize.height;
            return r;
        }

        public void setupPopup(int x, int y, Component invoker) {
            this.mPopupX = x;
            this.mPopupY = y;
            this.mInvoker = invoker;
        }
    }
}

