/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogSplitPaneDivider;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class FrogSplitPaneUI
extends BasicSplitPaneUI
implements ContainerListener {
    protected Component mLeftComponent = null;
    protected Component mRightComponent = null;

    public static ComponentUI createUI(JComponent x) {
        return new FrogSplitPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.addContainerListener(this);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c != null) {
            c.removeContainerListener(this);
        }
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new FrogSplitPaneDivider(this);
    }

    public void paint(Graphics g, JComponent jc) {
        if (jc.getClientProperty("avoidSwingBug") != null) {
            this.avoidBug();
        }
        g.setColor(SystemHueShift.getColor(jc, "SplitPane.background"));
        g.fillRect(0, 0, jc.getWidth(), jc.getHeight());
    }

    public void componentAdded(ContainerEvent evt) {
        this.mLeftComponent = this.getSplitPane().getLeftComponent();
        this.mRightComponent = this.getSplitPane().getRightComponent();
    }

    public void componentRemoved(ContainerEvent evt) {
        if (evt.getChild() == this.mLeftComponent) {
            this.mLeftComponent = null;
        } else if (evt.getChild() == this.mRightComponent) {
            this.mRightComponent = null;
        }
    }

    public void bugRemove(JComponent c) {
        int finishedPoint = 0;
        if (c instanceof JSplitPane) {
            Component splitcomp = null;
            if (c instanceof JSplitPane) {
                if (((JSplitPane)c).getOrientation() == 0) {
                    splitcomp = ((JSplitPane)c).getTopComponent();
                    if (splitcomp != null) {
                        super.startDragging();
                        finishedPoint = (int)splitcomp.getPreferredSize().getHeight();
                        this.dragDividerTo(finishedPoint);
                    }
                } else {
                    splitcomp = ((JSplitPane)c).getLeftComponent();
                    if (splitcomp != null) {
                        super.startDragging();
                        finishedPoint = (int)splitcomp.getPreferredSize().getWidth();
                        this.dragDividerTo(finishedPoint);
                    }
                }
                if (splitcomp != null) {
                    super.finishDraggingTo(finishedPoint);
                    c.revalidate();
                    c.repaint();
                }
            }
        }
    }

    protected void avoidBug() {
        int dividerSize = this.getSplitPane().getDividerSize();
        boolean removeBug = false;
        if (this.mLeftComponent != null && this.mRightComponent != null) {
            if (this.getSplitPane().getOrientation() == 0) {
                if (this.mLeftComponent.getBounds().height + dividerSize != this.mRightComponent.getBounds().y) {
                    removeBug = true;
                }
            } else if (this.mLeftComponent.getBounds().width + dividerSize != this.mRightComponent.getBounds().x) {
                removeBug = true;
            }
        }
        if (removeBug) {
            this.bugRemove(this.getSplitPane());
        }
    }
}

