/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogButtonUI;
import com.sap.plaf.frog.FrogLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class FrogSplitPaneDivider
extends BasicSplitPaneDivider {
    protected static final int ONE_TOUCH_SIZE = 8;

    public FrogSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new FrogDividerLayout());
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton();
        b.setFocusPainted(true);
        b.setBorderPainted(true);
        b.setUI(new LeftOneTouchButtonUI());
        b.setBorder(new FrogBorders.LabelFocusBorder());
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton();
        b.setFocusPainted(true);
        b.setBorderPainted(true);
        b.setUI(new RightOneTouchButtonUI());
        b.setBorder(new FrogBorders.LabelFocusBorder());
        return b;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    public JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    public JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public class RightOneTouchButtonUI
    extends FrogButtonUI {
        int[][] buffer;

        public RightOneTouchButtonUI() {
            int[][] nArrayArray = new int[6][];
            nArrayArray[0] = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
            int[] nArray = new int[11];
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 1;
            nArray[7] = 1;
            nArray[8] = 1;
            nArray[9] = 1;
            nArray[10] = 3;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[11];
            nArray2[2] = 1;
            nArray2[3] = 1;
            nArray2[4] = 1;
            nArray2[5] = 1;
            nArray2[6] = 1;
            nArray2[7] = 1;
            nArray2[8] = 1;
            nArray2[9] = 3;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[11];
            nArray3[3] = 1;
            nArray3[4] = 1;
            nArray3[5] = 1;
            nArray3[6] = 1;
            nArray3[7] = 1;
            nArray3[8] = 3;
            nArrayArray[3] = nArray3;
            int[] nArray4 = new int[11];
            nArray4[4] = 1;
            nArray4[5] = 1;
            nArray4[6] = 1;
            nArray4[7] = 3;
            nArrayArray[4] = nArray4;
            int[] nArray5 = new int[11];
            nArray5[6] = 3;
            nArrayArray[5] = nArray5;
            this.buffer = nArrayArray;
        }

        public void update(Graphics g, JComponent c) {
            g.setColor(UIManager.getColor("SplitPane.background"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            this.paint(g, c);
        }

        public void paint(Graphics g, JComponent c) {
            block9: {
                JSplitPane splitPane = FrogSplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane == null) break block9;
                int oneTouchSize = 7;
                int orientation = FrogSplitPaneDivider.this.getOrientationFromSuper();
                int blockSize = Math.min(FrogSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                Color[] colors = new Color[]{c.getBackground(), FrogLookAndFeel.getPrimaryControlDarkShadow(), FrogLookAndFeel.getPrimaryControlInfo(), FrogLookAndFeel.getPrimaryControlHighlight()};
                g.setColor(UIManager.getColor("SplitPane.background"));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                if (((JButton)c).getModel().isPressed()) {
                    colors[1] = colors[2];
                }
                if (orientation == 0) {
                    int i = 1;
                    while (i <= this.buffer[0].length) {
                        int j = 1;
                        while (j < blockSize) {
                            if (this.buffer[j - 1][i - 1] != 0) {
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= this.buffer[0].length) {
                        int j = 1;
                        while (j < blockSize) {
                            if (this.buffer[j - 1][i - 1] != 0) {
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected class FrogDividerLayout
    implements LayoutManager {
        protected FrogDividerLayout() {
        }

        public void layoutContainer(Container c) {
            if (FrogSplitPaneDivider.this.leftButton != null && FrogSplitPaneDivider.this.rightButton != null && c == FrogSplitPaneDivider.this) {
                if (FrogSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = FrogSplitPaneDivider.this.getInsets();
                    if (FrogSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int blockSize = FrogSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                        }
                        blockSize = Math.min(blockSize, 8);
                        int y = (c.getSize().height - blockSize) / 2;
                        FrogSplitPaneDivider.this.leftButton.setBounds(extraX + 2, y, blockSize * 2, blockSize);
                        FrogSplitPaneDivider.this.rightButton.setBounds(extraX + 2 + 16, y, blockSize * 2, blockSize);
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = FrogSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                        }
                        blockSize = Math.min(blockSize, 8);
                        int x = (c.getSize().width - blockSize) / 2;
                        FrogSplitPaneDivider.this.leftButton.setBounds(x, extraY + 2, blockSize, blockSize * 2);
                        FrogSplitPaneDivider.this.rightButton.setBounds(x, extraY + 2 + 16, blockSize, blockSize * 2);
                    }
                } else {
                    FrogSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    FrogSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }

    public class LeftOneTouchButtonUI
    extends FrogButtonUI {
        int[][] buffer;

        public LeftOneTouchButtonUI() {
            int[][] nArrayArray = new int[6][];
            int[] nArray = new int[11];
            nArray[4] = 2;
            nArray[5] = 2;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[11];
            nArray2[3] = 2;
            nArray2[4] = 1;
            nArray2[5] = 1;
            nArray2[6] = 1;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[11];
            nArray3[2] = 2;
            nArray3[3] = 1;
            nArray3[4] = 1;
            nArray3[5] = 1;
            nArray3[6] = 1;
            nArray3[7] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[11];
            nArray4[1] = 2;
            nArray4[2] = 1;
            nArray4[3] = 1;
            nArray4[4] = 1;
            nArray4[5] = 1;
            nArray4[6] = 1;
            nArray4[7] = 1;
            nArray4[8] = 1;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[11];
            nArray5[0] = 2;
            nArray5[1] = 1;
            nArray5[2] = 1;
            nArray5[3] = 1;
            nArray5[4] = 1;
            nArray5[5] = 1;
            nArray5[6] = 1;
            nArray5[7] = 1;
            nArray5[8] = 1;
            nArray5[9] = 1;
            nArrayArray[4] = nArray5;
            int[] nArray6 = new int[11];
            nArray6[1] = 3;
            nArray6[2] = 3;
            nArray6[3] = 3;
            nArray6[4] = 3;
            nArray6[5] = 3;
            nArray6[6] = 3;
            nArray6[7] = 3;
            nArray6[8] = 3;
            nArray6[9] = 3;
            nArray6[10] = 3;
            nArrayArray[5] = nArray6;
            this.buffer = nArrayArray;
        }

        public void update(Graphics g, JComponent c) {
            g.setColor(UIManager.getColor("SplitPane.background"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            this.paint(g, c);
        }

        public void paint(Graphics g, JComponent c) {
            block9: {
                JSplitPane splitPane = FrogSplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane == null) break block9;
                int oneTouchSize = 7;
                int orientation = FrogSplitPaneDivider.this.getOrientationFromSuper();
                int blockSize = Math.min(FrogSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                Color[] colors = new Color[]{c.getBackground(), FrogLookAndFeel.getPrimaryControlDarkShadow(), FrogLookAndFeel.getPrimaryControlInfo(), FrogLookAndFeel.getPrimaryControlHighlight()};
                if (((JButton)c).getModel().isPressed()) {
                    colors[1] = colors[2];
                }
                if (orientation == 0) {
                    int i = 1;
                    while (i <= this.buffer[0].length) {
                        int j = 1;
                        while (j < blockSize) {
                            if (this.buffer[j - 1][i - 1] != 0) {
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= this.buffer[0].length) {
                        int j = 1;
                        while (j < blockSize) {
                            if (this.buffer[j - 1][i - 1] != 0) {
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

