/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class FrogSeparatorUI
extends BasicSeparatorUI {
    public static final String __PerforceId = "$Id$";
    private static boolean mMacVendor = false;
    private static FrogImageData mLB;
    private static FrogImageData mRB;
    private static FrogImageData mSeparator_L;
    private static FrogImageData mSeparator_M;
    private static FrogImageData mSeparatorHorz_M;
    private static FrogImageData mSeparator_R;
    protected static FrogImageData[] mImageDataResources;
    protected static boolean mDefaultsInitialized;

    static {
        mSeparator_L = null;
        mSeparator_M = null;
        mSeparatorHorz_M = null;
        mSeparator_R = null;
        mDefaultsInitialized = false;
    }

    public static ComponentUI createUI(JComponent c) {
        return new FrogSeparatorUI();
    }

    protected void installDefaults(JSeparator s) {
        LookAndFeel.installColors(s, "Separator.background", "Separator.foreground");
        if (!mDefaultsInitialized) {
            FrogSeparatorUI.initializeImageData();
            mDefaultsInitialized = true;
        }
    }

    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        if (((JSeparator)c).getOrientation() == 1) {
            g.setColor(c.getForeground());
            g.drawLine(0, 0, 0, s.height);
            g.setColor(Color.green);
            g.drawLine(1, 0, 1, s.height);
        } else if (c.getClientProperty("ToolbarSeparator") != null) {
            if (mMacVendor) {
                g.drawImage(SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M")), 3, s.height / 2 - ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getHeight() / 2, s.width - 4, s.height / 2 + ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getHeight() / 2, 0, 0, ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getWidth(), ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getHeight(), null);
            } else {
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M")), 3, s.height / 2 - ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getHeight() / 2, s.width - 4, s.height / 2 + ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getHeight() / 2, ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getLeft(), ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getTop(), ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getRight(), ThemeData.getImageData(c, "Toolbar.SeparatorHorz.M").getBottom(), Color.cyan, null);
            }
        } else if (mMacVendor) {
            g.drawImage(SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PopupMenu.Separator.M")), 0, 0, s.width, s.height, 0, 0, ThemeData.getImageData(c, "PopupMenu.Separator.M").getWidth(), ThemeData.getImageData(c, "PopupMenu.Separator.M").getHeight(), Color.cyan, null);
            g.drawImage(SystemHueShift.getCropImage(c, mRB), s.width - mRB.getWidth(), 0, s.width, s.height, 0, 0, mRB.getWidth(), mRB.getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(c, mLB), 0, 0, mLB.getWidth(), s.height, 0, 0, mLB.getWidth(), mLB.getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PopupMenu.Separator.L")), mLB.getWidth(), 0, mLB.getWidth() + ThemeData.getImageData(c, "PopupMenu.Separator.L").getWidth(), s.height, 0, 0, ThemeData.getImageData(c, "PopupMenu.Separator.L").getWidth(), ThemeData.getImageData(c, "PopupMenu.Separator.L").getHeight(), null);
            g.drawImage(SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PopupMenu.Separator.R")), s.width - mRB.getWidth() - ThemeData.getImageData(c, "PopupMenu.Separator.R").getWidth(), 0, s.width - mRB.getWidth(), s.height, 0, 0, ThemeData.getImageData(c, "PopupMenu.Separator.R").getWidth(), ThemeData.getImageData(c, "PopupMenu.Separator.R").getHeight(), null);
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "PopupMenu.Separator.M")), 2, 0, s.width - 2, s.height, ThemeData.getImageData(c, "PopupMenu.Separator.M").getLeft(), ThemeData.getImageData(c, "PopupMenu.Separator.M").getTop(), ThemeData.getImageData(c, "PopupMenu.Separator.M").getRight(), ThemeData.getImageData(c, "PopupMenu.Separator.M").getBottom(), Color.cyan, null);
            if (!(c.getParent() instanceof CellRendererPane)) {
                int gap = 0;
                g.drawImage(FrogLookAndFeel.getImageFromData(c, mRB), s.width - mRB.getWidth() + gap, 0, s.width, s.height, mRB.getLeft(), mRB.getTop(), mRB.getRight() - gap, mRB.getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(c, mLB), 0, 0, mLB.getWidth() - gap, s.height, mLB.getLeft() + gap, mLB.getTop(), mLB.getRight(), mLB.getBottom(), null);
            }
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "PopupMenu.Separator.L")), mLB.getWidth(), 0, mLB.getWidth() + ThemeData.getImageData(c, "PopupMenu.Separator.L").getWidth(), s.height, ThemeData.getImageData(c, "PopupMenu.Separator.L").getLeft(), ThemeData.getImageData(c, "PopupMenu.Separator.L").getTop(), ThemeData.getImageData(c, "PopupMenu.Separator.L").getRight(), ThemeData.getImageData(c, "PopupMenu.Separator.L").getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "PopupMenu.Separator.R")), s.width - mRB.getWidth() - ThemeData.getImageData(c, "PopupMenu.Separator.R").getWidth(), 0, s.width - mRB.getWidth(), s.height, ThemeData.getImageData(c, "PopupMenu.Separator.R").getLeft(), ThemeData.getImageData(c, "PopupMenu.Separator.R").getTop(), ThemeData.getImageData(c, "PopupMenu.Separator.R").getRight(), ThemeData.getImageData(c, "PopupMenu.Separator.R").getBottom(), null);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2, 0);
        }
        return new Dimension(0, ThemeData.getImageData(c, "PopupMenu.Separator.M").getHeight());
    }

    private static void initializeImageData() {
        if (FrogLookAndFeel.isMACOS9()) {
            mMacVendor = true;
        }
        mLB = FrogBorders.PopupMenuDockedBorder.getLBImage();
        mRB = FrogBorders.PopupMenuDockedBorder.getRBImage();
    }

    public static FrogImageData[] getImageDataResources() {
        if (mImageDataResources == null) {
            FrogSeparatorUI.initializeImageData();
            FrogImageData[] datas = new FrogImageData[]{ThemeData.getImageData(null, "PopupMenu.Separator.L"), ThemeData.getImageData(null, "PopupMenu.Separator.M"), ThemeData.getImageData(null, "PopupMenu.Separator.R"), ThemeData.getImageData(null, "Toolbar.SeparatorHorz.M")};
            mImageDataResources = datas;
        }
        return mImageDataResources;
    }
}

