/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.metal.MetalScrollPaneUI;

public class FrogScrollPaneUI
extends MetalScrollPaneUI {
    private PropertyChangeListener scrollBarSwapListener;

    public static ComponentUI createUI(JComponent x) {
        return new FrogScrollPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JScrollPane sp = (JScrollPane)c;
        JScrollBar hsb = sp.getHorizontalScrollBar();
        JScrollBar vsb = sp.getVerticalScrollBar();
        hsb.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        vsb.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.scrollpane.setBackground(SystemHueShift.getColor((JComponent)this.scrollpane, "ScrollPane.background"));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JScrollPane sp = (JScrollPane)c;
        JScrollBar hsb = sp.getHorizontalScrollBar();
        JScrollBar vsb = sp.getVerticalScrollBar();
        hsb.putClientProperty("JScrollBar.isFreeStanding", null);
        vsb.putClientProperty("JScrollBar.isFreeStanding", null);
    }

    public void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        this.scrollBarSwapListener = this.createScrollBarSwapListener();
        scrollPane.addPropertyChangeListener(this.scrollBarSwapListener);
    }

    public void uninstallListeners(JScrollPane scrollPane) {
        super.uninstallListeners(scrollPane);
        scrollPane.removePropertyChangeListener(this.scrollBarSwapListener);
    }

    protected PropertyChangeListener createScrollBarSwapListener() {
        return new FrogPropertyChangeListener();
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(SystemHueShift.getColor(c, "ScrollPane.background"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        } else {
            super.update(g, c);
        }
    }

    public class FrogPropertyChangeListener
    extends BasicScrollPaneUI.PropertyChangeHandler {
        public FrogPropertyChangeListener() {
            super(FrogScrollPaneUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("system") || propertyName.equals("theme")) {
                ((JScrollPane)e.getSource()).getVerticalScrollBar().putClientProperty(propertyName, e.getNewValue());
                ((JScrollPane)e.getSource()).getHorizontalScrollBar().putClientProperty(propertyName, e.getNewValue());
            }
        }
    }
}

