/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicArrowButton;

public class FrogScrollButton
extends BasicArrowButton {
    public static final String __PerforceId = "$Id$";
    private boolean isFreeStanding = false;
    private static boolean default_initialized = false;
    private int mGapSize = 1;
    private int buttonWidth;
    private int mPosition;
    private JScrollBar mScrollBar;

    public FrogScrollButton(JScrollBar scrollbar, int direction, int width, boolean freeStanding, int position) {
        super(direction);
        this.mScrollBar = scrollbar;
        this.buttonWidth = width;
        this.mPosition = position;
        this.isFreeStanding = freeStanding;
        if (!default_initialized) {
            default_initialized = true;
        }
    }

    public static void reloadHueShiftDefaults() {
    }

    public void setFreeStanding(boolean freeStanding) {
        this.isFreeStanding = freeStanding;
    }

    protected int getPosition() {
        return this.mPosition;
    }

    public void paint(Graphics g) {
        boolean isEnabled = this.getParent().isEnabled();
        boolean isPressed = this.getModel().isPressed();
        int image_x = 0;
        int image_y = 0;
        g.setColor(SystemHueShift.getColor((JComponent)this, "ScrollPane.background"));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getDirection() == 1) {
            if (this.getPosition() == 0) {
                image_x = 1;
                image_y = 0;
            }
            if (this.getPosition() == 2) {
                image_x = 1;
                image_y = 1;
            }
            if (isEnabled && isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VLDE"), image_x, image_y);
            } else if (isEnabled) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VLUE"), image_x, image_y);
            } else if (isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VLUD"), image_x, image_y);
            } else {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VLDD"), image_x, image_y);
            }
        } else if (this.getDirection() == 5) {
            if (this.getPosition() == 1) {
                image_x = 1;
                image_y = 0;
            }
            if (this.getPosition() == 3) {
                image_x = 1;
                image_y = 1;
            }
            if (isEnabled && isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VRDE"), image_x, image_y);
            } else if (isEnabled) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VRUE"), image_x, image_y);
            } else if (isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VRUD"), image_x, image_y);
            } else {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.VRDD"), image_x, image_y);
            }
        }
        if (this.getDirection() == 3) {
            if (this.getPosition() == 1) {
                image_x = 0;
                image_y = 1;
            }
            if (this.getPosition() == 3) {
                image_x = 1;
                image_y = 1;
            }
            if (isEnabled && isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HRDE"), image_x, image_y);
            } else if (isEnabled) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HRUE"), image_x, image_y);
            } else if (isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HRUD"), image_x, image_y);
            } else {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HRDD"), image_x, image_y);
            }
        }
        if (this.getDirection() == 7) {
            if (this.getPosition() == 2) {
                image_x = 1;
                image_y = 1;
            }
            if (this.getPosition() == 0) {
                image_x = 0;
                image_y = 1;
            }
            if (isEnabled && isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HLDE"), image_x, image_y);
            } else if (isEnabled) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HLUE"), image_x, image_y);
            } else if (isPressed) {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HLUD"), image_x, image_y);
            } else {
                this.paintFroggyStyle(g, ThemeData.getImageData(this, "SButton.HLDD"), image_x, image_y);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.buttonWidth + 1, this.buttonWidth + 1);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    private void paintFroggyStyle(Graphics g, FrogImageData imagedata, int x, int y) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.isFreeStanding) {
            width += 2;
        }
        g.drawImage(FrogLookAndFeel.getImageFromData(this, imagedata), x, y, imagedata.getWidth() + x, imagedata.getHeight() + y, imagedata.getLeft(), imagedata.getTop(), imagedata.getRight(), imagedata.getBottom(), null);
        if (!this.isFreeStanding) {
            width -= 2;
        }
    }
}

