/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogGIFReader;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.FrogScrollButton;
import com.sap.plaf.frog.FrogUtils;
import com.sap.plaf.frog.HueShiftCapableI;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

public class FrogScrollBarUI
extends ScrollBarUI
implements LayoutManager,
Serializable,
SwingConstants,
HueShiftCapableI {
    public static final String __PerforceId = "$Id$";
    private static final Dimension minimumThumbSize = new Dimension(8, 8);
    private static final Dimension maximumThumbSize = new Dimension(4096, 4096);
    private static final int scrollButtonSize = 17;
    protected static boolean defaults_initialized = false;
    protected FrogScrollButton m_increaseButton1;
    protected FrogScrollButton m_increaseButton2;
    protected FrogScrollButton m_decreaseButton1;
    protected FrogScrollButton m_decreaseButton2;
    protected FrogTrackListener m_trackListener;
    protected FrogArrowButtonListener m_buttonListener;
    protected FrogModelListener m_modelListener;
    protected FrogScrollListener m_scrollListener;
    protected FrogScrollBarListener m_scrollBarListener;
    protected Timer m_scrollTimer;
    protected boolean m_isDragging;
    private Rectangle m_thumbRect;
    private Rectangle m_trackRect;
    protected int scrollBarWidth;
    protected JScrollBar m_scrollbar = null;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI(JComponent c) {
        return new FrogScrollBarUI();
    }

    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width") != null ? (Integer)UIManager.get("ScrollBar.width") : 11;
        if (!defaults_initialized) {
            defaults_initialized = true;
        }
    }

    public void setHueShiftDefaultsInitialized(boolean hueshift_initialized) {
        defaults_initialized = hueshift_initialized;
    }

    public void installUI(JComponent c) {
        this.m_scrollbar = (JScrollBar)c;
        this.installDefaults();
        this.m_thumbRect = new Rectangle(0, 0, 0, 0);
        this.m_trackRect = new Rectangle(0, 0, 0, 0);
        this.initScrollButtons(c);
        this.m_scrollbar.setLayout(this);
        this.m_trackListener = new FrogTrackListener();
        this.m_modelListener = new FrogModelListener();
        this.m_scrollbar.addMouseListener(this.m_trackListener);
        this.m_scrollbar.addMouseMotionListener(this.m_trackListener);
        this.m_scrollbar.getModel().addChangeListener(this.m_modelListener);
        this.initScrollButtons(c);
        this.m_scrollbar.setEnabled(this.m_scrollbar.isEnabled());
        this.m_scrollbar.setOpaque(false);
        this.m_scrollListener = new FrogScrollListener();
        this.m_scrollTimer = new Timer(100, this.m_scrollListener);
        this.m_scrollTimer.setInitialDelay(800);
        LookAndFeel.installBorder(this.m_scrollbar, "ScrollBar.border");
        this.m_scrollBarListener = new FrogScrollBarListener();
        this.m_scrollbar.addPropertyChangeListener(this.m_scrollBarListener);
        this.m_scrollBarListener.handlePropertyChange(this.m_scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    public void uninstallUI(JComponent c) {
        this.m_scrollTimer.stop();
        this.m_scrollTimer = null;
        if (this.m_decreaseButton1 != null) {
            this.m_decreaseButton1.removeMouseListener(this.m_buttonListener);
        }
        if (this.m_decreaseButton2 != null) {
            this.m_decreaseButton2.removeMouseListener(this.m_buttonListener);
        }
        if (this.m_increaseButton1 != null) {
            this.m_increaseButton1.removeMouseListener(this.m_buttonListener);
        }
        if (this.m_increaseButton2 != null) {
            this.m_increaseButton2.removeMouseListener(this.m_buttonListener);
        }
        this.m_scrollbar.getModel().removeChangeListener(this.m_modelListener);
        this.m_scrollbar.removeMouseListener(this.m_trackListener);
        this.m_scrollbar.removeMouseMotionListener(this.m_trackListener);
        this.m_scrollbar.remove(this.m_increaseButton1);
        this.m_scrollbar.remove(this.m_increaseButton2);
        this.m_scrollbar.remove(this.m_decreaseButton1);
        this.m_scrollbar.remove(this.m_decreaseButton2);
        this.m_scrollbar.setLayout(null);
        this.m_thumbRect = null;
        this.m_increaseButton1 = null;
        this.m_increaseButton2 = null;
        this.m_decreaseButton1 = null;
        this.m_decreaseButton2 = null;
        this.m_scrollbar = null;
    }

    public void paint(Graphics g, JComponent c) {
        this.paintTrack(g, c, this.getTrackBounds());
        this.paintThumb(g, c, this.getThumbBounds());
        c.setOpaque(false);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (this.m_scrollbar.getOrientation() == 1) {
            g.translate(trackBounds.x, trackBounds.y);
            if (c.isEnabled()) {
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbar.VBgndLeft")), 1, 0, this.scrollBarWidth - 1, ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getHeight(), ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getLeft(), ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getTop(), ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getRight(), ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getBottom(), null);
                int i = 0;
                while (i < ThemeData.getImageData(c, "Scrollbar.VBgndMiddle").getWidth()) {
                    g.setColor(FrogGIFReader.getColor(c, ThemeData.getImageData(c, "Scrollbar.VBgndMiddle").getPath(), ThemeData.getImageData(c, "Scrollbar.VBgndMiddle").getLeft() + i, ThemeData.getImageData(c, "Scrollbar.VBgndMiddle").getTop()));
                    g.drawLine(i + 1, ThemeData.getImageData(c, "Scrollbar.VBgndLeft").getHeight(), i + 1, trackBounds.height - ThemeData.getImageData(c, "Scrollbar.VBgndRight").getHeight());
                    ++i;
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbar.VBgndRight")), 1, trackBounds.height - ThemeData.getImageData(c, "Scrollbar.VBgndRight").getHeight(), this.scrollBarWidth - 1, trackBounds.height, ThemeData.getImageData(c, "Scrollbar.VBgndRight").getLeft(), ThemeData.getImageData(c, "Scrollbar.VBgndRight").getTop(), ThemeData.getImageData(c, "Scrollbar.VBgndRight").getRight(), ThemeData.getImageData(c, "Scrollbar.VBgndRight").getBottom(), null);
                g.translate(-trackBounds.x, -trackBounds.y);
            } else {
                FrogUtils.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
        } else {
            g.translate(trackBounds.x, trackBounds.y);
            if (c.isEnabled()) {
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbar.HBgndLeft")), 0, 1, ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getWidth(), this.scrollBarWidth - 1, ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getLeft(), ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getTop(), ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getRight(), ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getBottom(), null);
                int i = 0;
                while (i < ThemeData.getImageData(c, "Scrollbar.HBgndMiddle").getHeight()) {
                    g.setColor(FrogGIFReader.getColor(c, ThemeData.getImageData(c, "Scrollbar.HBgndMiddle").getPath(), ThemeData.getImageData(c, "Scrollbar.HBgndMiddle").getLeft(), ThemeData.getImageData(c, "Scrollbar.HBgndMiddle").getTop() + i));
                    g.drawLine(ThemeData.getImageData(c, "Scrollbar.HBgndLeft").getWidth(), i + 1, trackBounds.width - ThemeData.getImageData(c, "Scrollbar.HBgndRight").getWidth(), i + 1);
                    ++i;
                }
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbar.HBgndRight")), trackBounds.width - ThemeData.getImageData(c, "Scrollbar.HBgndRight").getWidth(), 1, trackBounds.width, this.scrollBarWidth - 1, ThemeData.getImageData(c, "Scrollbar.HBgndRight").getLeft(), ThemeData.getImageData(c, "Scrollbar.HBgndRight").getTop(), ThemeData.getImageData(c, "Scrollbar.HBgndRight").getRight(), ThemeData.getImageData(c, "Scrollbar.HBgndRight").getBottom(), null);
            } else {
                FrogUtils.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
            g.translate(-trackBounds.x, -trackBounds.y);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        if (this.m_scrollbar.getOrientation() == 1 && thumbBounds.height > 0) {
            g.translate(thumbBounds.x, thumbBounds.y);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbox.VBgndLeft")), 3, 1, this.scrollBarWidth - 3, ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getHeight() + 1, ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getLeft(), ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getTop(), ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getRight(), ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getBottom(), null);
            int i = 0;
            while (i < ThemeData.getImageData(c, "Scrollbox.VBgndMiddle").getWidth()) {
                g.setColor(FrogGIFReader.getColor(c, ThemeData.getImageData(c, "Scrollbar.VBgndMiddle").getPath(), ThemeData.getImageData(c, "Scrollbox.VBgndMiddle").getLeft() + i, ThemeData.getImageData(c, "Scrollbox.VBgndMiddle").getTop()));
                g.drawLine(i + 3, ThemeData.getImageData(c, "Scrollbox.VBgndLeft").getHeight(), i + 3, thumbBounds.height - ThemeData.getImageData(c, "Scrollbox.VBgndRight").getHeight());
                ++i;
            }
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbox.VBgndRight")), 3, thumbBounds.height - ThemeData.getImageData(c, "Scrollbox.VBgndRight").getHeight() - 1, this.scrollBarWidth - 3, thumbBounds.height - 1, ThemeData.getImageData(c, "Scrollbox.VBgndRight").getLeft(), ThemeData.getImageData(c, "Scrollbox.VBgndRight").getTop(), ThemeData.getImageData(c, "Scrollbox.VBgndRight").getRight(), ThemeData.getImageData(c, "Scrollbox.VBgndRight").getBottom(), null);
            g.translate(-thumbBounds.x, -thumbBounds.y);
        } else if (this.m_scrollbar.getOrientation() == 0 && thumbBounds.width > 0) {
            g.translate(thumbBounds.x, thumbBounds.y);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbox.HBgndLeft")), 1, 3, ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getWidth() + 1, this.scrollBarWidth - 3, ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getLeft(), ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getTop(), ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getRight(), ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getBottom(), null);
            int i = 0;
            while (i < ThemeData.getImageData(c, "Scrollbox.HBgndMiddle").getHeight()) {
                g.setColor(FrogGIFReader.getColor(c, ThemeData.getImageData(c, "Scrollbar.HBgndMiddle").getPath(), ThemeData.getImageData(c, "Scrollbox.HBgndMiddle").getLeft(), ThemeData.getImageData(c, "Scrollbox.HBgndMiddle").getTop() + i));
                g.drawLine(ThemeData.getImageData(c, "Scrollbox.HBgndLeft").getWidth(), i + 3, thumbBounds.width - ThemeData.getImageData(c, "Scrollbox.HBgndRight").getWidth(), i + 3);
                ++i;
            }
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Scrollbox.HBgndRight")), thumbBounds.width - ThemeData.getImageData(c, "Scrollbox.HBgndRight").getWidth(), 3, thumbBounds.width, this.scrollBarWidth - 3, ThemeData.getImageData(c, "Scrollbox.HBgndRight").getLeft(), ThemeData.getImageData(c, "Scrollbox.HBgndRight").getTop(), ThemeData.getImageData(c, "Scrollbox.HBgndRight").getRight(), ThemeData.getImageData(c, "Scrollbox.HBgndRight").getBottom(), null);
            g.translate(-thumbBounds.x, -thumbBounds.y);
        }
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected Dimension getMaximumThumbSize() {
        return maximumThumbSize;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.m_scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
    }

    public void addLayoutComponent(String name, Component child) {
    }

    public void removeLayoutComponent(Component child) {
    }

    public Dimension preferredLayoutSize(Container scrollbarContainer) {
        return this.getPreferredSize((JComponent)scrollbarContainer);
    }

    public Dimension minimumLayoutSize(Container scrollbarContainer) {
        return this.getMinimumSize((JComponent)scrollbarContainer);
    }

    public void layoutContainer(Container scrollbarContainer) {
        if (this.m_isDragging) {
            return;
        }
        JScrollBar scrollbar = (JScrollBar)scrollbarContainer;
        switch (scrollbar.getOrientation()) {
            case 1: {
                FrogScrollButton firstScrollButton = (FrogScrollButton)scrollbar.getComponent(0);
                if (firstScrollButton != null && firstScrollButton.getDirection() == 3 || firstScrollButton.getDirection() == 7) {
                    this.initScrollButtons(scrollbarContainer);
                }
                this.layoutVScrollbar(scrollbar);
                break;
            }
            case 0: {
                FrogScrollButton firstScrollButton = (FrogScrollButton)scrollbar.getComponent(0);
                if (firstScrollButton != null && firstScrollButton.getDirection() == 1 || firstScrollButton.getDirection() == 5) {
                    this.initScrollButtons(scrollbarContainer);
                }
                this.layoutHScrollbar(scrollbar);
            }
        }
    }

    protected void initScrollButtons(Container c) {
        c.removeAll();
        JScrollBar scrollbar = (JScrollBar)c;
        switch (scrollbar.getOrientation()) {
            case 1: {
                this.m_increaseButton1 = new FrogScrollButton(this.m_scrollbar, 5, 17, this.isFreeStanding, 1);
                this.m_increaseButton2 = new FrogScrollButton(this.m_scrollbar, 5, 17, this.isFreeStanding, 3);
                this.m_decreaseButton1 = new FrogScrollButton(this.m_scrollbar, 1, 17, this.isFreeStanding, 0);
                this.m_decreaseButton2 = new FrogScrollButton(this.m_scrollbar, 1, 17, this.isFreeStanding, 2);
                break;
            }
            case 0: {
                this.m_increaseButton1 = new FrogScrollButton(this.m_scrollbar, 3, 17, this.isFreeStanding, 1);
                this.m_increaseButton2 = new FrogScrollButton(this.m_scrollbar, 3, 17, this.isFreeStanding, 3);
                this.m_decreaseButton1 = new FrogScrollButton(this.m_scrollbar, 7, 17, this.isFreeStanding, 0);
                this.m_decreaseButton2 = new FrogScrollButton(this.m_scrollbar, 7, 17, this.isFreeStanding, 2);
            }
        }
        this.m_increaseButton1.setOpaque(false);
        this.m_increaseButton2.setOpaque(false);
        this.m_decreaseButton1.setOpaque(false);
        this.m_decreaseButton2.setOpaque(false);
        scrollbar.add(this.m_increaseButton1);
        scrollbar.add(this.m_increaseButton2);
        scrollbar.add(this.m_decreaseButton1);
        scrollbar.add(this.m_decreaseButton2);
        if (this.m_buttonListener == null) {
            this.m_buttonListener = new FrogArrowButtonListener();
        }
        this.m_increaseButton1.addMouseListener(this.m_buttonListener);
        this.m_increaseButton2.addMouseListener(this.m_buttonListener);
        this.m_decreaseButton1.addMouseListener(this.m_buttonListener);
        this.m_decreaseButton2.addMouseListener(this.m_buttonListener);
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        if (this.m_thumbRect.x == x && this.m_thumbRect.y == y && this.m_thumbRect.width == width && this.m_thumbRect.height == height) {
            return;
        }
        int minX = Math.min(x, this.m_thumbRect.x);
        int minY = Math.min(y, this.m_thumbRect.y);
        int maxX = Math.max(x + width, this.m_thumbRect.x + this.m_thumbRect.width);
        int maxY = Math.max(y + height, this.m_thumbRect.y + this.m_thumbRect.height);
        this.m_thumbRect.setBounds(x, y, width, height);
        this.m_scrollbar.repaint(minX, minY, maxX - minX, maxY - minY);
    }

    protected Rectangle getThumbBounds() {
        return this.m_thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.m_trackRect;
    }

    protected void scrollByBlock(int direction) {
        JScrollBar jScrollBar = this.m_scrollbar;
        synchronized (jScrollBar) {
            int oldValue = this.m_scrollbar.getValue();
            int blockIncrement = this.m_scrollbar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.m_scrollbar.setValue(oldValue + delta);
            Rectangle dirtyRect = this.getTrackBounds();
            this.m_scrollbar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
        }
    }

    protected void scrollByUnit(int direction) {
        JScrollBar jScrollBar = this.m_scrollbar;
        synchronized (jScrollBar) {
            int delta = direction > 0 ? this.m_scrollbar.getUnitIncrement(direction) : -this.m_scrollbar.getUnitIncrement(direction);
            this.m_scrollbar.setValue(delta + this.m_scrollbar.getValue());
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        int sbButtonsW;
        int sbInsetsW;
        float trackW;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        int decrButtonW2 = this.m_decreaseButton2.getPreferredSize().width;
        int incrButtonW2 = this.m_increaseButton2.getPreferredSize().width;
        int decrButtonW1 = this.m_decreaseButton1.getPreferredSize().width;
        int incrButtonW1 = this.m_increaseButton1.getPreferredSize().width;
        int decrButtonX1 = sbInsets.left;
        int decrButtonX2 = sbSize.width - (sbInsets.right + incrButtonW2 + decrButtonW2);
        int incrButtonX1 = sbInsets.left + decrButtonW1;
        int incrButtonX2 = sbSize.width - (sbInsets.right + incrButtonW2);
        boolean visible = this.m_decreaseButton1.isVisible();
        if (!visible) {
            decrButtonW1 = 0;
            incrButtonW1 = 0;
            decrButtonX1 = sbInsets.left;
            incrButtonX1 = sbInsets.left;
        }
        if ((trackW = (float)(sbSize.width - ((sbInsetsW = sbInsets.left + sbInsets.right) + (sbButtonsW = decrButtonW1 + incrButtonW1 + decrButtonW2 + incrButtonW2)))) > 150.0f) {
            decrButtonW1 = this.m_decreaseButton1.getPreferredSize().width;
            incrButtonW1 = this.m_increaseButton1.getPreferredSize().width;
            decrButtonX1 = sbInsets.left;
            incrButtonX1 = sbInsets.left + decrButtonW1;
            sbButtonsW = decrButtonW1 + incrButtonW1 + decrButtonW2 + incrButtonW2;
            trackW = sbSize.width - (sbInsetsW + sbButtonsW);
            visible = true;
        } else if (trackW < 115.0f) {
            decrButtonW1 = 0;
            incrButtonW1 = 0;
            decrButtonX1 = sbInsets.left;
            incrButtonX1 = sbInsets.left;
            sbButtonsW = decrButtonW2 + incrButtonW2;
            trackW = sbSize.width - (sbInsetsW + sbButtonsW);
            visible = false;
        }
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int thumbX = decrButtonX2 - thumbW;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbX += decrButtonX1 + decrButtonW1 + incrButtonW1;
        }
        this.m_decreaseButton1.setVisible(visible);
        this.m_increaseButton1.setVisible(visible);
        this.m_decreaseButton1.setBounds(decrButtonX1, itemY, decrButtonW1, itemH);
        this.m_increaseButton1.setBounds(incrButtonX1, itemY, incrButtonW1, itemH);
        this.m_decreaseButton2.setBounds(decrButtonX2, itemY, decrButtonW2, itemH);
        this.m_increaseButton2.setBounds(incrButtonX2, itemY, incrButtonW2, itemH);
        int itrackX = decrButtonX1 + decrButtonW1 + incrButtonW1;
        int itrackW = decrButtonX2 - itrackX;
        this.m_trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > decrButtonX2) {
                thumbX = decrButtonX2 - thumbW;
            }
            if (thumbX < incrButtonX1 + incrButtonW1) {
                thumbX = incrButtonX1 + incrButtonW1 + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbButtonsH;
        int sbInsetsH;
        float trackH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int decrButtonH1 = this.m_decreaseButton1.getPreferredSize().height;
        int decrButtonH2 = this.m_decreaseButton2.getPreferredSize().height;
        int incrButtonH1 = this.m_increaseButton1.getPreferredSize().height;
        int incrButtonH2 = this.m_increaseButton2.getPreferredSize().height;
        int decrButtonY1 = sbInsets.top;
        int decrButtonY2 = sbSize.height - (sbInsets.bottom + incrButtonH2 + decrButtonH2);
        int incrButtonY1 = sbInsets.top + decrButtonH1;
        int incrButtonY2 = sbSize.height - (sbInsets.bottom + incrButtonH2);
        boolean visible = this.m_decreaseButton1.isVisible();
        if (!visible) {
            decrButtonH1 = 0;
            incrButtonH1 = 0;
            decrButtonY1 = sbInsets.left;
            incrButtonY1 = sbInsets.left;
        }
        if ((trackH = (float)(sbSize.height - ((sbInsetsH = sbInsets.top + sbInsets.bottom) + (sbButtonsH = decrButtonH1 + incrButtonH1 + decrButtonH2 + incrButtonH2)))) > 150.0f) {
            decrButtonH1 = this.m_decreaseButton1.getPreferredSize().height;
            incrButtonH1 = this.m_increaseButton1.getPreferredSize().height;
            decrButtonY1 = sbInsets.left;
            incrButtonY1 = sbInsets.left + decrButtonH1;
            sbButtonsH = decrButtonH1 + incrButtonH1 + decrButtonH2 + incrButtonH2;
            trackH = sbSize.height - (sbInsetsH + sbButtonsH);
            visible = true;
        } else if (trackH < 115.0f) {
            decrButtonH1 = 0;
            incrButtonH1 = 0;
            decrButtonY1 = sbInsets.left;
            incrButtonY1 = sbInsets.left;
            sbButtonsH = decrButtonH1 + incrButtonH1 + decrButtonH2 + incrButtonH2;
            trackH = sbSize.height - (sbInsetsH + sbButtonsH);
            visible = false;
        }
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButtonY2 - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY1 + decrButtonH1 + incrButtonH1;
        }
        this.m_decreaseButton1.setVisible(visible);
        this.m_increaseButton1.setVisible(visible);
        this.m_decreaseButton1.setBounds(itemX, decrButtonY1, itemW, decrButtonH1);
        this.m_decreaseButton2.setBounds(itemX, decrButtonY2, itemW, decrButtonH2);
        this.m_increaseButton1.setBounds(itemX, incrButtonY1, itemW, incrButtonH1);
        this.m_increaseButton2.setBounds(itemX, incrButtonY2, itemW, incrButtonH2);
        int itrackY = decrButtonY1 + decrButtonH1 + incrButtonH1;
        int itrackH = decrButtonY2 - itrackY;
        this.m_trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButtonY2) {
                thumbY = decrButtonY2 - thumbH;
            }
            if (thumbY < incrButtonY1 + incrButtonH1) {
                thumbY = incrButtonY1 + incrButtonH1 + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected class FrogTrackListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        protected FrogTrackListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (!FrogScrollBarUI.this.m_scrollbar.isEnabled()) {
                return;
            }
            Rectangle r = FrogScrollBarUI.this.getTrackBounds();
            FrogScrollBarUI.this.m_scrollbar.repaint(r.x, r.y, r.width, r.height);
            FrogScrollBarUI.this.m_isDragging = false;
            this.offset = 0;
            FrogScrollBarUI.this.m_scrollTimer.stop();
            FrogScrollBarUI.this.m_scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent e) {
            if (!FrogScrollBarUI.this.m_scrollbar.isEnabled()) {
                return;
            }
            FrogScrollBarUI.this.m_scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (FrogScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (FrogScrollBarUI.this.m_scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - FrogScrollBarUI.this.getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - FrogScrollBarUI.this.getThumbBounds().x;
                    }
                }
                FrogScrollBarUI.this.m_isDragging = true;
                return;
            }
            FrogScrollBarUI.this.m_isDragging = false;
            Dimension sbSize = FrogScrollBarUI.this.m_scrollbar.getSize();
            int direction = 1;
            switch (FrogScrollBarUI.this.m_scrollbar.getOrientation()) {
                case 1: {
                    if (FrogScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = FrogScrollBarUI.this.getThumbBounds().y;
                    direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    int thumbX;
                    int scrollbarCenter;
                    direction = FrogScrollBarUI.this.getThumbBounds().isEmpty() ? (this.currentMouseX < (scrollbarCenter = sbSize.width / 2) ? -1 : 1) : (this.currentMouseX < (thumbX = FrogScrollBarUI.this.getThumbBounds().x) ? -1 : 1);
                }
            }
            FrogScrollBarUI.this.scrollByBlock(direction);
            if (!FrogScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                FrogScrollBarUI.this.m_scrollTimer.stop();
                FrogScrollBarUI.this.m_scrollListener.setDirection(direction);
                FrogScrollBarUI.this.m_scrollListener.setScrollByBlock(true);
                FrogScrollBarUI.this.m_scrollTimer.start();
            }
        }

        public void mouseDragged(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            if (!FrogScrollBarUI.this.m_scrollbar.isEnabled() || !FrogScrollBarUI.this.m_isDragging) {
                return;
            }
            BoundedRangeModel model = FrogScrollBarUI.this.m_scrollbar.getModel();
            Rectangle thumbR = FrogScrollBarUI.this.getThumbBounds();
            if (FrogScrollBarUI.this.m_scrollbar.getOrientation() == 1) {
                thumbMin = FrogScrollBarUI.this.m_increaseButton1.getY() + FrogScrollBarUI.this.m_increaseButton1.getHeight();
                thumbMax = FrogScrollBarUI.this.m_decreaseButton2.getY() - FrogScrollBarUI.this.getThumbBounds().height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                FrogScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
                float trackLength = FrogScrollBarUI.this.getTrackBounds().height;
            } else {
                thumbMin = FrogScrollBarUI.this.m_increaseButton1.getX() + FrogScrollBarUI.this.m_increaseButton1.getWidth();
                thumbMax = FrogScrollBarUI.this.m_decreaseButton2.getX() - FrogScrollBarUI.this.getThumbBounds().width;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                FrogScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
                float trackLength = FrogScrollBarUI.this.getTrackBounds().width;
            }
            if (thumbPos == thumbMax) {
                FrogScrollBarUI.this.m_scrollbar.setValue(model.getMaximum() - model.getExtent());
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                FrogScrollBarUI.this.m_scrollbar.setValue(value + model.getMinimum());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class FrogArrowButtonListener
    extends MouseAdapter
    implements Serializable {
        boolean handledEvent;

        protected FrogArrowButtonListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!FrogScrollBarUI.this.m_scrollbar.isEnabled()) {
                return;
            }
            int direction = e.getSource() == FrogScrollBarUI.this.m_increaseButton1 || e.getSource() == FrogScrollBarUI.this.m_increaseButton2 ? 1 : -1;
            FrogScrollBarUI.this.scrollByUnit(direction);
            FrogScrollBarUI.this.m_scrollTimer.stop();
            FrogScrollBarUI.this.m_scrollListener.setDirection(direction);
            FrogScrollBarUI.this.m_scrollListener.setScrollByBlock(false);
            FrogScrollBarUI.this.m_scrollTimer.start();
            this.handledEvent = true;
        }

        public void mouseReleased(MouseEvent e) {
            FrogScrollBarUI.this.m_scrollTimer.stop();
            this.handledEvent = false;
            FrogScrollBarUI.this.m_scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class FrogScrollListener
    implements ActionListener,
    Serializable {
        int direction = 1;
        boolean useBlockIncrement;

        public FrogScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public FrogScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.useBlockIncrement) {
                FrogScrollBarUI.this.scrollByBlock(this.direction);
                if (FrogScrollBarUI.this.m_scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (FrogScrollBarUI.this.getThumbBounds().y + FrogScrollBarUI.this.getThumbBounds().height >= FrogScrollBarUI.this.m_trackListener.currentMouseY) {
                            ((Timer)e.getSource()).stop();
                        }
                    } else if (FrogScrollBarUI.this.getThumbBounds().y <= FrogScrollBarUI.this.m_trackListener.currentMouseY) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (FrogScrollBarUI.this.getThumbBounds().x + FrogScrollBarUI.this.getThumbBounds().width >= FrogScrollBarUI.this.m_trackListener.currentMouseX) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (FrogScrollBarUI.this.getThumbBounds().x <= FrogScrollBarUI.this.m_trackListener.currentMouseX) {
                    ((Timer)e.getSource()).stop();
                }
            } else {
                FrogScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && FrogScrollBarUI.this.m_scrollbar.getValue() + FrogScrollBarUI.this.m_scrollbar.getVisibleAmount() >= FrogScrollBarUI.this.m_scrollbar.getMaximum()) {
                ((Timer)e.getSource()).stop();
            } else if (this.direction < 0 && FrogScrollBarUI.this.m_scrollbar.getValue() <= FrogScrollBarUI.this.m_scrollbar.getMinimum()) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    protected class FrogModelListener
    implements ChangeListener,
    Serializable {
        protected FrogModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            FrogScrollBarUI.this.layoutContainer(FrogScrollBarUI.this.m_scrollbar);
        }
    }

    class FrogScrollBarListener
    implements PropertyChangeListener {
        FrogScrollBarListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ((propertyName.equals("system") || propertyName.equals("theme")) && FrogScrollBarUI.this.m_increaseButton1 != null) {
                FrogScrollBarUI.this.m_increaseButton1.putClientProperty(propertyName, e.getNewValue());
                FrogScrollBarUI.this.m_increaseButton2.putClientProperty(propertyName, e.getNewValue());
                FrogScrollBarUI.this.m_decreaseButton1.putClientProperty(propertyName, e.getNewValue());
                FrogScrollBarUI.this.m_decreaseButton2.putClientProperty(propertyName, e.getNewValue());
            }
            if (propertyName.equals(FrogScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(e.getNewValue());
            }
        }

        public void handlePropertyChange(Object newValue) {
            if (newValue != null) {
                FrogScrollBarUI.this.isFreeStanding = (Boolean)newValue;
            } else if (!FrogScrollBarUI.this.isFreeStanding) {
                FrogScrollBarUI.this.isFreeStanding = true;
            }
            if (FrogScrollBarUI.this.m_increaseButton1 != null) {
                FrogScrollBarUI.this.m_increaseButton1.setFreeStanding(FrogScrollBarUI.this.isFreeStanding);
            }
            if (FrogScrollBarUI.this.m_increaseButton2 != null) {
                FrogScrollBarUI.this.m_increaseButton2.setFreeStanding(FrogScrollBarUI.this.isFreeStanding);
            }
            if (FrogScrollBarUI.this.m_decreaseButton1 != null) {
                FrogScrollBarUI.this.m_decreaseButton1.setFreeStanding(FrogScrollBarUI.this.isFreeStanding);
            }
            if (FrogScrollBarUI.this.m_decreaseButton2 != null) {
                FrogScrollBarUI.this.m_decreaseButton2.setFreeStanding(FrogScrollBarUI.this.isFreeStanding);
            }
        }
    }
}

