/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.HueShiftCapableI;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class FrogRadioButtonUI
extends BasicRadioButtonUI
implements HueShiftCapableI {
    private static final FrogRadioButtonUI frogRadioButtonUI = new FrogRadioButtonUI();
    private static final String propertyPrefix = "RadioButton.";
    private static final String mLookAndFeelName = "Frog";
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;
    private boolean mHueShiftInitialized = false;

    public static ComponentUI createUI(JComponent c) {
        return frogRadioButtonUI;
    }

    public void installUI(AbstractButton b) {
        super.installUI(b);
    }

    protected void reloadHueShiftDefaults(JComponent b) {
        if (!this.mHueShiftInitialized) {
            b.setBackground(UIManager.getColor("RadioButton.background"));
            this.icon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "icon");
            this.mHueShiftInitialized = true;
        }
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "focus");
            this.selectColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "select");
            this.disabledTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "disabledText");
            this.defaults_initialized = true;
            this.mHueShiftInitialized = true;
        }
        b.setOpaque(false);
    }

    public void uninstallUI(AbstractButton b) {
        if (!UIManager.getLookAndFeel().getName().equals(mLookAndFeelName)) {
            b.putClientProperty("HueShifting", null);
            super.uninstallUI(b);
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
        this.mHueShiftInitialized = false;
    }

    public void setHueShiftDefaultsInitialized(boolean initialized) {
        this.mHueShiftInitialized = initialized;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        int w = size.width;
        int h = size.height;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getDefaultTextIconGap(b));
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            this.paintText(g, c, textRect, text);
            if (b.hasFocus() && b.isFocusPainted()) {
                this.paintFocus(g, textRect, size, c);
            }
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        if (model.isEnabled()) {
            g.setColor(c.getForeground());
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        } else {
            if (c.getClientProperty("disabledForeground") instanceof Color) {
                g.setColor((Color)c.getClientProperty("disabledForeground"));
            } else {
                g.setColor(SystemHueShift.getColor(c, "RadioButton.disabledText"));
            }
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d, JComponent c) {
        FrogBorders.FocusBorder.drawFocus(g, c);
    }
}

