/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FrogProgressBarUI
extends BasicProgressBarUI {
    public static final String __PerforceId = "$Id$";
    protected static Image mA_left = null;
    protected static Image mA_fill = null;
    protected static Image mA_mid = null;
    protected static Image mA_shadow1 = null;
    protected static Image mA_shadow2 = null;
    protected static Image mA_shadow3 = null;
    protected static Image mA_right = null;
    protected static Image mA_border = null;
    protected static boolean defaults_initialized = false;
    protected static boolean mMacVendor = false;

    public FrogProgressBarUI() {
        if (!defaults_initialized) {
            this.initializeImages();
            defaults_initialized = true;
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new FrogProgressBarUI();
    }

    public int getAmountFull(JComponent c) {
        int amountFull = 0;
        JProgressBar progressBar = (JProgressBar)c;
        BoundedRangeModel model = progressBar.getModel();
        int width = c.getWidth();
        int height = c.getHeight();
        Insets b = progressBar.getInsets();
        int x = b.left;
        int y = b.top;
        long span = model.getMaximum() - model.getMinimum();
        if (span != 0L) {
            double bigValue = model.getValue();
            double fractionComplete = bigValue / (double)span;
            if (progressBar.getOrientation() == 0) {
                double bigWidth = width - (b.left + b.right);
                amountFull = (int)(bigWidth * fractionComplete);
            } else {
                double bigHeight = height - (b.top + b.bottom);
                amountFull = (int)(bigHeight * fractionComplete);
            }
        }
        return amountFull;
    }

    public void paint(Graphics g, JComponent c) {
        int barRectX = 0;
        int barRectY = 0;
        int barRectWidth = this.progressBar.getWidth();
        int barRectHeight = this.progressBar.getHeight();
        Insets b = this.progressBar.getInsets();
        int amountFull = this.getAmountFull(b, barRectWidth -= b.right + (barRectX += b.left), barRectHeight -= b.bottom + (barRectY += b.top));
        JProgressBar progressBar = (JProgressBar)c;
        if (progressBar.getOrientation() != 0) {
            throw new Error("Vertical ProgressBar not implemented");
        }
        this.paintHorizontal(g, progressBar);
        if (progressBar.isStringPainted()) {
            this.paintString(g, barRectX, barRectY, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintHorizontal(Graphics g, JProgressBar c) {
        Dimension size = c.getSize();
        Insets i = c.getInsets();
        Rectangle barRect = new Rectangle(size);
        barRect.x += i.left;
        barRect.y += i.top;
        barRect.width -= i.right + barRect.x;
        barRect.height -= i.bottom + barRect.y;
        int amountFull = this.getAmountFull(c);
        boolean rightVisible = true;
        boolean leftVisible = true;
        if (amountFull <= ThemeData.getImageData(c, "ProgressBar.Left").getWidth() + ThemeData.getImageData(c, "ProgressBar.Mid").getWidth()) {
            leftVisible = false;
        }
        if (amountFull >= barRect.width - ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth() - ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth() - ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth() - ThemeData.getImageData(c, "ProgressBar.Border").getWidth() + 4) {
            amountFull = barRect.width - ThemeData.getImageData(c, "ProgressBar.Mid").getWidth() + 1;
            rightVisible = false;
        }
        g.translate(barRect.x, barRect.y);
        int pos = 0;
        if (mMacVendor) {
            g.drawImage(mA_left, 0, 0, ThemeData.getImageData(c, "ProgressBar.Left").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Left").getWidth(), ThemeData.getImageData(c, "ProgressBar.Left").getHeight(), null);
            pos += ThemeData.getImageData(c, "ProgressBar.Left").getWidth();
            if (leftVisible) {
                g.drawImage(mA_fill, ThemeData.getImageData(c, "ProgressBar.Left").getWidth(), 0, amountFull - ThemeData.getImageData(c, "ProgressBar.Mid").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Fill").getWidth(), ThemeData.getImageData(c, "ProgressBar.Fill").getHeight(), null);
                g.drawImage(mA_mid, amountFull - ThemeData.getImageData(c, "ProgressBar.Mid").getWidth(), 0, amountFull, barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Mid").getWidth(), ThemeData.getImageData(c, "ProgressBar.Mid").getHeight(), null);
                pos = amountFull;
            }
            if (rightVisible && leftVisible) {
                pos = amountFull;
                g.drawImage(mA_shadow1, pos, 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth(), ThemeData.getImageData(c, "ProgressBar.Shadow1").getHeight(), null);
                g.drawImage(mA_shadow2, pos += ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth(), 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth(), ThemeData.getImageData(c, "ProgressBar.Shadow2").getHeight(), null);
                g.drawImage(mA_shadow3, pos += ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth(), 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth(), ThemeData.getImageData(c, "ProgressBar.Shadow3").getHeight(), null);
                pos += ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth();
            }
            if (rightVisible) {
                g.drawImage(mA_right, pos, 0, barRect.width - ThemeData.getImageData(c, "ProgressBar.Border").getWidth(), barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Right").getWidth(), ThemeData.getImageData(c, "ProgressBar.Right").getHeight(), null);
                g.drawImage(mA_border, barRect.width - ThemeData.getImageData(c, "ProgressBar.Border").getWidth(), 0, barRect.width, barRect.height, 0, 0, ThemeData.getImageData(c, "ProgressBar.Border").getWidth(), ThemeData.getImageData(c, "ProgressBar.Border").getHeight(), null);
            }
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Left")), 0, 0, ThemeData.getImageData(c, "ProgressBar.Left").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Left").getLeft(), ThemeData.getImageData(c, "ProgressBar.Left").getTop(), ThemeData.getImageData(c, "ProgressBar.Left").getRight(), ThemeData.getImageData(c, "ProgressBar.Left").getBottom(), null);
            pos += ThemeData.getImageData(c, "ProgressBar.Left").getWidth();
            if (leftVisible) {
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Fill")), ThemeData.getImageData(c, "ProgressBar.Left").getWidth(), 0, amountFull - ThemeData.getImageData(c, "ProgressBar.Mid").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Fill").getLeft(), ThemeData.getImageData(c, "ProgressBar.Fill").getTop(), ThemeData.getImageData(c, "ProgressBar.Fill").getRight(), ThemeData.getImageData(c, "ProgressBar.Fill").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Mid")), amountFull - ThemeData.getImageData(c, "ProgressBar.Mid").getWidth(), 0, amountFull, barRect.height, ThemeData.getImageData(c, "ProgressBar.Mid").getLeft(), ThemeData.getImageData(c, "ProgressBar.Mid").getTop(), ThemeData.getImageData(c, "ProgressBar.Mid").getRight(), ThemeData.getImageData(c, "ProgressBar.Mid").getBottom(), null);
                pos = amountFull;
            }
            if (rightVisible && leftVisible) {
                pos = amountFull;
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Shadow1")), pos, 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Shadow1").getLeft(), ThemeData.getImageData(c, "ProgressBar.Shadow1").getTop(), ThemeData.getImageData(c, "ProgressBar.Shadow1").getRight(), ThemeData.getImageData(c, "ProgressBar.Shadow1").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Shadow2")), pos += ThemeData.getImageData(c, "ProgressBar.Shadow1").getWidth(), 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Shadow2").getLeft(), ThemeData.getImageData(c, "ProgressBar.Shadow2").getTop(), ThemeData.getImageData(c, "ProgressBar.Shadow2").getRight(), ThemeData.getImageData(c, "ProgressBar.Shadow2").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Shadow3")), pos += ThemeData.getImageData(c, "ProgressBar.Shadow2").getWidth(), 0, pos + ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Shadow3").getLeft(), ThemeData.getImageData(c, "ProgressBar.Shadow3").getTop(), ThemeData.getImageData(c, "ProgressBar.Shadow3").getRight(), ThemeData.getImageData(c, "ProgressBar.Shadow3").getBottom(), null);
                pos += ThemeData.getImageData(c, "ProgressBar.Shadow3").getWidth();
            }
            if (rightVisible) {
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Right")), pos, 0, barRect.width - ThemeData.getImageData(c, "ProgressBar.Border").getWidth(), barRect.height, ThemeData.getImageData(c, "ProgressBar.Right").getLeft(), ThemeData.getImageData(c, "ProgressBar.Right").getTop(), ThemeData.getImageData(c, "ProgressBar.Right").getRight(), ThemeData.getImageData(c, "ProgressBar.Right").getBottom(), null);
                g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "ProgressBar.Border")), barRect.width - ThemeData.getImageData(c, "ProgressBar.Border").getWidth(), 0, barRect.width, barRect.height, ThemeData.getImageData(c, "ProgressBar.Border").getLeft(), ThemeData.getImageData(c, "ProgressBar.Border").getTop(), ThemeData.getImageData(c, "ProgressBar.Border").getRight(), ThemeData.getImageData(c, "ProgressBar.Border").getBottom(), null);
            }
        }
        g.translate(-barRect.x, -barRect.y);
    }

    protected Color getSelectionForeground() {
        return UIManager.getColor("Tree.background2");
    }

    protected Color getSelectionBackground() {
        return UIManager.getColor("Table.gridColor");
    }

    public void initializeImages() {
    }
}

