/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;

public class FrogPanelUI
extends BasicPanelUI {
    public static final String __PerforceId = "$Id$";
    protected static FrogPanelUI frogPanelUI = new FrogPanelUI();

    public static ComponentUI createUI(JComponent c) {
        return frogPanelUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        String mStatusObject = (String)c.getClientProperty("statusbar");
        if (mStatusObject != null && mStatusObject.equals("statusMainBorder")) {
            c.setBorder(null);
        }
        if (c.getClientProperty("workingpane") != null) {
            c.setBorder(new FrogBorders.WorkingAreaBorder());
        }
        if (c instanceof UIResource) {
            c.setBorder(null);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c.getBorder() instanceof UIResource) {
            c.setBorder(null);
        }
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getClientProperty("toolBarPane") != null) {
                g.setColor(SystemHueShift.getColor(c, "TitleBar.background"));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                this.paint(g, c);
            } else if (c.getClientProperty("OKCodeFieldPanel") != null) {
                g.setColor(SystemHueShift.getColor(c, "Panel.okCodeField.Background"));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                this.paint(g, c);
            } else if (c.getClientProperty("GridWidth") != null) {
                int gridWidth = (Integer)c.getClientProperty("GridWidth");
                super.update(g, c);
                if (gridWidth > 0) {
                    Rectangle bounds = c.getBounds();
                    g.setColor(Color.darkGray);
                    g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
                    g.drawRect(1, 1, bounds.width - 3, bounds.height - 3);
                    int x = gridWidth;
                    while (x < bounds.width) {
                        g.drawLine(x, 0, x, bounds.height);
                        x += gridWidth;
                    }
                    int y = gridWidth;
                    while (y < bounds.height) {
                        g.drawLine(0, y, bounds.width, y);
                        y += gridWidth;
                    }
                }
                this.paint(g, c);
            } else if (c.getClientProperty("Grid") != null) {
                g.setColor(SystemHueShift.getColor(c, "StatusBar.background"));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                this.paint(g, c);
            } else if (c.getParent() != null && c.getParent() instanceof JComponent && ((JComponent)c.getParent()).getClientProperty("TabbedPane") != null) {
                g.setColor(SystemHueShift.getColor(c, "TabbedPane.primaryTabBackground"));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                this.paint(g, c);
            } else if (c.getClientProperty("SashOrientation") != null) {
                if (c.getClientProperty("SashOrientation") == Boolean.TRUE) {
                    g.setColor(new Color(64, 64, 64));
                    g.drawLine(0, 0, 0, c.getHeight());
                    g.drawLine(2, 0, 2, c.getHeight());
                    g.setColor(Color.white);
                    g.drawLine(1, 0, 1, c.getHeight());
                } else {
                    g.setColor(new Color(64, 64, 64));
                    g.drawLine(0, 0, c.getWidth(), 0);
                    g.drawLine(0, 2, c.getWidth(), 2);
                    g.setColor(Color.white);
                    g.drawLine(0, 1, c.getWidth(), 1);
                }
            } else {
                g.setColor(c.getBackground());
                if (c.getBackground() instanceof ColorUIResource || c.getBackground() == null) {
                    if (c.getParent() instanceof JTabbedPane) {
                        g.setColor(SystemHueShift.getColor(c, "TabbedPane.primaryTabBackground"));
                    } else if (c.getClientProperty("toolbarType") != null) {
                        g.setColor(SystemHueShift.getColor(c, "ToolBar.controlbackground"));
                    } else if (c.getClientProperty("DoNotFrog") == null) {
                        g.setColor(SystemHueShift.getColor(c, "Panel.background"));
                    }
                }
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                this.paint(g, c);
            }
        } else {
            super.update(g, c);
        }
    }
}

