/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.FrogMenuItemUI;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FrogMenuUI
extends FrogMenuItemUI {
    public static final String __PerforceId = "$Id$";
    protected MouseInputListener mouseInputListener;
    private static boolean mTopLevelMenuSelected;
    protected static Color mTopMenuSelectionForeground;
    protected static Color mMenuSelectionForeground;
    protected static Color mMenubackground;
    private static String mPrefix;
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private InputMap selectedWindowInputMap;
    private int lastMnemonic = 0;

    static {
        mPrefix = null;
    }

    public static ComponentUI createUI(JComponent c) {
        ComponentUI compUI = FrogMenuUI.createOSUI(c);
        if (compUI != null) {
            return compUI;
        }
        return new FrogMenuUI();
    }

    protected void installDefaults() {
        mPrefix = this.getPropertyPrefix();
        super.installDefaults();
        this.setMenuColors();
        ((JMenu)this.menuItem).setDelay(200);
        mTopLevelMenuSelected = false;
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (!FrogLookAndFeel.isJVM1dot4()) {
            this.changeListener = this.createChangeListener(this.menuItem);
            this.menuItem.addChangeListener(this.changeListener);
        }
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.menuListener = this.createMenuListener(this.menuItem);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void installKeyboardActions() {
        if (FrogLookAndFeel.isVMVersion1dot2() || FrogLookAndFeel.isJVM1dot4()) {
            super.installKeyboardActions();
            this.updateMnemonicBinding();
        } else if (!FrogLookAndFeel.isJVM1dot4() && this.menuItem.getModel().getMnemonic() != this.lastMnemonic) {
            this.menuItem.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
            this.lastMnemonic = this.menuItem.getModel().getMnemonic();
            this.menuItem.registerKeyboardAction(new PostAction((JMenu)this.menuItem, true), KeyStroke.getKeyStroke(this.lastMnemonic, 8, false), 2);
        }
    }

    void updateMnemonicBinding() {
        if (FrogLookAndFeel.isJVM1dot4()) {
            int i;
            int mnemonic = this.menuItem.getModel().getMnemonic();
            int[] shortcutKeys = (int[])UIManager.get("Menu.shortcutKeys");
            if (mnemonic == this.lastMnemonic || shortcutKeys == null) {
                return;
            }
            if (this.lastMnemonic != 0 && this.windowInputMap != null) {
                i = 0;
                while (i < shortcutKeys.length) {
                    this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKeys[i], false));
                    ++i;
                }
            }
            if (mnemonic != 0) {
                if (this.windowInputMap == null) {
                    this.windowInputMap = this.createInputMap(2);
                    SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
                }
                i = 0;
                while (i < shortcutKeys.length) {
                    this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKeys[i], false), "selectMenu");
                    ++i;
                }
            }
            this.lastMnemonic = mnemonic;
        } else {
            int mnemonic = this.menuItem.getModel().getMnemonic();
            if (mnemonic == this.lastMnemonic) {
                return;
            }
            if (this.lastMnemonic != 0 && this.windowInputMap != null) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
            }
            if (mnemonic != 0) {
                if (this.windowInputMap == null) {
                    this.windowInputMap = this.createInputMap(2);
                    SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
                }
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8, false), "selectMenu");
            }
            this.lastMnemonic = mnemonic;
        }
    }

    ActionMap createActionMap() {
        ActionMap am = super.createActionMap();
        if (am != null) {
            am.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
            ActionMap parent = (ActionMap)UIManager.get("Menu.sharedActionMap");
            if (parent == null && (parent = this.createSharedActionMap()) != null) {
                UIManager.put("MenuUI.sharedActionMap", parent);
            }
            if (parent != null) {
                am.setParent(parent);
            }
        }
        return am;
    }

    private static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex) {
        int i = fromIndex;
        int c = e.length;
        while (i < c) {
            Component comp;
            if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                return e[i];
            }
            ++i;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex) {
        int i = fromIndex;
        while (i >= 0) {
            Component comp;
            if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                return e[i];
            }
            --i;
        }
        return null;
    }

    ActionMap createSharedActionMap() {
        ActionMapUIResource am = new ActionMapUIResource();
        am.put("cancel", new CancelAction());
        am.put("selectNext", new SelectNextItemAction());
        am.put("selectPrevious", new SelectPreviousItemAction());
        am.put("selectParent", new SelectParentItemAction());
        am.put("selectChild", new SelectChildItemAction());
        am.put("return", new ReturnAction());
        return am;
    }

    protected void uninstallKeyboardActions() {
        if (FrogLookAndFeel.isVMVersion1dot2()) {
            super.uninstallKeyboardActions();
        } else {
            this.menuItem.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
            this.lastMnemonic = 0;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        return new MenuHandler();
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler((JMenu)c, this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent c) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension d = c.getPreferredSize();
            return new Dimension(d.width, Short.MAX_VALUE);
        }
        return null;
    }

    private void setMenuColors() {
        String mPrefix = this.getPropertyPrefix();
        if (this.menuItem.getForeground() == null || this.menuItem.getForeground() instanceof ColorUIResource) {
            if (((JMenu)this.menuItem).isTopLevelMenu()) {
                this.menuItem.setForeground(SystemHueShift.getColor((JComponent)this.menuItem, String.valueOf(mPrefix) + ".TopMenuforeground"));
                if (!this.menuItem.isOpaque() && UIManager.getColor("MenuOpaque.TopMenuForeground") != null) {
                    this.menuItem.setForeground(UIManager.getColor("MenuOpaque.TopMenuForeground"));
                }
            } else {
                this.menuItem.setForeground(SystemHueShift.getColor((JComponent)this.menuItem, String.valueOf(mPrefix) + ".foreground"));
            }
        }
    }

    private void setMenuBorders() {
        String mPrefix = this.getPropertyPrefix();
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            LookAndFeel.installBorder(this.menuItem, String.valueOf(mPrefix) + ".TopMenuborder");
        } else {
            LookAndFeel.installBorder(this.menuItem, String.valueOf(mPrefix) + ".border");
        }
    }

    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new PostAction(menu, false));
        timer.setRepeats(false);
        timer.start();
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, null, null, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        FrogMenuItemUI.viewRect.setBounds(0, 0, menuWidth, menuHeight);
        FrogMenuItemUI.viewRect.x += i.left;
        FrogMenuItemUI.viewRect.y += i.top;
        FrogMenuItemUI.viewRect.width -= i.right + FrogMenuItemUI.viewRect.x;
        FrogMenuItemUI.viewRect.height -= i.bottom + FrogMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        Color holdc = g.getColor();
        if (c.isOpaque()) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                if (((JMenu)c).isTopLevelMenu()) {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".TopMenubackground"));
                } else {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".selectionBackground"));
                }
            } else if (((JMenu)c).isTopLevelMenu()) {
                g.setColor(SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".TopMenubackground"));
            } else {
                g.setColor(SystemHueShift.getColor(c, "Menu.background"));
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(holdc);
        }
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + "+";
            }
            acceleratorText = String.valueOf(acceleratorText) + KeyEvent.getKeyText(accelerator.getKeyCode());
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), FrogMenuItemUI.viewRect, FrogMenuItemUI.iconRect, FrogMenuItemUI.textRect, FrogMenuItemUI.acceleratorRect, FrogMenuItemUI.checkIconRect, FrogMenuItemUI.arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(b.getForeground());
            }
            if (this.useCheckAndArrow()) {
                checkIcon.paintIcon(c, g, FrogMenuItemUI.checkIconRect.x, FrogMenuItemUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, FrogMenuItemUI.iconRect.x, FrogMenuItemUI.iconRect.y);
            }
        }
        if (text != null && !text.equals("")) {
            if (!model.isEnabled()) {
                if (!c.isOpaque() && UIManager.get("MenuOpaque.disabledForeground") != null) {
                    g.setColor(UIManager.getColor("MenuOpaque.disabledForeground"));
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
                } else if (UIManager.get("MenuItem.disabledForeground") instanceof ColorUIResource) {
                    g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
                } else {
                    g.setColor(this.mItemBackground.brighter());
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
                    g.setColor(this.mItemBackground.darker());
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x - 1, FrogMenuItemUI.textRect.y + fm.getAscent() - 1);
                }
            } else {
                g.setColor(((JMenu)c).getForeground());
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".disabledForeground") != null) {
                    SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".disabledForeground");
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
                } else {
                    g.setColor(this.mItemBackground.brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
                    g.setColor(this.mItemBackground.darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x - 1, FrogMenuItemUI.acceleratorRect.y + fm.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(mPrefix) + ".acceleratorSelectionForeground"));
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, FrogMenuItemUI.arrowIconRect.x, FrogMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    public JMenuItem getmenuItem() {
        return this.menuItem;
    }

    private static ComponentUI createOSUI(JComponent c) {
        Class<?> theInputClass = null;
        try {
            theInputClass = Class.forName("com.sap.platin.base.macosx.menu.GuiMacOSXMenuWrap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (theInputClass != null && c.getClass().getName().equals(theInputClass.getName())) {
            try {
                Class<?> theRes = Class.forName("apple.laf.AquaMenuUI");
                return (ComponentUI)theRes.newInstance();
            }
            catch (Exception e) {
                try {
                    Class<?> theRes2 = Class.forName("com.apple.mrj.swing.MacMenuUI");
                    return (ComponentUI)theRes2.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            block4: {
                MenuElement parent;
                MenuElement[] currentSelection;
                block5: {
                    JMenu menu = (JMenu)e.getSource();
                    if (!menu.isEnabled()) {
                        return;
                    }
                    currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (currentSelection.length <= 1) break block4;
                    parent = currentSelection[currentSelection.length - 2];
                    if (!(parent.getComponent() instanceof JMenu)) break block5;
                    parent = currentSelection[currentSelection.length - 1];
                    MenuElement[] childs = parent.getSubElements();
                    if (childs.length <= 0) break block4;
                    MenuElement[] newPath = new MenuElement[currentSelection.length + 1];
                    System.arraycopy(currentSelection, 0, newPath, 0, currentSelection.length);
                    newPath[currentSelection.length] = FrogMenuUI.nextEnabledChild(childs, 0);
                    if (newPath[currentSelection.length] == null) break block4;
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                    break block4;
                }
                MenuElement[] childs = parent.getSubElements();
                int i = 0;
                int c = childs.length;
                while (i < c) {
                    if (childs[i] == currentSelection[currentSelection.length - 1]) {
                        MenuElement nextChild = FrogMenuUI.nextEnabledChild(childs, i + 1);
                        if (nextChild == null) {
                            nextChild = FrogMenuUI.nextEnabledChild(childs, 0);
                        }
                        if (nextChild == null) break;
                        currentSelection[currentSelection.length - 1] = nextChild;
                        MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private static class SelectPreviousItemAction
    extends AbstractAction {
        SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            block4: {
                MenuElement parent;
                MenuElement[] currentSelection;
                block5: {
                    JMenu menu = (JMenu)e.getSource();
                    if (!menu.isEnabled()) {
                        return;
                    }
                    currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (currentSelection.length <= 1) break block4;
                    parent = currentSelection[currentSelection.length - 2];
                    if (!(parent.getComponent() instanceof JMenu)) break block5;
                    parent = currentSelection[currentSelection.length - 1];
                    MenuElement[] childs = parent.getSubElements();
                    if (childs.length <= 0) break block4;
                    MenuElement[] newPath = new MenuElement[currentSelection.length + 1];
                    System.arraycopy(currentSelection, 0, newPath, 0, currentSelection.length);
                    newPath[currentSelection.length] = FrogMenuUI.previousEnabledChild(childs, childs.length - 1);
                    if (newPath[currentSelection.length] == null) break block4;
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                    break block4;
                }
                MenuElement[] childs = parent.getSubElements();
                int i = 0;
                int c = childs.length;
                while (i < c) {
                    if (childs[i] == currentSelection[currentSelection.length - 1]) {
                        MenuElement nextChild = FrogMenuUI.previousEnabledChild(childs, i - 1);
                        if (nextChild == null) {
                            nextChild = FrogMenuUI.previousEnabledChild(childs, childs.length - 1);
                        }
                        if (nextChild == null) break;
                        currentSelection[currentSelection.length - 1] = nextChild;
                        MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private static class SelectParentItemAction
    extends AbstractAction {
        SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!menu.isEnabled()) {
                return;
            }
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 3 && path[path.length - 3].getComponent() instanceof JMenu && !((JMenu)path[path.length - 3].getComponent()).isTopLevelMenu()) {
                MenuElement[] newPath = new MenuElement[path.length - 2];
                System.arraycopy(path, 0, newPath, 0, path.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else if (path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                MenuElement[] tmp;
                MenuElement nextMenu = null;
                JPopupMenu popup = null;
                MenuElement firstItem = null;
                if (path.length > 1) {
                    tmp = path[0].getSubElements();
                    int i = 0;
                    int c = tmp.length;
                    while (i < c) {
                        if (tmp[i] == path[1] && (nextMenu = FrogMenuUI.previousEnabledChild(tmp, i - 1)) == null) {
                            nextMenu = FrogMenuUI.previousEnabledChild(tmp, tmp.length - 1);
                        }
                        ++i;
                    }
                }
                if (nextMenu != null) {
                    popup = ((JMenu)nextMenu).getPopupMenu();
                    if (((JMenu)nextMenu).isTopLevelMenu()) {
                        firstItem = null;
                    } else {
                        tmp = popup.getSubElements();
                        if (tmp.length > 0) {
                            firstItem = FrogMenuUI.nextEnabledChild(tmp, 0);
                        }
                    }
                    MenuElement[] newSelection = firstItem != null ? new MenuElement[]{path[0], nextMenu, popup, firstItem} : new MenuElement[]{path[0], nextMenu, popup};
                    MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                }
            }
        }
    }

    private static class SelectChildItemAction
    extends AbstractAction {
        SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!menu.isEnabled()) {
                return;
            }
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0 && path[path.length - 1].getComponent().isEnabled() && path[path.length - 1].getComponent() instanceof JMenu && !((JMenu)path[path.length - 1].getComponent()).isTopLevelMenu()) {
                MenuElement[] newPath = new MenuElement[path.length + 2];
                System.arraycopy(path, 0, newPath, 0, path.length);
                newPath[path.length] = ((JMenu)path[path.length - 1].getComponent()).getPopupMenu();
                MenuElement[] subElements = newPath[path.length].getSubElements();
                if (subElements.length > 0) {
                    newPath[path.length + 1] = FrogMenuUI.nextEnabledChild(subElements, 0);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                }
            } else if (path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                MenuElement[] tmp;
                MenuElement nextMenu = null;
                JPopupMenu popup = null;
                MenuElement firstItem = null;
                if (path.length > 1) {
                    tmp = path[0].getSubElements();
                    int i = 0;
                    int c = tmp.length;
                    while (i < c) {
                        if (tmp[i] == path[1] && (nextMenu = FrogMenuUI.nextEnabledChild(tmp, i + 1)) == null) {
                            nextMenu = FrogMenuUI.nextEnabledChild(tmp, 0);
                        }
                        ++i;
                    }
                }
                if (nextMenu != null) {
                    popup = ((JMenu)nextMenu).getPopupMenu();
                    if (((JMenu)nextMenu).isTopLevelMenu()) {
                        firstItem = null;
                    } else {
                        tmp = popup.getSubElements();
                        if (tmp.length > 0) {
                            firstItem = FrogMenuUI.nextEnabledChild(tmp, 0);
                        }
                    }
                    MenuElement[] newSelection = firstItem != null ? new MenuElement[]{path[0], nextMenu, popup, firstItem} : new MenuElement[]{path[0], nextMenu, popup};
                    MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!menu.isEnabled()) {
                return;
            }
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 4) {
                MenuElement[] newPath = new MenuElement[path.length - 2];
                System.arraycopy(path, 0, newPath, 0, path.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class ReturnAction
    extends AbstractAction {
        ReturnAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!menu.isEnabled()) {
                return;
            }
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0) {
                MenuElement lastElement = path[path.length - 1];
                if (lastElement instanceof JMenu) {
                    MenuElement[] newPath = new MenuElement[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = ((JMenu)lastElement).getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else if (lastElement instanceof JMenuItem) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ((JMenuItem)lastElement).doClick(0);
                    ((JMenuItem)lastElement).setArmed(false);
                }
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu menu, boolean shouldForce) {
            this.menu = menu;
            this.force = shouldForce;
        }

        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                this.menu = (JMenu)e.getSource();
                Container cnt = this.menu.getParent();
                if (cnt != null && cnt instanceof JMenuBar) {
                    MenuElement[] subElements = this.menu.getPopupMenu().getSubElements();
                    if (subElements.length > 0) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu(), subElements[0]};
                        defaultManager.setSelectedPath(me);
                    } else {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), this.menu};
                        defaultManager.setSelectedPath(me);
                    }
                }
            } else {
                MenuElement[] path = defaultManager.getSelectedPath();
                if (path.length > 0 && path[path.length - 1] == this.menu) {
                    MenuElement[] newPath = new MenuElement[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = this.menu.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("mnemonic")) {
                FrogMenuUI.this.installKeyboardActions();
            } else if (prop.equals("ancestor") || prop.equals("theme") || prop.equals("system") || prop.equals("UI")) {
                FrogMenuUI.this.setMenuBorders();
                FrogMenuUI.this.setMenuColors();
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.isTopLevelMenu()) {
                if (menu.isSelected()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = menu.getParent();
                    if (cnt != null && cnt instanceof JMenuBar) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    MenuElement[] newPath = new MenuElement[selectedPath.length + 1];
                    System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                    newPath[selectedPath.length] = menu.getPopupMenu();
                    manager.setSelectedPath(newPath);
                } else {
                    FrogMenuUI.this.setupPostTimer(menu);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
            if (!menu.isEnabled()) {
                return;
            }
            if (menu.isTopLevelMenu()) {
                menu.setForeground(SystemHueShift.getColor((JComponent)menu, "Menu.rolloverForeground"));
                if (!menu.isOpaque() && UIManager.getColor("MenuOpaque.rolloverForeground") != null) {
                    FrogMenuUI.this.getmenuItem().setForeground(UIManager.getColor("MenuOpaque.rolloverForeground"));
                }
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        MenuElement[] newPath = new MenuElement[selectedPath.length + 2];
                        System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                        newPath[selectedPath.length] = FrogMenuUI.this.getmenuItem();
                        newPath[selectedPath.length + 1] = menu.getPopupMenu();
                        manager.setSelectedPath(newPath);
                    } else {
                        manager.setSelectedPath(FrogMenuUI.this.getPath());
                        FrogMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
        }

        public void mouseExited(MouseEvent e) {
            JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
            if (!menu.isEnabled()) {
                return;
            }
            if (menu.isTopLevelMenu() && !mTopLevelMenuSelected && (FrogMenuUI.this.getmenuItem().getForeground() == null || FrogMenuUI.this.getmenuItem().getForeground() instanceof ColorUIResource)) {
                FrogMenuUI.this.getmenuItem().setForeground(SystemHueShift.getColor((JComponent)menu, "Menu.TopMenuforeground"));
                if (!menu.isOpaque() && UIManager.getColor("MenuOpaque.TopMenuForeground") != null) {
                    FrogMenuUI.this.getmenuItem().setForeground(UIManager.getColor("MenuOpaque.TopMenuForeground"));
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            JMenu m = (JMenu)e.getSource();
            if (m.isTopLevelMenu() && (FrogMenuUI.this.getmenuItem().getForeground() == null || FrogMenuUI.this.getmenuItem().getForeground() instanceof ColorUIResource)) {
                m.setForeground(SystemHueShift.getColor((JComponent)m, "Menu.rolloverForeground"));
                if (!m.isOpaque() && UIManager.getColor("MenuOpaque.rolloverForeground") != null) {
                    m.setForeground(UIManager.getColor("MenuOpaque.rolloverForeground"));
                }
            }
        }
    }

    private static class MenuHandler
    implements MenuListener {
        MenuHandler() {
        }

        public void menuSelected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            if (m.isTopLevelMenu() && (m.getForeground() == null || m.getForeground() instanceof ColorUIResource)) {
                m.setForeground(SystemHueShift.getColor((JComponent)m, "Menu.rolloverForeground"));
                if (!m.isOpaque() && UIManager.getColor("MenuOpaque.rolloverForeground") != null) {
                    m.setForeground(UIManager.getColor("MenuOpaque.rolloverForeground"));
                }
                mTopLevelMenuSelected = true;
            }
        }

        public void menuDeselected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            if (m.isTopLevelMenu() && (m.getForeground() == null || m.getForeground() instanceof ColorUIResource)) {
                m.setForeground(SystemHueShift.getColor((JComponent)m, "Menu.TopMenuforeground"));
                if (!m.isOpaque() && UIManager.getColor("MenuOpaque.TopMenuForeground") != null) {
                    m.setForeground(UIManager.getColor("MenuOpaque.TopMenuForeground"));
                }
                mTopLevelMenuSelected = false;
            }
        }

        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.isComponentPartOfCurrentMenu(m)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public FrogMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu m, FrogMenuUI ui) {
            this.menu = m;
            this.ui = ui;
            if (FrogLookAndFeel.isVMVersion1dot2()) {
                this.validateKeyboardActions12(this.menu.isSelected());
            } else {
                this.validateKeyboardActions(this.menu.isSelected());
            }
        }

        public void stateChanged(ChangeEvent e) {
            JMenu m = (JMenu)e.getSource();
            if (FrogLookAndFeel.isVMVersion1dot2()) {
                this.validateKeyboardActions12(this.menu.isSelected());
            } else {
                this.validateKeyboardActions(this.menu.isSelected());
            }
        }

        private Component findFocusedComponent(Component c) {
            Container parent = c.getParent();
            while (parent != null) {
                if (parent instanceof Window) {
                    return ((Window)parent).getFocusOwner();
                }
                parent = parent.getParent();
            }
            return null;
        }

        private void validateKeyboardActions12(boolean sel) {
            if (sel != this.isSelected) {
                this.isSelected = sel;
                if (this.isSelected) {
                    Object[] bindings;
                    boolean isRequestFocusEnabled = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (this.wasFocused instanceof JComponent && ((JComponent)this.wasFocused).getRootPane() != this.menu.getRootPane()) {
                        this.wasFocused = null;
                    }
                    if (!isRequestFocusEnabled) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!isRequestFocusEnabled) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    if (FrogMenuUI.this.selectedWindowInputMap == null && (bindings = (Object[])UIManager.get("Menu.selectedWindowInputMapBindings")) != null) {
                        FrogMenuUI.this.selectedWindowInputMap = LookAndFeel.makeComponentInputMap(FrogMenuUI.this.menuItem, bindings);
                    }
                    if (FrogMenuUI.this.windowInputMap == null) {
                        FrogMenuUI.this.windowInputMap = FrogMenuUI.this.createInputMap(2);
                        SwingUtilities.replaceUIInputMap(FrogMenuUI.this.menuItem, 2, FrogMenuUI.this.windowInputMap);
                    }
                    if (FrogMenuUI.this.windowInputMap != null && FrogMenuUI.this.selectedWindowInputMap != null) {
                        FrogMenuUI.this.windowInputMap.setParent(FrogMenuUI.this.selectedWindowInputMap);
                    }
                } else {
                    if (FrogMenuUI.this.windowInputMap != null && FrogMenuUI.this.selectedWindowInputMap != null) {
                        FrogMenuUI.this.windowInputMap.setParent(null);
                    }
                    if (this.wasFocused != null) {
                        if (this.wasFocused instanceof JComponent) {
                            JComponent jc = (JComponent)this.wasFocused;
                            boolean isRFEnabled = jc.isRequestFocusEnabled();
                            if (!isRFEnabled) {
                                jc.setRequestFocusEnabled(true);
                            }
                            this.wasFocused.requestFocus();
                            if (!isRFEnabled) {
                                jc.setRequestFocusEnabled(false);
                            }
                        } else {
                            this.wasFocused.requestFocus();
                        }
                        this.wasFocused = null;
                    }
                }
            }
        }

        private void validateKeyboardActions(boolean sel) {
            if (sel != this.isSelected) {
                this.isSelected = sel;
                if (this.isSelected) {
                    boolean isRequestFocusEnabled = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (!isRequestFocusEnabled) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!isRequestFocusEnabled) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    this.menu.registerKeyboardAction(new CancelAction(), KeyStroke.getKeyStroke(27, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectNextItemAction(), KeyStroke.getKeyStroke(40, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectPreviousItemAction(), KeyStroke.getKeyStroke(38, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectParentItemAction(), KeyStroke.getKeyStroke(37, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectChildItemAction(), KeyStroke.getKeyStroke(39, 0, false), 2);
                    this.menu.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(10, 0, false), 2);
                    this.menu.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(32, 0, false), 2);
                } else {
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0, false));
                    if (this.wasFocused != null) {
                        if (this.wasFocused instanceof JComponent) {
                            JComponent jc = (JComponent)this.wasFocused;
                            boolean isRFEnabled = jc.isRequestFocusEnabled();
                            if (!isRFEnabled) {
                                jc.setRequestFocusEnabled(true);
                            }
                            this.wasFocused.requestFocus();
                            if (!isRFEnabled) {
                                jc.setRequestFocusEnabled(false);
                            }
                        } else {
                            this.wasFocused.requestFocus();
                        }
                        this.wasFocused = null;
                    }
                }
            }
        }

        private MenuElement nextEnabledChild(MenuElement[] e, int fromIndex) {
            int i = fromIndex;
            int c = e.length;
            while (i < c) {
                Component comp;
                if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                    return e[i];
                }
                ++i;
            }
            return null;
        }

        private MenuElement previousEnabledChild(MenuElement[] e, int fromIndex) {
            int i = fromIndex;
            while (i >= 0) {
                Component comp;
                if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                    return e[i];
                }
                --i;
            }
            return null;
        }

        private class CancelAction
        implements ActionListener {
            CancelAction() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                if (!menu.isEnabled()) {
                    return;
                }
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 4) {
                    MenuElement[] newPath = new MenuElement[path.length - 2];
                    System.arraycopy(path, 0, newPath, 0, path.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        }

        private class ReturnAction
        implements ActionListener {
            ReturnAction() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                if (!menu.isEnabled()) {
                    return;
                }
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 0) {
                    MenuElement lastElement = path[path.length - 1];
                    if (lastElement instanceof JMenu) {
                        MenuElement[] newPath = new MenuElement[path.length + 1];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = ((JMenu)lastElement).getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                    } else if (lastElement instanceof JMenuItem) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        ((JMenuItem)lastElement).doClick(0);
                        ((JMenuItem)lastElement).setArmed(false);
                    }
                }
            }
        }

        private class SelectNextItemAction
        implements ActionListener {
            SelectNextItemAction() {
            }

            public void actionPerformed(ActionEvent e) {
                block4: {
                    MenuElement parent;
                    MenuElement[] currentSelection;
                    block5: {
                        JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                        if (!menu.isEnabled()) {
                            return;
                        }
                        currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (currentSelection.length <= 1) break block4;
                        parent = currentSelection[currentSelection.length - 2];
                        if (!(parent.getComponent() instanceof JMenu)) break block5;
                        parent = currentSelection[currentSelection.length - 1];
                        MenuElement[] childs = parent.getSubElements();
                        if (childs.length <= 0) break block4;
                        MenuElement[] newPath = new MenuElement[currentSelection.length + 1];
                        System.arraycopy(currentSelection, 0, newPath, 0, currentSelection.length);
                        newPath[currentSelection.length] = ChangeHandler.this.nextEnabledChild(childs, 0);
                        if (newPath[currentSelection.length] == null) break block4;
                        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                        break block4;
                    }
                    MenuElement[] childs = parent.getSubElements();
                    int i = 0;
                    int c = childs.length;
                    while (i < c) {
                        if (childs[i] == currentSelection[currentSelection.length - 1]) {
                            MenuElement nextChild = ChangeHandler.this.nextEnabledChild(childs, i + 1);
                            if (nextChild == null) {
                                nextChild = ChangeHandler.this.nextEnabledChild(childs, 0);
                            }
                            if (nextChild == null) break;
                            currentSelection[currentSelection.length - 1] = nextChild;
                            MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }

        private class SelectPreviousItemAction
        implements ActionListener {
            SelectPreviousItemAction() {
            }

            public void actionPerformed(ActionEvent e) {
                block4: {
                    MenuElement parent;
                    MenuElement[] currentSelection;
                    block5: {
                        JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                        if (!menu.isEnabled()) {
                            return;
                        }
                        currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (currentSelection.length <= 1) break block4;
                        parent = currentSelection[currentSelection.length - 2];
                        if (!(parent.getComponent() instanceof JMenu)) break block5;
                        parent = currentSelection[currentSelection.length - 1];
                        MenuElement[] childs = parent.getSubElements();
                        if (childs.length <= 0) break block4;
                        MenuElement[] newPath = new MenuElement[currentSelection.length + 1];
                        System.arraycopy(currentSelection, 0, newPath, 0, currentSelection.length);
                        newPath[currentSelection.length] = ChangeHandler.this.previousEnabledChild(childs, childs.length - 1);
                        if (newPath[currentSelection.length] == null) break block4;
                        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                        break block4;
                    }
                    MenuElement[] childs = parent.getSubElements();
                    int i = 0;
                    int c = childs.length;
                    while (i < c) {
                        if (childs[i] == currentSelection[currentSelection.length - 1]) {
                            MenuElement nextChild = ChangeHandler.this.previousEnabledChild(childs, i - 1);
                            if (nextChild == null) {
                                nextChild = ChangeHandler.this.previousEnabledChild(childs, childs.length - 1);
                            }
                            if (nextChild == null) break;
                            currentSelection[currentSelection.length - 1] = nextChild;
                            MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }

        private class SelectParentItemAction
        implements ActionListener {
            SelectParentItemAction() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                if (!menu.isEnabled()) {
                    return;
                }
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 3 && path[path.length - 3].getComponent() instanceof JMenu && !((JMenu)path[path.length - 3].getComponent()).isTopLevelMenu()) {
                    MenuElement[] newPath = new MenuElement[path.length - 2];
                    System.arraycopy(path, 0, newPath, 0, path.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else if (path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] tmp;
                    MenuElement nextMenu = null;
                    JPopupMenu popup = null;
                    MenuElement firstItem = null;
                    if (path.length > 1) {
                        tmp = path[0].getSubElements();
                        int i = 0;
                        int c = tmp.length;
                        while (i < c) {
                            if (tmp[i] == path[1] && (nextMenu = ChangeHandler.this.previousEnabledChild(tmp, i - 1)) == null) {
                                nextMenu = ChangeHandler.this.previousEnabledChild(tmp, tmp.length - 1);
                            }
                            ++i;
                        }
                    }
                    if (nextMenu != null) {
                        popup = ((JMenu)nextMenu).getPopupMenu();
                        if (((JMenu)nextMenu).isTopLevelMenu()) {
                            firstItem = null;
                        } else {
                            tmp = popup.getSubElements();
                            if (tmp.length > 0) {
                                firstItem = ChangeHandler.this.nextEnabledChild(tmp, 0);
                            }
                        }
                        MenuElement[] newSelection = firstItem != null ? new MenuElement[]{path[0], nextMenu, popup, firstItem} : new MenuElement[]{path[0], nextMenu, popup};
                        MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                    }
                }
            }
        }

        private class SelectChildItemAction
        implements ActionListener {
            SelectChildItemAction() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                if (!menu.isEnabled()) {
                    return;
                }
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 0 && path[path.length - 1].getComponent().isEnabled() && path[path.length - 1].getComponent() instanceof JMenu && !((JMenu)path[path.length - 1].getComponent()).isTopLevelMenu()) {
                    MenuElement[] newPath = new MenuElement[path.length + 2];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = ((JMenu)path[path.length - 1].getComponent()).getPopupMenu();
                    MenuElement[] subElements = newPath[path.length].getSubElements();
                    if (subElements.length > 0) {
                        newPath[path.length + 1] = ChangeHandler.this.nextEnabledChild(subElements, 0);
                        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                    }
                } else if (path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] tmp;
                    MenuElement nextMenu = null;
                    JPopupMenu popup = null;
                    MenuElement firstItem = null;
                    if (path.length > 1) {
                        tmp = path[0].getSubElements();
                        int i = 0;
                        int c = tmp.length;
                        while (i < c) {
                            if (tmp[i] == path[1] && (nextMenu = ChangeHandler.this.nextEnabledChild(tmp, i + 1)) == null) {
                                nextMenu = ChangeHandler.this.nextEnabledChild(tmp, 0);
                            }
                            ++i;
                        }
                    }
                    if (nextMenu != null) {
                        popup = ((JMenu)nextMenu).getPopupMenu();
                        if (((JMenu)nextMenu).isTopLevelMenu()) {
                            firstItem = null;
                        } else {
                            tmp = popup.getSubElements();
                            if (tmp.length > 0) {
                                firstItem = ChangeHandler.this.nextEnabledChild(tmp, 0);
                            }
                        }
                        MenuElement[] newSelection = firstItem != null ? new MenuElement[]{path[0], nextMenu, popup, firstItem} : new MenuElement[]{path[0], nextMenu, popup};
                        MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                    }
                }
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!FrogMenuUI.this.getmenuItem().isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < FrogMenuUI.this.getmenuItem().getWidth() && p.y >= 0 && p.y < FrogMenuUI.this.getmenuItem().getHeight()) {
                JMenu menu = (JMenu)FrogMenuUI.this.getmenuItem();
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                        MenuElement[] newPath = new MenuElement[path.length + 1];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = menu.getPopupMenu();
                        manager.setSelectedPath(newPath);
                    } else {
                        manager.setSelectedPath(path);
                        FrogMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            int key = FrogMenuUI.this.getmenuItem().getMnemonic();
            if (key == 0) {
                return;
            }
            MenuElement[] path = e.getPath();
            if (this.lower(key) == this.lower(e.getKeyChar())) {
                JPopupMenu popupMenu = ((JMenu)FrogMenuUI.this.getmenuItem()).getPopupMenu();
                MenuElement[] sub = popupMenu.getSubElements();
                if (sub.length > 0) {
                    MenuSelectionManager manager = e.getMenuSelectionManager();
                    MenuElement[] newPath = new MenuElement[path.length + 2];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = popupMenu;
                    newPath[path.length + 1] = sub[0];
                    manager.setSelectedPath(newPath);
                }
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private int lower(int ascii) {
            if (ascii >= 65 && ascii <= 90) {
                return ascii + 97 - 65;
            }
            return ascii;
        }
    }
}

